/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.Strings;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.servicehelper.ParamServiceHelper;
import ysq.rpac.rpamc.common.servicehelper.ScheduleServiceHelper;

public class ProcessSchOneFormPlugin
extends AbstractFormPlugin {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String YSQ_PROC_NAME = "ysq_proc_name";
    private static final String YSQ_PROC_VER = "ysq_proc_ver";
    private static final String YSQ_SCH_PARAM = "ysq_sch_param";
    public static final String YSQ_PARAM_SAVE = "ysq_param_save";
    public static final String YSQ_BTN_SAVE = "ysq_btn_save";
    public static final String YSQ_BTN_EXIT = "ysq_btn_exit";
    public static final String YSQ_RPA_SCH_PARAM = "ysq_rpa_sch_param";
    public static final String YSQ_CLOSE_BACK_PARAM = "ysq_close_back_param";
    public static final String YSQ_CONFIRM_BACK_EXIT = "ysq_confirm_back_exit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button saveBtn = (Button)this.getView().getControl(YSQ_BTN_SAVE);
        saveBtn.addClickListener((ClickListener)this);
        Button paramBtn = (Button)this.getView().getControl(YSQ_PARAM_SAVE);
        paramBtn.addClickListener((ClickListener)this);
        Button exitBtn = (Button)this.getView().getControl(YSQ_BTN_EXIT);
        exitBtn.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long procId = (Long)formShowParameter.getCustomParam("procId");
        Boolean lock = (Boolean)formShowParameter.getCustomParam("versionLock");
        if (procId != null) {
            DynamicObject procObject = BusinessDataServiceHelper.loadSingle((Object)procId, (String)"ysq_rpa_process_ver");
            this.initProcess(procObject, lock);
        }
    }

    private void initProcess(DynamicObject entity, Boolean lock) {
        String code = entity.getString("ysq_proc_code");
        this.initProcVer(code);
        this.getModel().setValue(YSQ_PROC_NAME, (Object)entity.getString(YSQ_PROC_NAME));
        this.getModel().setValue(YSQ_PROC_VER, (Object)entity.getString(YSQ_PROC_VER));
        if (StringUtils.isBlank((CharSequence)entity.getString("ysq_param_tag"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{YSQ_PARAM_SAVE});
        }
        this.getModel().setValue("ysq_sch_param_tag", (Object)entity.getString("ysq_param_tag"));
        this.getModel().setValue("ysq_proc_code", (Object)code);
        if (lock.booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{YSQ_PROC_VER});
        }
        DynamicObject orgObj = entity.getDynamicObject("org");
        long orgId = orgObj.getLong(0);
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        List childIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"15", orgIds, (boolean)true);
        this.bindAgent(childIds);
    }

    public void propertyChanged(PropertyChangedArgs changeArgs) {
        super.propertyChanged(changeArgs);
        String fieldKey = changeArgs.getProperty().getName();
        if (YSQ_PROC_VER.equals(fieldKey)) {
            String procCode = this.getModel().getValue("ysq_proc_code").toString();
            this.upDateParams(procCode);
        }
    }

    private void upDateParams(String procCode) {
        if (StringUtils.isNotBlank((CharSequence)procCode)) {
            Object ver = this.getModel().getValue(YSQ_PROC_VER);
            if (ver == null || Strings.isNullOrEmpty((String)ver.toString())) {
                this.getModel().getDataEntity().set("ysq_sch_param_tag", (Object)"");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{YSQ_PARAM_SAVE});
                return;
            }
            QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
            String version = this.getModel().getValue(YSQ_PROC_VER).toString();
            QFilter versionFilter = new QFilter(YSQ_PROC_VER, "=", (Object)version);
            DynamicObjectCollection processList = QueryServiceHelper.query((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter, versionFilter});
            if (CollectionUtils.isNotEmpty((Collection)processList)) {
                DynamicObject processDb = (DynamicObject)processList.get(0);
                String params = processDb.getString("ysq_param_tag");
                DynamicObject schInfo = this.getModel().getDataEntity();
                if (StringUtils.isNotBlank((CharSequence)params)) {
                    schInfo.set("ysq_sch_param_tag", (Object)params);
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{YSQ_PARAM_SAVE});
                } else {
                    schInfo.set("ysq_sch_param_tag", (Object)"");
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{YSQ_PARAM_SAVE});
                }
            }
        }
    }

    private void initProcVer(String procCode) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(YSQ_PROC_VER);
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObjectCollection list = QueryServiceHelper.query((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter, codeFilter});
        for (DynamicObject dynamicObject : list) {
            ComboItem oneProcItem = new ComboItem(new LocaleString(dynamicObject.get(YSQ_PROC_VER).toString()), dynamicObject.get(YSQ_PROC_VER).toString());
            data.add(oneProcItem);
        }
        comboEdit.setComboItems(data);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.endsWith(YSQ_BTN_EXIT)) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(YSQ_CONFIRM_BACK_EXIT, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(2, "\u8fd4\u56de\u7f16\u8f91");
            btnNameMaps.put(6, "\u76f4\u63a5\u9000\u51fa");
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            ConfirmTypes confirmTypes = ConfirmTypes.Default;
            ArrayList msglinks = new ArrayList();
            this.getView().showConfirm("\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u4fee\u6539\u3002", msglinks, options, confirmTypes, confirmCallBacks, btnNameMaps);
            return;
        }
        if (key.endsWith(YSQ_BTN_SAVE)) {
            String version = this.getModel().getDataEntity().getString(YSQ_PROC_VER);
            if (Strings.isNullOrEmpty((String)version)) {
                this.getView().showErrorNotification("\u8bf7\u9009\u62e9\u6d41\u7a0b\u7248\u672c\u3002");
                evt.setCancel(true);
                return;
            }
            String param = this.getModel().getDataEntity().getString("ysq_sch_param_tag");
            if (StringUtils.isNotBlank((CharSequence)param) && ScheduleServiceHelper.checkSchParam((String)param)) {
                evt.setCancel(true);
                this.getView().showErrorNotification("\u8bf7\u70b9\u51fb\u201c\u8fd0\u884c\u53c2\u6570\u4fee\u6539\u201d\uff0c\u586b\u5199\u597d\u8fd0\u884c\u53c2\u6570\u540e\u518d\u4fdd\u5b58\u3002");
            } else {
                long fid = ID.genLongId();
                this.getModel().setValue("ysq_fid", (Object)fid);
                String jobParam = null;
                try {
                    jobParam = ParamServiceHelper.getJobParamFile((String)param, (Long)fid);
                }
                catch (Exception e) {
                    this.log.info("\u4e34\u65f6\u6587\u4ef6\u94fe\u63a5\u8fc7\u671f\u3002");
                    evt.setCancel(true);
                    this.getView().showErrorNotification("\u8fd0\u884c\u53c2\u6570\u4e2d\u4e0a\u4f20\u7684\u6587\u4ef6\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002");
                    return;
                }
                this.getModel().setValue("ysq_sch_param_tag", (Object)jobParam);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.endsWith(YSQ_PARAM_SAVE)) {
            this.openParam();
        } else if (key.endsWith(YSQ_BTN_SAVE)) {
            this.getView().returnDataToParent((Object)true);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if (YSQ_CLOSE_BACK_PARAM.equals(closedCallBackEvent.getActionId()) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            ArrayList maps = (ArrayList)returnData;
            String s = JSON.toJSONString((Object)maps);
            this.getModel().setValue("ysq_sch_param_tag", (Object)s);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)YSQ_CONFIRM_BACK_EXIT, (CharSequence)callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("close");
        }
    }

    private void bindAgent(List<Long> childIds) {
        DynamicObject[] processList;
        ComboEdit agentCom = (ComboEdit)this.getControl("ysq_robots_sel");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        QFilter orgFilter = new QFilter("org", "in", childIds);
        QFilter typeFilter = new QFilter("ysq_agent_type", "=", (Object)"robot");
        QFilter[] agentFilters = new QFilter[]{orgFilter, typeFilter};
        String field = "ysq_agent_alias,ysq_agent_no";
        for (DynamicObject dynamicObject : processList = BusinessDataServiceHelper.load((String)"ysq_rpa_agent", (String)field, (QFilter[])agentFilters)) {
            Object code = dynamicObject.get("ysq_agent_no");
            Object name = dynamicObject.get("ysq_agent_alias");
            data.add(new ComboItem(new LocaleString(name.toString()), code.toString()));
        }
        agentCom.setComboItems(data);
    }

    private void openParam() {
        DynamicObject schInfo = this.getModel().getDataEntity();
        String param = schInfo.getString("ysq_sch_param_tag");
        if (StringUtils.isNotBlank((CharSequence)param)) {
            JSONArray jsonArray = null;
            try {
                jsonArray = JSONArray.parseArray((String)param);
            }
            catch (Exception e) {
                this.log.info("\u8fd0\u884c\u53c2\u6570\u89e3\u6790\u9519\u8bef\uff1a" + e.getMessage());
                this.getView().showTipNotification("\u8fd0\u884c\u53c2\u6570\u89e3\u6790\u9519\u8bef\u3002");
                return;
            }
            if (jsonArray == null || jsonArray.size() <= 0) {
                this.getView().showTipNotification("\u8be5\u6d41\u7a0b\u6682\u65e0\u8fd0\u884c\u53c2\u6570\u3002");
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(YSQ_RPA_SCH_PARAM);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("ysq_sch_param_tag", param);
            showParameter.setCustomParams(map);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, YSQ_CLOSE_BACK_PARAM));
            this.getView().showForm(showParameter);
        } else {
            this.getView().showTipNotification("\u8be5\u6d41\u7a0b\u6682\u65e0\u8fd0\u884c\u53c2\u6570\u3002");
        }
    }
}

