/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.process.version;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqProcessConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.constant.YsqRpaJobConstant;
import ysq.rpac.rpamc.common.constant.YsqScheduleConstant;
import ysq.rpac.rpamc.common.model.ParamsVo;
import ysq.rpac.rpamc.common.utils.IsearchFileUtils;
import ysq.rpac.rpamc.common.utils.UserUtils;
import ysq.rpac.rpamc.common.utils.VersionUtil;

public class ProcessVersionFormPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(ProcessVersionFormPlugin.class);
    public static final String KEY_BUTTON = "ysq_btn_publish";
    public static final String ATTACHMENTPANEL = "attachmentpanel";
    public static final String KEY_PROCESS_DEIT_CHICK = "KEY_PROCESS_DEIT_CHICK";
    public static final String KEY_PARAMS_TABLES = "ysq_params_table";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String action = (String)this.getView().getFormShowParameter().getCustomParam("param");
        if ("save".equals(action)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ysq_flexpanelap1"});
        } else {
            this.bindParamsTable(e);
        }
    }

    public void registerListener(EventObject e) {
        Button button = (Button)this.getView().getControl(KEY_BUTTON);
        button.addClickListener((ClickListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (KEY_BUTTON.equals(key)) {
            this.saveCheck(key, control, evt);
            return;
        }
    }

    private void saveCheck(String key, Control control, BeforeClickEvent evt) {
        boolean exists;
        boolean isExist;
        String s;
        BillModel model = (BillModel)control.getModel();
        DynamicObject dynamicObject = model.getDataEntity();
        AttachmentPanel panel = (AttachmentPanel)this.getControl(ATTACHMENTPANEL);
        String procCode = dynamicObject.get("ysq_proc_code").toString();
        String procName = dynamicObject.get("ysq_proc_name").toString();
        Object isApp = dynamicObject.get("ysq_is_app");
        if (isApp != null && StringUtils.isNotBlank((CharSequence)(s = isApp.toString()))) {
            this.getView().showErrorNotification("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u6d41\u7a0b\u5305\u3002");
            evt.setCancel(true);
            return;
        }
        List files = panel.getAttachmentData();
        if (CollectionUtils.isEmpty((Collection)files)) {
            this.getView().showErrorNotification("\u6d41\u7a0b\u5305\u4e0d\u53ef\u4e3a\u7a7a\u3002");
            evt.setCancel(true);
            return;
        }
        Object verObj = dynamicObject.get("ysq_proc_ver");
        String procVersion = "";
        if (verObj != null) {
            String s2 = verObj.toString();
            if (s2.length() < 1 || s2.length() > 11) {
                this.getView().showTipNotification("\u6d41\u7a0b\u7248\u672c\u8fc7\u957f\uff0c\u53ea\u80fd\u4e3a1~11\u5b57\u7b26");
                evt.setCancel(true);
                return;
            }
            procVersion = s2;
        }
        if (isExist = this.checkProcName(procCode, procName)) {
            control.getView().showErrorNotification("\u201c\u6d41\u7a0b\u540d\u201d\u5df2\u5b58\u5728\u3002");
            evt.setCancel(true);
            return;
        }
        String fileName = UUID.randomUUID().toString().replace("-", "") + ".ipkg";
        Map map = (Map)files.get(0);
        map.put("name", fileName);
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            dynamicObject.set("ysq_proc_file", (Object)("/doc/ipkg/" + fileName));
        }
        QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        QFilter versionFilter = new QFilter("ysq_proc_ver", "=", (Object)procVersion);
        DynamicObject process = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process", (QFilter[])new QFilter[]{codeFilter});
        if (process != null && !UserUtils.getDptId().equals(process.getDynamicObject("org").getLong("id"))) {
            control.getView().showErrorNotification("\u4e0a\u4f20\u7684\u6d41\u7a0b\u548c\u5176\u4ed6\u7ec4\u7ec7\u7684\u6d41\u7a0b\u540d\u79f0\u6709\u51b2\u7a81\uff0c\u8bf7\u4fee\u6539\u3002");
            evt.setCancel(true);
            return;
        }
        Long procVerId = dynamicObject.getLong("id");
        QFilter idFilter = new QFilter("id", "=", (Object)procVerId);
        boolean processVerDBExists = QueryServiceHelper.exists((String)"ysq_rpa_process_ver", (QFilter[])new QFilter[]{idFilter});
        if (!processVerDBExists && (exists = QueryServiceHelper.exists((String)"ysq_rpa_process_ver", (QFilter[])new QFilter[]{codeFilter, versionFilter}))) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_PROCESS_DEIT_CHICK, (IFormPlugin)this);
            this.getView().showConfirm("\u6d41\u7a0b\u5df2\u5b58\u5728\u3002\u66ff\u6362\u540e\uff0c\u65e7\u7248\u672c\u7684\u7b49\u5f85\u4efb\u52a1\u5c06\u4f1a\u88ab\u53d6\u6d88\u3002\u786e\u5b9a\u662f\u5426\u66ff\u6362", MessageBoxOptions.OKCancel, confirmCallBacks);
            evt.setCancel(true);
            return;
        }
    }

    private boolean checkProcName(String procCode, String procName) {
        boolean flag = false;
        QFilter proCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        boolean exists = QueryServiceHelper.exists((String)"ysq_rpa_process_ver", (QFilter[])new QFilter[]{proCodeFilter});
        if (exists) {
            boolean procNameExists;
            QFilter procNameFilter = new QFilter("ysq_proc_name", "=", (Object)procName);
            QFilter procCodeFilter = new QFilter("ysq_proc_code", "!=", (Object)procCode);
            flag = procNameExists = QueryServiceHelper.exists((String)"ysq_rpa_process_ver", (QFilter[])new QFilter[]{procNameFilter, procCodeFilter});
        } else {
            boolean procNameExists;
            QFilter qFilter = new QFilter("ysq_proc_name", "=", (Object)procName);
            flag = procNameExists = QueryServiceHelper.exists((String)"ysq_rpa_process_ver", (QFilter[])new QFilter[]{qFilter});
        }
        return flag;
    }

    private void bindParamsTable(EventObject e) {
        DynamicObjectCollection rows = null;
        rows = this.getModel().getEntryEntity(KEY_PARAMS_TABLES);
        EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().getProperties().get((Object)KEY_PARAMS_TABLES);
        EntryType entryType = (EntryType)entryProp.getItemType();
        DynamicObject processData = this.getModel().getDataEntity();
        if (processData != null) {
            String param = processData.getString("ysq_param_tag");
            List list = IsearchFileUtils.analysisParam((String)param);
            for (ParamsVo paramsVo : list) {
                DynamicObject entry = new DynamicObject((DynamicObjectType)entryType);
                entry.set("ysq_params_name", (Object)paramsVo.getParamsName());
                entry.set("ysq_params_desc", (Object)paramsVo.getParamsDesc());
                entry.set("ysq_params_type", (Object)paramsVo.getParamsType());
                if ("checkbox".equals(paramsVo.getParamsType()) && StringUtils.isBlank((CharSequence)paramsVo.getParamsDefValue())) {
                    entry.set("ysq_params_def_value", (Object)"false");
                } else {
                    entry.set("ysq_params_def_value", (Object)paramsVo.getParamsDefValue());
                }
                String paramsRequired = paramsVo.getParamsRequired();
                String blStr = "\u5426";
                if (StringUtils.isNotBlank((CharSequence)paramsRequired) && paramsRequired.equalsIgnoreCase("1")) {
                    blStr = "\u662f";
                }
                entry.set("ysq_params_required", (Object)blStr);
                entry.set("ysq_params_help", (Object)paramsVo.getParamsHelp());
                rows.add((Object)entry);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.getView().getParentView().showSuccessNotification("\u64cd\u4f5c\u6210\u529f");
            BillModel model = (BillModel)this.getModel();
            DynamicObject dynamicObject = model.getDataEntity();
            this.updateLatestProcess(dynamicObject.get("ysq_proc_code").toString(), dynamicObject.getString("ysq_proc_ver"));
            this.updateProcNameInSchedule(dynamicObject.getString("ysq_proc_code"), dynamicObject.getString("ysq_proc_name"));
            this.updateProcNameInTask(dynamicObject.getString("ysq_proc_code"), dynamicObject.getString("ysq_proc_name"));
            IFormView parentView = this.getView().getParentView();
            ListView listView = (ListView)parentView;
            listView.refresh();
            this.getView().sendFormAction(parentView);
            this.getView().close();
        }
    }

    private void updateProcNameInSchedule(String procCode, String newName) {
        QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"ysq_process_schedule", (String)YsqScheduleConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
        if (load != null && load.length > 0) {
            for (DynamicObject dynamicObject : load) {
                dynamicObject.set("ysq_proc_name", (Object)newName);
            }
            SaveServiceHelper.save((DynamicObject[])load);
        }
    }

    private void updateProcNameInTask(String procCode, String newName) {
        QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
        if (load != null && load.length > 0) {
            for (DynamicObject dynamicObject : load) {
                dynamicObject.set("ysq_proc_name", (Object)newName);
            }
            SaveServiceHelper.save((DynamicObject[])load);
        }
    }

    private void updateLatestProcess(String procCode, String procVer) {
        String latestVersion = "0";
        QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
        if (query.size() == 0) {
            return;
        }
        for (DynamicObject dynamicObject : query) {
            if (VersionUtil.compare((String)dynamicObject.get("ysq_proc_ver").toString(), (String)latestVersion) <= 0) continue;
            latestVersion = dynamicObject.get("ysq_proc_ver").toString();
        }
        QFilter versionFilter = new QFilter("ysq_proc_ver", "=", (Object)latestVersion);
        DynamicObject latestVerProcess = QueryServiceHelper.queryOne((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter, versionFilter});
        DynamicObject process = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
        if (VersionUtil.compare((String)latestVersion, (String)process.getString("ysq_proc_ver")) > 0) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)process.getLong("id"), (String)"ysq_rpa_process");
            dynamicObject.set("ysq_proc_ver", latestVerProcess.get("ysq_proc_ver"));
            dynamicObject.set("ysq_proc_desc", latestVerProcess.get("ysq_proc_desc"));
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            return;
        }
        if (procVer.equals(process.getString("ysq_proc_ver"))) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)process.getLong("id"), (String)"ysq_rpa_process");
            dynamicObject.set("ysq_proc_ver", latestVerProcess.get("ysq_proc_ver"));
            dynamicObject.set("ysq_proc_desc", latestVerProcess.get("ysq_proc_desc"));
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)KEY_PROCESS_DEIT_CHICK, (CharSequence)callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            this.getView().invokeOperation("save");
        }
    }
}

