/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.process.version;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqProcessConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.model.dto.ProcessVersionDTO;
import ysq.rpac.rpamc.common.upgrade.ProcessMigrate;
import ysq.rpac.rpamc.common.utils.VersionUtil;

public class ProcessVersionListPlugin
extends AbstractListPlugin {
    private static Log log = LogFactory.getLog(ProcessVersionListPlugin.class);
    private static final String PARAM_KEY = "param";
    private static final String CODE_CACHE = "procCode";
    private static final String SCHEDULE_PAGE_ID = "ysq_process_schedule";
    public static final String YSQ_PRO_RUN_INFO = "ysq_pro_run_info";
    public static final String YSQ_CLOSEBACK_PROCESS = "ysq_closeback_process";
    private static final String YSQ_BTN_SCH_ONE = "ysq_btn_sch_one";
    public static final String KEY_MAINBAR = "toolbarap";
    private static final String BILLLISTAP = "billlistap";
    private static final String YSQ_CLOSE_BACK_SCH_ONE = "ysq_close_back_sch_one";

    public void filterContainerInit(FilterContainerInitArgs args) {
        ProcessMigrate.migrateProcess();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)YSQ_BTN_SCH_ONE) && !this.checkRows(evt)) {
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        BillList list;
        ListSelectedRowCollection selectedRows;
        Long primaryKeyValue;
        DynamicObject procObject;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)YSQ_BTN_SCH_ONE) && (procObject = BusinessDataServiceHelper.loadSingle((Object)(primaryKeyValue = (Long)(selectedRows = (list = (BillList)this.getControl(BILLLISTAP)).getSelectedRows()).get(0).getPrimaryKeyValue()), (String)"ysq_rpa_process_ver")) != null) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ysq_rpa_sch_one");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("procId", (Object)primaryKeyValue);
            formShowParameter.setCustomParam("versionLock", (Object)true);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, YSQ_CLOSE_BACK_SCH_ONE));
            this.getView().showForm(formShowParameter);
            return;
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_MAINBAR});
    }

    private boolean checkRows(BeforeItemClickEvent evt) {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        int size = selectedRows.size();
        if (size > 1) {
            this.getView().showTipNotification("\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002");
            evt.setCancel(true);
            return false;
        }
        if (size == 0) {
            this.getView().showTipNotification("\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002");
            evt.setCancel(true);
            return false;
        }
        return true;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String procCode = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_KEY);
        if (procCode == null || procCode.isEmpty()) {
            QFilter typeFilter = new QFilter("ysq_proc_type", "=", (Object)"standard");
            DynamicObjectCollection stdProcess = QueryServiceHelper.query((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])new QFilter[]{typeFilter});
            ArrayList<String> stdList = new ArrayList<String>();
            for (DynamicObject process : stdProcess) {
                stdList.add(process.get("ysq_proc_code").toString());
            }
            QFilter filter = new QFilter("ysq_proc_code", "not in", stdList);
            e.addCustomQFilter(filter);
            return;
        }
        QFilter qFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        e.addCustomQFilter(qFilter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"delete", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            String[] codeArray;
            IPageCache pageCache = this.getPageCache();
            String s = pageCache.get(CODE_CACHE);
            for (String procCode : codeArray = s.split(",")) {
                if (!this.remainVersion(procCode).booleanValue()) {
                    QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_rpa_process", (String)"id", (QFilter[])new QFilter[]{codeFilter});
                    if (query.size() > 0) {
                        AttachmentServiceHelper.remove((String)"ysq_rpa_process", (Object)((DynamicObject)query.get(0)).getLong("id"));
                    }
                    DeleteServiceHelper.delete((String)"ysq_rpa_process", (QFilter[])new QFilter[]{codeFilter});
                    DynamicObjectCollection schedules = QueryServiceHelper.query((String)SCHEDULE_PAGE_ID, (String)"id", (QFilter[])new QFilter[]{codeFilter});
                    if (schedules.size() <= 0) continue;
                    for (DynamicObject schedule : schedules) {
                        AttachmentServiceHelper.remove((String)SCHEDULE_PAGE_ID, (Object)schedule.getLong("id"));
                    }
                    DeleteServiceHelper.delete((String)SCHEDULE_PAGE_ID, (QFilter[])new QFilter[]{codeFilter});
                    continue;
                }
                this.updateLatestProcess(procCode);
            }
            FormView parentView = (FormView)this.getView().getParentView();
            if (parentView != null && parentView.getFormId().equals("ysq_rpa_process")) {
                ListView listView = (ListView)parentView;
                listView.refresh();
                this.getView().sendFormAction((IFormView)parentView);
            }
        }
    }

    private void updateLatestProcess(String procCode) {
        String latestVersion = "0";
        QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
        if (query.size() == 0) {
            return;
        }
        for (DynamicObject dynamicObject : query) {
            if (VersionUtil.compare((String)dynamicObject.get("ysq_proc_ver").toString(), (String)latestVersion) <= 0) continue;
            latestVersion = dynamicObject.get("ysq_proc_ver").toString();
        }
        QFilter versionFilter = new QFilter("ysq_proc_ver", "=", (Object)latestVersion);
        DynamicObject latestVerProcess = QueryServiceHelper.queryOne((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter, versionFilter});
        DynamicObject process = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
        if (!latestVersion.equals(process.getString("ysq_proc_ver"))) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)process.getLong("id"), (String)"ysq_rpa_process");
            dynamicObject.set("ysq_proc_ver", latestVerProcess.get("ysq_proc_ver"));
            dynamicObject.set("ysq_proc_desc", latestVerProcess.get("ysq_proc_desc"));
            SaveServiceHelper.update((DynamicObject)dynamicObject);
        }
    }

    private Boolean remainVersion(String procCode) {
        QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        return QueryServiceHelper.exists((String)"ysq_rpa_process_ver", (QFilter[])new QFilter[]{codeFilter});
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageData = e.getPageData();
        for (DynamicObject data : pageData) {
            long id = data.getLong("id");
            DynamicObject process = null;
            try {
                process = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ysq_rpa_process_ver");
            }
            catch (Exception exception) {
                log.debug(exception.getMessage());
                process = null;
            }
            if (null == process) continue;
            QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)process.getString("ysq_proc_code"));
            QFilter versionFilter = new QFilter("ysq_proc_ver", "=", (Object)process.getString("ysq_proc_ver"));
            DynamicObjectCollection schDataList = QueryServiceHelper.query((String)SCHEDULE_PAGE_ID, (String)"id", (QFilter[])new QFilter[]{codeFilter, versionFilter});
            data.set("ysq_dispatch_time", (Object)schDataList.size());
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject rowData = e.getRowData();
        this.dataEncapsulation(e, rowData);
    }

    private void dataEncapsulation(PackageDataEvent e, DynamicObject rowData) {
        ColumnDesc columnDesc;
        if (e.getSource() instanceof ColumnDesc && YSQ_PRO_RUN_INFO.equals((columnDesc = (ColumnDesc)e.getSource()).getKey())) {
            e.setFormatValue((Object)"\u67e5\u770b");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Object primaryKeyValue;
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
        Long id = 0L;
        if (currentRow != null && (primaryKeyValue = currentRow.getPrimaryKeyValue()) != null) {
            id = Long.valueOf(primaryKeyValue.toString());
        }
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{idFilter});
        if (dynamicObject == null) {
            this.getView().showTipNotification("\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\u3002");
            args.setCancel(true);
            return;
        }
        String proCode = dynamicObject.getString("ysq_proc_code");
        String proVer = dynamicObject.getString("ysq_proc_ver");
        String proOrg = dynamicObject.getString("org");
        if (YSQ_PRO_RUN_INFO.equals(args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ysq_proc_code", proCode);
            map.put("ysq_proc_ver", proVer);
            map.put("org", proOrg);
            map.put("contactVersion", true);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ysq_rpa_process_run_info");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParams(map);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, YSQ_CLOSEBACK_PROCESS));
            this.getView().showForm(formShowParameter);
        }
        if ("ysq_dispatch_time".equals(args.getHyperLinkClickEvent().getFieldName())) {
            BillShowParameter showParameter;
            args.setCancel(true);
            QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)proCode);
            QFilter versionFilter = new QFilter("ysq_proc_ver", "=", (Object)proVer);
            DynamicObjectCollection query = QueryServiceHelper.query((String)SCHEDULE_PAGE_ID, (String)"id", (QFilter[])new QFilter[]{codeFilter, versionFilter});
            int schTime = query.size();
            if (schTime <= 1) {
                showParameter = new BillShowParameter();
                if (schTime == 0) {
                    showParameter.setCustomParam("routerParam", (Object)new ProcessVersionDTO(proCode, proVer));
                }
                if (schTime == 1) {
                    DynamicObject singleSchedule = (DynamicObject)query.get(0);
                    showParameter.setPkId(singleSchedule.get("id"));
                }
                showParameter.setFormId(SCHEDULE_PAGE_ID);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            }
            if (schTime > 1) {
                showParameter = new ListShowParameter();
                showParameter.setBillFormId(SCHEDULE_PAGE_ID);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParam("proCode", (Object)proCode);
                showParameter.setCustomParam("proVer", (Object)proVer);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)YSQ_CLOSEBACK_PROCESS) && null != closedCallBackEvent.getReturnData()) {
            HashMap<String, Object> map;
            ArrayList<String> list;
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            String jobType = (String)returnData.get("jobType");
            String proCode = (String)returnData.get("proCode");
            String proVer = (String)returnData.get("proVer");
            String proOrg = (String)returnData.get("proOrg");
            if (StringUtils.equals((CharSequence)jobType, (CharSequence)"run")) {
                list = new ArrayList<String>();
                list.add(RpaJobStatusEnums.RUNNING.getCode());
                list.add(RpaJobStatusEnums.STOPPING.getCode());
                list.add(RpaJobStatusEnums.SUCCESS.getCode());
                list.add(RpaJobStatusEnums.FAILED.getCode());
                list.add(RpaJobStatusEnums.STOPPED.getCode());
                list.add(RpaJobStatusEnums.RUN_OUTTIME.getCode());
                map = new HashMap();
                map.put("org", proOrg);
                map.put("ysq_proc_code", proCode);
                map.put("ysq_proc_ver", proVer);
                map.put("jobStatus", list);
                map.put("contactVersion", true);
                this.toJobListPage(map);
            }
            if (StringUtils.equals((CharSequence)jobType, (CharSequence)"fail")) {
                list = new ArrayList();
                list.add(RpaJobStatusEnums.FAILED.getCode());
                map = new HashMap<String, Object>();
                map.put("org", proOrg);
                map.put("ysq_proc_code", proCode);
                map.put("ysq_proc_ver", proVer);
                map.put("jobStatus", list);
                map.put("contactVersion", true);
                this.toJobListPage(map);
            }
        }
    }

    private void toJobListPage(Map<String, Object> map) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("ysq_rpa_job");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCustomParams(map);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

