/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.process.version;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import ysq.rpac.rpamc.common.constant.YsqRpaJobConstant;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.message.JobQueueProducer;
import ysq.rpac.rpamc.common.message.RobotPendingJobProducer;
import ysq.rpac.rpamc.common.model.dto.ProcessVersionDTO;
import ysq.rpac.rpamc.common.servicehelper.ProcessServiceHelper;
import ysq.rpac.rpamc.common.utils.ScheduleUtils;

public class ProcessVersionRemoveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity data : dataEntities = this.getDataEntities()) {
                    String id = data.getValue("id").toString();
                    DynamicObject dynamicObject = null;
                    try {
                        dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ysq_rpa_process_ver");
                    }
                    catch (Exception exception) {
                        dynamicObject = null;
                    }
                    if (null == dynamicObject) continue;
                    String proCode = dynamicObject.getString("ysq_proc_code");
                    QFilter statusFilter = new QFilter("ysq_work_status", "=", (Object)RpaJobStatusEnums.PENDING.getCode());
                    QFilter procCodeFilte = new QFilter("ysq_proc_code", "=", (Object)proCode);
                    DynamicObjectCollection jobsData = QueryServiceHelper.query((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])new QFilter[]{statusFilter, procCodeFilte});
                    for (DynamicObject job : jobsData) {
                        String jobNo = job.getString("ysq_job_no");
                        String version = job.getString("ysq_proc_ver");
                        boolean isExist = RobotPendingJobProducer.getInstance().checkHasJob(jobNo, null);
                        if (!isExist) continue;
                        this.addErrorMessage(data, String.format("%s\u6d41\u7a0b\u6709\u4efb\u52a1\u5df2\u52a0\u5165\u5904\u7406\u961f\u5217\uff0c\u4e0d\u80fd\u5220\u9664\u3002", proCode + "v" + version));
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<ProcessVersionDTO> list = new ArrayList<ProcessVersionDTO>();
        ArrayList<String> procIds = new ArrayList<String>();
        for (DynamicObject data : dataEntities) {
            String id = data.get("id").toString();
            DynamicObject processObj = null;
            try {
                processObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ysq_rpa_process_ver");
            }
            catch (Exception exception) {
                processObj = null;
            }
            if (null == processObj) continue;
            String procCode = processObj.get("ysq_proc_code").toString();
            String procVersion = processObj.get("ysq_proc_ver").toString();
            String felid = "ysq_kd_planid,ysq_kd_jobid";
            QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
            QFilter versionFilter = new QFilter("ysq_proc_ver", "=", (Object)procVersion);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_process_schedule", (String)felid, (QFilter[])new QFilter[]{codeFilter, versionFilter});
            for (DynamicObject sch : query) {
                Long jobId = sch.getLong("ysq_kd_jobid");
                Long palinId = sch.getLong("ysq_kd_planid");
                ScheduleUtils.delTaskJob((String)jobId.toString(), (String)palinId.toString());
            }
            list.add(new ProcessVersionDTO(procCode, procVersion));
            procIds.add(id);
        }
        for (ProcessVersionDTO processVersionDTO : list) {
            QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)processVersionDTO.getProcCode());
            QFilter versionFilter = new QFilter("ysq_proc_ver", "=", (Object)processVersionDTO.getProcVersion());
            QFilter[] filters = new QFilter[]{codeFilter, versionFilter};
            DynamicObject[] schs = BusinessDataServiceHelper.load((String)"ysq_process_schedule", (String)"id", (QFilter[])filters);
            for (DynamicObject sch : schs) {
                AttachmentServiceHelper.remove((String)"ysq_process_schedule", (Object)sch.getLong("id"));
            }
            DeleteServiceHelper.delete((String)"ysq_process_schedule", (QFilter[])filters);
        }
        for (ProcessVersionDTO processVersionDTO : list) {
            QFilter statusFilter = new QFilter("ysq_status", "=", (Object)RpaJobStatusEnums.PENDING.getCode());
            QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)processVersionDTO.getProcCode());
            QFilter versionFilter = new QFilter("ysq_proc_ver", "=", (Object)processVersionDTO.getProcVersion());
            DynamicObjectCollection jobsData = QueryServiceHelper.query((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])new QFilter[]{statusFilter, procCodeFilter, versionFilter});
            for (DynamicObject job : jobsData) {
                Long jobId = job.getLong("id");
                String jobNo = job.getString("ysq_job_no");
                JobQueueProducer.getInstance().removeJob(jobNo);
                AttachmentServiceHelper.remove((String)"ysq_rpa_job", (Object)jobId);
            }
            DeleteServiceHelper.delete((String)"ysq_rpa_job", (QFilter[])new QFilter[]{procCodeFilter, versionFilter, statusFilter});
        }
        ProcessServiceHelper.checkProcExistAndStartSchedule((String)"stop");
    }
}

