/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.process.version;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqProcessConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.constant.YsqRpaJobConstant;
import ysq.rpac.rpamc.common.constant.YsqScheduleConstant;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.message.RobotPendingJobProducer;
import ysq.rpac.rpamc.common.status.job.core.JobStatusCache;
import ysq.rpac.rpamc.common.utils.IsearchFileUtils;
import ysq.rpac.rpamc.common.utils.PermOrgsUtils;

public class ProcessVersionSaveOpPlugin
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(ProcessVersionSaveOpPlugin.class);
    public static final int COUNT = 100000;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
            }
        });
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            Long procVerId = dynamicObject.getLong("id");
            QFilter idFilter = new QFilter("id", "=", (Object)procVerId);
            boolean processVerExists = QueryServiceHelper.exists((String)"ysq_rpa_process_ver", (QFilter[])new QFilter[]{idFilter});
            String procCode = dynamicObject.getString("ysq_proc_code");
            String procVer = dynamicObject.getString("ysq_proc_ver");
            if (!processVerExists) {
                Long procId = null;
                if (!this.processExist(procCode).booleanValue()) {
                    procId = this.saveProcess(dynamicObject);
                }
                QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
                QFilter versionFilter = new QFilter("ysq_proc_ver", "=", (Object)procVer);
                boolean existsSameVersion = QueryServiceHelper.exists((String)"ysq_rpa_process_ver", (QFilter[])new QFilter[]{codeFilter, versionFilter});
                if (existsSameVersion) {
                    AttachmentServiceHelper.remove((String)"ysq_rpa_process_ver", (Object)dynamicObject.getLong("id"));
                    DeleteServiceHelper.delete((String)"ysq_rpa_process_ver", (QFilter[])new QFilter[]{codeFilter, versionFilter});
                    this.uploadSchedule(procCode, procVer, dynamicObject.getString("ysq_proc_name"), dynamicObject.getString("ysq_param_tag"));
                    this.cancel(procCode, procVer);
                }
                this.saveProcessVersion(dynamicObject, procId);
                continue;
            }
            this.saveProcessVersion(dynamicObject, null);
        }
    }

    private Boolean processExist(String procCode) {
        QFilter proCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        Boolean exist = QueryServiceHelper.exists((String)"ysq_rpa_process", (QFilter[])new QFilter[]{proCodeFilter});
        return exist;
    }

    private Boolean processOfVersionExist(String procCode, String procVersion) {
        QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        QFilter procVersionFilter = new QFilter("ysq_proc_ver", "=", (Object)procVersion);
        Boolean exist = QueryServiceHelper.exists((String)"ysq_rpa_process_ver", (QFilter[])new QFilter[]{procCodeFilter, procVersionFilter});
        return exist;
    }

    private Long saveProcess(DynamicObject dynamicObject) {
        String billNo;
        DynamicObject emptyObject;
        block1: {
            emptyObject = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_process");
            billNo = "";
            int i = 0;
            do {
                billNo = this.getBillNo();
                QFilter qFilter = new QFilter("billno", "=", (Object)billNo);
                QFilter[] qFilters = new QFilter[]{qFilter};
                boolean exists = QueryServiceHelper.exists((String)"ysq_rpa_process", (QFilter[])qFilters);
                if (!exists) break block1;
            } while (++i <= 100000);
            throw new KDException("\u6d41\u7a0b\u7f16\u53f7\u751f\u6210\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
        emptyObject.set("billno", (Object)billNo);
        emptyObject.set("ysq_status_ctime", (Object)new Date());
        emptyObject.set("ysq_publish_time", (Object)new Date());
        emptyObject.set("ysq_work_status", (Object)"release");
        emptyObject.set("ysq_proc_ver", dynamicObject.get("ysq_proc_ver"));
        emptyObject.set("ysq_proc_code", dynamicObject.get("ysq_proc_code"));
        emptyObject.set("ysq_proc_name", dynamicObject.get("ysq_proc_name"));
        emptyObject.set("ysq_proc_desc", dynamicObject.get("ysq_proc_desc"));
        Long userId = RequestContext.get().getCurrUserId();
        emptyObject.set("creator", (Object)userId);
        emptyObject.set("billstatus", (Object)"A");
        emptyObject.set("org", (Object)PermOrgsUtils.processNewOrgId((Long)userId, null));
        emptyObject.set("ysq_studio_ver", dynamicObject.get("ysq_studio_ver"));
        emptyObject.set("ysq_pro_change", dynamicObject.get("ysq_pro_change"));
        emptyObject.set("ysq_proc_type", (Object)"common");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{emptyObject});
        return emptyObject.getLong("id");
    }

    private void saveProcessVersion(DynamicObject model, Long procId) {
        if (procId != null) {
            model.set("ysq_proc_fid", (Object)procId);
            QFilter idFilter = new QFilter("id", "=", (Object)procId);
            DynamicObject process = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])new QFilter[]{idFilter});
            model.set("billno", process.get("billno"));
        } else {
            QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)model.getString("ysq_proc_code"));
            DynamicObject process = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
            model.set("billno", process.get("billno"));
        }
        model.set("ysq_proc_name", (Object)model.getString("ysq_proc_name"));
        this.updateAllProcessName(model.getString("ysq_proc_code"), model.getString("ysq_proc_name"));
        model.set("ysq_proc_desc", (Object)model.getString("ysq_proc_desc"));
        model.set("ysq_publish_time", (Object)new Date());
        model.set("ysq_status_ctime", (Object)new Date());
        model.set("ysq_work_status", (Object)"release");
        model.set("ysq_is_activity", (Object)"yes");
        model.set("ysq_param_tag", model.get("ysq_param_tag"));
        model.set("billstatus", (Object)"A");
    }

    private void updateAllProcessName(String procCode, String name) {
        QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObject process = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
        if (!process.getString("ysq_proc_name").equals(name)) {
            DynamicObject[] list;
            process.set("ysq_proc_name", (Object)name);
            for (DynamicObject e : list = BusinessDataServiceHelper.load((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter})) {
                e.set("ysq_proc_name", (Object)name);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{process});
            SaveServiceHelper.save((DynamicObject[])list);
        }
    }

    private String getBillNo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        String format = sdf.format(new Date());
        int i = (int)(Math.random() * 90000.0 + 10000.0);
        String billNo = "RPAprocess_" + format + "_" + i;
        return billNo;
    }

    private Long getProcess(String procCode) {
        QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObject process = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
        return process.getLong("id");
    }

    private void uploadSchedule(String procCode, String procVer, String procName, String procParam) {
        QFilter qFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        QFilter versionFilter = new QFilter("ysq_proc_ver", "=", (Object)procVer);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"ysq_process_schedule", (String)YsqScheduleConstant.selAllFileds(), (QFilter[])new QFilter[]{qFilter, versionFilter});
        if (load != null && load.length > 0) {
            String paramBase64 = procParam;
            if (StringUtils.isNotBlank((CharSequence)procParam)) {
                paramBase64 = IsearchFileUtils.paramsBase64((String)procParam);
            }
            for (DynamicObject sch : load) {
                sch.set("ysq_proc_ver", (Object)procVer);
                sch.set("ysq_proc_name", (Object)procName);
                sch.set("ysq_sch_param_tag", (Object)paramBase64);
            }
            SaveServiceHelper.update((DynamicObject[])load);
        }
    }

    private void cancel(String procCode, String procVer) {
        QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        QFilter versionFilter = new QFilter("ysq_proc_ver", "=", (Object)procVer);
        QFilter statusFilter = new QFilter("ysq_status", "=", (Object)RpaJobStatusEnums.PENDING.getCode());
        DynamicObject[] jobs = BusinessDataServiceHelper.load((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])new QFilter[]{procCodeFilter, statusFilter, versionFilter});
        if (jobs != null && jobs.length > 0) {
            for (DynamicObject job : jobs) {
                String jobNo = job.getString("ysq_job_no");
                Long jobId = job.getLong("id");
                boolean isExist = RobotPendingJobProducer.getInstance().checkHasJob(jobNo, null);
                if (isExist) {
                    log.info("\u4efb\u52a1\u5df2\u88ab\u9886\u53d6\uff0c\u4ec5\u7b49\u5f85\u8fd0\u884c\u4e2d\u7684\u6d41\u7a0b\u4efb\u52a1\u53ef\u6267\u884c\u53d6\u6d88\u64cd\u4f5c\u3002");
                    continue;
                }
                boolean b = JobStatusCache.getInstance().handChacheStatusCheck(jobId, jobNo, RpaJobStatusEnums.PENDING.getCode(), ((Object)((Object)this)).getClass().getName());
                if (b) {
                    log.info("\u4fee\u6539\u52a8\u4f5c\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u3002");
                    continue;
                }
                try {
                    JobStatusCache.getInstance().handChacheStatus(jobId, jobNo, RpaJobStatusEnums.CANCELLED.getCode(), ((Object)((Object)this)).getClass().getName());
                }
                catch (Exception e) {
                    log.debug("exc: \u4efb\u52a1id\uff1a{}\uff0cjobNO\uff1a{}\uff0c\u8981\u6539\u6210\u72b6\u6001\uff1a{}\uff0c\u5df2\u63d0\u4ea4\uff0c\u672c\u6b21\u4e0d\u63d0\u4ea4\u961f\u5217\u3002\u4fee\u6539\u65f6\u95f4\uff1a{}", new Object[]{jobId, jobNo, RpaJobStatusEnums.CANCELLED.getCode(), new Date()});
                }
            }
        }
    }
}

