/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.queues;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.enums.RobotRangeEnums;
import ysq.rpac.rpamc.common.utils.UserUtils;

public class QueuesFormPlugin
extends AbstractFormPlugin {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String YSQ_BTN_SAVE = "ysq_btn_save";

    public void preOpenForm(PreOpenFormEventArgs e) {
        e.getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        Long fid = dataEntity.getLong("id");
        if (fid != null && fid != 0L) {
            this.getView().setFormTitle(new LocaleString("\u7f16\u8f91\u6570\u636e\u7a7a\u95f4"));
        }
        this.initData();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button = (Button)this.getView().getControl(YSQ_BTN_SAVE);
        button.addClickListener((ClickListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)YSQ_BTN_SAVE)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Long fid = dataEntity.getLong("id");
            String queueName = dataEntity.getString("ysq_queue_name");
            boolean exists = QueryServiceHelper.exists((String)"ysq_rpa_queues", (QFilter[])new QFilter[]{new QFilter("ysq_queue_name", "=", (Object)queueName)});
            if ((fid == null || fid == 0L) && exists) {
                this.getView().showTipNotification("\u6570\u636e\u7a7a\u95f4\u540d\u5df2\u5b58\u5728\u3002");
                evt.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs changeArgs) {
        Object newValue;
        ChangeData[] changeSet;
        super.propertyChanged(changeArgs);
        String fieldKey = changeArgs.getProperty().getName();
        if ("ysq_robots_no_sel".equals(fieldKey) && (changeSet = changeArgs.getChangeSet()) != null && changeSet.length > 0 && (newValue = changeSet[0].getNewValue()) != null) {
            String value = newValue.toString();
            String[] split = value.split(",");
            if (RobotRangeEnums.DEPTALL.getCode().equals(split[split.length - 1])) {
                this.getModel().setValue("ysq_robots_no_sel", (Object)("," + RobotRangeEnums.DEPTALL.getCode() + ","));
            } else {
                String replace = value.replace(",-deptall-,", ",");
                this.getModel().setValue("ysq_robots_no_sel", (Object)replace);
            }
        }
    }

    private void initData() {
        long orgId = RequestContext.get().getOrgId();
        List childOrg = UserUtils.getChildOrg((long)orgId);
        this.bindAgent(childOrg);
    }

    private void bindAgent(List<Long> childOrg) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("ysq_robots_no_sel");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        ArrayList<String> agentTypes = new ArrayList<String>();
        agentTypes.add("robot");
        agentTypes.add("assistant");
        QFilter filter = new QFilter("org", "in", childOrg);
        filter.and(new QFilter("ysq_agent_type", "in", agentTypes));
        filter.or(new QFilter("ysq_agent_type", "=", (Object)"standardRobot"));
        String field = "ysq_agent_alias,ysq_agent_no";
        DynamicObject[] processList = BusinessDataServiceHelper.load((String)"ysq_rpa_agent", (String)field, (QFilter[])new QFilter[]{filter});
        data.add(new ComboItem(new LocaleString(RobotRangeEnums.DEPTALL.getName()), RobotRangeEnums.DEPTALL.getCode()));
        for (DynamicObject dynamicObject : processList) {
            Object code = dynamicObject.get("ysq_agent_no");
            Object name = dynamicObject.get("ysq_agent_alias");
            data.add(new ComboItem(new LocaleString(name.toString()), code.toString()));
        }
        comboEdit.setComboItems(data);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String robots = dataEntity.getString("ysq_robots_no_sel");
        if (StringUtils.isBlank((CharSequence)robots) || ",,".equals(robots)) {
            this.getModel().setValue("ysq_robots_no_sel", (Object)("," + RobotRangeEnums.DEPTALL.getCode() + ","));
        }
    }
}

