/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.queues;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.enums.RobotRangeEnums;

public class QueuesSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject data : dataEntities = e.getDataEntities()) {
            String robotNo = data.getString("ysq_robots_no_sel");
            if (StringUtils.isNotBlank((CharSequence)robotNo)) {
                String dep = "," + RobotRangeEnums.DEPTALL.getCode() + ",";
                if (dep.equals(robotNo)) {
                    String sub = robotNo.substring(1, robotNo.length() - 1);
                    data.set("ysq_robots_no_tag", (Object)sub);
                    data.set("ysq_agent_alias_tag", (Object)sub);
                    continue;
                }
                String[] split = robotNo.split(",");
                StringBuilder sbRobotNo = new StringBuilder();
                StringBuilder sbAlias = new StringBuilder();
                for (String s : split) {
                    if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                    sbRobotNo.append("-");
                    sbRobotNo.append(s);
                    sbRobotNo.append("-");
                    sbRobotNo.append(",");
                    ArrayList<String> agentTypes = new ArrayList<String>();
                    agentTypes.add("assistant");
                    agentTypes.add("robot");
                    agentTypes.add("standardRobot");
                    QFilter qFilter = new QFilter("ysq_agent_no", "=", (Object)s);
                    qFilter.and("ysq_agent_type", "in", agentTypes);
                    DynamicObject robot = QueryServiceHelper.queryOne((String)"ysq_rpa_agent", (String)"ysq_agent_alias", (QFilter[])new QFilter[]{qFilter});
                    if (!ObjectUtils.isNotEmpty((Object)robot)) continue;
                    String alias = robot.getString("ysq_agent_alias");
                    if (StringUtils.isBlank((CharSequence)alias)) {
                        alias = s;
                    }
                    sbAlias.append("-");
                    sbAlias.append(alias);
                    sbAlias.append("-");
                    sbAlias.append(",");
                }
                String robotNos = sbRobotNo.substring(0, sbRobotNo.length() - 1);
                String robotAlias = sbAlias.substring(0, sbAlias.length() - 1);
                data.set("ysq_robots_no_tag", (Object)robotNos);
                data.set("ysq_agent_alias_tag", (Object)robotAlias);
                continue;
            }
            data.set("ysq_robots_no_tag", (Object)" ");
        }
    }
}

