/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.rpajob;

import com.google.common.base.Strings;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.upgrade.ProcessMigrate;

public class JobContainerInitPlugin
extends AbstractListPlugin {
    private static final List<String> ALLOWED_ORDERED_PROPERTIES = Collections.unmodifiableList(Arrays.asList("feq", "ysq_proc_name", "ysq_job_type", "ysq_curr_robot_name", "ysq_status", "ysq_start_time", "ysq_run_time_sec"));
    private static final String KEY_TODAY = "13";
    private static final String KEY_WEEK = "10";
    private static final String KEY_MONTH = "63";
    private static final String BILLLISTAP = "billlistap";

    public void setFilter(SetFilterEvent e) {
        QFilter qFilter;
        DynamicObjectCollection query;
        DynamicObject dynamicObject;
        super.setFilter(e);
        ArrayList qFilterList = new ArrayList();
        Long currentUserId = UserServiceHelper.getCurrentUserId();
        List qFilters = e.getQFilters();
        ArrayList<QFilter> jobTypeFilterList = new ArrayList<QFilter>();
        Iterator filterIterator = qFilters.iterator();
        while (filterIterator.hasNext()) {
            QFilter oneFilter = (QFilter)filterIterator.next();
            String property = oneFilter.getProperty();
            if (!"ysq_job_type".equals(property)) continue;
            filterIterator.remove();
            String jobTypes = oneFilter.getValue().toString();
            QFilter qFilter2 = null;
            if (jobTypes.contains("plan")) {
                if (null == qFilter2) {
                    qFilter2 = new QFilter("ysq_job_type", "=", (Object)"plan");
                } else {
                    qFilter2.or(new QFilter("ysq_job_type", "=", (Object)"plan"));
                }
            }
            if (jobTypes.contains("self")) {
                if (null == qFilter2) {
                    qFilter2 = new QFilter("ysq_job_type", "=", (Object)currentUserId.toString());
                } else {
                    qFilter2.or(new QFilter("ysq_job_type", "=", (Object)currentUserId.toString()));
                }
            }
            if (jobTypes.contains("other")) {
                if (null == qFilter2) {
                    qFilter2 = new QFilter("ysq_job_type", "!=", (Object)currentUserId.toString());
                } else {
                    qFilter2.or(new QFilter("ysq_job_type", "!=", (Object)currentUserId.toString()));
                }
            }
            if (null == qFilter2) continue;
            jobTypeFilterList.add(qFilter2);
        }
        for (QFilter oneFilter : jobTypeFilterList) {
            qFilters.add(oneFilter);
        }
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Long schId = (Long)showParameter.getCustomParam("ysq_sch_fid");
        Object appFid = showParameter.getCustomParam("appFid");
        String isAppOpenParam = (String)showParameter.getCustomParam("isAppOpen");
        Map customParams = showParameter.getCustomParams();
        if (StringUtils.isNotBlank((CharSequence)isAppOpenParam)) {
            e.addCustomQFilter(new QFilter("ysq_com_job_type", "=", (Object)"standard"));
        } else {
            e.addCustomQFilter(new QFilter("ysq_com_job_type", "!=", (Object)"standard"));
        }
        if (ObjectUtils.isNotEmpty((Object)appFid) && (dynamicObject = (DynamicObject)(query = QueryServiceHelper.query((String)"ysq_app_mine", (String)"ysq_proc_code", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "=", (Object)Long.valueOf(appFid.toString()))})).get(0)) != null) {
            String appProcCode = dynamicObject.getString("ysq_proc_code");
            e.addCustomQFilter(new QFilter("ysq_proc_code", "=", (Object)appProcCode));
        }
        if (schId != null) {
            QFilter idFilter = new QFilter("ysq_sch_fid", "=", (Object)schId);
            e.addCustomQFilter(idFilter);
        }
        String proCode = null;
        String proVer = null;
        Boolean contactVersion = null;
        if (customParams != null) {
            Object proCodeObj = customParams.get("ysq_proc_code");
            Object proVerObj = customParams.get("ysq_proc_ver");
            if (proCodeObj != null) {
                proCode = proCodeObj.toString();
            }
            if (proVerObj != null) {
                proVer = proVerObj.toString();
            }
            if (customParams.get("contactVersion") != null) {
                contactVersion = Boolean.parseBoolean(customParams.get("contactVersion").toString());
            }
        }
        if (StringUtils.isNotBlank(proVer)) {
            e.addCustomQFilter(new QFilter("ysq_proc_code", "=", proCode));
        }
        if (StringUtils.isNotBlank(proVer) && contactVersion.booleanValue()) {
            e.addCustomQFilter(new QFilter("ysq_proc_ver", "=", (Object)proVer));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        FilterColumn filterColumn;
        FilterColumn startTimeColumn;
        super.filterContainerInit(args);
        ProcessMigrate.migrateProcess();
        if (!Strings.isNullOrEmpty((String)((String)this.getView().getFormShowParameter().getCustomParam("isAppOpen")))) {
            List list = args.getFastFilterColumns();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (((FilterColumn)iterator.next()).getFieldName().equals("ysq_proc_name")) continue;
                iterator.remove();
            }
        }
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Object dptIdParam = showParameter.getCustomParam("dptIds");
        String dateTypeParam = (String)showParameter.getCustomParam("dateType");
        String statusParam = (String)showParameter.getCustomParam("ysq_status");
        Object orgIdObj = showParameter.getCustomParam("org");
        Map customParams = showParameter.getCustomParams();
        List jobStatusList = null;
        if (customParams != null) {
            jobStatusList = (List)customParams.get("jobStatus");
        }
        if (jobStatusList != null) {
            FilterColumn statusColumn = args.getFilterColumn("ysq_status");
            statusColumn.setDefaultValues(jobStatusList);
        }
        Long orgId = null;
        if (orgIdObj != null) {
            orgId = Long.valueOf(orgIdObj.toString());
        }
        Long dptId = null;
        FilterColumn orgColumn = args.getFilterColumn("org.number");
        if (dptIdParam != null) {
            dptId = Long.valueOf(dptIdParam.toString());
        }
        if (orgColumn != null && dptId != null) {
            orgColumn.setDefaultValues(new Object[]{dptId.toString()});
        }
        if ((startTimeColumn = args.getFilterColumn("ysq_job_time")) != null && dateTypeParam != null && StringUtils.isNotBlank((CharSequence)dateTypeParam)) {
            if ("today".equals(dateTypeParam)) {
                startTimeColumn.setDefaultValue(KEY_TODAY);
            }
            if ("week".equals(dateTypeParam)) {
                startTimeColumn.setDefaultValue(KEY_WEEK);
            }
            if ("month".equals(dateTypeParam)) {
                startTimeColumn.setDefaultValue(KEY_MONTH);
            }
            if ("custom".equals(dateTypeParam)) {
                String customDateParam = (String)showParameter.getCustomParam("customDate");
                int year = Integer.parseInt(customDateParam.substring(0, 4));
                int month = Integer.parseInt(customDateParam.substring(5, 7));
                String lastDayOfMonth = JobContainerInitPlugin.getLastDayOfMonth(year, month);
                startTimeColumn.setDefaultValues(new Object[]{customDateParam, lastDayOfMonth});
            }
        }
        if ((filterColumn = args.getFilterColumn("ysq_status")) != null && statusParam != null && StringUtils.isNotBlank((CharSequence)statusParam)) {
            filterColumn.setDefaultValue(statusParam);
        }
        FilterColumn orgCoum = args.getFilterColumn("org.number");
        if (orgId != null) {
            orgCoum.setDefaultValue(orgId.toString());
        }
    }

    public static String getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(cal.getTime());
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        if (!Strings.isNullOrEmpty((String)((String)this.getView().getFormShowParameter().getCustomParam("isAppOpen")))) {
            List columns = args.getListColumns();
            Iterator iterator = columns.iterator();
            while (iterator.hasNext()) {
                if (ALLOWED_ORDERED_PROPERTIES.contains(((IListColumn)iterator.next()).getListFieldKey())) continue;
                iterator.remove();
            }
        }
    }
}

