/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.rpajob;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import ysq.rpac.rpamc.common.utils.DateUtils;
import ysq.rpac.rpamc.common.utils.UserUtils;

public class JobDataLoadListPlugin
extends AbstractListPlugin {
    public static final String YSQ_PENDING_TIME_DESC = "ysq_pending_time_desc";
    public static final String YSQ_RUN_TIME_SEC = "ysq_run_time_sec";
    private static Log log = LogFactory.getLog(JobDataLoadListPlugin.class);

    public void packageData(PackageDataEvent e) {
        DynamicObject rowData = e.getRowData();
        this.dataEncapsulation(e, rowData);
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageData = e.getPageData();
        for (DynamicObject data : pageData) {
            String jobType = data.getString("ysq_job_type");
            String string = data.getString("ysq_curr_robot_name");
            if ("plan".equals(jobType)) continue;
            try {
                Long userId = Long.valueOf(jobType);
                String userName = UserUtils.getUserName((Long)userId);
                data.set("ysq_job_type", (Object)userName);
            }
            catch (Exception exception) {
                log.debug(exception.getMessage());
            }
        }
    }

    private void dataEncapsulation(PackageDataEvent e, DynamicObject rowData) {
        if (e.getSource() instanceof ColumnDesc) {
            ColumnDesc columnDesc = (ColumnDesc)e.getSource();
            String key = columnDesc.getKey();
            if (YSQ_RUN_TIME_SEC.equals(columnDesc.getKey())) {
                Long runTime = rowData.getLong(YSQ_RUN_TIME_SEC);
                String runTimeDes = DateUtils.secondToTimeFormat((long)runTime);
                e.setFormatValue((Object)runTimeDes);
            }
            if ("ysq_pending_time".equals(columnDesc.getKey())) {
                Long pendingTime = rowData.getLong("ysq_pending_time");
                String pendingTimeDes = DateUtils.secondToTime((long)pendingTime);
                e.setFormatValue((Object)pendingTimeDes);
            }
        }
    }
}

