/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.rpajob;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;

public class JobDelOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("ysq_status");
        e.getFieldKeys().add("ysq_job_no");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                RowDataModel rowDataModel = new RowDataModel(this.entityKey, this.getValidateContext().getSubEntityType());
                for (ExtendedDataEntity data : dataEntities) {
                    rowDataModel.setRowContext(data.getDataEntity());
                    String id = data.getValue("id").toString();
                    String jobNo = data.getValue("ysq_job_no").toString();
                    String status = data.getValue("ysq_status").toString();
                    if (RpaJobStatusEnums.SUCCESS.getCode().equals(status) || RpaJobStatusEnums.FAILED.getCode().equals(status) || RpaJobStatusEnums.STOPPED.getCode().equals(status) || RpaJobStatusEnums.PEND_OUTTIME.getCode().equals(status) || RpaJobStatusEnums.CANCELLED.getCode().equals(status) || RpaJobStatusEnums.RUN_OUTTIME.getCode().equals(status)) continue;
                    this.addErrorMessage(data, String.format("%s\u72b6\u6001\u672a\u662f\u7ed3\u675f\u3001\u505c\u6b62\u3001\u5f02\u5e38\u3002", jobNo));
                }
            }
        });
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject data : dataEntities) {
            Long id = data.getLong("id");
            ids.add(id);
            AttachmentServiceHelper.remove((String)"ysq_rpa_job", (Object)id);
        }
        DynamicObject jobObject = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_job");
        DeleteServiceHelper.delete((IDataEntityType)jobObject.getDataEntityType(), (Object[])ids.toArray());
    }
}

