/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.rpajob;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.listop.ExportList;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import ysq.rpac.rpamc.common.constant.YsqRpaJobConstant;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.task.JobStatusCacheTask;
import ysq.rpac.rpamc.common.task.JobStatusChangeTask;
import ysq.rpac.rpamc.common.utils.ExecPoiUtils;
import ysq.rpac.rpamc.common.utils.KdPageUtils;
import ysq.rpac.rpamc.common.utils.UserUtils;

public class JobListPlugin
extends AbstractListPlugin {
    private static Log log = LogFactory.getLog(JobListPlugin.class);
    private static String KEY_MAINBAR = "toolbarap";
    private static final String BILLLISTAP = "billlistap";
    private static String YSQ_BTN_JOBDEL = "tbldel";
    private static String YSQ_BTN_CANCEL = "ysq_cancel";
    private static String YSQ_BTN_STOP = "ysq_btn_stop";
    private static String YSQ_BTN_RESTART = "ysq_btn_restart";
    private static String YSQ_JOB_LOG = "ysq_btn_log";
    private static String YSQ_JOB_ERROR_LOG = "ysq_btn_error_log";
    private static String YSQ_RPA_JOB_LOG = "ysq_rpa_job_log";
    private static String YSQ_RPA_JOB_FAIL = "ysq_rpa_job_fail";
    private static String PENDING_TIME_ESC = "ysq_pending_time_desc";
    private static String RUN_TIME_ESC = "ysq_run_time_sec_desc";
    private static String YSQ_RPA_SFILE = "ysq_rpa_sfile";
    private static String YSQ_RPA_SFILE_BACK = "ysq_rpa_sfile_back";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_MAINBAR});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (StringUtils.equals((CharSequence)YSQ_BTN_JOBDEL, (CharSequence)evt.getItemKey())) {
            BillList list = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            int size = selectedRows.size();
            if (size > 0) {
                String msg = String.format("\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d.\u786e\u5b9a\u8981\u5220\u9664\u6539\u8bb0\u5f55\u5417\uff1f", size);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("contentChange", (IFormPlugin)this);
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBacks);
                return;
            }
            this.getView().showTipNotification("\u672a\u9009\u62e9\u76f8\u5e94\u6570\u636e\u3002");
            evt.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)YSQ_BTN_CANCEL, (CharSequence)evt.getItemKey()) || StringUtils.equals((CharSequence)YSQ_BTN_STOP, (CharSequence)evt.getItemKey())) {
            BillList list = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            int size = selectedRows.size();
            if (size == 1) {
                String jobId = selectedRows.get(0).getPrimaryKeyValue().toString();
                Long lJobId = Long.valueOf(jobId);
                QFilter qFilter = new QFilter("id", "=", (Object)lJobId);
                DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_rpa_job", (String)"ysq_status", (QFilter[])new QFilter[]{qFilter});
                DynamicObject dynamicObject = (DynamicObject)query.get(0);
                String jobStatus = dynamicObject.getString("ysq_status");
                if (StringUtils.equals((CharSequence)YSQ_BTN_CANCEL, (CharSequence)evt.getItemKey()) && !RpaJobStatusEnums.PENDING.getCode().equals(jobStatus)) {
                    this.getView().showTipNotification("\u4ec5\u7b49\u5f85\u8fd0\u884c\u4e2d\u7684\u6d41\u7a0b\u4efb\u52a1\u53ef\u6267\u884c\u53d6\u6d88\u64cd\u4f5c\u3002");
                    evt.setCancel(true);
                    return;
                }
                if (StringUtils.equals((CharSequence)YSQ_BTN_STOP, (CharSequence)evt.getItemKey()) && !RpaJobStatusEnums.RUNNING.getCode().equals(jobStatus)) {
                    this.getView().showTipNotification("\u4ec5\u6b63\u5728\u8fd0\u884c\u4e2d\u7684\u6d41\u7a0b\u4efb\u52a1\u53ef\u6267\u884c\u505c\u6b62\u64cd\u4f5c\u3002");
                    evt.setCancel(true);
                    return;
                }
            } else if (size > 1) {
                ArrayList<Long> jobIdList = new ArrayList<Long>();
                for (ListSelectedRow selectedRow : selectedRows) {
                    String strId = selectedRow.getPrimaryKeyValue().toString();
                    Long lId = Long.valueOf(strId);
                    jobIdList.add(lId);
                }
                QFilter qFilter = new QFilter("id", "in", jobIdList);
                DynamicObjectCollection jobCollection = QueryServiceHelper.query((String)"ysq_rpa_job", (String)"ysq_status", (QFilter[])new QFilter[]{qFilter});
                if (jobCollection != null && jobCollection.size() > 1) {
                    String firstJobStatus = ((DynamicObject)jobCollection.get(0)).getString("ysq_status");
                    for (int i = 1; i < jobCollection.size(); ++i) {
                        if (firstJobStatus.equals(((DynamicObject)jobCollection.get(i)).getString("ysq_status"))) continue;
                        if (StringUtils.equals((CharSequence)YSQ_BTN_CANCEL, (CharSequence)evt.getItemKey())) {
                            this.getView().showTipNotification("\u8fd0\u884c\u72b6\u6001\u4e0d\u4e00\u81f4\u3002\u4ec5\u7b49\u5f85\u8fd0\u884c\u4e2d\u7684\u6d41\u7a0b\u4efb\u52a1\u53ef\u6267\u884c\u53d6\u6d88\u64cd\u4f5c\u3002");
                        } else if (StringUtils.equals((CharSequence)YSQ_BTN_STOP, (CharSequence)evt.getItemKey())) {
                            this.getView().showTipNotification("\u8fd0\u884c\u72b6\u6001\u4e0d\u4e00\u81f4\u3002\u4ec5\u6b63\u5728\u8fd0\u884c\u4e2d\u7684\u6d41\u7a0b\u4efb\u52a1\u53ef\u6267\u884c\u505c\u6b62\u64cd\u4f5c\u3002");
                        }
                        evt.setCancel(true);
                        return;
                    }
                    if (StringUtils.equals((CharSequence)YSQ_BTN_CANCEL, (CharSequence)evt.getItemKey())) {
                        if (!StringUtils.equals((CharSequence)firstJobStatus, (CharSequence)RpaJobStatusEnums.PENDING.getCode())) {
                            this.getView().showTipNotification("\u4ec5\u7b49\u5f85\u8fd0\u884c\u4e2d\u7684\u6d41\u7a0b\u4efb\u52a1\u53ef\u6267\u884c\u53d6\u6d88\u64cd\u4f5c\u3002");
                            evt.setCancel(true);
                            return;
                        }
                    } else if (StringUtils.equals((CharSequence)YSQ_BTN_STOP, (CharSequence)evt.getItemKey()) && !StringUtils.equals((CharSequence)firstJobStatus, (CharSequence)RpaJobStatusEnums.RUNNING.getCode())) {
                        this.getView().showTipNotification("\u4ec5\u6b63\u5728\u8fd0\u884c\u4e2d\u7684\u6d41\u7a0b\u4efb\u52a1\u53ef\u6267\u884c\u505c\u6b62\u64cd\u4f5c\u3002");
                        evt.setCancel(true);
                        return;
                    }
                }
            }
            String msg = "";
            if (StringUtils.equals((CharSequence)YSQ_BTN_CANCEL, (CharSequence)evt.getItemKey())) {
                msg = "\u662f\u5426\u53d6\u6d88\u8be5\u6761\u6d41\u7a0b\u4efb\u52a1\uff1f";
            } else if (StringUtils.equals((CharSequence)YSQ_BTN_STOP, (CharSequence)evt.getItemKey())) {
                msg = "\u662f\u5426\u505c\u6b62\u8be5\u6761\u6d41\u7a0b\u4efb\u52a1\uff1f";
            }
            if (size > 0) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("contentChange", (IFormPlugin)this);
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBacks);
                return;
            }
            this.getView().showTipNotification("\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002");
            evt.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)YSQ_BTN_RESTART, (CharSequence)evt.getItemKey())) {
            BillList list = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            int size = selectedRows.size();
            if (size == 1) return;
            this.getView().showTipNotification("\u8bf7\u9009\u62e9\u4e00\u6761\u201c\u5df2\u5931\u8d25\u201d\u7684\u4efb\u52a1\u8fdb\u884c\u64cd\u4f5c\u3002");
            evt.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)YSQ_JOB_LOG, (CharSequence)evt.getItemKey())) {
            if (!this.checkRows(evt)) {
                return;
            }
            BillList list = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection rows = list.getSelectedRows();
            ListSelectedRow row = rows.get(0);
            String id = row.toString();
            DynamicObject dynamicObject = null;
            try {
                dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ysq_rpa_job");
            }
            catch (Exception e) {
                log.debug(e.getMessage());
                dynamicObject = null;
            }
            if (null == dynamicObject) {
                this.getView().showTipNotification("\u53ea\u80fd\u67e5\u770b\u8fd0\u884c\u6210\u529f\u3001\u8fd0\u884c\u5931\u8d25\u3001\u51c6\u5907\u505c\u6b62\u3001\u6b63\u5728\u8fd0\u884c\u3001\u5df2\u505c\u6b62\u72b6\u6001\u7684\u65e5\u5fd7\u8bb0\u5f55\u3002");
                evt.setCancel(true);
                return;
            }
            String status = dynamicObject.getString("ysq_status");
            if (!(StringUtils.equals((CharSequence)status, (CharSequence)RpaJobStatusEnums.SUCCESS.getCode()) || StringUtils.equals((CharSequence)status, (CharSequence)RpaJobStatusEnums.FAILED.getCode()) || StringUtils.equals((CharSequence)status, (CharSequence)RpaJobStatusEnums.RUNNING.getCode()) || StringUtils.equals((CharSequence)status, (CharSequence)RpaJobStatusEnums.STOPPING.getCode()) || StringUtils.equals((CharSequence)status, (CharSequence)RpaJobStatusEnums.STOPPED.getCode()) || StringUtils.equals((CharSequence)status, (CharSequence)RpaJobStatusEnums.RUN_OUTTIME.getCode()))) {
                this.getView().showTipNotification("\u53ea\u80fd\u67e5\u770b\u8fd0\u884c\u6210\u529f\u3001\u8fd0\u884c\u5931\u8d25\u3001\u51c6\u5907\u505c\u6b62\u3001\u6b63\u5728\u8fd0\u884c\u3001\u5df2\u505c\u6b62\u72b6\u6001\u7684\u65e5\u5fd7\u8bb0\u5f55\u3002");
                evt.setCancel(true);
                return;
            }
            Long lid = dynamicObject.getLong("id");
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("id", lid);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(YSQ_RPA_JOB_LOG);
            showParameter.setCustomParams(map);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
            return;
        }
        if (!StringUtils.equals((CharSequence)YSQ_JOB_ERROR_LOG, (CharSequence)evt.getItemKey())) return;
        if (!this.checkRows(evt)) {
            return;
        }
        BillList list = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection rows = list.getSelectedRows();
        ListSelectedRow row = rows.get(0);
        DynamicObject dynamicObject = null;
        try {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)row.toString(), (String)"ysq_rpa_job");
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            dynamicObject = null;
        }
        if (null == dynamicObject) {
            this.getView().showTipNotification("\u8be5\u6761\u4efb\u52a1\u5df2\u4e0d\u5b58\u5728\u3002");
            evt.setCancel(true);
            return;
        }
        String status = dynamicObject.getString("ysq_status");
        String content = dynamicObject.getString("ysq_exception_content_tag");
        if (!StringUtils.equals((CharSequence)status, (CharSequence)RpaJobStatusEnums.FAILED.getCode())) {
            this.getView().showTipNotification("\u53ea\u80fd\u67e5\u770b\u5df2\u5931\u8d25\u72b6\u6001\u7684\u5f02\u5e38\u8bb0\u5f55\u3002");
            evt.setCancel(true);
            return;
        }
        if (StringUtils.isBlank((CharSequence)content)) {
            this.getView().showTipNotification("\u8be5\u6761\u4efb\u52a1\u6682\u65e0\u5f02\u5e38\u8bb0\u5f55\u3002");
            evt.setCancel(true);
            return;
        }
        String procName = dynamicObject.getString("ysq_proc_name");
        String procVer = dynamicObject.getString("ysq_proc_ver");
        String exceptionName = dynamicObject.getString("ysq_exception_name");
        String exceptionContentTag = dynamicObject.getString("ysq_exception_content_tag");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ysq_proc_name", procName);
        map.put("ysq_proc_ver", procVer);
        map.put("ysq_exception_name", exceptionName);
        map.put("ysq_exception_content_tag", exceptionContentTag);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(YSQ_RPA_JOB_FAIL);
        showParameter.setCustomParams(map);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)YSQ_JOB_ERROR_LOG, (CharSequence)itemKey)) {
            BillList list = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection listSelectedRowCollection = list.getSelectedRows();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        Object source;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals("canceljob")) {
            this.getView().invokeOperation("refresh");
        }
        if (!StringUtils.equals((CharSequence)operateKey, (CharSequence)"refresh") && !((source = afterDoOperationEventArgs.getSource()) instanceof ExportList)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        new JobStatusCacheTask().doTask();
        new JobStatusChangeTask().doTask();
    }

    public void afterExportFile(ExportFileEvent e) {
        Map customHeaderMap = e.getCustomHeaderMap();
        File file = e.getFile();
        if (file != null) {
            try (FileInputStream fis = new FileInputStream(file);){
                XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);
                Sheet sheet = wb.getSheetAt(0);
                boolean b = ExecPoiUtils.checkTitle((Sheet)sheet);
                int line = 1;
                if (b) {
                    line = 4;
                }
                ExecPoiUtils.fieldModify((Workbook)wb, (Sheet)sheet, (String)"\u8fd0\u884c\u65f6\u957f", (int)line);
                ExecPoiUtils.fieldModify((Workbook)wb, (Sheet)sheet, (String)"\u7b49\u5f85\u65f6\u957f", (int)line);
                FileOutputStream out = new FileOutputStream(file);
                wb.write((OutputStream)out);
                wb.close();
                out.close();
            }
            catch (Throwable ex) {
                log.warn("\u5bfc\u51fa\u4efb\u52a1\u6570\u636e\u5931\u8d25\uff1a" + ex.getMessage());
            }
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] datas;
        for (DynamicObject data : datas = e.getQueryValues()) {
            String jobType = data.getString("ysq_job_type");
            String cuuName = data.getString("ysq_curr_robot_name");
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue_zh_CN(cuuName);
            data.set("ysq_curr_robot_name", (Object)localeString);
            if ("plan".equals(jobType)) continue;
            try {
                Long userId = Long.valueOf(jobType);
                String userName = UserUtils.getUserName((Long)userId);
                data.set("ysq_job_type", (Object)userName);
            }
            catch (Exception exception) {
                log.debug(exception.getMessage());
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Object primaryKeyValue;
        ListSelectedRow currentRow;
        args.setCancel(true);
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        if (hyperLinkClickEvent != null && (currentRow = hyperLinkClickEvent.getCurrentRow()) != null && (primaryKeyValue = currentRow.getPrimaryKeyValue()) != null) {
            Long lid = Long.valueOf(primaryKeyValue.toString());
            QFilter idFilter = new QFilter("id", "=", (Object)lid);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])new QFilter[]{idFilter});
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("ysq_job_no", dynamicObject.getString("ysq_job_no"));
            ListShowParameter formShowParameter = KdPageUtils.toListPage((String)YSQ_RPA_SFILE, (ShowType)ShowType.MainNewTabPage, map);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, YSQ_RPA_SFILE_BACK));
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    private boolean checkRows(BeforeItemClickEvent evt) {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        int size = selectedRows.size();
        if (size > 1) {
            this.getView().showTipNotification("\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002");
            evt.setCancel(true);
            return false;
        }
        if (size == 0) {
            this.getView().showTipNotification("\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002");
            evt.setCancel(true);
            return false;
        }
        return true;
    }
}

