/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.rpajob;

import java.sql.Timestamp;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.utils.DateUtils;
import ysq.rpac.rpamc.common.utils.UserUtils;
import ysq.rpac.rpamc.plugin.rpajob.MyEntryGridControl;

public class JobLogPlugin
extends AbstractListPlugin {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static String ENTITY_KEY = "ysq_entryentity";
    private static String YSQ_LOG_DATE = "ysq_log_date";
    private static String YSQ_LOG_CONTENT = "ysq_log_content";
    private static String YSQ_LOG_COUNT = "ysq_log_count";
    private static String KEY_MAINBAR = "ysq_advcontoolbarap";
    private static String YSQ_PREVIOUS_PAGE = "ysq_previous_page";
    private static String YSQ_NEXT_PAGE = "ysq_next_page";
    private static String YSQ_REFRESH = "ysq_refresh";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_MAINBAR});
        this.addItemClickListeners(new String[]{"ysq_toolbarap"});
    }

    private void createEsToLog(String jobNo, int limit, int offset) {
        DynamicObjectCollection rows = null;
        rows = this.getModel().getEntryEntity(ENTITY_KEY);
        EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().getProperties().get((Object)ENTITY_KEY);
        EntryType entryType = (EntryType)entryProp.getItemType();
        LogORM logORM = LogORM.create();
        QFilter qFilter = new QFilter("ysq_job_no", "=", (Object)jobNo);
        long wincount = 0L;
        DataSet ds = logORM.queryDataSet("ysq_ueba_log", "ysq_log_time,ysq_message_tag,ysq_action", new QFilter[]{qFilter}, limit, offset);
        while (ds.hasNext()) {
            String action;
            Row row = ds.next();
            Timestamp timestamp = row.getTimestamp("ysq_log_time");
            String messg = row.getString("ysq_message_tag");
            String messgTime = "";
            if (timestamp != null) {
                messgTime = DateUtils.timeStampToDate((long)timestamp.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
            }
            if (StringUtils.equals((CharSequence)(action = row.getString("ysq_action")), (CharSequence)"window")) {
                ++wincount;
            }
            DynamicObject entry = new DynamicObject((DynamicObjectType)entryType);
            entry.set(YSQ_LOG_DATE, (Object)messgTime);
            entry.set(YSQ_LOG_CONTENT, (Object)messg);
            rows.add((Object)entry);
        }
    }

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{ENTITY_KEY});
    }

    public void afterCreateNewData(EventObject e) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTITY_KEY);
        int pageRow = 20;
        int startRowIndex = 0;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Long id = null;
        String idr = customParams.get("id").toString();
        id = Long.valueOf(idr);
        if (id == null || new Long(0L).equals(id)) {
            return;
        }
        DynamicObject dbData = null;
        try {
            dbData = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ysq_rpa_job");
        }
        catch (Exception exception) {
            this.log.debug(exception.getMessage());
            dbData = null;
        }
        if (dbData != null) {
            String jobNo = dbData.getString("ysq_job_no");
            this.createEsToLog(jobNo, pageRow, startRowIndex);
            LogORM logORM = LogORM.create();
            QFilter qFilter = new QFilter("ysq_job_no", "=", (Object)jobNo);
            DataSet ds = logORM.queryDataSet("ysq_ueba_log", "ysq_log_time,ysq_message_tag,ysq_action", new QFilter[]{qFilter}, 100000, 0);
            int length = 0;
            int wincount = 0;
            while (ds.hasNext()) {
                Row row = ds.next();
                String action = row.getString("ysq_action");
                if (StringUtils.equals((CharSequence)action, (CharSequence)"window")) {
                    ++wincount;
                }
                ++length;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            dataEntity.set("ysq_job_no", (Object)jobNo);
            dataEntity.getDataEntityState().setEntryRowCount(ENTITY_KEY, length);
            dataEntity.getDataEntityState().setEntryPageSize(ENTITY_KEY, pageRow);
            dataEntity.getDataEntityState().setEntryStartRowIndex(ENTITY_KEY, startRowIndex);
            this.createProInfo(dbData, length, wincount);
        }
    }

    private void createProInfo(DynamicObject jobDb, int length, int wincount) {
        Object id = null;
        String procName = null;
        String schName = null;
        String startTime = "";
        String endTime = "";
        String jobNo = "";
        String runTime = "";
        String jobType = "";
        String status = "";
        if (jobDb != null) {
            Date end;
            procName = jobDb.getString("ysq_proc_name");
            schName = jobDb.getString("ysq_sch_name");
            jobNo = jobDb.getString("ysq_job_no");
            runTime = jobDb.getString("ysq_run_time_sec");
            if (StringUtils.isNotBlank((CharSequence)runTime)) {
                runTime = DateUtils.secondToTime((long)Long.valueOf(runTime));
            }
            if (StringUtils.equals((CharSequence)"plan", (CharSequence)(jobType = jobDb.getString("ysq_job_type")))) {
                jobType = "\u8ba1\u5212";
            } else {
                String jobTypeId = jobDb.getString("ysq_job_type");
                Long typeId = null;
                try {
                    typeId = Long.valueOf(jobTypeId);
                }
                catch (Exception e) {
                    this.log.info("\u83b7\u53d6\u7528\u6237jobTypeId\u5931\u8d25\u3002");
                }
                if (typeId != null) {
                    jobType = UserUtils.getUserName((Long)typeId);
                }
            }
            status = jobDb.getString("ysq_status");
            status = RpaJobStatusEnums.getValue((String)status);
            Date start = jobDb.getDate("ysq_robot_start_time");
            if (start != null) {
                startTime = DateUtils.formatDate((Date)start, (String)"yyyy-MM-dd HH:mm:ss");
            }
            if ((end = jobDb.getDate("ysq_robot_end_time")) != null) {
                endTime = DateUtils.formatDate((Date)end, (String)"yyyy-MM-dd HH:mm:ss");
            }
        }
        IDataModel model = this.getModel();
        Label procNameLa = (Label)this.getView().getControl("ysq_proc_name");
        Label schNameLa = (Label)this.getView().getControl("ysq_sch_name");
        Label startTimeLa = (Label)this.getView().getControl("ysq_start_time");
        Label endTimeLa = (Label)this.getView().getControl("ysq_end_time");
        Label runTimeLa = (Label)this.getView().getControl("ysq_run_time_sec");
        Label jobTypeLa = (Label)this.getView().getControl("ysq_job_type");
        Label statusLa = (Label)this.getView().getControl("ysq_status");
        Label logCountLa = (Label)this.getView().getControl(YSQ_LOG_COUNT);
        procNameLa.setText(procName);
        schNameLa.setText(schName);
        startTimeLa.setText(startTime);
        endTimeLa.setText(endTime);
        runTimeLa.setText(runTime);
        jobTypeLa.setText(jobType);
        statusLa.setText(status);
        int runLog = length - wincount;
        String logMsg = String.format("\u8fd0\u884c\u65e5\u5fd7%s\u6761\uff0c\u7a97\u53e3\u65e5\u5fd7%s\u6761", runLog, wincount);
        logCountLa.setText(logMsg);
        model.setValue("ysq_job_no", (Object)jobNo);
    }

    public void onGetControl(OnGetControlArgs e) {
        if (StringUtils.equals((CharSequence)e.getKey(), (CharSequence)ENTITY_KEY)) {
            MyEntryGridControl entryGrid = new MyEntryGridControl();
            entryGrid.setView(this.getView());
            entryGrid.setKey(ENTITY_KEY);
            entryGrid.setEntryKey(ENTITY_KEY);
            entryGrid.setSplitPage(true);
            Control oldGrid = e.getControl();
            if (oldGrid == null) {
                this.findControl(ENTITY_KEY);
            }
            if (oldGrid instanceof EntryGrid) {
                entryGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
            }
            e.setControl((Control)entryGrid);
        }
    }

    private Control findControl(String key) {
        FormRoot root = (FormRoot)this.getView().getRootControl();
        return this.findControl(key, root.getItems());
    }

    private Control findControl(String key, List<Control> items) {
        for (Control ctl : items) {
            Control subCtl;
            if (StringUtils.equals((CharSequence)key, (CharSequence)ctl.getKey())) {
                return ctl;
            }
            if (!(ctl instanceof Container) || (subCtl = this.findControl(key, ((Container)ctl).getItems())) == null) continue;
            return subCtl;
        }
        return null;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)YSQ_REFRESH, (CharSequence)evt.getItemKey())) {
            this.getView().invokeOperation("refresh");
        }
    }
}

