/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.rpajob;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.collections.MapUtils;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.message.JobQueueProducer;
import ysq.rpac.rpamc.common.model.RpaJobVO;

public class JobRestartOpPlugin
extends AbstractOperationServicePlugIn {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private JobQueueProducer jobQueueProducer = JobQueueProducer.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("ysq_status");
        e.getFieldKeys().add("ysq_job_no");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                RowDataModel rowDataModel = new RowDataModel(this.entityKey, this.getValidateContext().getSubEntityType());
                for (ExtendedDataEntity data : dataEntities) {
                    Long jobId = Long.valueOf(data.getValue("id").toString());
                    DynamicObject jobObj = null;
                    try {
                        jobObj = BusinessDataServiceHelper.loadSingle((Object)jobId, (String)"ysq_rpa_job");
                    }
                    catch (Exception exception) {
                        JobRestartOpPlugin.this.log.debug(exception.getMessage());
                        jobObj = null;
                    }
                    if (null == jobObj) continue;
                    RpaJobVO rpaJob = new RpaJobVO().fromDynamicObject(jobObj);
                    rowDataModel.setRowContext(jobObj);
                    String jobNo = rpaJob.getJobNo();
                    String status = rpaJob.getStatus();
                    boolean isOk = true;
                    if (!(RpaJobStatusEnums.FAILED.getCode().equals(status) || RpaJobStatusEnums.PEND_OUTTIME.getCode().equals(status) || RpaJobStatusEnums.RUN_OUTTIME.getCode().equals(status))) {
                        this.addErrorMessage(data, String.format("\u8bf7\u9009\u62e9\u4e00\u6761\u201c\u5df2\u5931\u8d25\u201d\u7684\u4efb\u52a1\u8fdb\u884c\u64cd\u4f5c\u3002", new Object[0]));
                        isOk = false;
                    }
                    if (!isOk || QueryServiceHelper.exists((String)"ysq_rpa_process_ver", (Object)rpaJob.getProcFid())) continue;
                    this.addErrorMessage(data, String.format("\u4efb\u52a1\uff1a%s \u5bf9\u5e94\u6d41\u7a0b\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u65b0\u6267\u884c\u3002", jobNo));
                    isOk = false;
                }
            }
        });
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject data : dataEntities = args.getDataEntities()) {
            Long schId = data.getLong("id");
            DynamicObject dbData = null;
            try {
                dbData = BusinessDataServiceHelper.loadSingle((Object)schId, (String)"ysq_rpa_job");
            }
            catch (Exception e) {
                this.log.debug(e.getMessage());
                dbData = null;
            }
            if (null == dbData) continue;
            this.realRedo(dbData);
        }
    }

    private void realRedo(DynamicObject rpaJobDb) {
        RpaJobVO rpaJob = new RpaJobVO().fromDynamicObject(rpaJobDb);
        Date now = new Date();
        RpaJobVO rpaRedoJob = new RpaJobVO();
        rpaRedoJob.setWorkStatus(rpaJob.getWorkStatus());
        rpaRedoJob.setScheduleFId(rpaJob.getScheduleFId());
        rpaRedoJob.setSchName(rpaJob.getSchName());
        rpaRedoJob.setSchType(rpaJob.getSchType());
        rpaRedoJob.setJobNo(UUID.randomUUID().toString());
        rpaRedoJob.setJobOrder(Long.valueOf(System.currentTimeMillis()));
        Long userId = RequestContext.get().getCurrUserId();
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        List userList = UserServiceHelper.get(userIds);
        if (null != userList && !userList.isEmpty()) {
            rpaRedoJob.setJobType(MapUtils.getString((Map)((Map)userList.get(0)), (Object)"id"));
        } else {
            rpaRedoJob.setJobType("admin");
        }
        rpaRedoJob.setProduceType("manual_run");
        rpaRedoJob.setCurrRobotNo(null);
        rpaRedoJob.setCurrRobotName(null);
        rpaRedoJob.setExecRobotsNo(rpaJob.getExecRobotsNo());
        rpaRedoJob.setExecRobotsNames(rpaJob.getExecRobotsNames());
        rpaRedoJob.setExecRobotsAlias(rpaJob.getExecRobotsAlias());
        rpaRedoJob.setProcCode(rpaJob.getProcCode());
        rpaRedoJob.setProcName(rpaJob.getProcName());
        rpaRedoJob.setProcFile(rpaJob.getProcFile());
        rpaRedoJob.setProcVer(rpaJob.getProcVer());
        rpaRedoJob.setPublishTime(rpaJob.getPublishTime());
        rpaRedoJob.setOrgId(rpaJob.getOrgId());
        rpaRedoJob.setOwnerUserFid(rpaJob.getOwnerUserFid());
        rpaRedoJob.setOwnerUserAlias(rpaJob.getOwnerUserAlias());
        rpaRedoJob.setDeveloperUserFid(rpaJob.getDeveloperUserFid());
        rpaRedoJob.setScheduleTime(now);
        rpaRedoJob.setJobTime(now);
        rpaRedoJob.setStatus(RpaJobStatusEnums.PENDING.getCode());
        rpaRedoJob.setPendingTimeout(rpaJob.getPendingTimeout());
        rpaRedoJob.setRunningTimeout(rpaJob.getRunningTimeout());
        rpaRedoJob.setProcHandDoMin(rpaJob.getProcHandDoMin());
        rpaRedoJob.setAutoStopTime(rpaJob.getAutoStopTime());
        rpaRedoJob.setFailTryTimes(Integer.valueOf(0));
        rpaRedoJob.setRunTimes(Integer.valueOf(1));
        rpaRedoJob.setParameter(rpaJob.getParameter());
        rpaRedoJob.setPriority("high");
        rpaRedoJob.setDescription(null);
        rpaRedoJob.setApplyUsersFids(rpaJob.getApplyUsersFids());
        rpaRedoJob.setApplyUsersDesc(rpaJob.getApplyUsersDesc());
        rpaRedoJob.setStartTime(null);
        rpaRedoJob.setEndTime(null);
        rpaRedoJob.setExceptionName(null);
        rpaRedoJob.setExceptionContent(null);
        rpaRedoJob.setStudioVer(rpaJob.getStudioVer());
        rpaRedoJob.setProcVerDesc(rpaJob.getProcVerDesc());
        rpaRedoJob.setProcFid(rpaJob.getProcFid());
        rpaRedoJob.setComJobType(rpaJob.getComJobType());
        String proChange = null;
        QFilter[] filterArr = new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)rpaJob.getProcCode()), new QFilter("ysq_proc_ver", "=", (Object)rpaJob.getProcVer())};
        DynamicObject procVer = null;
        try {
            procVer = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])filterArr);
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            procVer = null;
        }
        if (null != procVer) {
            proChange = procVer.getString("ysq_pro_change");
        }
        Object[] jobs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rpaRedoJob.buildDynamicObject()});
        DynamicObject jobd = (DynamicObject)jobs[0];
        rpaRedoJob.setFid(Long.valueOf(jobd.getLong("id")));
        this.jobQueueProducer.addJob(rpaRedoJob, proChange);
    }
}

