/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.rpajob;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.status.job.core.JobStatusCache;

public class JobStopOpPlugin
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(JobStopOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("ysq_status");
        e.getFieldKeys().add("ysq_job_no");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                RowDataModel rowDataModel = new RowDataModel(this.entityKey, this.getValidateContext().getSubEntityType());
                for (ExtendedDataEntity data : dataEntities) {
                    rowDataModel.setRowContext(data.getDataEntity());
                    String id = data.getValue("id").toString();
                    String jobNo = data.getValue("ysq_job_no").toString();
                    String status = data.getValue("ysq_status").toString();
                    if (!RpaJobStatusEnums.RUNNING.getCode().equals(status)) {
                        this.addErrorMessage(data, String.format("\u6570\u636e\u72b6\u6001\u53ea\u80fd\u662f\u6b63\u5728\u8fd0\u884c\u3002", new Object[0]));
                        continue;
                    }
                    boolean b = JobStatusCache.getInstance().handChacheStatusCheck(Long.valueOf(id), jobNo, status, ((Object)((Object)this)).getClass().getName());
                    if (!b) continue;
                    this.addErrorMessage(data, String.format("\u4fee\u6539\u52a8\u4f5c\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u3002", new Object[0]));
                }
            }
        });
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList ids = new ArrayList();
        for (DynamicObject data : dataEntities) {
            Long id = data.getLong("id");
            String jobNo = data.getString("ysq_job_no");
            String status = data.getString("ysq_status");
            if (!RpaJobStatusEnums.RUNNING.getCode().equals(status)) continue;
            try {
                JobStatusCache.getInstance().handChacheStatus(id, jobNo, RpaJobStatusEnums.STOPPING.getCode(), ((Object)((Object)this)).getClass().getName());
            }
            catch (Exception exception) {
                log.debug("exc: \u4efb\u52a1id\uff1a{}\uff0cjobNO\uff1a{}\uff0c\u8981\u6539\u6210\u72b6\u6001\uff1a{}\uff0c\u5df2\u63d0\u4ea4\uff0c\u672c\u6b21\u4e0d\u63d0\u4ea4\u961f\u5217\u3002\u4fee\u6539\u65f6\u95f4\uff1a{}", new Object[]{id, jobNo, status, new Date()});
            }
        }
    }
}

