/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.schedule;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class SchduleDisableOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("ysq_status");
        e.getFieldKeys().add("ysq_sch_name");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                RowDataModel rowDataModel = new RowDataModel(this.entityKey, this.getValidateContext().getSubEntityType());
                for (ExtendedDataEntity data : dataEntities) {
                    rowDataModel.setRowContext(data.getDataEntity());
                    String id = data.getValue("id").toString();
                    String schName = data.getValue("ysq_sch_name").toString();
                    String status = data.getValue("ysq_status").toString();
                    if (!StringUtils.equals((CharSequence)status, (CharSequence)"no")) continue;
                    this.addErrorMessage(data, String.format("%s\u8c03\u5ea6\u5df2\u7ecf\u662f\u7981\u7528\u72b6\u6001\u3002", schName));
                }
            }
        });
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] load;
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> list = new ArrayList<Long>();
        for (DynamicObject data : dataEntities) {
            long id = data.getLong("id");
            list.add(id);
        }
        QFilter schFilter = new QFilter("id", "in", list);
        String field = "id,ysq_kd_jobid,ysq_kd_planid,ysq_status";
        for (DynamicObject data : load = BusinessDataServiceHelper.load((String)"ysq_process_schedule", (String)field, (QFilter[])new QFilter[]{schFilter})) {
            Long jobId = (Long)data.get("ysq_kd_jobid");
            Long planId = (Long)data.get("ysq_kd_planid");
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.disableSchedule(planId.toString());
            scheduleManager.disableJob(jobId.toString());
            data.set("ysq_status", (Object)"no");
            SaveServiceHelper.update((DynamicObject)data);
        }
    }
}

