/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.schedule;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import ysq.rpac.rpamc.common.constant.YsqProcessConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.message.JobQueueProducer;
import ysq.rpac.rpamc.common.model.RpaJobVO;
import ysq.rpac.rpamc.common.utils.LicenseUtils;

public class ScheduleBaritOpPlugin
extends AbstractOperationServicePlugIn {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private JobQueueProducer jobQueueProducer = JobQueueProducer.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("ysq_proc_fid");
        e.getFieldKeys().add("ysq_sch_name");
        e.getFieldKeys().add("ysq_proc_code");
        e.getFieldKeys().add("ysq_proc_ver");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                RowDataModel rowDataModel = new RowDataModel(this.entityKey, this.getValidateContext().getSubEntityType());
                for (ExtendedDataEntity data : dataEntities) {
                    QFilter[] procVerfilterArr;
                    rowDataModel.setRowContext(data.getDataEntity());
                    boolean isOk = true;
                    String schId = data.getValue("id").toString();
                    String schName = data.getValue("ysq_sch_name").toString();
                    String procCode = data.getValue("ysq_proc_code").toString();
                    String procVer = data.getValue("ysq_proc_ver").toString();
                    if (procVer.equals("latest")) {
                        QFilter[] procFilterArr = new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)procCode)};
                        DynamicObject processDb = null;
                        try {
                            processDb = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])procFilterArr);
                        }
                        catch (Exception e) {
                            ScheduleBaritOpPlugin.this.log.debug(e.getMessage());
                            processDb = null;
                        }
                        if (processDb != null) {
                            procVer = processDb.getString("ysq_proc_ver");
                        }
                    } else {
                        QFilter[] procVerfilterArr2 = new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)procCode), new QFilter("ysq_proc_ver", "=", (Object)procVer)};
                        DynamicObject processVerDb = null;
                        try {
                            processVerDb = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])procVerfilterArr2);
                        }
                        catch (Exception e) {
                            ScheduleBaritOpPlugin.this.log.debug(e.getMessage());
                            processVerDb = null;
                        }
                        if (processVerDb == null) {
                            this.addErrorMessage(data, String.format("\u8c03\u5ea6\uff1a%s \u5bf9\u5e94\u7684\u6d41\u7a0b\u7248\u672c\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u7acb\u5373\u8fd0\u884c\u3002", schName));
                            isOk = false;
                        }
                    }
                    DynamicObject schDb = BusinessDataServiceHelper.loadSingle((Object)schId, (String)"ysq_process_schedule");
                    if ("standard".equals(schDb.getString("ysq_sch_type")) && !LicenseUtils.checkStdAppLicense((String)schDb.getString("ysq_proc_code")).booleanValue()) {
                        this.addErrorMessage(data, "\u5e94\u7528\u8bb8\u53ef\u5df2\u8fc7\u671f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
                        isOk = false;
                    }
                    if (!isOk || QueryServiceHelper.exists((String)"ysq_rpa_process_ver", (QFilter[])(procVerfilterArr = new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)procCode), new QFilter("ysq_proc_ver", "=", (Object)procVer)}))) continue;
                    this.addErrorMessage(data, String.format("\u6d41\u7a0b\uff1a%s\uff0c\u7248\u672c\uff1a%s\uff0c\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u7acb\u5373\u8fd0\u884c\u3002", procCode, procVer));
                }
            }
        });
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        Date now = new Date();
        for (DynamicObject data : dataEntities) {
            Long id = data.getLong("id");
            this.scheduleOne(id, now);
        }
    }

    private void scheduleOne(Long id, Date now) {
        DynamicObject schDb = null;
        try {
            schDb = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ysq_process_schedule");
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            schDb = null;
        }
        if (null == schDb) {
            return;
        }
        String procCode = schDb.getString("ysq_proc_code");
        String procVer = schDb.getString("ysq_proc_ver");
        QFilter[] procFilterArr = new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)procCode)};
        DynamicObject processDb = null;
        try {
            processDb = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])procFilterArr);
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            return;
        }
        if (procVer.equals("latest")) {
            if (processDb != null) {
                procVer = processDb.getString("ysq_proc_ver");
            } else {
                return;
            }
        }
        QFilter[] procVerfilterArr = new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)procCode), new QFilter("ysq_proc_ver", "=", (Object)procVer)};
        DynamicObject processVerDb = null;
        try {
            processVerDb = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])procVerfilterArr);
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            processVerDb = null;
        }
        if (null == processVerDb) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(RequestContext.get().getCurrUserId());
        RpaJobVO job = this.buildOneJob(id, schDb, processDb, processVerDb, now, "manager", "manual_run", ((Map)UserServiceHelper.get(ids).get(0)).get("id").toString());
        job.setPriority("higher");
        job.setScheduleTime(now);
        String proChange = processVerDb.getString("ysq_pro_change");
        Object[] jobs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{job.buildDynamicObject()});
        DynamicObject jobd = (DynamicObject)jobs[0];
        job.setFid(Long.valueOf(jobd.getLong("id")));
        this.jobQueueProducer.addJob(job, proChange);
    }

    private RpaJobVO buildOneJob(Long schId, DynamicObject scheduleDb, DynamicObject processDb, DynamicObject processVerDb, Date now, String schType, String produceType, String jobType) {
        RpaJobVO job = new RpaJobVO();
        job.setWorkStatus(processDb.getString("ysq_work_status"));
        job.setScheduleFId(schId);
        job.setJobNo(UUID.randomUUID().toString());
        job.setJobOrder(Long.valueOf(now.getTime()));
        job.setSchName(scheduleDb.getString("ysq_sch_name"));
        job.setProduceType(produceType);
        job.setExecRobotsNo(scheduleDb.getString("ysq_exec_robots_no_tag"));
        job.setExecRobotsNames(scheduleDb.getString("ysq_exec_robots_names_tag"));
        job.setExecRobotsAlias(scheduleDb.getString("ysq_exec_robots_alias"));
        job.setProcFid(Long.valueOf(processVerDb.getLong("id")));
        job.setProcCode(processVerDb.getString("ysq_proc_code"));
        job.setProcName(processVerDb.getString("ysq_proc_name"));
        job.setProcFile(processVerDb.getString("ysq_proc_file"));
        job.setProcVer(processVerDb.getString("ysq_proc_ver"));
        job.setPublishTime(processVerDb.getDate("ysq_publish_time"));
        DynamicObject orgInfo = processDb.getDynamicObject("org");
        Long orgId = orgInfo.getLong("id");
        job.setOrgId(orgId);
        job.setDeveloperUserFid(Long.valueOf(processDb.getLong("ysq_dev_user_fid")));
        job.setDeveloperUserAlias(processDb.getString("ysq_dev_user_alias"));
        job.setJobTime(now);
        job.setStatus(RpaJobStatusEnums.PENDING.getCode());
        job.setExecRobotsAlias(scheduleDb.getString("ysq_exec_robots_alias"));
        job.setPendingTimeout(Integer.valueOf(scheduleDb.getInt("ysq_pending_timeout")));
        job.setRunningTimeout(Integer.valueOf(scheduleDb.getInt("ysq_running_timeout")));
        job.setProcHandDoMin(Integer.valueOf(scheduleDb.getInt("ysq_hand_do_min")));
        job.setAutoStopTime(Integer.valueOf(scheduleDb.getInt("ysq_auto_stop_time")));
        job.setFailTryTimes(Integer.valueOf(scheduleDb.getInt("ysq_fail_try_times")));
        job.setRunTimes(Integer.valueOf(1));
        job.setParameter(scheduleDb.getString("ysq_sch_param_tag"));
        job.setPriority(scheduleDb.getString("ysq_priority"));
        job.setJobType(jobType);
        job.setSchType(schType);
        job.setProcVerDesc(processDb.getString("ysq_proc_desc"));
        job.setStudioVer(processDb.getString("ysq_studio_ver"));
        String code = processVerDb.getString("ysq_proc_code");
        QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)code);
        DynamicObject model = null;
        try {
            model = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
            job.setComJobType(model.getString("ysq_proc_type"));
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
        }
        return job;
    }
}

