/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.schedule;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ScheduleDataListPlugin
extends AbstractListPlugin {
    private static Log log = LogFactory.getLog(ScheduleDataListPlugin.class);
    private static final String YSQ_BTN_APP_ADD = "ysq_btn_app_add";
    private static final String YSQ_CLOSE_BACK_SCH = "ysq_close_back_sch";
    private static final String YSQ_CLOSE_BACK_APP_SCH = "ysq_close_back_app_sch";
    public static final String REFRESH = "refresh";
    private static String KEY_MAINBAR = "toolbarap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_MAINBAR});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)YSQ_BTN_APP_ADD, (CharSequence)itemKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ysq_app_schedule");
            formShowParameter.setCustomParam("ysq_rpa_process_ver", this.getView().getFormShowParameter().getCustomParam("ysq_rpa_process_ver"));
            formShowParameter.setCustomParam("ysq_app_mine", this.getView().getFormShowParameter().getCustomParam("ysq_app_mine"));
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, YSQ_CLOSE_BACK_APP_SCH));
            this.getView().showForm(formShowParameter);
            return;
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
        Long primaryKeyValue = (Long)currentRow.getPrimaryKeyValue();
        QFilter qFilter = new QFilter("id", "=", (Object)primaryKeyValue);
        DynamicObject object = QueryServiceHelper.queryOne((String)"ysq_process_schedule", (String)"ysq_sch_type,ysq_proc_code", (QFilter[])new QFilter[]{qFilter});
        if (object != null) {
            String schType = object.getString("ysq_sch_type");
            String procCode = object.getString("ysq_proc_code");
            if (StringUtils.equals((CharSequence)schType, (CharSequence)"standard")) {
                args.setCancel(true);
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("ysq_app_schedule");
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setCustomParam("id", (Object)primaryKeyValue);
                formShowParameter.setCustomParam("ysq_proc_code", (Object)procCode);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, YSQ_CLOSE_BACK_SCH));
                this.getView().showForm(formShowParameter);
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)YSQ_CLOSE_BACK_SCH) && null != closedCallBackEvent.getReturnData()) {
            this.getView().showSuccessNotification("\u64cd\u4f5c\u6210\u529f\u3002");
            this.getView().invokeOperation(REFRESH);
        } else if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)YSQ_CLOSE_BACK_APP_SCH) && null != closedCallBackEvent.getReturnData()) {
            boolean returnData = (Boolean)closedCallBackEvent.getReturnData();
            if (returnData) {
                this.getView().showSuccessNotification("\u64cd\u4f5c\u6210\u529f\u3002");
            } else {
                this.getView().showTipNotification("\u65e0\u53ef\u7528\u673a\u5668\u4eba\uff0c\u8bf7\u524d\u5f80\u201c\u7ec8\u7aef\u7ba1\u7406\u201d\u68c0\u67e5\u673a\u5668\u4eba\u72b6\u6001\u6216\u4e0b\u8f7d\u673a\u5668\u4eba\u5ba2\u6237\u7aef\u3002", Integer.valueOf(6000));
            }
            this.getView().invokeOperation(REFRESH);
        }
    }

    public void afterExportFile(ExportFileEvent e) {
        File file;
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String isAppOpenParam = (String)showParameter.getCustomParam("isAppOpen");
        if (StringUtils.isNotBlank((CharSequence)isAppOpenParam) && (file = e.getFile()) != null) {
            try (FileInputStream fis = new FileInputStream(file);){
                XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);
                Sheet sheet = wb.getSheetAt(0);
                int[] seets = new int[]{6};
                ScheduleDataListPlugin.deleteColumns(sheet, seets);
                FileOutputStream out = new FileOutputStream(file);
                wb.write((OutputStream)out);
                wb.close();
                out.close();
            }
            catch (Throwable ex) {
                log.warn("\u5bfc\u51fa\u6d41\u7a0b\u5931\u8d25:" + ex.getMessage());
            }
        }
    }

    public static void deleteColumns(Sheet sheet, int[] columnToDeletes) {
        for (int r = 0; r <= sheet.getLastRowNum(); ++r) {
            Row row = sheet.getRow(r);
            for (int i = 0; i < columnToDeletes.length; ++i) {
                ScheduleDataListPlugin.deleteColum(sheet, row, r, columnToDeletes[i]);
                for (int j = i; j < columnToDeletes.length; ++j) {
                    int tb = columnToDeletes[i];
                    int tc = columnToDeletes[j];
                    if (tb >= tc) continue;
                    int n = j;
                    columnToDeletes[n] = columnToDeletes[n] - 1;
                }
            }
        }
    }

    public static void deleteColum(Sheet sheet, Row row, int r, int columnToDelete) {
        for (int c = columnToDelete; c <= row.getLastCellNum(); ++c) {
            Cell cNext;
            Cell cOld = row.getCell(c);
            if (cOld != null) {
                row.removeCell(cOld);
            }
            if ((cNext = row.getCell(c + 1)) == null) continue;
            Cell cNew = row.createCell(c, cNext.getCellType());
            ScheduleDataListPlugin.cloneCell(cNew, cNext);
            if (r != 0) continue;
            sheet.setColumnWidth(c, sheet.getColumnWidth(c + 1));
        }
    }

    private static void cloneCell(Cell cNew, Cell cOld) {
        cNew.setCellComment(cOld.getCellComment());
        cNew.setCellStyle(cOld.getCellStyle());
        if (CellType.BOOLEAN == cNew.getCellType()) {
            cNew.setCellValue(cOld.getBooleanCellValue());
        } else if (CellType.NUMERIC == cNew.getCellType()) {
            cNew.setCellValue(cOld.getNumericCellValue());
        } else if (CellType.STRING == cNew.getCellType()) {
            cNew.setCellValue(cOld.getStringCellValue());
        } else if (CellType.ERROR == cNew.getCellType()) {
            cNew.setCellValue((double)cOld.getErrorCellValue());
        } else if (CellType.FORMULA == cNew.getCellType()) {
            cNew.setCellValue(cOld.getCellFormula());
        }
    }
}

