/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.schedule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.common.Strings;
import ysq.rpac.rpamc.common.constant.YsqProcessConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.enums.ScheduleModelEnums;
import ysq.rpac.rpamc.common.model.ParamsVo;
import ysq.rpac.rpamc.common.model.dto.ProcessVersionDTO;
import ysq.rpac.rpamc.common.servicehelper.ScheduleServiceHelper;
import ysq.rpac.rpamc.common.status.job.core.JobStatusCache;
import ysq.rpac.rpamc.common.utils.CronExpressionUtils;
import ysq.rpac.rpamc.common.utils.IsearchFileUtils;
import ysq.rpac.rpamc.common.utils.KdPageUtils;
import ysq.rpac.rpamc.common.utils.ScheduleUtils;
import ysq.rpac.rpamc.common.utils.TriggerTimeUtils;
import ysq.rpac.rpamc.common.utils.ViewDataValueUtils;

public class ScheduleEditPlugin
extends AbstractFormPlugin {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String KEY_YSQ_BTN_SAVE = "ysq_btn_save";
    public static final String KEY_YSQ_SEL_ROBOT_LIST = "ysq_exec_robots_no";
    public static final String KEY_SCHDULE_DEIT_CHICK = "key_schdule_deit_chick";
    public static final String YSQ_CLOSEBACK_PARAM = "ysq_closeback_param";
    public static final String YSQ_CLOSEBACK_FILE = "ysq_closeback_file";
    public static final String YSQ_PARAM_SAVE = "ysq_param_save";
    public static final String YSQ_RPA_SCH_PARAM = "ysq_rpa_sch_param";
    public static final String YSQ_RPA_SCH_FILE = "ysq_attachmentpanelap";
    public static final String KEY_PARAMS_TABLES = "ysq_params_table";
    public static final String YSQ_PARAM_FLEX = "ysq_param_flex";
    private HashMap<String, String> properties = new HashMap();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button = (Button)this.getView().getControl(KEY_YSQ_BTN_SAVE);
        button.addClickListener((ClickListener)this);
        Button buttonTest = (Button)this.getView().getControl(YSQ_PARAM_SAVE);
        buttonTest.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long orgId = RequestContext.get().getOrgId();
        ArrayList<Long> childIds = new ArrayList();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        childIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"15", orgIds, (boolean)true);
        this.bindProcess(childIds);
        DynamicObject data = this.getModel().getDataEntity();
        this.initProcInfos(data);
        this.initTimeConfigs(data);
        this.initSchParam(data);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{YSQ_PARAM_SAVE});
        Object schParam = this.getModel().getValue("ysq_sch_param_tag");
        if (schParam != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schParam.toString())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{YSQ_PARAM_SAVE});
        }
        if (this.getView().getFormShowParameter().getCustomParam("routerParam") != null) {
            ProcessVersionDTO processVersionDTO = (ProcessVersionDTO)JSONObject.parseObject((String)this.getView().getFormShowParameter().getCustomParam("routerParam").toString(), ProcessVersionDTO.class);
            this.getModel().setValue("ysq_proc_code", (Object)processVersionDTO.getProcCode());
            this.getModel().setValue("ysq_proc_ver", (Object)processVersionDTO.getProcVersion());
            this.upDateParams(processVersionDTO.getProcCode());
        }
    }

    private void initSchParam(DynamicObject data) {
        String params = data.getString("ysq_sch_param_tag");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params)) {
            String jsonParma = IsearchFileUtils.base64ToParams((String)params);
            data.set("ysq_sch_param_tag", (Object)jsonParma);
        }
    }

    private void bindParamsTable() {
        this.getModel().getEntryEntity(KEY_PARAMS_TABLES).clear();
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_PARAMS_TABLES);
        EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().getProperties().get((Object)KEY_PARAMS_TABLES);
        EntryType entryType = (EntryType)entryProp.getItemType();
        DynamicObject schData = this.getModel().getDataEntity();
        if (schData != null) {
            String param = schData.getString("ysq_sch_param_tag");
            List list = IsearchFileUtils.analysisParam((String)param);
            for (ParamsVo paramsVo : list) {
                DynamicObject entry = new DynamicObject((DynamicObjectType)entryType);
                entry.set("ysq_params_name", (Object)paramsVo.getParamsName());
                entry.set("ysq_params_desc", (Object)paramsVo.getParamsDesc());
                entry.set("ysq_params_type", (Object)paramsVo.getParamsType());
                if ("checkbox".equals(paramsVo.getParamsType()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)paramsVo.getParamsDefValue())) {
                    entry.set("ysq_params_def_value", (Object)"false");
                } else {
                    entry.set("ysq_params_def_value", (Object)paramsVo.getParamsDefValue());
                }
                String paramsRequired = paramsVo.getParamsRequired();
                String blStr = "\u5426";
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)paramsRequired) && paramsRequired.equalsIgnoreCase("1")) {
                    blStr = "\u662f";
                }
                entry.set("ysq_params_required", (Object)blStr);
                entry.set("ysq_params_help", (Object)paramsVo.getParamsHelp());
                rows.add((Object)entry);
            }
        }
    }

    private void initTimeConfigs(DynamicObject data) {
        String schCommand;
        String monthSelDay;
        String monthSelMonth;
        String week;
        String hourSplit;
        String minSplit;
        IDataModel dataModel = this.getModel();
        String schModel = data.getString("ysq_schedule_mode");
        String schTime = data.getString("ysq_schedule_time").equals("") ? ViewDataValueUtils.getValHourMinStr((IDataModel)dataModel, (String)"ysq_sch_time") : data.getString("ysq_schedule_time");
        String cronExpression = ViewDataValueUtils.getValStr((IDataModel)dataModel, (String)"ysq_schedule_expre");
        String[] scheduleCommandArr = CronExpressionUtils.buildCommands((String)schModel, (String)cronExpression, (String)(minSplit = ViewDataValueUtils.getValStr((IDataModel)dataModel, (String)"ysq_min_split")), (String)(hourSplit = ViewDataValueUtils.getValStr((IDataModel)dataModel, (String)"ysq_hour_split")), (String)schTime, (String)(week = ViewDataValueUtils.getValStr((IDataModel)dataModel, (String)"ysq_week")), (String)(monthSelMonth = ViewDataValueUtils.getValStr((IDataModel)dataModel, (String)"ysq_month_selm")), (String)(monthSelDay = ViewDataValueUtils.getValStr((IDataModel)dataModel, (String)"ysq_month_seld")));
        if (null == scheduleCommandArr) {
            scheduleCommandArr = new String[]{"0"};
        }
        String string = schCommand = data.getString("ysq_schedule_command").equals("") ? scheduleCommandArr[0] : data.getString("ysq_schedule_command");
        if (!ScheduleModelEnums.TIME.getCode().equals(schModel) && !ScheduleModelEnums.CRON.getCode().equals(schModel)) {
            if (ScheduleModelEnums.MIN.getCode().equals(schModel)) {
                this.getModel().setValue("ysq_min_split", (Object)Integer.parseInt(schCommand));
            } else if (ScheduleModelEnums.HOUR.getCode().equals(schModel)) {
                schTime = schTime.equals("") ? minSplit : schTime;
                this.getModel().setValue("ysq_min_split", (Object)Integer.parseInt(schTime));
                this.getModel().setValue("ysq_hour_split", (Object)Integer.parseInt(schCommand));
            } else if (ScheduleModelEnums.DAY.getCode().equals(schModel)) {
                this.getModel().setValue("ysq_sch_time", (Object)ViewDataValueUtils.parseStrToHourMinVal((String)schTime));
            } else if (ScheduleModelEnums.WEEK.getCode().equals(schModel)) {
                this.getModel().setValue("ysq_sch_time", (Object)ViewDataValueUtils.parseStrToHourMinVal((String)schTime));
                this.getModel().setValue("ysq_week", (Object)schCommand);
            } else if (ScheduleModelEnums.MONTH.getCode().equals(schModel)) {
                String[] dayAndMonthArr = schCommand.split(" ");
                String days = dayAndMonthArr[0];
                String months = dayAndMonthArr[1];
                this.getModel().setValue("ysq_sch_time", (Object)ViewDataValueUtils.parseStrToHourMinVal((String)schTime));
                this.getModel().setValue("ysq_month_selm", (Object)months);
                this.getModel().setValue("ysq_month_seld", (Object)days);
            }
        }
    }

    private void originalTimeProperties() {
        String schModel = this.getModel().getDataEntity().getString("ysq_schedule_mode");
    }

    private void initProcInfos(DynamicObject data) {
        String proCode = data.getString("ysq_proc_code");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)proCode)) {
            return;
        }
        this.initProcVer(proCode);
        QFilter proCodeFilter = new QFilter("ysq_proc_code", "=", (Object)proCode);
        DynamicObject dbProcess = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)"org", (QFilter[])new QFilter[]{proCodeFilter});
        if (null == dbProcess) {
            return;
        }
        Long procOrg = dbProcess.getLong("org");
        if (procOrg != null && procOrg != 0L) {
            ArrayList<Long> agentOrg = new ArrayList();
            ArrayList<Long> agentOrgs = new ArrayList<Long>();
            agentOrgs.add(procOrg);
            agentOrg = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"15", agentOrgs, (boolean)true);
            this.bindAgent(agentOrg);
        }
    }

    private void initProcVer(String procCode) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("ysq_proc_ver");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        ComboItem textItem = new ComboItem(new LocaleString("\u59cb\u7ec8\u8c03\u5ea6\u6700\u65b0\u7248\u672c"), "latest");
        data.add(textItem);
        QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObjectCollection list = QueryServiceHelper.query((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter, codeFilter});
        for (DynamicObject dynamicObject : list) {
            ComboItem oneProcItem = new ComboItem(new LocaleString(dynamicObject.get("ysq_proc_ver").toString()), dynamicObject.get("ysq_proc_ver").toString());
            data.add(oneProcItem);
        }
        comboEdit.setComboItems(data);
    }

    private void bindAgent(List<Long> childIds) {
        DynamicObject[] processList;
        ComboEdit agentCom = (ComboEdit)this.getControl("ysq_robots_sel");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        QFilter orgFilter = new QFilter("org", "in", childIds);
        QFilter typeFilter = new QFilter("ysq_agent_type", "=", (Object)"robot");
        QFilter[] agentFilters = new QFilter[]{orgFilter, typeFilter};
        String field = "ysq_agent_alias,ysq_agent_no";
        for (DynamicObject dynamicObject : processList = BusinessDataServiceHelper.load((String)"ysq_rpa_agent", (String)field, (QFilter[])agentFilters)) {
            Object code = dynamicObject.get("ysq_agent_no");
            Object name = dynamicObject.get("ysq_agent_alias");
            data.add(new ComboItem(new LocaleString(name.toString()), code.toString()));
        }
        agentCom.setComboItems(data);
    }

    private void bindProcess(List<Long> childIds) {
        DynamicObject[] processList;
        ComboEdit comboEdit = (ComboEdit)this.getControl("ysq_proc_code");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        QFilter processFilter = new QFilter("org", "in", childIds);
        QFilter procTypeFilter = new QFilter("ysq_proc_type", "!=", (Object)"standard");
        QFilter[] processFilters = new QFilter[]{processFilter, procTypeFilter};
        String field = "ysq_proc_code,ysq_proc_name";
        for (DynamicObject dynamicObject : processList = BusinessDataServiceHelper.load((String)"ysq_rpa_process", (String)field, (QFilter[])processFilters)) {
            String code = dynamicObject.getString("ysq_proc_code");
            String name = dynamicObject.getString("ysq_proc_name");
            ComboItem oneProcItem = new ComboItem(new LocaleString(name), code);
            data.add(oneProcItem);
        }
        comboEdit.setComboItems(data);
    }

    public void propertyChanged(PropertyChangedArgs changeArgs) {
        super.propertyChanged(changeArgs);
        String fieldKey = changeArgs.getProperty().getName();
        if ("ysq_proc_code".equals(fieldKey)) {
            this.initVerAndAgents(changeArgs);
        } else if ("ysq_proc_ver".equals(fieldKey)) {
            String procCode = this.getModel().getValue("ysq_proc_code").toString();
            this.upDateParams(procCode);
        } else if ("ysq_schedule_mode".equals(fieldKey)) {
            this.initSchModelSels();
        } else if ("ysq_month_selm".equals(fieldKey)) {
            this.initDaySels();
        }
    }

    private void initVerAndAgents(PropertyChangedArgs changeArgs) {
        Object newValue;
        ChangeData[] change = changeArgs.getChangeSet();
        if (change != null && change.length > 0 && (newValue = change[0].getNewValue()) != null) {
            String procCode = newValue.toString();
            this.update(procCode);
            this.upDateParams(procCode);
        }
    }

    public void update(String procCode) {
        QFilter qFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)"org", (QFilter[])new QFilter[]{qFilter});
        long orgId = dynamicObject.getLong("org");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        List childIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"15", orgIds, (boolean)true);
        this.bindAgent(childIds);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        dataEntity.set("ysq_robots_sel", null);
        this.getView().updateView("ysq_robots_sel");
        this.updateVersionDropdownList(procCode);
    }

    private void upDateParams(String procCode) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)procCode)) {
            Object ver = this.getModel().getValue("ysq_proc_ver");
            if (ver == null || Strings.isNullOrEmpty((String)ver.toString())) {
                this.getModel().getDataEntity().set("ysq_sch_param_tag", (Object)"");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{YSQ_PARAM_SAVE});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{YSQ_PARAM_FLEX});
                return;
            }
            QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
            String version = this.getVersion(procCode);
            QFilter versionFilter = new QFilter("ysq_proc_ver", "=", (Object)version);
            DynamicObjectCollection processList = QueryServiceHelper.query((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter, versionFilter});
            if (CollectionUtils.isNotEmpty((Collection)processList)) {
                DynamicObject processDb = (DynamicObject)processList.get(0);
                String params = processDb.getString("ysq_param_tag");
                DynamicObject schInfo = this.getModel().getDataEntity();
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params)) {
                    schInfo.set("ysq_sch_param_tag", (Object)params);
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{YSQ_PARAM_SAVE});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{YSQ_PARAM_FLEX});
                    this.getModel().getDataEntity(true);
                    DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
                    dynamicObjectCollection.add((Object)schInfo);
                    this.getModel().updateEntryCache(dynamicObjectCollection);
                } else {
                    schInfo.set("ysq_sch_param_tag", (Object)"");
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{YSQ_PARAM_SAVE});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{YSQ_PARAM_FLEX});
                }
            }
        }
    }

    public String getVersion(String procCode) {
        String version = this.getModel().getValue("ysq_proc_ver").toString();
        if (version.startsWith("latest")) {
            this.getView().showSuccessNotification("\u5982\u6d41\u7a0b\u7684\u6700\u65b0\u7248\u672c\u6709\u8fd0\u884c\u53c2\u6570\uff0c\u8bf7\u5373\u65f6\u8bbe\u7f6e\u6216\u4fee\u6539", Integer.valueOf(10000));
            QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
            DynamicObjectCollection processList = QueryServiceHelper.query((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
            if (processList.size() > 0) {
                version = ((DynamicObject)processList.get(0)).getString("ysq_proc_ver");
            }
        }
        return version;
    }

    private void updateVersionDropdownList(String procCode) {
        this.getModel().setValue("ysq_proc_ver", null);
        ComboEdit comboEdit = (ComboEdit)this.getControl("ysq_proc_ver");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        ComboItem textItem = new ComboItem(new LocaleString("\u59cb\u7ec8\u8c03\u5ea6\u6700\u65b0\u7248\u672c"), "latest");
        data.add(textItem);
        QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObjectCollection list = QueryServiceHelper.query((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter, codeFilter});
        for (DynamicObject dynamicObject : list) {
            ComboItem oneProcItem = new ComboItem(new LocaleString(dynamicObject.get("ysq_proc_ver").toString()), dynamicObject.get("ysq_proc_ver").toString());
            data.add(oneProcItem);
        }
        comboEdit.setComboItems(data);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        if (key.endsWith(KEY_YSQ_BTN_SAVE)) {
            DynamicObject dataObj = control.getModel().getDataEntity();
            String param = dataObj.getString("ysq_sch_param_tag");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)param) && ScheduleServiceHelper.checkSchParam((String)param)) {
                evt.setCancel(true);
                this.getView().showErrorNotification("\u8bf7\u70b9\u51fb\u201c\u8fd0\u884c\u53c2\u6570\u4fee\u6539\u201d\uff0c\u586b\u5199\u597d\u8fd0\u884c\u53c2\u6570\u540e\u518d\u4fdd\u5b58\u8c03\u5ea6\u3002");
            }
            String robotSel = dataObj.getString("ysq_exec_robots_no_sel");
            String robotsSel = dataObj.getString("ysq_robots_sel");
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"2", (CharSequence)robotSel) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)robotsSel)) {
                this.getView().showTipNotification("\u8bf7\u9009\u62e9\u5019\u9009\u673a\u5668\u4eba\u3002");
                evt.setCancel(true);
                return;
            }
            boolean b = this.checkProcessEdit(key, control);
            if (b) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_SCHDULE_DEIT_CHICK, (IFormPlugin)this);
                this.getView().showConfirm("\u8be5\u8c03\u5ea6\u5df2\u4ea7\u751f\u7b49\u5f85\u8fd0\u884c\u7684\u4efb\u52a1\uff0c\u662f\u5426\u8981\u53d6\u6d88\u539f\u6709\u4efb\u52a1\uff0c\u4ea7\u751f\u65b0\u7684\u8c03\u5ea6\u4efb\u52a1\u3002", MessageBoxOptions.OKCancel, confirmCallBacks);
                evt.setCancel(true);
                return;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)KEY_SCHDULE_DEIT_CHICK, (CharSequence)callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            this.cancelJob(dataEntity);
            this.saveSchedule(dataEntity);
        }
    }

    private void cancelJob(DynamicObject dataEntity) {
        Long schId = dataEntity.getLong("id");
        QFilter schFilter = new QFilter("ysq_sch_fid", "=", (Object)schId);
        QFilter typeFilter = new QFilter("ysq_status", "=", (Object)RpaJobStatusEnums.PENDING.getCode());
        DynamicObjectCollection jobsData = QueryServiceHelper.query((String)"ysq_rpa_job", (String)"id,ysq_job_no", (QFilter[])new QFilter[]{schFilter, typeFilter});
        for (DynamicObject job : jobsData) {
            Long jobId = job.getLong("id");
            String jobNo = job.getString("ysq_job_no");
            JobStatusCache.getInstance().chacheStatus(jobId, jobNo, RpaJobStatusEnums.CANCELLED.getCode(), ((Object)((Object)this)).getClass().getName());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        if (key.endsWith(KEY_YSQ_BTN_SAVE)) {
            DynamicObject dataEntity = control.getModel().getDataEntity();
            this.saveSchedule(dataEntity);
            return;
        }
        if (key.endsWith(YSQ_PARAM_SAVE)) {
            this.openParam(evt);
        }
    }

    private void openParam(EventObject evt) {
        DynamicObject schInfo = this.getModel().getDataEntity();
        String param = schInfo.getString("ysq_sch_param_tag");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)param)) {
            JSONArray jsonArray = null;
            try {
                jsonArray = JSONArray.parseArray((String)param);
            }
            catch (Exception e) {
                this.log.info("\u8fd0\u884c\u53c2\u6570\u89e3\u6790\u9519\u8bef\uff1a" + e.getMessage());
                this.getView().showTipNotification("\u8fd0\u884c\u53c2\u6570\u89e3\u6790\u9519\u8bef\u3002");
                return;
            }
            if (jsonArray == null || jsonArray.size() <= 0) {
                this.getView().showTipNotification("\u8be5\u6d41\u7a0b\u6682\u65e0\u8fd0\u884c\u53c2\u6570\u3002");
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(YSQ_RPA_SCH_PARAM);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("ysq_sch_param_tag", param);
            map.put("id", schInfo.get("id") + "");
            showParameter.setCustomParams(map);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, YSQ_CLOSEBACK_PARAM));
            this.getView().showForm(showParameter);
        } else {
            this.getView().showTipNotification("\u8be5\u6d41\u7a0b\u6682\u65e0\u8fd0\u884c\u53c2\u6570\u3002");
        }
    }

    private String putParamFile(String param) {
        AttachmentPanel panel = (AttachmentPanel)this.getControl(YSQ_RPA_SCH_FILE);
        List attachmentData = panel.getAttachmentData();
        JSONArray jsonArray = JSONArray.parseArray((String)param);
        for (int i = 0; i < jsonArray.size(); ++i) {
            String value;
            Object valueObj;
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String type = jsonObject.get((Object)"Type").toString();
            if (!"file".equals(type) || (valueObj = jsonObject.get((Object)"Value")) == null || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(value = valueObj.toString()))) continue;
            Map map = null;
            for (Map file : attachmentData) {
                String uid = file.get("uid").toString();
                if (!value.equals(uid)) continue;
                map = file;
            }
            jsonObject.put("Value", map);
        }
        String rt = JSONArray.toJSONString((Object)jsonArray);
        return rt;
    }

    private void saveSchedule(DynamicObject dataObj) {
        String monthSelDay;
        String monthSelMonth;
        String week;
        String schTime;
        String hourSplit;
        String minSplit;
        String cronExpression;
        IDataModel viewModel = this.getModel();
        String schModel = viewModel.getValue("ysq_schedule_mode").toString();
        String[] scheduleCommandArr = CronExpressionUtils.buildCommands((String)schModel, (String)(cronExpression = ViewDataValueUtils.getValStr((IDataModel)viewModel, (String)"ysq_schedule_expre")), (String)(minSplit = ViewDataValueUtils.getValStr((IDataModel)viewModel, (String)"ysq_min_split")), (String)(hourSplit = ViewDataValueUtils.getValStr((IDataModel)viewModel, (String)"ysq_hour_split")), (String)(schTime = ViewDataValueUtils.getValHourMinStr((IDataModel)viewModel, (String)"ysq_sch_time")), (String)(week = ViewDataValueUtils.getValStr((IDataModel)viewModel, (String)"ysq_week")), (String)(monthSelMonth = ViewDataValueUtils.getValStr((IDataModel)viewModel, (String)"ysq_month_selm")), (String)(monthSelDay = ViewDataValueUtils.getValStr((IDataModel)viewModel, (String)"ysq_month_seld")));
        if (null == scheduleCommandArr) {
            this.getView().showTipNotification("\u8c03\u5ea6\u65f6\u95f4\u8bbe\u7f6e\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002");
            return;
        }
        String[] schConfigArr = CronExpressionUtils.getCronExpression((String)schModel, (String)scheduleCommandArr[0], (String)scheduleCommandArr[1]);
        if (null == schConfigArr) {
            this.getView().showTipNotification("\u8c03\u5ea6\u65f6\u95f4\u8bbe\u7f6e\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002");
            return;
        }
        if (!TriggerTimeUtils.checkCronStr((String)schConfigArr[1]).booleanValue()) {
            this.getView().showTipNotification("\u8c03\u5ea6\u8868\u8fbe\u5f0f\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002");
            return;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cronExpression)) {
            cronExpression = schConfigArr[1];
        }
        Date startDate = dataObj.getDate("ysq_start_time");
        Date endDate = dataObj.getDate("ysq_end_time");
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            this.getView().showTipNotification("\"\u8c03\u5ea6\u5931\u6548\u65f6\u95f4\"\u4e0d\u5f97\u65e9\u4e8e\"\u8c03\u5ea6\u751f\u6548\u65f6\u95f4\"\u3002");
            return;
        }
        String schName = dataObj.getString("ysq_sch_name");
        QFilter qFilter = new QFilter("ysq_sch_name", "=", (Object)schName);
        Object oid = dataObj.get("id");
        if (oid == null || new Long(0L).equals(oid)) {
            boolean schNameCheck = QueryServiceHelper.exists((String)"ysq_process_schedule", (QFilter[])new QFilter[]{qFilter});
            if (schNameCheck) {
                this.getView().showTipNotification("\u8c03\u5ea6\u540d\u79f0\u5df2\u5b58\u5728\u3002");
                return;
            }
            long lid = ID.genLongId();
            Long schId = lid;
            Date startTime = (Date)this.getModel().getValue("ysq_start_time");
            Date endTime = (Date)this.getModel().getValue("ysq_end_time");
            String[] jobPlanIds = ScheduleUtils.addTaskJob((Long)schId, (Date)startTime, (Date)endTime, (String)cronExpression, (String)schName);
            Long jobLong = Long.valueOf(jobPlanIds[0]);
            Long planLong = Long.valueOf(jobPlanIds[1]);
            dataObj.set("ysq_kd_jobid", (Object)jobLong);
            dataObj.set("ysq_kd_planid", (Object)planLong);
            this.saveDbSchdule(lid, dataObj, scheduleCommandArr, schConfigArr);
        } else {
            QFilter cronFilter;
            Date endTime;
            QFilter endFilter;
            Long lid = (Long)oid;
            String croeNew = schConfigArr[1];
            QFilter idFilter = new QFilter("id", "=", (Object)lid);
            Date startTime = (Date)this.getModel().getValue("ysq_start_time");
            QFilter startFilter = new QFilter("ysq_start_time", "=", (Object)startTime);
            QFilter[] qFilters = new QFilter[]{idFilter, startFilter, endFilter = new QFilter("ysq_end_time", "=", (Object)(endTime = (Date)this.getModel().getValue("ysq_end_time"))), cronFilter = new QFilter("ysq_schedule_expre", "=", (Object)croeNew)};
            boolean exists = QueryServiceHelper.exists((String)"ysq_process_schedule", (QFilter[])qFilters);
            if (!exists) {
                DynamicObject schDynObj = null;
                try {
                    schDynObj = BusinessDataServiceHelper.loadSingle((Object)lid, (String)"ysq_process_schedule");
                }
                catch (Exception e) {
                    this.log.debug(e.getMessage());
                    schDynObj = null;
                }
                if (schDynObj == null) {
                    this.getView().showTipNotification("\u8c03\u5ea6\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e");
                    return;
                }
                Long jobId = (Long)schDynObj.get("ysq_kd_jobid");
                Long palinId = (Long)schDynObj.get("ysq_kd_planid");
                ScheduleUtils.delTaskJob((String)jobId.toString(), (String)palinId.toString());
                String[] jobPlanIds = ScheduleUtils.addTaskJob((Long)lid, (Date)startTime, (Date)endTime, (String)croeNew, (String)schName);
                dataObj.set("ysq_kd_jobid", (Object)Long.valueOf(jobPlanIds[0]));
                dataObj.set("ysq_kd_planid", (Object)Long.valueOf(jobPlanIds[1]));
            }
            this.saveDbSchdule(lid, dataObj, scheduleCommandArr, schConfigArr);
        }
    }

    private void disposeParam(DynamicObject dataObj) {
        String param = dataObj.getString("ysq_sch_param_tag");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)param)) {
            List dataList = (List)JSONArray.parseObject((String)param, ArrayList.class);
            for (Map paramsVo : dataList) {
                if (!"file".equals(paramsVo.get("Type")) || null == paramsVo.get("Value") || !paramsVo.get("Value").toString().contains("/temp")) continue;
                ArrayList files = new ArrayList();
                String filePath = AttachmentServiceHelper.saveTempToFileService((String)paramsVo.get("Value").toString(), (String)"ysq_rpamc", (String)"ysq_process_schedule", (Object)dataObj.get("id"), (String)paramsVo.get("FileExtName").toString());
                HashMap<String, Object> filePathMap = new HashMap<String, Object>();
                filePathMap.put("url", filePath);
                filePathMap.put("name", paramsVo.get("FileExtName").toString());
                filePathMap.put("size", 1000);
                filePathMap.put("uid", KdPageUtils.generateFileUID());
                files.add(filePathMap);
                paramsVo.put("Value", filePath);
                List attachments = AttachmentServiceHelper.getAttachments((String)"ysq_process_schedule", (Object)dataObj.get("id"), (String)paramsVo.get("Name").toString());
                if (attachments.size() > 0) {
                    AttachmentServiceHelper.remove((String)"ysq_process_schedule", (Object)dataObj.get("id"), ((Map)attachments.get(0)).get("uid"));
                }
                AttachmentServiceHelper.upload((String)"ysq_process_schedule", (Object)dataObj.get("id"), (String)paramsVo.get("Name").toString(), files);
            }
            param = JSON.toJSONString((Object)dataList);
            String baseParam = IsearchFileUtils.paramsBase64((String)param);
            dataObj.set("ysq_sch_param_tag", (Object)baseParam);
        }
    }

    private void saveDbSchdule(Long lid, DynamicObject dataEntity, String[] scheduleCommandArr, String[] schConfigArr) {
        QFilter verFilter;
        QFilter proFilter;
        String field;
        DynamicObject[] processVerList;
        String robotsNoSel;
        if (!new Long(0L).equals(lid)) {
            dataEntity.set("id", (Object)lid);
        }
        if ("-deptall-".equals(robotsNoSel = dataEntity.getString("ysq_exec_robots_no_sel"))) {
            dataEntity.set("ysq_exec_robots_no_tag", (Object)robotsNoSel);
            dataEntity.set("ysq_robots_sel", null);
        } else {
            String[] split;
            StringBuilder robots = new StringBuilder();
            String string = dataEntity.getString("ysq_robots_sel");
            for (String robotNo : split = string.split(",")) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)robotNo)) continue;
                robots.append("-");
                robots.append(robotNo);
                robots.append("-");
                robots.append(",");
            }
            robots.deleteCharAt(robots.length() - 1);
            dataEntity.set("ysq_exec_robots_no_tag", (Object)robots.toString());
        }
        String proCode = dataEntity.getString("ysq_proc_code");
        String proVer = this.getVersion(proCode);
        if (proCode != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)proCode) && (processVerList = BusinessDataServiceHelper.load((String)"ysq_rpa_process_ver", (String)(field = "ysq_proc_ver,ysq_proc_name,ysq_proc_type"), (QFilter[])new QFilter[]{proFilter = new QFilter("ysq_proc_code", "=", (Object)proCode), verFilter = new QFilter("ysq_proc_ver", "=", (Object)proVer)})) != null && processVerList.length > 0) {
            DynamicObject dynamicObjects = processVerList[0];
            dataEntity.set("ysq_proc_fid", (Object)dynamicObjects.getLong("id"));
            String procName = dynamicObjects.getString("ysq_proc_name");
            dataEntity.set("ysq_proc_name", (Object)procName);
            dataEntity.set("ysq_sch_type", (Object)"common");
        }
        dataEntity.set("ysq_schedule_command", (Object)scheduleCommandArr[0]);
        dataEntity.set("ysq_schedule_time", (Object)scheduleCommandArr[1]);
        String exper = schConfigArr[1];
        dataEntity.set("ysq_schedule_expre", (Object)exper);
        dataEntity.set("ysq_sch_expre_desc", (Object)schConfigArr[2]);
        Date startTime = dataEntity.getDate("ysq_start_time");
        Date endTime = dataEntity.getDate("ysq_end_time");
        if (null == startTime) {
            startTime = new Date();
        }
        if (null == endTime) {
            Calendar endCalendar = Calendar.getInstance();
            endCalendar.setTime(new Date());
            endCalendar.add(1, 200);
            endTime = endCalendar.getTime();
        }
        Date nextExeTime = this.getNextExeTime(exper, startTime);
        dataEntity.set("ysq_next_exe_time", (Object)nextExeTime);
        this.disposeParam(dataEntity);
        this.getView().invokeOperation("save");
    }

    private boolean checkProcessEdit(String key, Control control) {
        DynamicObject data = control.getModel().getDataEntity();
        long schId = data.getLong("id");
        if (schId == 0L) {
            return false;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)data.getLong("id"));
        QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)data.getString("ysq_proc_code"));
        QFilter versionFilter = new QFilter("ysq_proc_ver", "=", (Object)data.getString("ysq_proc_ver"));
        String robots = data.getString("ysq_robots_sel");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)robots)) {
            robots = " ";
        }
        QFilter robotFilter = new QFilter("ysq_robots_sel", "=", (Object)robots);
        boolean exists = QueryServiceHelper.exists((String)"ysq_process_schedule", (QFilter[])new QFilter[]{idFilter, procCodeFilter, robotFilter});
        if (exists) {
            return false;
        }
        QFilter jobFilter = new QFilter("ysq_sch_fid", "=", (Object)data.getLong("id"));
        QFilter typeFilter = new QFilter("ysq_status", "=", (Object)RpaJobStatusEnums.PENDING.getCode());
        boolean jobExit = QueryServiceHelper.exists((String)"ysq_rpa_job", (QFilter[])new QFilter[]{jobFilter, typeFilter});
        return jobExit;
    }

    private Date getNextExeTime(String cron, Date lastDate) {
        List nextTimes = TriggerTimeUtils.findNextTimes((String)cron, (Integer)1, (Date)lastDate);
        if (!nextTimes.isEmpty()) {
            return (Date)nextTimes.get(0);
        }
        return null;
    }

    public void afterBindData(EventObject e) {
        FormShowParameter formShowParameter;
        String proCode;
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW) || status.equals((Object)OperationStatus.EDIT)) {
            this.initSchModelSels();
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(proCode = (String)(formShowParameter = this.getView().getFormShowParameter()).getCustomParam("proCode")))) {
            this.getModel().setValue("ysq_proc_code", (Object)proCode);
            this.getView().updateView("ysq_proc_code");
            this.getView().updateView("ysq_schedule_mode");
            this.update(proCode);
            this.upDateParams(proCode);
        }
    }

    private void initDaySels() {
        int maxVal = 32;
        String selMonthStr = this.getModel().getDataEntity().getString("ysq_month_selm");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)selMonthStr)) {
            String[] selMonthArr = selMonthStr.split(",");
            ArrayList<Integer> selMonthIntList = new ArrayList<Integer>();
            for (String oneMonthStr : selMonthArr) {
                if (!StringUtils.isNotBlank((CharSequence)oneMonthStr)) continue;
                selMonthIntList.add(Integer.parseInt(oneMonthStr.trim()));
            }
            if (selMonthIntList.contains(2)) {
                maxVal = 29;
            } else if (selMonthIntList.contains(4)) {
                maxVal = 31;
            } else if (selMonthIntList.contains(6)) {
                maxVal = 31;
            } else if (selMonthIntList.contains(9)) {
                maxVal = 31;
            } else if (selMonthIntList.contains(11)) {
                maxVal = 31;
            }
            ComboEdit daySel = (ComboEdit)this.getControl("ysq_month_seld");
            ArrayList<ComboItem> dataList = new ArrayList<ComboItem>();
            for (int i = 1; i < maxVal; ++i) {
                String valStr = String.valueOf(i);
                dataList.add(new ComboItem(new LocaleString(valStr), valStr));
            }
            daySel.setComboItems(dataList);
        }
    }

    private void initSchModelSels() {
        String schModel = (String)this.getModel().getValue("ysq_schedule_mode");
        IFormView formView = this.getView();
        formView.setVisible(Boolean.FALSE, new String[]{"ysq_schedule_expre", "ysq_min_split", "ysq_hour_split", "ysq_sch_time", "ysq_week", "ysq_month_selm", "ysq_month_seld"});
        if (ScheduleModelEnums.CRON.getCode().equals(schModel)) {
            formView.setVisible(Boolean.TRUE, new String[]{"ysq_schedule_expre"});
        } else if (StringUtils.isBlank((CharSequence)schModel) || ScheduleModelEnums.MIN.getCode().equals(schModel)) {
            this.getModel().setValue("ysq_schedule_mode", (Object)ScheduleModelEnums.MIN.getCode());
            formView.setVisible(Boolean.TRUE, new String[]{"ysq_min_split"});
            Map map = KdPageUtils.updateControlCaption((String)"\u6bcf\u9694\u51e0\u5206\u949f");
            this.getView().updateControlMetadata("ysq_min_split", map);
        } else if (ScheduleModelEnums.HOUR.getCode().equals(schModel)) {
            formView.setVisible(Boolean.TRUE, new String[]{"ysq_min_split", "ysq_hour_split"});
            Map map = KdPageUtils.updateControlCaption((String)"\u6267\u884c\u65f6\u95f4");
            this.getView().updateControlMetadata("ysq_min_split", map);
        } else if (ScheduleModelEnums.DAY.getCode().equals(schModel)) {
            formView.setVisible(Boolean.TRUE, new String[]{"ysq_sch_time"});
        } else if (ScheduleModelEnums.WEEK.getCode().equals(schModel)) {
            formView.setVisible(Boolean.TRUE, new String[]{"ysq_sch_time", "ysq_week"});
        } else if (ScheduleModelEnums.MONTH.getCode().equals(schModel)) {
            formView.setVisible(Boolean.TRUE, new String[]{"ysq_sch_time", "ysq_month_selm", "ysq_month_seld"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if (YSQ_CLOSEBACK_PARAM.equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null && (returnData = closedCallBackEvent.getReturnData()) != null) {
            ArrayList maps = (ArrayList)returnData;
            String s = JSON.toJSONString((Object)maps);
            this.getModel().setValue("ysq_sch_param_tag", (Object)s);
        }
    }

    private String createFile(List<Map<String, Object>> attachmentData, DynamicObject attachObj) {
        HashMap<String, Object> attachMap = new HashMap<String, Object>();
        attachMap.put("description", attachObj.getString("description"));
        attachMap.put("type", attachObj.getString("type"));
        InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(attachObj.getString("url"));
        String saveUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(attachObj.getString("name"), (InputStream)new BufferedInputStream(inputStream), 7200);
        attachMap.put("url", saveUrl);
        String uid = this.getUid();
        attachMap.put("uid", uid);
        attachMap.put("name", attachObj.getString("name"));
        attachMap.put("size", attachObj.get("size"));
        attachMap.put("fattachmentpanel", "attachmentpanel");
        attachMap.put("entityNum", this.getView().getEntityId());
        attachMap.put("billPkId", String.valueOf(this.getModel().getValue("id")));
        attachMap.put("lastModified", new Date().getTime());
        attachMap.put("status", "success");
        attachMap.put("client", null);
        attachmentData.add(attachMap);
        return uid;
    }

    private String getUid() {
        StringBuffer uid = new StringBuffer("ysq-params-upload-");
        uid.append(new Date().getTime());
        uid.append("-");
        int index = (int)(1.0 + Math.random() * 10.0);
        uid.append(index);
        return uid.toString();
    }
}

