/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.task;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqProcessConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.message.JobQueueProducer;
import ysq.rpac.rpamc.common.model.RpaJobVO;
import ysq.rpac.rpamc.common.utils.LicenseUtils;
import ysq.rpac.rpamc.common.utils.TriggerTimeUtils;

public class RpaJobTask
extends AbstractTask {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private JobQueueProducer jobQueueProducer = JobQueueProducer.getInstance();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Long schId = MapUtils.getLong(map, (Object)"schId");
        if (null == schId) {
            return;
        }
        DynamicObject scheduleDb = null;
        try {
            scheduleDb = BusinessDataServiceHelper.loadSingle((Object)schId, (String)"ysq_process_schedule");
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            scheduleDb = null;
        }
        if (null == scheduleDb) {
            return;
        }
        Date now = new Date();
        String status = scheduleDb.getString("ysq_status");
        if (!"yes".equals(status)) {
            this.log.info("schedule is stopped.");
            return;
        }
        Date endTime = scheduleDb.getDate("ysq_end_time");
        if (null != endTime && new Date().compareTo(endTime) > 0) {
            this.stopSchedule(scheduleDb);
            return;
        }
        String schtype = scheduleDb.getString("ysq_sch_type");
        if ("standard".equals(schtype) && !LicenseUtils.checkStdAppLicense((String)scheduleDb.getString("ysq_proc_code")).booleanValue()) {
            this.log.info(scheduleDb.getString("ysq_proc_code") + "\uff1a\u8bb8\u53ef\u5df2\u8fc7\u671f\u3002");
            return;
        }
        this.changeNextFireTime(scheduleDb, now);
        this.scheduleJob(schId, scheduleDb, now);
    }

    private void scheduleJob(Long schId, DynamicObject scheduleDb, Date now) {
        String procCode = scheduleDb.getString("ysq_proc_code");
        String procVer = scheduleDb.getString("ysq_proc_ver");
        String proChange = null;
        QFilter[] procFilterArr = new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)procCode)};
        DynamicObject processDb = null;
        try {
            processDb = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])procFilterArr);
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            processDb = null;
        }
        if (null == processDb) {
            this.log.info("process is not exist.");
            return;
        }
        if (procVer.equals("latest")) {
            procVer = processDb.getString("ysq_proc_ver");
        }
        QFilter[] procVerfilterArr = new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)procCode), new QFilter("ysq_proc_ver", "=", (Object)procVer)};
        DynamicObject processVerDb = null;
        try {
            processVerDb = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])procVerfilterArr);
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            processVerDb = null;
        }
        if (null == processVerDb) {
            this.log.info("process version is not exist.");
            return;
        }
        proChange = processVerDb.getString("ysq_pro_change");
        QFilter[] filters = new QFilter[]{new QFilter("ysq_status", "=", (Object)RpaJobStatusEnums.PENDING.getCode()), new QFilter("ysq_proc_code", "=", (Object)procCode), new QFilter("ysq_proc_ver", "=", (Object)procVer), new QFilter("ysq_sch_fid", "=", (Object)schId)};
        if (QueryServiceHelper.exists((String)"ysq_rpa_job", (QFilter[])filters)) {
            this.log.info("There is already a pending job to be run in this schedule");
            return;
        }
        int i = scheduleDb.getInt("ysq_sch_job_nums");
        this.syncSchInfos(scheduleDb);
        for (int j = 0; j < i; ++j) {
            RpaJobVO job = this.buildOneJob(schId, scheduleDb, processDb, processVerDb, now, "manager", "task_scheduling", "plan");
            job.setScheduleTime(now);
            DynamicObject rpaJobObj = job.buildDynamicObject();
            Object[] jobs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rpaJobObj});
            DynamicObject jobd = (DynamicObject)jobs[0];
            job.setFid(Long.valueOf(jobd.getLong("id")));
            this.jobQueueProducer.addJob(job, proChange);
        }
    }

    private RpaJobVO buildOneJob(Long schId, DynamicObject scheduleDb, DynamicObject processDb, DynamicObject processVerDb, Date now, String schType, String produceType, String jobType) {
        RpaJobVO job = new RpaJobVO();
        job.setWorkStatus(processDb.getString("ysq_work_status"));
        job.setScheduleFId(schId);
        job.setJobNo(UUID.randomUUID().toString());
        job.setJobOrder(Long.valueOf(now.getTime()));
        job.setSchName(scheduleDb.getString("ysq_sch_name"));
        job.setProduceType(produceType);
        job.setExecRobotsNo(scheduleDb.getString("ysq_exec_robots_no_tag"));
        job.setExecRobotsNames(scheduleDb.getString("ysq_exec_robots_names_tag"));
        job.setExecRobotsAlias(scheduleDb.getString("ysq_exec_robots_alias"));
        job.setProcFid(Long.valueOf(processVerDb.getLong("id")));
        job.setProcCode(processDb.getString("ysq_proc_code"));
        job.setProcName(processDb.getString("ysq_proc_name"));
        job.setProcFile(processVerDb.getString("ysq_proc_file"));
        job.setProcVer(processVerDb.getString("ysq_proc_ver"));
        job.setPublishTime(processVerDb.getDate("ysq_publish_time"));
        if (StringUtils.equals((CharSequence)processDb.getString("ysq_proc_type"), (CharSequence)"standard")) {
            DynamicObject orgInfo = scheduleDb.getDynamicObject("org");
            job.setOrgId(Long.valueOf(orgInfo.getLong("id")));
        } else {
            DynamicObject orgInfo = processDb.getDynamicObject("org");
            Long orgId = orgInfo.getLong("id");
            job.setOrgId(orgId);
        }
        job.setDeveloperUserFid(Long.valueOf(processDb.getLong("ysq_dev_user_fid")));
        job.setDeveloperUserAlias(processDb.getString("ysq_dev_user_alias"));
        job.setJobTime(now);
        job.setStatus(RpaJobStatusEnums.PENDING.getCode());
        job.setExecRobotsAlias(scheduleDb.getString("ysq_exec_robots_alias"));
        job.setPendingTimeout(Integer.valueOf(scheduleDb.getInt("ysq_pending_timeout")));
        job.setRunningTimeout(Integer.valueOf(scheduleDb.getInt("ysq_running_timeout")));
        job.setProcHandDoMin(Integer.valueOf(scheduleDb.getInt("ysq_hand_do_min")));
        job.setAutoStopTime(Integer.valueOf(scheduleDb.getInt("ysq_auto_stop_time")));
        job.setFailTryTimes(Integer.valueOf(scheduleDb.getInt("ysq_fail_try_times")));
        job.setRunTimes(Integer.valueOf(1));
        job.setParameter(scheduleDb.getString("ysq_sch_param_tag"));
        job.setPriority(scheduleDb.getString("ysq_priority"));
        job.setJobType(jobType);
        job.setSchType(schType);
        job.setProcVerDesc(processDb.getString("ysq_proc_desc"));
        job.setStudioVer(processDb.getString("ysq_studio_ver"));
        job.setComJobType(processDb.getString("ysq_proc_type"));
        return job;
    }

    private void syncSchInfos(DynamicObject scheduleDb) {
    }

    private void changeNextFireTime(DynamicObject scheduleDb, Date now) {
        List nextFireTime;
        String cronStr = scheduleDb.getString("ysq_schedule_expre");
        if (StringUtils.isBlank((CharSequence)cronStr)) {
            return;
        }
        if (TriggerTimeUtils.checkCronStr((String)cronStr).booleanValue() && null != (nextFireTime = TriggerTimeUtils.findNextTimes((String)cronStr, (Integer)1, (Date)now)) && !nextFireTime.isEmpty()) {
            Long schId = scheduleDb.getLong("id");
            DynamicObject schUpdate = BusinessDataServiceHelper.newDynamicObject((String)"ysq_process_schedule");
            schUpdate.set("id", (Object)schId);
            schUpdate.set("ysq_next_exe_time", nextFireTime.get(0));
            SaveServiceHelper.update((DynamicObject)schUpdate);
        }
    }

    private void stopSchedule(DynamicObject scheduleDb) {
        Long jobId = scheduleDb.getLong("ysq_kd_jobid");
        Long planId = scheduleDb.getLong("ysq_kd_planid");
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableSchedule(planId.toString());
        scheduleManager.disableJob(jobId.toString());
        scheduleDb.set("ysq_status", (Object)"no");
        SaveServiceHelper.update((DynamicObject)scheduleDb);
    }
}

