/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import ysq.rpac.rpamc.common.enums.RedisKeyItemsEnums;
import ysq.rpac.rpamc.common.enums.RedisLockKeysEnums;

public class RedisCache {
    private final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");
    private static RedisCache instance = null;
    public static final int EXPIRE_NINETY_DAY = 7776000;
    public static final int EXPIRE_ONE_DAY = 86400;
    public static final int EXPIRE_NONE = -1;

    public static RedisCache getInstance() {
        if (null == instance) {
            instance = new RedisCache();
        }
        return instance;
    }

    public <T> T hashGet(String key, String item, Class<?> valueType) {
        String objStr = (String)this.cache.get("ysq_rpamc" + RequestContext.get().getAccountId() + key, item);
        if (StringUtils.isBlank((String)objStr)) {
            return null;
        }
        if (String.class.equals(valueType)) {
            return (T)objStr;
        }
        return (T)SerializationUtils.fromJsonString((String)objStr, valueType);
    }

    public Map<String, String> hashGet(String key) {
        return this.cache.getAll("ysq_rpamc" + RequestContext.get().getAccountId() + key);
    }

    public List<String> hashItemsSet(String key) {
        return this.cache.getKeys("ysq_rpamc" + RequestContext.get().getAccountId() + key);
    }

    public void hashSet(String key, Map<String, String> map) {
        this.hashSet(key, map, 7776000);
    }

    public void hashSet(String key, Map<String, String> map, int expire) {
        this.cache.put("ysq_rpamc" + RequestContext.get().getAccountId() + key, map, expire);
    }

    public void hashSet(String key, String item, String value) {
        this.hashSet(key, item, value, 7776000);
    }

    public void hashSet(String key, String item, String value, int expire) {
        this.cache.put("ysq_rpamc" + RequestContext.get().getAccountId() + key, item, value, expire);
    }

    public boolean hasHashItem(String key, String item) {
        return this.cache.contains("ysq_rpamc" + RequestContext.get().getAccountId() + key, item);
    }

    public void set(String key, String value) {
        this.set(key, value, 7776000);
    }

    public void set(String key, String value, int expire) {
        this.cache.put("ysq_rpamc" + RequestContext.get().getAccountId() + key, (Object)value, expire);
    }

    public <T> T get(String key, Class<?> valueType) {
        String objStr = (String)this.cache.get("ysq_rpamc" + RequestContext.get().getAccountId() + key);
        if (StringUtils.isBlank((String)objStr)) {
            return null;
        }
        if (String.class.equals(valueType)) {
            return (T)objStr;
        }
        return (T)SerializationUtils.fromJsonString((String)objStr, valueType);
    }

    public ArrayList<String> getList(String key) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isBlank((String)key)) {
            return list;
        }
        String[] as = this.cache.getList("ysq_rpamc" + RequestContext.get().getAccountId() + key);
        if (as == null || as.length <= 0) {
            return list;
        }
        list = new ArrayList<String>(Arrays.asList(as));
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T pop(String key, Class<?> valueType) {
        Object result = null;
        if (this.listNum(key) <= 0) {
            return (T)result;
        }
        String objStr = null;
        DLock lock = DLock.create((String)(RedisLockKeysEnums.KEY_HEAD.getKey() + RequestContext.get().getAccountId() + RedisLockKeysEnums.KEY_SPLIT_LOCK.getKey() + RedisLockKeysEnums.REDIS_POP_HEAD.getKey() + key));
        try {
            if (lock.tryLock()) {
                objStr = this.cache.getListObject("ysq_rpamc" + RequestContext.get().getAccountId() + key, 0);
                this.cache.removeListObject("ysq_rpamc" + RequestContext.get().getAccountId() + key, 0);
            }
        }
        finally {
            lock.unlock();
            lock.close();
        }
        if (StringUtils.isBlank(objStr)) {
            return null;
        }
        result = valueType.equals(String.class) ? objStr : SerializationUtils.fromJsonString(objStr, valueType);
        return (T)result;
    }

    public void rightPush(String key, String value) {
        String[] values = new String[]{value};
        this.cache.addList("ysq_rpamc" + RequestContext.get().getAccountId() + key, values, 7776000);
    }

    public void headPush(String key, String value) {
        String[] values = new String[]{value};
        this.cache.insertList("ysq_rpamc" + RequestContext.get().getAccountId() + key, 0, values);
    }

    public Integer listNum(String key) {
        return this.cache.getListLength("ysq_rpamc" + RequestContext.get().getAccountId() + key);
    }

    public boolean hasKey(String key) {
        return this.cache.contains("ysq_rpamc" + RequestContext.get().getAccountId() + key);
    }

    public void delete(String[] keyArr) {
        if (keyArr != null && keyArr.length > 0) {
            String[] preKeyArr = new String[keyArr.length];
            for (int i = 0; i < keyArr.length; ++i) {
                preKeyArr[i] = "ysq_rpamc" + RequestContext.get().getAccountId() + keyArr[i];
            }
            this.cache.remove(preKeyArr);
        }
    }

    public void hashDelete(String key, String item) {
        String[] itemsArr = new String[]{item};
        this.hashDelete(key, itemsArr);
    }

    public void hashDelete(String key, String[] itemsArr) {
        this.cache.remove("ysq_rpamc" + RequestContext.get().getAccountId() + key, itemsArr);
    }

    private RedisCache() {
    }

    public void pendingRobothashSet(String extendAgentNo, String jobNo, String pendingJob) {
        HashMap<String, String> map = (HashMap<String, String>)this.hashGet(RedisKeyItemsEnums.JOB_PENDING_ROBOT_H.getKey(), extendAgentNo, Map.class);
        if (ObjectUtils.isEmpty((Object)map)) {
            map = new HashMap<String, String>();
        }
        map.put(jobNo, pendingJob);
        this.hashSet(RedisKeyItemsEnums.JOB_PENDING_ROBOT_H.getKey(), extendAgentNo, SerializationUtils.toJsonString(map));
    }

    public <T> T pendingRobothashGet(String extendAgentNo, String jobNo, Class<?> valueType) {
        String objStr = null;
        Map map = (Map)this.hashGet(RedisKeyItemsEnums.JOB_PENDING_ROBOT_H.getKey(), extendAgentNo, Map.class);
        if (ObjectUtils.isEmpty((Object)map)) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)jobNo)) {
            objStr = (String)map.get(jobNo);
            map.remove(jobNo);
            if (map.isEmpty()) {
                this.hashDelete(RedisKeyItemsEnums.JOB_PENDING_ROBOT_H.getKey(), extendAgentNo);
            } else {
                this.hashSet(RedisKeyItemsEnums.JOB_PENDING_ROBOT_H.getKey(), extendAgentNo, SerializationUtils.toJsonString((Object)map));
            }
        }
        if (StringUtils.isBlank(objStr)) {
            return null;
        }
        Object result = valueType.equals(String.class) ? objStr : SerializationUtils.fromJsonString((String)objStr, valueType);
        return (T)result;
    }

    public <T> T pendingRobothashGetRandom(String extendAgentNo, Class<?> valueType) {
        Map map = (Map)this.hashGet(RedisKeyItemsEnums.JOB_PENDING_ROBOT_H.getKey(), extendAgentNo, Map.class);
        if (ObjectUtils.isEmpty((Object)map)) {
            return null;
        }
        String[] keys = map.keySet().toArray(new String[0]);
        String objStr = (String)map.get(keys[0]);
        map.remove(keys[0]);
        if (map.isEmpty()) {
            this.hashDelete(RedisKeyItemsEnums.JOB_PENDING_ROBOT_H.getKey(), extendAgentNo);
        } else {
            this.hashSet(RedisKeyItemsEnums.JOB_PENDING_ROBOT_H.getKey(), extendAgentNo, SerializationUtils.toJsonString((Object)map));
        }
        if (StringUtils.isBlank((String)objStr)) {
            return null;
        }
        Object result = valueType.equals(String.class) ? objStr : SerializationUtils.fromJsonString((String)objStr, valueType);
        return (T)result;
    }
}

