/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.message;

import java.util.ArrayList;
import java.util.List;
import kd.bos.login.actions.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.cache.RedisCache;
import ysq.rpac.rpamc.common.enums.RedisKeyItemsEnums;
import ysq.rpac.rpamc.common.enums.RobotRangeEnums;
import ysq.rpac.rpamc.common.message.model.JobQueueBean;
import ysq.rpac.rpamc.common.model.RpaJobVO;

public class JobQueueProducer {
    private static JobQueueProducer instance = null;
    private final RedisCache redisCache = RedisCache.getInstance();

    public static JobQueueProducer getInstance() {
        if (null == instance) {
            instance = new JobQueueProducer();
        }
        return instance;
    }

    public void addJobStopping(RpaJobVO job) {
        this.redisCache.hashSet(RedisKeyItemsEnums.JOB_STOPPING_H.getKey(), job.getJobNo(), SerializationUtils.toJsonString((Object)job));
    }

    public RpaJobVO returnJobStopping(String jobNo) {
        if (StringUtils.isBlank((CharSequence)jobNo)) {
            return null;
        }
        RpaJobVO rpaJob = (RpaJobVO)this.redisCache.hashGet(RedisKeyItemsEnums.JOB_STOPPING_H.getKey(), jobNo, RpaJobVO.class);
        this.redisCache.hashDelete(RedisKeyItemsEnums.JOB_STOPPING_H.getKey(), jobNo);
        return rpaJob;
    }

    public void removeJob(String jobNo) {
        if (StringUtils.isBlank((CharSequence)jobNo)) {
            return;
        }
        this.redisCache.pop(RedisKeyItemsEnums.KEY_JONNO_QUEUE_H.getKey() + RedisKeyItemsEnums.KEY_SPLIT.getKey() + jobNo, RpaJobVO.class);
    }

    public boolean checkJobExist(String jobNo) {
        return this.redisCache.hasKey(RedisKeyItemsEnums.KEY_JONNO_QUEUE_H.getKey() + RedisKeyItemsEnums.KEY_SPLIT.getKey() + jobNo);
    }

    public void addJob(RpaJobVO job, String proChange) {
        String execNos = job.getExecRobotsNo();
        if (StringUtils.isBlank((CharSequence)execNos)) {
            return;
        }
        String level = job.getPriority();
        if (null == level) {
            level = "middle";
        }
        JobQueueBean bean = JobQueueBean.buildBean(job, proChange);
        List<String> keys = this.asJobStroeKeys(execNos, level, job.getSchType(), job.getOrgId(), job.getProcCode(), job.getComJobType());
        this.redisCache.rightPush(RedisKeyItemsEnums.KEY_JONNO_QUEUE_H.getKey() + RedisKeyItemsEnums.KEY_SPLIT.getKey() + job.getJobNo(), SerializationUtils.toJsonString((Object)bean));
        keys.forEach(key -> this.redisCache.rightPush((String)key, job.getJobNo()));
    }

    public JobQueueBean popJob(String robotsNo, Long agentOrgId, Boolean isManager, String agentType) {
        String schId;
        String string = schId = Boolean.TRUE.equals(isManager) ? RedisKeyItemsEnums.KEY_HASSCH.getKey() : RedisKeyItemsEnums.KEY_NOSCH.getKey();
        if (StringUtils.isBlank((CharSequence)robotsNo)) {
            return null;
        }
        ArrayList<String> midKeyList = new ArrayList<String>();
        if (agentType.equals("standardRobot")) {
            schId = "standard";
            midKeyList.add(RobotRangeEnums.DEFAULT.getCode());
        }
        midKeyList.add(robotsNo);
        if (null == agentOrgId) {
            midKeyList.add(RedisKeyItemsEnums.KEY_JOB_ALL.getKey());
        } else {
            midKeyList.add(agentOrgId.toString());
        }
        return this.findJob(midKeyList, schId);
    }

    private JobQueueBean findJob(List<String> keyList, String schId) {
        JobQueueBean rpaJob;
        String key;
        ArrayList<String> levelList = new ArrayList<String>();
        levelList.add("higher");
        levelList.add("high");
        levelList.add("middle");
        levelList.add("low");
        for (String oneLevel : levelList) {
            for (String oneKey : keyList) {
                key = this.buildKey(oneKey, oneLevel, schId);
                rpaJob = this.popJob(key);
                if (null == rpaJob) continue;
                return rpaJob;
            }
        }
        if (!schId.equals("standard")) {
            schId = "standard";
            for (String oneLevel : levelList) {
                for (String oneKey : keyList) {
                    key = this.buildKey(oneKey, oneLevel, schId);
                    rpaJob = this.popJob(key);
                    if (null == rpaJob) continue;
                    return rpaJob;
                }
            }
        }
        return null;
    }

    private JobQueueBean popJob(String key) {
        JobQueueBean rpaJob = null;
        String jobNo = null;
        do {
            if (!StringUtils.isBlank((CharSequence)(jobNo = (String)this.redisCache.pop(key, String.class)))) continue;
            return rpaJob;
        } while ((rpaJob = (JobQueueBean)this.redisCache.pop(RedisKeyItemsEnums.KEY_JONNO_QUEUE_H.getKey() + RedisKeyItemsEnums.KEY_SPLIT.getKey() + jobNo, JobQueueBean.class)) == null);
        return rpaJob;
    }

    private List<String> asJobStroeKeys(String execRobotsNo, String level, String schType, Long orgId, String procCode, String comJobType) {
        String hasSch;
        String string = hasSch = schType.equals("manager") ? RedisKeyItemsEnums.KEY_HASSCH.getKey() : RedisKeyItemsEnums.KEY_NOSCH.getKey();
        if ("standard".equals(comJobType)) {
            hasSch = "standard";
        }
        ArrayList<String> keys = new ArrayList<String>();
        if (RobotRangeEnums.DEFAULT.getCode().equals(execRobotsNo)) {
            keys.add(this.buildKey(RobotRangeEnums.DEFAULT.getCode(), level, hasSch));
        } else if (RobotRangeEnums.DEPTALL.getCode().equals(execRobotsNo)) {
            if (null != orgId) {
                keys.add(this.buildKey(orgId.toString(), level, hasSch));
            }
        } else {
            String[] execNos = execRobotsNo.split(",");
            if (null == execNos) {
                return keys;
            }
            for (String execNo : execNos) {
                if (!StringUtils.isNotBlank((CharSequence)execNo)) continue;
                keys.add(this.buildKey(execNo.trim(), level, hasSch));
            }
        }
        return keys;
    }

    private String buildKey(String midKey, String level, String hasSch) {
        return RedisKeyItemsEnums.KEY_JOB_H.getKey() + RedisKeyItemsEnums.KEY_SPLIT.getKey() + hasSch + RedisKeyItemsEnums.KEY_SPLIT.getKey() + midKey + RedisKeyItemsEnums.KEY_SPLIT.getKey() + level;
    }

    private JobQueueProducer() {
    }
}

