/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.message;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.cache.RedisCache;
import ysq.rpac.rpamc.common.enums.RedisKeyItemsEnums;
import ysq.rpac.rpamc.common.message.model.JobQueueBean;
import ysq.rpac.rpamc.common.utils.DateUtils;

public class RobotPendingJobProducer {
    private static Log log = LogFactory.getLog(RobotPendingJobProducer.class);
    private static RobotPendingJobProducer instance = null;
    private final RedisCache redisCache = RedisCache.getInstance();

    public static RobotPendingJobProducer getInstance() {
        if (null == instance) {
            instance = new RobotPendingJobProducer();
        }
        return instance;
    }

    public JobQueueBean popJob(String extendAgentNo, String jobNo) {
        return (JobQueueBean)this.redisCache.pendingRobothashGet(extendAgentNo, jobNo, JobQueueBean.class);
    }

    public JobQueueBean popLikeJob(String extendAgentNo, String jobNo, Date nowStamp) {
        JobQueueBean bean = (JobQueueBean)this.redisCache.pendingRobothashGet(extendAgentNo, jobNo, JobQueueBean.class);
        if (null != bean) {
            return bean;
        }
        bean = (JobQueueBean)this.redisCache.pendingRobothashGetRandom(extendAgentNo, JobQueueBean.class);
        if (null != bean) {
            bean.setJobStartTime(nowStamp);
        }
        return bean;
    }

    public void pushJob(String extendAgentNo, String robotName, String jobNo, JobQueueBean pendingJob, Date now) {
        if (null != now) {
            pendingJob.setRobotPendingPutTime(DateUtils.formatDate(now));
            pendingJob.setJobStartTime(now);
        }
        pendingJob.setRobotName(robotName);
        this.redisCache.pendingRobothashSet(extendAgentNo, jobNo, SerializationUtils.toJsonString((Object)pendingJob));
    }

    public boolean checkHasJob(String jobNo, String extendAgentNo) {
        if (StringUtils.isBlank((CharSequence)extendAgentNo)) {
            Map<String, String> hash = this.redisCache.hashGet(RedisKeyItemsEnums.JOB_PENDING_ROBOT_H.getKey());
            Set<String> keys = hash.keySet();
            Map pendJobs = null;
            for (String key : keys) {
                String json = hash.get(key);
                try {
                    pendJobs = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
                    if (!ObjectUtils.isNotEmpty(pendJobs.get(jobNo))) continue;
                    return true;
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    return false;
                }
            }
            return false;
        }
        Map map = (Map)this.redisCache.hashGet(RedisKeyItemsEnums.JOB_PENDING_ROBOT_H.getKey(), extendAgentNo, Map.class);
        return !StringUtils.isBlank((CharSequence)((CharSequence)map.get(jobNo)));
    }

    public Set<String> listKeys() {
        Map<String, String> hash = this.redisCache.hashGet(RedisKeyItemsEnums.JOB_PENDING_ROBOT_H.getKey());
        Set<String> keys = hash.keySet();
        return keys;
    }

    private RobotPendingJobProducer() {
    }
}

