/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.model;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.model.BaseVO;
import ysq.rpac.rpamc.common.utils.DateUtils;

public class CdaAgentVO
extends BaseVO {
    private static final long serialVersionUID = 5570670624988757441L;
    public static final String SERVER_OS_FLG = "server";
    public static final String UNIQUE_FLG_SPLIT = "@";
    public static final String UNIQUE_FLG = "-";
    public static final String MULTI_SPLIT = ",";
    public static final String MANAGER_TRUE = "yes";
    public static final String MANAGER_FALSE = "no";
    public static final String ASSISTANT = "assistant";
    public static final String ROBOT = "robot";
    public static final String STANDARD_ROBOT = "standardRobot";
    public static final String STUDIO = "studio";
    public static final String STATUS_ENABLE = "yes";
    public static final String STATUS_DISABLE = "no";
    public static final String UNDER_MANAGERMENT_TRUE = "yes";
    public static final String UNDER_MANAGERMENT_FALSE = "no";
    public static final String AUTO_LOGIN_TRUE = "yes";
    public static final String AUTO_LOGIN_FALSE = "no";
    private Long fid;
    private String agentNo;
    private String agentDcode;
    private String agentUncode;
    private String agentIp;
    private String agentAlias;
    private String agentType;
    private String isManager;
    private String userName;
    private String userDomain;
    private String agentName;
    private String agentOs;
    private String agentVersion;
    private String rpaUserName;
    private Long orgFid;
    private String desktopType;
    private Date lastHeartTime;
    private String description;
    private String nextAction;
    private String status;
    private String dataStatus;
    private Integer rdpPort;
    private String commToken;
    private Date lastLoginTime;
    private String winStatus;
    private String underManagerment;
    private Date lastConnTime;
    private String connIp;
    private String clientPwd;
    private String clientResolution;
    private String autoLogin;
    private String connFaileMsg;
    private Long identityFid;
    private String identityDesc;
    private String accessToken;
    private String extendAgentNo;

    @Override
    public DynamicObject buildDynamicObject() {
        DynamicObject objectDb = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_agent");
        objectDb.set("id", (Object)this.fid);
        objectDb.set("org", (Object)this.orgFid);
        objectDb.set("ysq_agent_no", (Object)this.agentNo);
        objectDb.set("ysq_agent_dcode", (Object)this.agentDcode);
        objectDb.set("ysq_agent_uncode", (Object)this.agentUncode);
        objectDb.set("ysq_agent_ip", (Object)this.agentIp);
        objectDb.set("ysq_agent_alias", (Object)this.agentAlias);
        objectDb.set("ysq_agent_type", (Object)this.agentType);
        objectDb.set("ysq_is_manager", (Object)this.isManager);
        objectDb.set("ysq_user_name", (Object)this.userName);
        objectDb.set("ysq_user_domain", (Object)this.userDomain);
        objectDb.set("ysq_agent_name", (Object)this.agentName);
        objectDb.set("ysq_agent_os", (Object)this.agentOs);
        objectDb.set("ysq_agent_version", (Object)this.agentVersion);
        objectDb.set("ysq_rpa_user_name", (Object)this.rpaUserName);
        objectDb.set("ysq_desktop_type", (Object)this.desktopType);
        objectDb.set("ysq_last_heart_time", (Object)this.lastHeartTime);
        objectDb.set("ysq_description", (Object)this.description);
        objectDb.set("ysq_next_action", (Object)this.nextAction);
        objectDb.set("ysq_status", (Object)this.status);
        objectDb.set("ysq_data_status", (Object)this.dataStatus);
        objectDb.set("ysq_rdp_port", (Object)this.rdpPort);
        objectDb.set("ysq_comm_token", (Object)this.commToken);
        objectDb.set("ysq_last_login_time", (Object)this.lastLoginTime);
        objectDb.set("ysq_win_status", (Object)this.winStatus);
        objectDb.set("ysq_under_managerment", (Object)this.underManagerment);
        objectDb.set("ysq_last_conn_time", (Object)this.lastConnTime);
        objectDb.set("ysq_conn_ip", (Object)this.connIp);
        objectDb.set("ysq_client_pwd", (Object)this.clientPwd);
        objectDb.set("ysq_client_resolution", (Object)this.clientResolution);
        objectDb.set("ysq_auto_login", (Object)this.autoLogin);
        objectDb.set("ysq_conn_faile_msg", (Object)this.connFaileMsg);
        objectDb.set("ysq_identity_fid", (Object)this.identityFid);
        objectDb.set("ysq_identity_desc", (Object)this.identityDesc);
        objectDb.set("ysq_access_token", (Object)this.accessToken);
        return objectDb;
    }

    @Override
    public CdaAgentVO fromDynamicObject(DynamicObject objectDb) {
        CdaAgentVO baseVo = null;
        if (null == objectDb) {
            return baseVo;
        }
        baseVo = new CdaAgentVO();
        baseVo.setFid(objectDb.getLong("id"));
        baseVo.setOrgFid(BaseVO.getOrgId(objectDb));
        baseVo.setAgentNo(objectDb.getString("ysq_agent_no"));
        baseVo.setAgentDcode(objectDb.getString("ysq_agent_dcode"));
        baseVo.setAgentUncode(objectDb.getString("ysq_agent_uncode"));
        baseVo.setAgentIp(objectDb.getString("ysq_agent_ip"));
        baseVo.setAgentAlias(objectDb.getString("ysq_agent_alias"));
        baseVo.setAgentType(objectDb.getString("ysq_agent_type"));
        baseVo.setIsManager(objectDb.getString("ysq_is_manager"));
        baseVo.setUserName(objectDb.getString("ysq_user_name"));
        baseVo.setUserDomain(objectDb.getString("ysq_user_domain"));
        baseVo.setAgentName(objectDb.getString("ysq_agent_name"));
        baseVo.setAgentOs(objectDb.getString("ysq_agent_os"));
        baseVo.setAgentVersion(objectDb.getString("ysq_agent_version"));
        baseVo.setRpaUserName(objectDb.getString("ysq_rpa_user_name"));
        baseVo.setDesktopType(objectDb.getString("ysq_desktop_type"));
        baseVo.setLastHeartTime(objectDb.getDate("ysq_last_heart_time"));
        baseVo.setDescription(objectDb.getString("ysq_description"));
        baseVo.setNextAction(objectDb.getString("ysq_next_action"));
        baseVo.setStatus(objectDb.getString("ysq_status"));
        baseVo.setDataStatus(objectDb.getString("ysq_data_status"));
        baseVo.setRdpPort(objectDb.getInt("ysq_rdp_port"));
        baseVo.setCommToken(objectDb.getString("ysq_comm_token"));
        baseVo.setLastLoginTime(objectDb.getDate("ysq_last_login_time"));
        baseVo.setWinStatus(objectDb.getString("ysq_win_status"));
        baseVo.setUnderManagerment(objectDb.getString("ysq_under_managerment"));
        baseVo.setLastConnTime(objectDb.getDate("ysq_last_conn_time"));
        baseVo.setConnIp(objectDb.getString("ysq_conn_ip"));
        baseVo.setClientPwd(objectDb.getString("ysq_client_pwd"));
        baseVo.setClientResolution(objectDb.getString("ysq_client_resolution"));
        baseVo.setAutoLogin(objectDb.getString("ysq_auto_login"));
        baseVo.setConnFaileMsg(objectDb.getString("ysq_conn_faile_msg"));
        baseVo.setIdentityFid(objectDb.getLong("ysq_identity_fid"));
        baseVo.setIdentityDesc(objectDb.getString("ysq_identity_desc"));
        baseVo.setAccessToken(objectDb.getString("ysq_access_token"));
        return baseVo;
    }

    public Map<String, Object> mapFromDynamicObject(DynamicObject objectDb) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", objectDb.getLong("id"));
        map.put("agentNo", objectDb.getString("ysq_agent_no"));
        map.put("agentIp", objectDb.getString("ysq_agent_ip"));
        map.put("agentAlias", objectDb.getString("ysq_agent_alias"));
        map.put("agentType", objectDb.getString("ysq_agent_type"));
        if ("yes".equals(objectDb.getString("ysq_is_manager"))) {
            map.put("isManager", 0);
        } else {
            map.put("isManager", 1);
        }
        map.put("userName", objectDb.getString("ysq_user_name"));
        map.put("userDomain", objectDb.getString("ysq_user_domain"));
        map.put("agentName", objectDb.getString("ysq_agent_name"));
        map.put("agentOs", objectDb.getString("ysq_agent_os"));
        map.put("agentVersion", objectDb.getString("ysq_agent_version"));
        map.put("rpaUserName", objectDb.getString("ysq_rpa_user_name"));
        DynamicObject org = objectDb.getDynamicObject("org");
        map.put("curOrgName", org.getString("name"));
        map.put("desktopType", objectDb.getString("ysq_desktop_type"));
        map.put("description", objectDb.getString("ysq_description"));
        map.put("nextAction", objectDb.getString("ysq_next_action"));
        if ("yes".equals(objectDb.getString("ysq_status"))) {
            map.put("status", 0);
        } else {
            map.put("status", 1);
        }
        map.put("dataStatus", objectDb.getString("ysq_data_status"));
        map.put("rdpPort ", objectDb.getString("ysq_rdp_port"));
        map.put("licSn", "");
        map.put("licStatus", 0);
        map.put("winStatus", objectDb.getString("ysq_win_status"));
        map.put("underManagerment", objectDb.getString("ysq_under_managerment"));
        map.put("lastConnTime", objectDb.getString("ysq_last_conn_time"));
        map.put("connIp", objectDb.getString("ysq_conn_ip"));
        if ("yes".equals(objectDb.getString("ysq_auto_login"))) {
            map.put("autoLogin", 0);
        } else {
            map.put("autoLogin", 1);
        }
        map.put("connFaileMsg", objectDb.getString("ysq_conn_faile_msg"));
        map.put("identity", objectDb.getLong("ysq_identity_fid"));
        map.put("createTime", DateUtils.formatDate(objectDb.getDate("createtime"), "yyyy-MM-dd HH:mm:ss"));
        map.put("modifyTime", DateUtils.formatDate(objectDb.getDate("modifytime"), "yyyy-MM-dd HH:mm:ss"));
        return map;
    }

    public static boolean isServerOs(String osDesc) {
        boolean isServerOs = false;
        if (StringUtils.isNotBlank((CharSequence)osDesc) && osDesc.toLowerCase().contains(SERVER_OS_FLG)) {
            isServerOs = true;
        }
        return isServerOs;
    }

    public static String buildRealAgentNo(String osDesc, String userName, String agentNo) {
        if (CdaAgentVO.isServerOs(osDesc)) {
            return userName + UNIQUE_FLG_SPLIT + agentNo;
        }
        return agentNo;
    }

    public String buildRealAgentNo() {
        if (CdaAgentVO.isServerOs(this.getAgentOs())) {
            return this.getUserName() + UNIQUE_FLG_SPLIT + this.getAgentNo();
        }
        return this.getAgentNo();
    }

    public boolean selfIsServerOs() {
        return CdaAgentVO.isServerOs(this.getAgentOs());
    }

    public Long getFid() {
        return this.fid;
    }

    public void setFid(Long fid) {
        this.fid = fid;
    }

    public String getAgentNo() {
        return this.agentNo;
    }

    public void setAgentNo(String agentNo) {
        this.agentNo = agentNo;
    }

    public String getAgentDcode() {
        return this.agentDcode;
    }

    public void setAgentDcode(String agentDcode) {
        this.agentDcode = agentDcode;
    }

    public String getAgentUncode() {
        return this.agentUncode;
    }

    public void setAgentUncode(String agentUncode) {
        this.agentUncode = agentUncode;
    }

    public String getAgentIp() {
        return this.agentIp;
    }

    public void setAgentIp(String agentIp) {
        this.agentIp = agentIp;
    }

    public String getAgentAlias() {
        return this.agentAlias;
    }

    public void setAgentAlias(String agentAlias) {
        this.agentAlias = agentAlias;
    }

    public String getAgentType() {
        return this.agentType;
    }

    public void setAgentType(String agentType) {
        this.agentType = agentType;
    }

    public String getIsManager() {
        return this.isManager;
    }

    public void setIsManager(String isManager) {
        this.isManager = isManager;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserDomain() {
        return this.userDomain;
    }

    public void setUserDomain(String userDomain) {
        this.userDomain = userDomain;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getAgentOs() {
        return this.agentOs;
    }

    public void setAgentOs(String agentOs) {
        this.agentOs = agentOs;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public String getRpaUserName() {
        return this.rpaUserName;
    }

    public void setRpaUserName(String rpaUserName) {
        this.rpaUserName = rpaUserName;
    }

    public Long getOrgFid() {
        return this.orgFid;
    }

    public void setOrgFid(Long orgFid) {
        this.orgFid = orgFid;
    }

    public String getDesktopType() {
        return this.desktopType;
    }

    public void setDesktopType(String desktopType) {
        this.desktopType = desktopType;
    }

    public Date getLastHeartTime() {
        return this.lastHeartTime;
    }

    public void setLastHeartTime(Date lastHeartTime) {
        this.lastHeartTime = lastHeartTime;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNextAction() {
        return this.nextAction;
    }

    public void setNextAction(String nextAction) {
        this.nextAction = nextAction;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDataStatus() {
        return this.dataStatus;
    }

    public void setDataStatus(String dataStatus) {
        this.dataStatus = dataStatus;
    }

    public Integer getRdpPort() {
        return this.rdpPort;
    }

    public void setRdpPort(Integer rdpPort) {
        this.rdpPort = rdpPort;
    }

    public String getCommToken() {
        return this.commToken;
    }

    public void setCommToken(String commToken) {
        this.commToken = commToken;
    }

    public Date getLastLoginTime() {
        return this.lastLoginTime;
    }

    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public String getWinStatus() {
        return this.winStatus;
    }

    public void setWinStatus(String winStatus) {
        this.winStatus = winStatus;
    }

    public String getUnderManagerment() {
        return this.underManagerment;
    }

    public void setUnderManagerment(String underManagerment) {
        this.underManagerment = underManagerment;
    }

    public Date getLastConnTime() {
        return this.lastConnTime;
    }

    public void setLastConnTime(Date lastConnTime) {
        this.lastConnTime = lastConnTime;
    }

    public String getConnIp() {
        return this.connIp;
    }

    public void setConnIp(String connIp) {
        this.connIp = connIp;
    }

    public String getClientPwd() {
        return this.clientPwd;
    }

    public void setClientPwd(String clientPwd) {
        this.clientPwd = clientPwd;
    }

    public String getClientResolution() {
        return this.clientResolution;
    }

    public void setClientResolution(String clientResolution) {
        this.clientResolution = clientResolution;
    }

    public String getAutoLogin() {
        return this.autoLogin;
    }

    public void setAutoLogin(String autoLogin) {
        this.autoLogin = autoLogin;
    }

    public String getConnFaileMsg() {
        return this.connFaileMsg;
    }

    public void setConnFaileMsg(String connFaileMsg) {
        this.connFaileMsg = connFaileMsg;
    }

    public Long getIdentityFid() {
        return this.identityFid;
    }

    public void setIdentityFid(Long identityFid) {
        this.identityFid = identityFid;
    }

    public String getIdentityDesc() {
        return this.identityDesc;
    }

    public void setIdentityDesc(String identityDesc) {
        this.identityDesc = identityDesc;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getExtendAgentNo() {
        if (StringUtils.isNotBlank((CharSequence)this.agentNo)) {
            return UNIQUE_FLG + this.agentNo + UNIQUE_FLG;
        }
        return null;
    }

    public void setExtendAgentNo(String extendAgentNo) {
        this.extendAgentNo = extendAgentNo;
    }
}

