/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.servicehelper;

import java.io.File;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqProcessConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.message.JobQueueProducer;
import ysq.rpac.rpamc.common.message.RobotPendingJobProducer;
import ysq.rpac.rpamc.common.model.CdaAgentVO;
import ysq.rpac.rpamc.common.model.HandSaveJobVO;
import ysq.rpac.rpamc.common.model.RpaJobVO;
import ysq.rpac.rpamc.common.status.job.core.JobStatusCache;
import ysq.rpac.rpamc.common.status.job.utils.JobStatusFullInofBuilder;
import ysq.rpac.rpamc.common.utils.DateUtils;
import ysq.rpac.rpamc.common.utils.IsearchFileUtils;

public class AgentProcessServiceHelper {
    private static Log log = LogFactory.getLog(AgentProcessServiceHelper.class);

    public static Map<String, Object> run(Map<String, Object> tokenUser, CdaAgentVO cdaAgent, String procCode, String procVer) {
        Date now = new Date();
        QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        QFilter[] filters = new QFilter[]{procCodeFilter};
        String feild = YsqProcessConstant.selAllFileds();
        DynamicObject process = null;
        try {
            process = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process", (String)feild, (QFilter[])filters);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            process = null;
        }
        if (null == process) {
            log.info("process is not exist.");
            return null;
        }
        QFilter[] procVerfilterArr = new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)procCode)};
        DynamicObject[] processVerArr = BusinessDataServiceHelper.load((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])procVerfilterArr, (String)"id asc");
        if (null == processVerArr || processVerArr.length == 0) {
            log.info("process version is not exist.");
            return null;
        }
        DynamicObject processVerDb = processVerArr[0];
        String proChange = processVerDb.getString("ysq_pro_change");
        RpaJobVO job = AgentProcessServiceHelper.buildOneJob(cdaAgent, process, processVerDb, now, tokenUser.get("id").toString());
        Object[] jobs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{job.buildDynamicObject()});
        DynamicObject jobd = (DynamicObject)jobs[0];
        job.setFid(jobd.getLong("id"));
        JobQueueProducer.getInstance().addJob(job, proChange);
        Map<String, Object> result = AgentProcessServiceHelper.coverJob(job, proChange);
        return result;
    }

    private static Map<String, Object> coverJob(RpaJobVO job, String proChange) {
        HashMap<String, Object> rstMap = new HashMap<String, Object>();
        rstMap.put("action", "proc_run");
        rstMap.put("job_id", "" + job.getFid());
        rstMap.put("job_no", job.getJobNo());
        rstMap.put("proc_name", job.getProcName());
        rstMap.put("proc_code", job.getProcCode());
        rstMap.put("proc_path", job.getProcFile());
        rstMap.put("proc_ver", job.getProcVer());
        rstMap.put("proc_plan_time", DateUtils.formatDate(job.getScheduleTime()));
        rstMap.put("proc_start_time", DateUtils.full());
        rstMap.put("parameter", job.getParameter());
        long pendingTime = 0L;
        Date planTime = job.getScheduleTime();
        Date startTime = DateUtils.getNow();
        if (planTime != null) {
            pendingTime = startTime.getTime() - planTime.getTime();
            pendingTime /= 1000L;
        }
        rstMap.put("proc_pending_time", pendingTime);
        rstMap.put("proc_hand_duration_min", job.getProcHandDoMin());
        String procFile = job.getProcFile();
        File file = new File(procFile);
        Long fileSize = 0L;
        if (file.exists()) {
            fileSize = file.length();
        }
        if (null != proChange) {
            rstMap.put("proChange", proChange);
        }
        rstMap.put("file_size", fileSize);
        if (null != job.getPublishTime()) {
            rstMap.put("publish", DateUtils.formatDate(job.getPublishTime()));
        }
        return rstMap;
    }

    private static RpaJobVO buildOneJob(CdaAgentVO cdaAgent, DynamicObject processDb, DynamicObject processVerDb, Date now, String jobType) {
        RpaJobVO job = new RpaJobVO();
        job.setWorkStatus(processDb.getString("ysq_work_status"));
        job.setJobNo(UUID.randomUUID().toString());
        job.setJobOrder(now.getTime());
        job.setProduceType("manual_run");
        job.setExecRobotsNo(cdaAgent.getExtendAgentNo());
        job.setExecRobotsNames("-" + cdaAgent.getAgentName() + "-");
        job.setExecRobotsAlias("-" + cdaAgent.getAgentAlias() + "-");
        job.setProcFid(processDb.getLong("id"));
        job.setProcCode(processDb.getString("ysq_proc_code"));
        job.setProcName(processDb.getString("ysq_proc_name"));
        job.setProcFile(processVerDb.getString("ysq_proc_file"));
        job.setProcVer(processVerDb.getString("ysq_proc_ver"));
        job.setPublishTime(processVerDb.getDate("ysq_publish_time"));
        DynamicObject orgInfo = processDb.getDynamicObject("org");
        Long orgId = orgInfo.getLong("id");
        job.setOrgId(orgId);
        job.setDeveloperUserFid(processDb.getLong("ysq_dev_user_fid"));
        job.setDeveloperUserAlias(processDb.getString("ysq_dev_user_alias"));
        job.setJobTime(now);
        job.setStatus(RpaJobStatusEnums.RUNNING.getCode());
        job.setRunTimes(1);
        job.setProcVerDesc(processDb.getString("ysq_proc_desc"));
        job.setPriority("higher");
        job.setJobType(jobType);
        job.setSchType("unManager");
        job.setStudioVer(processDb.getString("ysq_studio_ver"));
        job.setParameter(IsearchFileUtils.base64ToParams(processVerDb.getString("ysq_param_tag")));
        return job;
    }

    public static void robotsJobResult(CdaAgentVO cdaAgent, DynamicObject rpaJob, String result, String resultDesc, String procEndTime, String procStartTime, String exceName, String exceDesc) {
        boolean isExist;
        Date procEndTimeD;
        Timestamp robotStartTime = null;
        Timestamp robotEndTime = null;
        Date procStartTimeD = DateUtils.parseDate(procStartTime);
        if (null != procStartTimeD) {
            robotStartTime = new Timestamp(procStartTimeD.getTime());
        }
        if (null != (procEndTimeD = DateUtils.parseDate(procEndTime))) {
            robotEndTime = new Timestamp(procEndTimeD.getTime());
        }
        Timestamp serviceEndTime = null;
        Timestamp now = DateUtils.getTimestamp();
        Date startTime = rpaJob.getDate("ysq_start_time");
        serviceEndTime = null == robotEndTime ? now : (null != startTime && robotEndTime.before(startTime) ? now : robotEndTime);
        if (null == startTime && null != robotEndTime && null != robotStartTime) {
            startTime = new Timestamp(serviceEndTime.getTime() - (robotEndTime.getTime() - robotStartTime.getTime()));
            rpaJob.set("ysq_start_time", (Object)startTime);
        }
        JobStatusFullInofBuilder builder = JobStatusFullInofBuilder.newBuilder(rpaJob.getLong("id"), rpaJob.getString("ysq_job_no"), result);
        long seconds = DateUtils.getIntervals(serviceEndTime, startTime);
        builder.runTimeSec(seconds);
        builder.endTime(serviceEndTime);
        builder.description(resultDesc);
        builder.exceptionName(exceName);
        builder.exceptionContent(exceDesc);
        builder.robotStartTime(robotStartTime);
        builder.robotEndTime(robotEndTime);
        builder.startTime(startTime);
        builder.operType("client");
        builder.currRobotNo(cdaAgent.getExtendAgentNo());
        builder.currRobotName(cdaAgent.getAgentAlias());
        if (result.equals(RpaJobStatusEnums.CANCELLED.getCode()) && (isExist = RobotPendingJobProducer.getInstance().checkHasJob(rpaJob.getString("ysq_job_no"), null))) {
            return;
        }
        JobStatusCache.getInstance().chacheStatus(builder.build(), "AgentProcessServiceHelper");
    }

    public static DynamicObject saveJob(HandSaveJobVO handSaveJobVo, CdaAgentVO cdaAgent) {
        String procCode = handSaveJobVo.getProc_code();
        String proVer = handSaveJobVo.getProc_ver();
        Date startTime = DateUtils.parseDate(handSaveJobVo.getStart_time());
        Date now = new Date();
        QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        QFilter[] filters = new QFilter[]{procCodeFilter};
        String feild = YsqProcessConstant.selAllFileds();
        DynamicObject proc = null;
        try {
            proc = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process", (String)feild, (QFilter[])filters);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            proc = null;
        }
        if (proc == null) {
            log.info("process is not exist.");
            return null;
        }
        QFilter[] procVerfilterArr = new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)procCode), new QFilter("ysq_proc_ver", "=", (Object)proVer)};
        DynamicObject procVer = null;
        try {
            procVer = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])procVerfilterArr);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            procVer = null;
        }
        if (procVer == null) {
            log.info("processver is not exist.");
            return null;
        }
        DynamicObject job = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_job");
        String procType = proc.getString("ysq_proc_type");
        if (StringUtils.equals((CharSequence)procType, (CharSequence)"standard")) {
            job.set("ysq_com_job_type", (Object)"standard");
        }
        job.set("ysq_exec_robots_no_tag", (Object)cdaAgent.getAgentNo());
        job.set("ysq_exec_robots_names_tag", (Object)cdaAgent.getAgentName());
        job.set("ysq_exec_robots_alias", (Object)cdaAgent.getAgentAlias());
        job.set("ysq_curr_robot_no", (Object)cdaAgent.getExtendAgentNo());
        job.set("ysq_curr_robot_name", (Object)cdaAgent.getAgentAlias());
        job.set("ysq_job_no", (Object)handSaveJobVo.getJob_no());
        job.set("ysq_job_order", (Object)System.currentTimeMillis());
        job.set("ysq_proc_code", (Object)procCode);
        job.set("ysq_proc_file", procVer.get("ysq_proc_file"));
        job.set("ysq_work_status", procVer.get("ysq_work_status"));
        job.set("ysq_fail_try_times", (Object)10);
        job.set("ysq_proc_name", proc.get("ysq_proc_name"));
        job.set("ysq_proc_ver", (Object)proVer);
        job.set("ysq_publish_time", proc.get("ysq_publish_time"));
        job.set("org", (Object)RequestContext.get().getOrgId());
        job.set("ysq_job_time", (Object)now);
        job.set("ysq_produce_type", (Object)"manual_run");
        job.set("ysq_studio_ver", proc.get("ysq_studio_ver"));
        if (ObjectUtils.isEmpty((Object)startTime)) {
            job.set("ysq_robot_start_time", (Object)now);
            job.set("ysq_start_time", (Object)now);
        } else {
            job.set("ysq_robot_start_time", (Object)startTime);
            job.set("ysq_start_time", (Object)startTime);
        }
        job.set("ysq_status", (Object)RpaJobStatusEnums.RUNNING.getCode());
        job.set("ysq_pending_timeout", proc.get("ysq_pending_timeout"));
        job.set("ysq_running_timeout", proc.get("ysq_running_timeout"));
        job.set("ysq_proc_hand_do_min", (Object)0);
        job.set("ysq_auto_stop_time", proc.get("ysq_auto_stop_time"));
        job.set("ysq_fail_try_times", (Object)0);
        job.set("ysq_run_times", (Object)1);
        job.set("ysq_priority", (Object)0);
        job.set("ysq_proc_ver_desc", proc.get("ysq_proc_desc"));
        if (StringUtils.equals((CharSequence)"robot", (CharSequence)cdaAgent.getAgentType()) || StringUtils.equals((CharSequence)"standardRobot", (CharSequence)cdaAgent.getAgentType())) {
            DynamicObject agentDb = null;
            try {
                agentDb = BusinessDataServiceHelper.loadSingle((Object)cdaAgent.getFid(), (String)"ysq_rpa_agent");
            }
            catch (Exception e) {
                log.debug(e.getMessage());
                agentDb = null;
            }
            if (agentDb != null) {
                DynamicObject modify = (DynamicObject)agentDb.get("modifier");
                String masterid = modify.getString("masterid");
                job.set("ysq_job_type", (Object)masterid);
            }
        } else {
            job.set("ysq_job_type", (Object)cdaAgent.getAgentNo());
        }
        job.set("ysq_schedule_time", (Object)now);
        job.set("ysq_studio_ver", proc.get("ysq_studio_ver"));
        job.set("ysq_proc_fid", proc.get("id"));
        job.set("ysq_sch_type", (Object)"unManager");
        Long fid = ID.genLongId();
        job.set("id", (Object)fid);
        String param = procVer.getString("ysq_param_tag");
        job.set("ysq_parameter_tag", (Object)IsearchFileUtils.base64ToParams(param));
        return job;
    }
}

