/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.servicehelper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.cache.RobotCache;
import ysq.rpac.rpamc.common.constant.YsqAgentConstant;
import ysq.rpac.rpamc.common.enums.HkWinStatusEnums;
import ysq.rpac.rpamc.common.enums.RoborDataStatusEnums;
import ysq.rpac.rpamc.common.enums.RobotTypeEnums;
import ysq.rpac.rpamc.common.message.JobQueueProducer;
import ysq.rpac.rpamc.common.message.RobotPendingJobProducer;
import ysq.rpac.rpamc.common.message.model.JobQueueBean;
import ysq.rpac.rpamc.common.model.BaseVO;
import ysq.rpac.rpamc.common.model.CdaAgentVO;
import ysq.rpac.rpamc.common.model.RpaJobVO;
import ysq.rpac.rpamc.common.model.rpai.BaseRapiResultVO;
import ysq.rpac.rpamc.common.model.rpai.PendingRapiResultVO;
import ysq.rpac.rpamc.common.model.rpai.RunningRapiResultVO;
import ysq.rpac.rpamc.common.status.agent.AgentChangeOffer;
import ysq.rpac.rpamc.common.status.job.core.JobStatusCacheOffer;
import ysq.rpac.rpamc.common.status.stop.core.JobStopOffer;
import ysq.rpac.rpamc.common.utils.DateUtils;
import ysq.rpac.rpamc.common.utils.PermOrgsUtils;
import ysq.rpac.rpamc.common.utils.UserUtils;

public class AgentServiceHelper {
    private static Log log = LogFactory.getLog(AgentServiceHelper.class);
    private static AgentChangeOffer agentChangeOffer = AgentChangeOffer.getInstance();
    private static RobotCache robotCache = RobotCache.getInstance();
    public static final int EXPIRE_ONE_DAY = 86400;

    public static boolean checkRobotStatus(Long orgId) {
        List<Long> childOrg = null;
        if (orgId != null && orgId != 0L) {
            childOrg = UserUtils.getChildOrg(orgId);
        }
        String[] agentType = new String[]{RobotTypeEnums.STANDARD_ROBOT.getCode(), RobotTypeEnums.ROBOT.getCode()};
        QFilter typeFilter = new QFilter("ysq_agent_type", "in", (Object)agentType);
        QFilter statusFilter = new QFilter("ysq_data_status", "=", (Object)RoborDataStatusEnums.FREE.getCode());
        QFilter orgFilter = new QFilter("org", "in", childOrg);
        return QueryServiceHelper.exists((String)"ysq_rpa_agent", (QFilter[])new QFilter[]{typeFilter, statusFilter, orgFilter});
    }

    public static Map<String, Object> saveAgent(DynamicObject agent, Map<String, Object> userVo, Map<String, Object> rpaRobotVo) throws Exception {
        String autoLogin;
        String agentIp = ObjectUtils.isNotEmpty((Object)rpaRobotVo.get("agentIp")) ? rpaRobotVo.get("agentIp").toString() : "";
        String agentAlias = ObjectUtils.isNotEmpty((Object)rpaRobotVo.get("agentAlias")) ? rpaRobotVo.get("agentAlias").toString() : "";
        String winStatus = agent.get("ysq_win_status") == null ? HkWinStatusEnums.UNBIND.getCode() : agent.get("ysq_win_status").toString();
        String underManagerment = agent.get("ysq_under_managerment") == null ? "no" : agent.get("ysq_under_managerment").toString();
        String string = autoLogin = agent.get("ysq_auto_login") == null ? "no" : agent.get("ysq_auto_login").toString();
        if (agentIp.length() > 512) {
            agentIp = agentIp.substring(0, 500) + "...";
            rpaRobotVo.put("agentIp", agentIp);
        }
        if (StringUtils.isEmpty((CharSequence)agentAlias)) {
            agentAlias = ObjectUtils.isNotEmpty((Object)agent.get("ysq_agent_alias")) ? agent.get("ysq_agent_alias").toString() : "";
            rpaRobotVo.put("agentAlias", agentAlias);
        }
        boolean isManager = false;
        ArrayList<String> mapKeys = new ArrayList<String>();
        ArrayList<String> fields = new ArrayList<String>();
        agent.set("ysq_user_name", rpaRobotVo.get("agentUser"));
        if (agent.get("ysq_agent_type") != null && ("assistant".equals(agent.getString("ysq_agent_type")) || "studio".equals(agent.getString("ysq_agent_type")))) {
            agent.set("ysq_is_manager", (Object)"no");
            mapKeys.add("agentDcode");
            mapKeys.add("agentAlias");
            mapKeys.add("agentDomain");
            mapKeys.add("agentIp");
            mapKeys.add("agentName");
            mapKeys.add("agentOs");
            mapKeys.add("agentVersion");
            mapKeys.add("agentUncode");
            mapKeys.add("agentUser");
            fields.add("ysq_agent_dcode");
            fields.add("ysq_agent_alias");
            fields.add("ysq_user_domain");
            fields.add("ysq_agent_ip");
            fields.add("ysq_agent_name");
            fields.add("ysq_agent_os");
            fields.add("ysq_agent_version");
            fields.add("ysq_agent_uncode");
            fields.add("ysq_user_name");
        }
        if ("robot".equals(agent.getString("ysq_agent_type")) || "standardRobot".equals(agent.getString("ysq_agent_type"))) {
            isManager = true;
            agent.set("ysq_is_manager", (Object)"yes");
            mapKeys.add("agentAlias");
            mapKeys.add("agentDcode");
            mapKeys.add("agentDomain");
            mapKeys.add("agentIp");
            mapKeys.add("agentName");
            mapKeys.add("agentOs");
            mapKeys.add("agentUncode");
            mapKeys.add("agentVersion");
            mapKeys.add("id");
            mapKeys.add("agentUser");
            fields.add("ysq_agent_alias");
            fields.add("ysq_agent_dcode");
            fields.add("ysq_user_domain");
            fields.add("ysq_agent_ip");
            fields.add("ysq_agent_name");
            fields.add("ysq_agent_os");
            fields.add("ysq_agent_uncode");
            fields.add("ysq_agent_version");
            fields.add("id");
            fields.add("ysq_user_name");
        }
        if ("studio".equals((agent = BaseVO.mapTODynamicObject(agent, rpaRobotVo, fields, mapKeys)).get("ysq_agent_type"))) {
            agent.set("ysq_data_status", (Object)"-");
        } else {
            agent.set("ysq_data_status", (Object)RoborDataStatusEnums.FREE.getCode());
        }
        agent.set("ysq_last_login_time", (Object)new Date());
        if (!"studio".equals(agent.get("ysq_agent_type"))) {
            agent.set("ysq_last_login_time", (Object)new Date());
        }
        agent.set("ysq_win_status", (Object)winStatus);
        agent.set("ysq_under_managerment", (Object)underManagerment);
        agent.set("ysq_auto_login", (Object)autoLogin);
        if (("robot".equals(agent.get("ysq_agent_type")) || "standardRobot".equals(agent.get("ysq_agent_type"))) && ObjectUtils.isEmpty((Object)agent.get("ysq_comm_token"))) {
            agent.set("ysq_comm_token", (Object)UUID.randomUUID());
        }
        if ("assistant".equals(agent.get("ysq_agent_type"))) {
            if (ObjectUtils.isNotEmpty((Object)agent.get("ysq_comm_token"))) {
                robotCache.remove(agent.get("ysq_comm_token").toString());
            }
            agent.set("ysq_comm_token", (Object)UUID.randomUUID());
        }
        Long orgIdDb = BaseVO.getOrgId(agent);
        Long orgFid = null;
        Long userId = MapUtils.getLong(userVo, (Object)"id");
        orgIdDb = orgFid = PermOrgsUtils.agentNewOrgId(userId, orgIdDb);
        CdaAgentVO agentToCache = null;
        if (!"studio".equals(agent.get("ysq_agent_type"))) {
            agentToCache = new CdaAgentVO().fromDynamicObject(agent);
            if (null != orgFid) {
                agentToCache.setOrgFid(orgFid);
            }
        }
        if (null != orgFid) {
            agent.set("org", (Object)orgFid);
        }
        if (null == agent.get("id") || "0".equals(agent.get("id").toString())) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{agent});
        } else {
            SaveServiceHelper.update((DynamicObject)agent);
        }
        if (!"studio".equals(agent.get("ysq_agent_type")) && null != agentToCache) {
            agentToCache.setFid(agent.getLong("id"));
            robotCache.put(agent.get("ysq_comm_token").toString(), agentToCache);
        }
        String agentRoleName = "";
        HashMap<String, Object> rpaRobot = new HashMap<String, Object>();
        rpaRobot.put("agentRoleName", agentRoleName);
        rpaRobot.put("isManager", isManager);
        rpaRobot.put("agentAlias", agentAlias);
        rpaRobot.put("orgId", orgIdDb);
        rpaRobot.put("orgCode", "");
        rpaRobot.put("orgName", "");
        rpaRobot.put("licTypeDesc", "");
        rpaRobot.put("licType", "");
        rpaRobot.put("applyTime", "");
        rpaRobot.put("applyUser", "");
        rpaRobot.put("custAgentName", "");
        rpaRobot.put("custName", "");
        rpaRobot.put("deviceCode", "");
        rpaRobot.put("procudtModel", "");
        rpaRobot.put("trialEndDate", "");
        rpaRobot.put("commtoken", agent.get("ysq_comm_token").toString());
        return rpaRobot;
    }

    public static CdaAgentVO checkCommonToken(String commonToken) {
        CdaAgentVO agentVo = null;
        try {
            agentVo = robotCache.get(commonToken);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            agentVo = null;
        }
        if (null == agentVo || null == agentVo.getFid() || 0L == agentVo.getFid()) {
            QFilter[] filters = new QFilter[]{new QFilter("ysq_comm_token", "=", (Object)commonToken)};
            DynamicObject agentDb = null;
            try {
                agentDb = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_agent", (String)YsqAgentConstant.selAllFileds(), (QFilter[])filters);
            }
            catch (Exception e) {
                log.debug(e.getMessage());
                agentDb = null;
            }
            if (null != agentDb) {
                agentVo = new CdaAgentVO().fromDynamicObject(agentDb);
                robotCache.put(commonToken, agentVo);
            }
        }
        if (null != agentVo) {
            return agentVo;
        }
        return null;
    }

    public static BaseRapiResultVO robotsHeartNew(CdaAgentVO agentVo, String dataStatus, String jobNo) {
        Date lastHeartTime = agentVo.getLastHeartTime();
        Date now = new Date();
        boolean isHeartbeatUpdate = false;
        boolean isStatusUpdate = false;
        if (ObjectUtils.isEmpty((Object)agentVo.getLastHeartTime()) || ObjectUtils.isNotEmpty((Object)agentVo.getLastHeartTime()) && DateUtils.getIntervals(now, lastHeartTime) >= 120L) {
            isHeartbeatUpdate = true;
        }
        if (!dataStatus.equalsIgnoreCase(agentVo.getDataStatus())) {
            isStatusUpdate = true;
        }
        agentVo.setDataStatus(dataStatus);
        if (isHeartbeatUpdate || isStatusUpdate) {
            agentVo.setLastHeartTime(now);
            robotCache.put(agentVo.getCommToken(), agentVo);
            agentChangeOffer.addDatas(agentVo.getFid(), agentVo.getLastHeartTime(), agentVo.getDataStatus());
        }
        return AgentServiceHelper.getRobotNextJobNew(jobNo, agentVo, now);
    }

    private static BaseRapiResultVO getRobotNextJobNew(String jobNo, CdaAgentVO agentVo, Date now) {
        BaseRapiResultVO parentHeartVo = new BaseRapiResultVO();
        if (RoborDataStatusEnums.FREE.getCode().equals(agentVo.getDataStatus())) {
            log.debug("free\u5fc3\u8df3doThingByStatusFree  start:" + System.currentTimeMillis());
            parentHeartVo = AgentServiceHelper.doThingByStatusFree(jobNo, agentVo, parentHeartVo, now);
            log.debug("free\u5fc3\u8df3doThingByStatusFree end:" + System.currentTimeMillis());
            String stopJobNo = null;
            if (!"nothing".equals(parentHeartVo.getAction())) {
                PendingRapiResultVO heartVo = (PendingRapiResultVO)parentHeartVo;
                stopJobNo = heartVo.getJob_no();
                JobStopOffer.getInstance().addDatas(agentVo.getExtendAgentNo(), stopJobNo);
            }
        } else if (RoborDataStatusEnums.RUNNING.getCode().equals(agentVo.getDataStatus())) {
            log.debug("busy\u5fc3\u8df3doThingByStatusBusy  start:" + System.currentTimeMillis());
            parentHeartVo = AgentServiceHelper.doThingByStatusBusy(jobNo, agentVo, parentHeartVo);
            log.debug("busy\u5fc3\u8df3doThingByStatusBusy  end:" + System.currentTimeMillis());
        } else {
            parentHeartVo.setAction("nothing");
        }
        return parentHeartVo;
    }

    private static BaseRapiResultVO doThingByStatusFree(String jobNo, CdaAgentVO agentVo, BaseRapiResultVO parentHeartVo, Date now) {
        log.debug("\u83b7\u53d6\u5f85\u673a\u5668\u4eba\u8fd0\u884c\u4efb\u52a1popLikeJob  start:" + System.currentTimeMillis());
        JobQueueBean robotPendingJob = RobotPendingJobProducer.getInstance().popLikeJob(agentVo.getExtendAgentNo(), jobNo, now);
        log.debug("\u83b7\u53d6\u5f85\u673a\u5668\u4eba\u8fd0\u884c\u4efb\u52a1popLikeJob  end:" + System.currentTimeMillis());
        if (null == robotPendingJob) {
            log.debug("\u83b7\u53d6\u5f85\u8fd0\u884c\u4efb\u52a1popJob  start:" + System.currentTimeMillis());
            JobQueueBean pendingJob = JobQueueProducer.getInstance().popJob(agentVo.getExtendAgentNo(), agentVo.getOrgFid(), "yes".equals(agentVo.getIsManager()), agentVo.getAgentType());
            log.debug("\u83b7\u53d6\u5f85\u8fd0\u884c\u4efb\u52a1popJob  end:" + System.currentTimeMillis());
            if (pendingJob == null) {
                parentHeartVo.setAction("nothing");
            } else {
                log.debug("\u628a\u5f85\u8fd0\u884c\u4efb\u52a1\u653e\u5165\u5f85\u673a\u5668\u4eba\u8fd0\u884c\u961f\u5217pushJob  start:" + System.currentTimeMillis());
                RobotPendingJobProducer.getInstance().pushJob(agentVo.getExtendAgentNo(), agentVo.getAgentAlias(), pendingJob.getJobNo(), pendingJob, now);
                log.debug("\u628a\u5f85\u8fd0\u884c\u4efb\u52a1\u653e\u5165\u5f85\u673a\u5668\u4eba\u8fd0\u884c\u961f\u5217pushJob  end:" + System.currentTimeMillis());
                log.debug("\u7ec4\u88c5\u8fd4\u56de\u6570\u636ebuildReturnData  start:" + System.currentTimeMillis());
                PendingRapiResultVO heartVo = AgentServiceHelper.buildReturnData(pendingJob, now);
                log.debug("\u7ec4\u88c5\u8fd4\u56de\u6570\u636ebuildReturnData  end:" + System.currentTimeMillis());
                parentHeartVo = heartVo;
            }
        } else if (robotPendingJob.getJobNo().equals(jobNo)) {
            JobStatusCacheOffer.getInstance().addDatas(robotPendingJob.getJobId(), robotPendingJob.getJobNo(), agentVo.getExtendAgentNo(), agentVo.getAgentAlias(), robotPendingJob.getJobTime(), robotPendingJob.getJobStartTime());
            JobStopOffer.getInstance().addDatas(agentVo.getExtendAgentNo(), robotPendingJob.getJobNo());
            log.debug("\u83b7\u53d6\u5f85\u8fd0\u884c\u4efb\u52a1popJob  start:" + System.currentTimeMillis());
            JobQueueBean pendingJob = JobQueueProducer.getInstance().popJob(agentVo.getExtendAgentNo(), agentVo.getOrgFid(), "yes".equals(agentVo.getIsManager()), agentVo.getAgentType());
            log.debug("\u83b7\u53d6\u5f85\u8fd0\u884c\u4efb\u52a1popJob  end:" + System.currentTimeMillis());
            if (pendingJob == null) {
                parentHeartVo.setAction("nothing");
            } else {
                RobotPendingJobProducer.getInstance().pushJob(agentVo.getExtendAgentNo(), agentVo.getAgentAlias(), pendingJob.getJobNo(), pendingJob, now);
                PendingRapiResultVO heartVo = AgentServiceHelper.buildReturnData(pendingJob, now);
                parentHeartVo = heartVo;
            }
        } else {
            PendingRapiResultVO heartVo = AgentServiceHelper.buildReturnData(robotPendingJob, now);
            parentHeartVo = heartVo;
            log.debug("\u7ec4\u88c5\u8fd4\u56de\u6570\u636ebuildReturnData  start:" + System.currentTimeMillis());
            RobotPendingJobProducer.getInstance().pushJob(agentVo.getExtendAgentNo(), agentVo.getAgentAlias(), robotPendingJob.getJobNo(), robotPendingJob, now);
            log.debug("\u7ec4\u88c5\u8fd4\u56de\u6570\u636ebuildReturnData  end:" + System.currentTimeMillis());
        }
        return parentHeartVo;
    }

    private static BaseRapiResultVO doThingByStatusBusy(String jobNo, CdaAgentVO agentVo, BaseRapiResultVO parentHeartVo) {
        JobQueueBean robotPendingJob = RobotPendingJobProducer.getInstance().popJob(agentVo.getExtendAgentNo(), jobNo);
        if (robotPendingJob != null) {
            JobStatusCacheOffer.getInstance().addDatas(robotPendingJob.getJobId(), robotPendingJob.getJobNo(), agentVo.getExtendAgentNo(), agentVo.getAgentAlias(), robotPendingJob.getJobTime(), robotPendingJob.getJobStartTime());
            JobStopOffer.getInstance().addDatas(agentVo.getExtendAgentNo(), robotPendingJob.getJobNo());
        }
        log.debug("\u65e0\u5f85\u673a\u5668\u4eba\u8fd0\u884c\u4efb\u52a1\u83b7\u53d6\u5f85\u505c\u6b62\u4efb\u52a1returnJobStopping  start:" + System.currentTimeMillis());
        RpaJobVO job = JobQueueProducer.getInstance().returnJobStopping(jobNo);
        log.debug("\u65e0\u5f85\u673a\u5668\u4eba\u8fd0\u884c\u4efb\u52a1\u83b7\u53d6\u5f85\u505c\u6b62\u4efb\u52a1returnJobStopping  end:" + System.currentTimeMillis());
        if (job != null) {
            RunningRapiResultVO heartVo = new RunningRapiResultVO();
            heartVo.setAction("proc_stop");
            heartVo.setJob_id("" + job.getFid());
            heartVo.setJob_no(job.getJobNo());
            heartVo.setProc_code(job.getProcCode());
            heartVo.setProc_name(job.getProcName());
            heartVo.setProc_ver(job.getProcVer());
            heartVo.setProc_path(job.getProcFile());
            heartVo.setFile_size(0L);
            parentHeartVo = heartVo;
        } else {
            parentHeartVo.setAction("nothing");
        }
        return parentHeartVo;
    }

    private static PendingRapiResultVO buildReturnData(JobQueueBean pendingJob, Date nowStamp) {
        String nowStr = DateUtils.formatDate(nowStamp);
        Date startTime = nowStamp;
        PendingRapiResultVO heartVo = new PendingRapiResultVO();
        heartVo.setAction("proc_run");
        heartVo.setJob_id("" + pendingJob.getJobId());
        heartVo.setJob_no(pendingJob.getJobNo());
        heartVo.setProc_code(pendingJob.getProcCode());
        heartVo.setProc_name(pendingJob.getProcName());
        heartVo.setProc_ver(pendingJob.getProcVer());
        heartVo.setProc_path(pendingJob.getProcFile());
        heartVo.setProc_plan_time(DateUtils.formatDate(pendingJob.getScheduleTime()));
        heartVo.setProc_start_time(nowStr);
        heartVo.setParameter(pendingJob.getParameter());
        long pendingTime = 0L;
        Date planTime = pendingJob.getScheduleTime();
        if (planTime != null) {
            pendingTime = startTime.getTime() - planTime.getTime();
            pendingTime /= 1000L;
        }
        heartVo.setProc_pending_time(pendingTime);
        heartVo.setProc_hand_duration_min(pendingJob.getProcHandDoMin());
        heartVo.setProChange(pendingJob.getProChange());
        List attachmentpanel = AttachmentServiceHelper.getAttachments((String)"ysq_rpa_process_ver", (Object)pendingJob.getProcFid(), (String)"attachmentpanel");
        if (attachmentpanel.size() > 0) {
            log.info("\u65b0\u7684\u8c03\u5ea6\u751f\u6210\u7684\u4efb\u52a1\u662f\u83b7\u53d6\u6d41\u7a0b\u4e0a\u7684\u5305\u5f00\u59cb");
            String url = ((Map)attachmentpanel.get(0)).get("url").toString();
            heartVo.setFileUrl(url);
            log.info("\u65b0\u7684\u8c03\u5ea6\u751f\u6210\u7684\u4efb\u52a1\u662f\u83b7\u53d6\u6d41\u7a0b\u4e0a\u7684\u5305\u6210\u529f");
        } else {
            log.info("\u8001\u7684\u8c03\u5ea6\u751f\u6210\u7684\u4efb\u52a1\u662f\u83b7\u53d6\u6d41\u7a0b\u4e0a\u7684\u5305\u5f00\u59cb");
            attachmentpanel = AttachmentServiceHelper.getAttachments((String)"ysq_rpa_process", (Object)pendingJob.getProcFid(), (String)"attachmentpanel");
            if (attachmentpanel.size() > 0) {
                String url = ((Map)attachmentpanel.get(0)).get("url").toString();
                heartVo.setFileUrl(url);
                log.info("\u8001\u7684\u8c03\u5ea6\u751f\u6210\u7684\u4efb\u52a1\u662f\u83b7\u53d6\u6d41\u7a0b\u4e0a\u7684\u5305\u6210\u529f");
            }
        }
        heartVo.setFile_size(0L);
        if (null != pendingJob.getPublishTime()) {
            heartVo.setPublish(DateUtils.formatDate(pendingJob.getPublishTime()));
        }
        return heartVo;
    }
}

