/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.servicehelper;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqProcessConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.constant.YsqScheduleConstant;
import ysq.rpac.rpamc.common.constant.YsqSysConfigConstant;
import ysq.rpac.rpamc.common.utils.IsearchFileUtils;
import ysq.rpac.rpamc.common.utils.PermOrgsUtils;
import ysq.rpac.rpamc.common.utils.UserUtils;
import ysq.rpac.rpamc.common.utils.VersionUtil;

public class ProcessServiceHelper {
    private static Log log = LogFactory.getLog(ProcessServiceHelper.class);
    public static final int COUNT = 100000;
    public static final String START = "start";
    public static final String STOP = "stop";

    @Deprecated
    public static void saveProcess(Map<String, Object> map, long procId, String fileName, String urlStr) {
        if (map != null) {
            String procCode = map.get("proCode").toString();
            Long userId = RequestContext.get().getCurrUserId();
            QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
            QFilter userIdFilter = new QFilter("creator", "!=", (Object)userId);
            QFilter[] filters = new QFilter[]{procCodeFilter, userIdFilter};
            DynamicObject proc = null;
            try {
                proc = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process", (String)"id", (QFilter[])filters);
            }
            catch (Exception e) {
                log.debug(e.getMessage());
                proc = null;
            }
            if (proc != null) {
                throw new KDException("\u6d41\u7a0b\u5df2\u5b58\u5728\u3002\u8bf7\u5220\u9664\u540c\u540d\u6d41\u7a0b\u6216\u4fee\u6539\u6d41\u7a0b\u5305\u540d\u79f0\u540e\u518d\u4e0a\u4f20\u3002");
            }
            QFilter[] procFilter = new QFilter[]{procCodeFilter};
            boolean exists = QueryServiceHelper.exists((String)"ysq_rpa_process", (QFilter[])procFilter);
            if (exists) {
                QFilter qFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
                DeleteServiceHelper.delete((String)"ysq_rpa_process", (QFilter[])new QFilter[]{qFilter});
                DeleteServiceHelper.delete((String)"ysq_rpa_process_ver", (QFilter[])new QFilter[]{qFilter});
            }
            ProcessServiceHelper.saveProcessDb(map, procId, fileName, urlStr);
            if (exists) {
                String procVer = map.get("proVersion").toString();
                Object inputs = map.get("Inputs");
                String param = null;
                if (ObjectUtils.isNotEmpty((Object)inputs)) {
                    param = inputs.toString();
                }
                ProcessServiceHelper.uploadSchdule(procCode, procId, procVer, param);
            }
        } else {
            throw new KDException("\u6d41\u7a0b\u7f16\u53f7\u751f\u6210\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    private static String getBillNo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        String format = sdf.format(new Date());
        int i = (int)(Math.random() * 90000.0 + 10000.0);
        String billNo = "RPAprocess_" + format + "_" + i;
        return billNo;
    }

    private static void saveProcessDb(Map<String, Object> map, long procId, String fileName, String urlStr) {
        QFilter qFilter;
        QFilter processCodeFilter = new QFilter("ysq_proc_code", "=", (Object)map.get("proCode").toString());
        QFilter[] processCodeFilters = new QFilter[]{processCodeFilter};
        DynamicObject process = null;
        try {
            process = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])processCodeFilters);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            process = null;
        }
        if (null == process) {
            QFilter[] qFilters;
            boolean exists;
            process = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_process");
            process.set("id", (Object)procId);
            String billNo = "";
            int i = 0;
            while (exists = QueryServiceHelper.exists((String)"ysq_rpa_process", (QFilter[])(qFilters = new QFilter[]{qFilter = new QFilter("billno", "=", (Object)(billNo = ProcessServiceHelper.getBillNo()))}))) {
                if (++i <= 100000) continue;
                throw new KDException("\u6d41\u7a0b\u7f16\u53f7\u751f\u6210\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            process.set("billno", (Object)billNo);
            process.set("billstatus", (Object)"A");
        }
        if (map != null) {
            String params = (String)map.get("Inputs");
            process.set("ysq_proc_code", map.get("proCode"));
            process.set("ysq_proc_desc", map.get("proDesc"));
            process.set("ysq_proc_name", map.get("proName"));
            process.set("ysq_proc_file", (Object)urlStr);
            process.set("ysq_proc_ver", map.get("proVersion"));
            process.set("ysq_pro_change", map.get("proChange"));
            process.set("ysq_studio_ver", map.get("proStudio"));
            if (StringUtils.isNotBlank((CharSequence)params) && !StringUtils.equals((CharSequence)params, (CharSequence)"[]")) {
                process.set("ysq_param_tag", map.get("Inputs"));
            }
        }
        process.set("ysq_status_ctime", (Object)new Date());
        process.set("ysq_publish_time", (Object)new Date());
        process.set("ysq_work_status", (Object)"release");
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            process.set("ysq_proc_file", (Object)("/doc/ipkg/" + fileName));
        }
        Long userId = RequestContext.get().getCurrUserId();
        process.set("creator", (Object)userId);
        Long orgId = PermOrgsUtils.processNewOrgId(userId, null);
        process.set("org", (Object)orgId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{process});
        qFilter = new QFilter("ysq_proc_fid", "=", (Object)procId);
        DynamicObject procVerObj = QueryServiceHelper.queryOne((String)"ysq_rpa_process_ver", (String)"id", (QFilter[])new QFilter[]{qFilter});
        DynamicObject procVerObject = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_process_ver");
        procVerObject.set("ysq_proc_fid", (Object)procId);
        procVerObject.set("ysq_proc_name", process.get("ysq_proc_name"));
        procVerObject.set("ysq_proc_code", process.get("ysq_proc_code"));
        procVerObject.set("ysq_proc_file", process.get("ysq_proc_file"));
        procVerObject.set("ysq_proc_ver", process.get("ysq_proc_ver"));
        procVerObject.set("ysq_is_activity", (Object)"yes");
        procVerObject.set("ysq_proc_desc", process.get("ysq_proc_desc"));
        procVerObject.set("ysq_work_status", process.get("ysq_work_status"));
        procVerObject.set("ysq_pro_change", process.get("ysq_pro_change"));
        procVerObject.set("ysq_studio_ver", process.get("ysq_studio_ver"));
        procVerObject.set("ysq_param_tag", process.get("ysq_param_tag"));
        procVerObject.set("creator", (Object)userId);
        procVerObject.set("org", (Object)orgId);
        if (procVerObj != null) {
            procVerObject.set("id", procVerObj.get("id"));
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{procVerObject});
        } else {
            procVerObject.set("ysq_publish_time", (Object)new Date());
            procVerObject.set("ysq_status_ctime", (Object)new Date());
            SaveServiceHelper.save((IDataEntityType)procVerObject.getDataEntityType(), (Object[])new DynamicObject[]{procVerObject});
        }
    }

    private static Long getStudioOrgByUserId(Long userId) {
        if (userId == null || new Long(0L).equals(userId)) {
            return null;
        }
        QFilter userIdFilter = new QFilter("creator", "=", (Object)userId);
        QFilter typeFilter = new QFilter("ysq_agent_type", "=", (Object)"studio");
        DynamicObject studioInfo = QueryServiceHelper.queryOne((String)"ysq_rpa_agent", (String)"org", (QFilter[])new QFilter[]{userIdFilter, typeFilter});
        return studioInfo.getLong("org");
    }

    private static void uploadSchdule(String procCode, Long procId, String procVer, String param) {
        QFilter qFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        QFilter versionFilter = new QFilter("ysq_proc_ver", "=", (Object)procVer);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"ysq_process_schedule", (String)YsqScheduleConstant.selAllFileds(), (QFilter[])new QFilter[]{qFilter, versionFilter});
        if (load != null && load.length > 0) {
            String paramBase64 = param;
            if (StringUtils.isNotBlank((CharSequence)param)) {
                paramBase64 = IsearchFileUtils.paramsBase64(param);
            }
            for (DynamicObject sch : load) {
                sch.set("ysq_proc_fid", (Object)procId);
                sch.set("ysq_proc_ver", (Object)procVer);
                sch.set("ysq_sch_param_tag", (Object)paramBase64);
            }
            SaveServiceHelper.update((DynamicObject[])load);
        }
    }

    public static boolean checkProcName(String proCode, String procName) {
        QFilter proCodeFilter = new QFilter("ysq_proc_code", "!=", (Object)proCode);
        QFilter procNameFilter = new QFilter("ysq_proc_name", "=", (Object)procName);
        return QueryServiceHelper.exists((String)"ysq_rpa_process", (QFilter[])new QFilter[]{proCodeFilter, procNameFilter});
    }

    public static void checkProcExistAndStartSchedule(String action) {
        boolean hasProcess = QueryServiceHelper.exists((String)"ysq_rpa_process_ver", (QFilter[])new QFilter[0]);
        QFilter statusFilter = new QFilter("ysq_key", "=", (Object)"ysq_schedule_status");
        DynamicObject config = BusinessDataServiceHelper.loadSingle((String)"ysq_sys_config", (String)YsqSysConfigConstant.selAllFileds(), (QFilter[])new QFilter[]{statusFilter});
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        String ids = "2C937W6YZ3FK,2CB1DLEWOV4Y,2CH=A8HPM0EL,2CH=0+XSWGMA,2CH=2AEL4D1J,2CH=54Y29VVF,2CH=7U=BNA2P,2CH=D=EOINX4,2CH=LAJSDTA2,2CH=PJR02+69,2CH=RQD6XNUM,2CH=NECZNU9G,2F2MTRF9T1X5";
        String jobIds = "2C934740Q4CN,2BM156WKZNOB,2CH9/0U0/QGW,2CH7W4VJI1U2,2CH8NPDUDPVF,2CH8ROABW50S,2CH8VMDB88G3,2CH91UHGW96U,2CH941IMRCXL,2CH9=LYPT81X,2CH9D4XNAO84,2CH9MRCXBCA6,2F2MKTF60GWT";
        String[] idList = ids.split(",");
        String[] jobIdList = jobIds.split(",");
        if (START.equals(action)) {
            if (hasProcess && !config.getBoolean("ysq_value")) {
                for (String id : idList) {
                    scheduleManager.enableSchedule(id);
                }
                for (String id : jobIdList) {
                    scheduleManager.enableJob(id);
                }
                config.set("ysq_value", (Object)"true");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
            }
        } else if (STOP.equals(action) && !hasProcess && config.getBoolean("ysq_value")) {
            for (String id : idList) {
                scheduleManager.disableSchedule(id);
            }
            for (String id : jobIdList) {
                scheduleManager.disableJob(id);
            }
            config.set("ysq_value", (Object)"false");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
        }
    }

    public static void saveProcessMultiVersion(Map<String, Object> map, long procVerId, String fileName, String urlStr) {
        if (map != null) {
            String procCode = map.get("proCode").toString();
            String version = map.get("proVersion").toString();
            Long userId = RequestContext.get().getCurrUserId();
            QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
            QFilter versionFilter = new QFilter("ysq_proc_ver", "=", (Object)version);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{versionFilter, procCodeFilter});
            if (query.size() > 0) {
                QFilter qFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
                AttachmentServiceHelper.remove((String)"ysq_rpa_process_ver", (Object)((DynamicObject)query.get(0)).getLong("id"));
                DeleteServiceHelper.delete((String)"ysq_rpa_process_ver", (QFilter[])new QFilter[]{qFilter, versionFilter});
            }
            ProcessServiceHelper.saveProcessMultiVersionDB(map, procVerId, fileName, urlStr);
            if (query.size() > 0) {
                String procVer = map.get("proVersion").toString();
                Object inputs = map.get("Inputs");
                String param = null;
                if (ObjectUtils.isNotEmpty((Object)inputs)) {
                    param = inputs.toString();
                }
                ProcessServiceHelper.uploadSchdule(procCode, procVerId, procVer, param);
            }
        } else {
            throw new KDException("\u6d41\u7a0b\u7f16\u53f7\u751f\u6210\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    private static void saveProcessMultiVersionDB(Map<String, Object> map, long procVerId, String fileName, String urlStr) {
        String procCode = map.get("proCode").toString();
        QFilter proCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        Boolean exist = QueryServiceHelper.exists((String)"ysq_rpa_process", (QFilter[])new QFilter[]{proCodeFilter});
        if (!exist.booleanValue()) {
            Long processId = ProcessServiceHelper.createProcess(map, fileName, urlStr);
            ProcessServiceHelper.createProcessVersion(procCode, procVerId, processId, map, urlStr);
        } else {
            ProcessServiceHelper.createProcessVersion(procCode, procVerId, null, map, urlStr);
            String procVersion = map.get("proVersion").toString();
            ProcessServiceHelper.updateLatestProcess(procCode, procVersion);
        }
    }

    private static Long createProcess(Map<String, Object> map, String fileName, String urlStr) {
        QFilter qFilter;
        QFilter[] qFilters;
        boolean exists;
        DynamicObject emptyObject = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_process");
        String billNo = "";
        int i = 0;
        while (exists = QueryServiceHelper.exists((String)"ysq_rpa_process", (QFilter[])(qFilters = new QFilter[]{qFilter = new QFilter("billno", "=", (Object)(billNo = ProcessServiceHelper.getBillNo()))}))) {
            if (++i <= 100000) continue;
            throw new KDException("\u6d41\u7a0b\u7f16\u53f7\u751f\u6210\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
        emptyObject.set("billno", (Object)billNo);
        if (map != null) {
            String params = (String)map.get("Inputs");
            emptyObject.set("ysq_proc_code", map.get("proCode"));
            emptyObject.set("ysq_proc_desc", map.get("proDesc"));
            emptyObject.set("ysq_proc_name", map.get("proName"));
            emptyObject.set("ysq_proc_file", (Object)urlStr);
            emptyObject.set("ysq_proc_ver", map.get("proVersion"));
            emptyObject.set("ysq_pro_change", map.get("proChange"));
            emptyObject.set("ysq_studio_ver", map.get("proStudio"));
            if (StringUtils.isNotBlank((CharSequence)params) && !StringUtils.equals((CharSequence)params, (CharSequence)"[]")) {
                emptyObject.set("ysq_param_tag", map.get("Inputs"));
            }
        }
        emptyObject.set("ysq_status_ctime", (Object)new Date());
        emptyObject.set("ysq_publish_time", (Object)new Date());
        emptyObject.set("ysq_work_status", (Object)"release");
        Long userId = RequestContext.get().getCurrUserId();
        emptyObject.set("creator", (Object)userId);
        emptyObject.set("billstatus", (Object)"A");
        emptyObject.set("org", (Object)PermOrgsUtils.processNewOrgId(userId, null));
        emptyObject.set("ysq_proc_type", (Object)"common");
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            emptyObject.set("ysq_proc_file", (Object)("/doc/ipkg/" + fileName));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{emptyObject});
        return emptyObject.getLong("id");
    }

    private static void createProcessVersion(String procCode, Long procVerId, Long processId, Map<String, Object> map, String urlStr) {
        DynamicObject process = ProcessServiceHelper.getProcessByCode(procCode);
        String proDesc = map.get("proDesc").toString();
        String proVer = map.get("proVersion").toString();
        String proName = map.get("proName").toString();
        String proCode = map.get("proCode").toString();
        String param = map.get("Inputs") == null ? "" : map.get("Inputs").toString();
        String proStudio = map.get("proStudio").toString();
        String proChange = map.get("proChange").toString();
        DynamicObject procVerObject = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_process_ver");
        procVerObject.set("id", (Object)procVerId);
        if (processId != null) {
            procVerObject.set("ysq_proc_fid", (Object)processId);
        } else {
            procVerObject.set("ysq_proc_fid", process.get("id"));
        }
        procVerObject.set("billno", process.get("billno"));
        procVerObject.set("ysq_proc_name", (Object)proName);
        procVerObject.set("ysq_proc_code", (Object)proCode);
        procVerObject.set("ysq_proc_file", (Object)("/doc/ipkg/" + urlStr));
        procVerObject.set("ysq_proc_ver", (Object)proVer);
        procVerObject.set("ysq_is_activity", (Object)"yes");
        procVerObject.set("ysq_proc_desc", (Object)proDesc);
        procVerObject.set("ysq_work_status", (Object)"release");
        procVerObject.set("ysq_pro_change", (Object)proChange);
        procVerObject.set("ysq_studio_ver", (Object)proStudio);
        procVerObject.set("billstatus", (Object)"A");
        if (StringUtils.isNotBlank((CharSequence)param) && !StringUtils.equals((CharSequence)param, (CharSequence)"[]")) {
            procVerObject.set("ysq_param_tag", map.get("Inputs"));
        }
        Long userId = RequestContext.get().getCurrUserId();
        procVerObject.set("creator", (Object)userId);
        procVerObject.set("org", (Object)PermOrgsUtils.processNewOrgId(userId, null));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{procVerObject});
    }

    private static DynamicObject getProcessByCode(String procCode) {
        QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObject process = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
        return process;
    }

    private static void updateLatestProcess(String procCode, String procVer) {
        String latestVersion = "0";
        QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
        if (query.size() == 0) {
            return;
        }
        for (DynamicObject dynamicObject : query) {
            if (VersionUtil.compare(dynamicObject.get("ysq_proc_ver").toString(), latestVersion) <= 0) continue;
            latestVersion = dynamicObject.get("ysq_proc_ver").toString();
        }
        QFilter versionFilter = new QFilter("ysq_proc_ver", "=", (Object)latestVersion);
        DynamicObject latestVerProcess = QueryServiceHelper.queryOne((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter, versionFilter});
        DynamicObject process = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
        if (VersionUtil.compare(latestVersion, process.getString("ysq_proc_ver")) > 0) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)process.getLong("id"), (String)"ysq_rpa_process");
            dynamicObject.set("ysq_proc_ver", latestVerProcess.get("ysq_proc_ver"));
            dynamicObject.set("ysq_proc_desc", latestVerProcess.get("ysq_proc_desc"));
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            return;
        }
        if (procVer.equals(process.getString("ysq_proc_ver"))) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)process.getLong("id"), (String)"ysq_rpa_process");
            dynamicObject.set("ysq_proc_ver", latestVerProcess.get("ysq_proc_ver"));
            dynamicObject.set("ysq_proc_desc", latestVerProcess.get("ysq_proc_desc"));
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            return;
        }
    }

    public static DynamicObjectCollection getProcByDptId(Long dptId) {
        List<Long> childOrg = UserUtils.getChildOrg(dptId);
        QFilter orgFilter = new QFilter("org", "in", childOrg);
        QFilter typeFilter = new QFilter("ysq_proc_type", "!=", (Object)"standard");
        return QueryServiceHelper.query((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])new QFilter[]{orgFilter, typeFilter});
    }
}

