/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.servicehelper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import ysq.rpac.rpamc.common.constant.YsqQueueItemsConstant;
import ysq.rpac.rpamc.common.constant.YsqQueuesConstant;
import ysq.rpac.rpamc.common.enums.ItemQueueStatusEnums;
import ysq.rpac.rpamc.common.enums.PriorityEnums;
import ysq.rpac.rpamc.common.enums.QueueItemStatusEnums;
import ysq.rpac.rpamc.common.enums.RedisLockKeysEnums;
import ysq.rpac.rpamc.common.enums.ResultStatusEnums;
import ysq.rpac.rpamc.common.enums.RobotRangeEnums;
import ysq.rpac.rpamc.common.model.CdaAgentVO;
import ysq.rpac.rpamc.common.model.ISearchCustomApiResultVO;
import ysq.rpac.rpamc.common.model.query.PageResult;
import ysq.rpac.rpamc.common.model.queueItems.AddQueueItemVO;
import ysq.rpac.rpamc.common.model.queueItems.DeleteQueueItemVO;
import ysq.rpac.rpamc.common.model.queueItems.QueueItemKeyVO;
import ysq.rpac.rpamc.common.model.queueItems.QueueItemQueryVO;
import ysq.rpac.rpamc.common.model.queueItems.QueueItemVO;
import ysq.rpac.rpamc.common.model.queueItems.UpdateQueueItemVO;
import ysq.rpac.rpamc.common.servicehelper.OrgServiceHelper;
import ysq.rpac.rpamc.common.utils.DateUtils;
import ysq.rpac.rpamc.common.utils.EsUtils;

@Service
public class QueueItemServiceHelper {
    private static Log log = LogFactory.getLog(QueueItemServiceHelper.class);

    public static ISearchCustomApiResultVO listQueueItem(QueueItemQueryVO query, CdaAgentVO agent) {
        QFilter createTimeFilter;
        ErrorCode errorCode;
        Long orgId = agent.getOrgFid();
        String agentNo = agent.getAgentNo();
        String agentType = agent.getAgentType();
        String agentAlias = agent.getAgentAlias();
        if (StringUtils.isNotBlank((CharSequence)query.getAgentNo())) {
            agentNo = query.getAgentNo();
        }
        DynamicObject queue = QueueItemServiceHelper.getQueueByQueueName(query.getQueueName(), orgId, agentNo);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (StringUtils.isNotBlank((CharSequence)query.getQueueName())) {
            QFilter queueNameFilter = new QFilter("ysq_queue_name", "=", (Object)query.getQueueName());
            qFilters.add(queueNameFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)query.getPriority())) {
            QFilter priorityFilter = new QFilter("ysq_priority", "=", (Object)PriorityEnums.getCode(query.getPriority()));
            qFilters.add(priorityFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)query.getStatus())) {
            QFilter statusFilter = new QFilter("ysq_status", "=", (Object)query.getStatus());
            qFilters.add(statusFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)query.getExpression())) {
            AtomicBoolean isField = new AtomicBoolean(false);
            String[] exp = query.getExpression().split(":");
            Arrays.stream(YsqQueueItemsConstant.selAllFileds().split(",")).forEach(item -> {
                if (exp[0].equals(item)) {
                    QFilter expFilter1 = new QFilter(exp[0], "=", (Object)exp[1]);
                    qFilters.add(expFilter1);
                    isField.set(true);
                }
            });
            if (!isField.get()) {
                QFilter expFilter2 = new QFilter("ysq_custom_field_tag", "like", (Object)("%{\"key\":\"" + exp[0] + "\",\"value\":\"" + exp[1] + "\"}%"));
                qFilters.add(expFilter2);
            }
        }
        if (ObjectUtils.isNotEmpty((Object)query.getStartTime())) {
            try {
                DateUtils.formatDate(query.getStartTime());
            }
            catch (Exception e) {
                errorCode = new ErrorCode(ResultStatusEnums.INVALID_DATE_FORMART.getCode() + "", ResultStatusEnums.INVALID_DATE_FORMART.getCodeMsg());
                throw new KDException(errorCode, null, null);
            }
            createTimeFilter = new QFilter("createtime", ">=", (Object)query.getStartTime());
            qFilters.add(createTimeFilter);
        }
        if (ObjectUtils.isNotEmpty((Object)query.getEndTime())) {
            try {
                DateUtils.formatDate(query.getEndTime());
            }
            catch (Exception e) {
                errorCode = new ErrorCode(ResultStatusEnums.INVALID_DATE_FORMART.getCode() + "", ResultStatusEnums.INVALID_DATE_FORMART.getCodeMsg());
                throw new KDException(errorCode, null, null);
            }
            createTimeFilter = new QFilter("createtime", "<=", (Object)query.getEndTime());
            qFilters.add(createTimeFilter);
        }
        QFilter[] objects = new QFilter[qFilters.size()];
        objects = qFilters.toArray(objects);
        int pageIndex = 0;
        int pageSize = 10000;
        if (ObjectUtils.isNotEmpty((Object)query.getPage()) && pageIndex > 0) {
            pageIndex = query.getPage() - 1;
        }
        if (ObjectUtils.isNotEmpty((Object)query.getSize())) {
            pageSize = query.getSize();
        }
        DynamicObject[] queueItems = BusinessDataServiceHelper.load((String)"ysq_rpa_queues_items", (String)YsqQueueItemsConstant.selAllFileds(), (QFilter[])objects, (String)"createtime desc", (int)pageIndex, (int)pageSize);
        EsUtils.addQueueEsLog(Arrays.asList(queueItems), "read", agentNo, agentAlias, agentType, query.getJobNo(), query.getProcCode(), "-");
        PageResult<Map<String, Object>> result = new PageResult<Map<String, Object>>();
        if (null == queueItems || queueItems.length == 0) {
            return ISearchCustomApiResultVO.ok();
        }
        result.setItems(QueueItemServiceHelper.convertToBean(queueItems, queue));
        result.setTotal(queueItems.length);
        return ISearchCustomApiResultVO.success(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISearchCustomApiResultVO popQueueItem(String queueName, CdaAgentVO agent, String jobNo, String procCode) {
        block4: {
            Long orgId = agent.getOrgFid();
            String agentNo = agent.getAgentNo();
            String agentType = agent.getAgentType();
            QueueItemServiceHelper.getQueueByQueueName(queueName, orgId, agentNo);
            QFilter queueNameFilter = new QFilter("ysq_queue_name", "=", (Object)queueName);
            ArrayList<String> statusList = new ArrayList<String>();
            statusList.add(ItemQueueStatusEnums.PENDING.getCode());
            statusList.add(ItemQueueStatusEnums.RETRY.getCode());
            QFilter statusFilter = new QFilter("ysq_status", "in", statusList);
            DLock lock = DLock.create((String)(RedisLockKeysEnums.KEY_HEAD.getKey() + RequestContext.get().getAccountId() + RedisLockKeysEnums.KEY_SPLIT_LOCK.getKey() + RedisLockKeysEnums.REDIS_POP_QUEUE_HEAD.getKey() + queueName));
            lock.lock();
            try {
                DynamicObject[] queueItem = BusinessDataServiceHelper.load((String)"ysq_rpa_queues_items", (String)YsqQueueItemsConstant.selAllFileds(), (QFilter[])new QFilter[]{queueNameFilter, statusFilter}, (String)"ysq_priority asc, createtime asc", (int)1);
                if (null == queueItem || queueItem.length <= 0) break block4;
                if (ObjectUtils.isNotEmpty((Object)queueItem[0].get("ysq_deadline")) && queueItem[0].getDate("ysq_deadline").before(new Date())) {
                    QueueItemServiceHelper.modifyQueueStatus(ItemQueueStatusEnums.WAITTIMEOUT.getCode(), queueItem[0].getString("ysq_item_no"), null, agent, procCode, jobNo);
                    lock.unlock();
                    QueueItemServiceHelper.popQueueItem(queueName, agent, procCode, jobNo);
                    break block4;
                }
                QueueItemServiceHelper.modifyQueueStatus(ItemQueueStatusEnums.RUNNING.getCode(), queueItem[0].getString("ysq_item_no"), null, agent, procCode, jobNo);
                Map<String, Object> popItem = QueueItemServiceHelper.updateAndConvertToBean(queueItem[0], orgId, agentNo, agentType);
                lock.unlock();
                ISearchCustomApiResultVO iSearchCustomApiResultVO = ISearchCustomApiResultVO.success(popItem);
                return iSearchCustomApiResultVO;
            }
            finally {
                lock.unlock();
                lock.close();
            }
        }
        return ISearchCustomApiResultVO.ok();
    }

    public static ISearchCustomApiResultVO addQueueItem(AddQueueItemVO queueItem, CdaAgentVO agent) {
        Long orgId = agent.getOrgFid();
        String agentNo = agent.getAgentNo();
        String agentType = agent.getAgentType();
        DynamicObject queue = QueueItemServiceHelper.getQueueByQueueName(queueItem.getQueueName(), orgId, agentNo);
        long queueItemTotal = QueueItemServiceHelper.getQueueItemTotal(queue.getString("ysq_queue_name"), orgId);
        if (queueItemTotal >= queue.getLong("ysq_queue_max_items")) {
            log.error(" [{}]\u90e8\u95e8  [{}] \u961f\u5217 \u8d85\u8fc7\u8be5\u6570\u636e\u9879\u6700\u5927\u6570", (Object)orgId, (Object)queueItem.getQueueName());
            return ISearchCustomApiResultVO.fail(ResultStatusEnums.QUEUES_EXCEED_MAX_ITEMS.getCodeMsg(), ResultStatusEnums.QUEUES_EXCEED_MAX_ITEMS.getCode());
        }
        Long id = QueueItemServiceHelper.queueItemAdd(orgId, queue, queueItem, agentNo, agentType, agent.getAgentAlias());
        HashMap<String, Comparable<Long>> queueRds = new HashMap<String, Comparable<Long>>();
        queueRds.put("id", id);
        queueRds.put("deadline", queueItem.getDeadline());
        return ISearchCustomApiResultVO.ok();
    }

    public static long getQueueItemTotal(String queueName, long orgId) {
        QFilter queueNameFilter = new QFilter("ysq_queue_name", "=", (Object)queueName);
        DynamicObjectCollection queueItems = QueryServiceHelper.query((String)"ysq_rpa_queues_items", (String)YsqQueueItemsConstant.selAllFileds(), (QFilter[])new QFilter[]{queueNameFilter});
        return queueItems.size();
    }

    public static ISearchCustomApiResultVO deleteQueueItem(DeleteQueueItemVO deleteQueueItemVo, CdaAgentVO agent) {
        Long orgId = agent.getOrgFid();
        String agentNo = agent.getAgentNo();
        String agentType = agent.getAgentType();
        Object items = deleteQueueItemVo.getItems();
        if (items == null) {
            return ISearchCustomApiResultVO.fail(ResultStatusEnums.QUEUE_ITEMS_IS_NULL.getCodeMsg(), ResultStatusEnums.QUEUE_ITEMS_IS_NULL.getCode());
        }
        String queueNameQ = deleteQueueItemVo.getQueueName();
        QueueItemServiceHelper.getQueueByQueueName(queueNameQ, orgId, agentNo);
        ArrayList<Map> paramItems = new ArrayList<Map>();
        if (items instanceof List) {
            List list = (List)items;
            list.forEach(one -> {
                if (one instanceof String) {
                    HashMap<String, String> itemsMap = new HashMap<String, String>();
                    itemsMap.put("itemNo", (String)one);
                    paramItems.add(itemsMap);
                } else if (one instanceof Map) {
                    ArrayList itemsList = new ArrayList();
                    Map mapOne = (Map)one;
                    String itemno = (String)mapOne.get("itemNo");
                    if (StringUtils.isNotBlank((CharSequence)itemno)) {
                        if (itemno.startsWith("[")) {
                            itemno = itemno.substring(1);
                        }
                        if (itemno.endsWith("]")) {
                            itemno = itemno.substring(0, itemno.length() - 1);
                        }
                        List<String> array = Arrays.asList(itemno.split(","));
                        array.forEach(item -> {
                            if (item.startsWith("'")) {
                                item = item.substring(1);
                            }
                            if (item.endsWith("'")) {
                                item = item.substring(0, item.length() - 1);
                            }
                            HashMap<String, String> itemsMap = new HashMap<String, String>();
                            itemsMap.put("itemNo", (String)item);
                            itemsList.add(itemsMap);
                        });
                    }
                    paramItems.addAll(itemsList);
                }
            });
        } else if (items instanceof Map) {
            paramItems.add((Map)items);
        } else if (items instanceof String) {
            HashMap<String, String> itemsMap = new HashMap<String, String>();
            itemsMap.put("itemNo", (String)items);
            if (StringUtils.isEmpty((CharSequence)((String)items))) {
                return ISearchCustomApiResultVO.fail(ResultStatusEnums.QUEUE_ITEMS_IS_NULL.getCodeMsg(), ResultStatusEnums.QUEUE_ITEMS_IS_NULL.getCode());
            }
            paramItems.add(itemsMap);
        }
        if (paramItems.isEmpty()) {
            return ISearchCustomApiResultVO.fail(ResultStatusEnums.QUEUE_ITEMS_ERROR.getCodeMsg(), ResultStatusEnums.QUEUE_ITEMS_ERROR.getCode());
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        for (Map map : paramItems) {
            String itemNo = (String)map.get("itemNo");
            QFilter itemNoFilter = new QFilter("ysq_item_no", "=", (Object)itemNo);
            qFilters.add(itemNoFilter);
            QueueItemServiceHelper.getQueueByQueueNameAndItemNo(queueNameQ, itemNo);
            QueueItemServiceHelper.modifyQueueStatus(ItemQueueStatusEnums.DELETED.getCode(), itemNo, null, agent, deleteQueueItemVo.getProcCode(), deleteQueueItemVo.getJobNo());
        }
        return ISearchCustomApiResultVO.ok();
    }

    public static ISearchCustomApiResultVO updateQueueItem(UpdateQueueItemVO updateQueueItemVo, CdaAgentVO agent) {
        Long orgId = agent.getOrgFid();
        String agentNo = agent.getAgentNo();
        String agentType = agent.getAgentType();
        if (ObjectUtils.isEmpty((Object)orgId)) {
            return ISearchCustomApiResultVO.fail(ResultStatusEnums.NOT_AUTHORIZED.getCodeMsg(), ResultStatusEnums.NOT_AUTHORIZED.getCode());
        }
        String itemNo = updateQueueItemVo.getItemNo();
        String status = updateQueueItemVo.getStatus();
        String result = updateQueueItemVo.getResult();
        String queueName = updateQueueItemVo.getQueueName();
        QueueItemServiceHelper.getQueueByQueueName(queueName, orgId, agentNo);
        if (StringUtils.isBlank((CharSequence)itemNo)) {
            return ISearchCustomApiResultVO.fail(ResultStatusEnums.QUEUE_ITEM_NO_IS_NULL.getCodeMsg(), ResultStatusEnums.QUEUE_ITEM_NO_IS_NULL.getCode());
        }
        QueueItemServiceHelper.getQueueByQueueNameAndItemNo(queueName, itemNo);
        if (!ItemQueueStatusEnums.SUCC.getCode().equals(status) && !ItemQueueStatusEnums.FAILED.getCode().equals(status)) {
            return ISearchCustomApiResultVO.fail(ResultStatusEnums.QUEUE_STATUS_NOLL.getCodeMsg(), ResultStatusEnums.QUEUE_STATUS_NOLL.getCode());
        }
        QueueItemServiceHelper.modifyQueueStatus(status, itemNo, result, agent, updateQueueItemVo.getProcCode(), updateQueueItemVo.getJobNo());
        return ISearchCustomApiResultVO.ok();
    }

    private static Long queueItemAdd(long orgId, DynamicObject queue, AddQueueItemVO queueItem, String agentNo, String agentType, String agentAlias) {
        HashMap<String, String> params = new HashMap<String, String>();
        DynamicObject queueItems = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_queues_items");
        queueItems.set("billstatus", (Object)"A");
        List<QueueItemKeyVO> keys = queueItem.getKeys();
        if (CollectionUtils.isNotEmpty(keys)) {
            for (QueueItemKeyVO itemKey : keys) {
                if (!StringUtils.isNotBlank((CharSequence)itemKey.getKey())) continue;
                params.put(itemKey.getKey(), itemKey.getValue());
            }
            queueItems.set("ysq_custom_field_tag", (Object)JSON.toJSONString(keys));
        }
        queueItems.set("ysq_queue_name", (Object)queue.getString("ysq_queue_name"));
        queueItems.set("ysq_status", (Object)ItemQueueStatusEnums.PENDING.getCode());
        queueItems.set("ysq_job_no", (Object)queueItem.getJobNo());
        queueItems.set("ysq_proc_code", (Object)queueItem.getProcCode());
        queueItems.set("ysq_agent_no", (Object)agentNo);
        queueItems.set("ysq_fail_try_times", (Object)queue.getString("ysq_fail_try_times"));
        queueItems.set("ysq_queue_max_items", (Object)queue.getString("ysq_queue_max_items"));
        if (StringUtils.isBlank((CharSequence)agentAlias)) {
            agentAlias = agentNo;
        }
        queueItems.set("ysq_robot_no", (Object)agentNo);
        queueItems.set("ysq_agent_alias", (Object)agentAlias);
        queueItems.set("ysq_sourceId", (Object)queue.getString("id"));
        queueItems.set("ysq_item_no", (Object)UUID.randomUUID().toString());
        if (ObjectUtils.isEmpty((Object)queueItem.getDeadline())) {
            queueItems.set("ysq_deadline_null", (Object)-1);
        } else {
            queueItems.set("ysq_deadline", (Object)queueItem.getDeadline());
        }
        queueItems.set("ysq_priority", (Object)PriorityEnums.getCode(queueItem.getPriority()));
        queueItems.set("ysq_run_times", (Object)0);
        queueItems.set("ysq_org_code", (Object)orgId);
        queueItems.set("org", (Object)orgId);
        queueItems.set("ysq_agent_type", (Object)agentType);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{queueItems});
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        dynamicObjects.add(queueItems);
        EsUtils.addQueueEsLog(dynamicObjects, "create", agentNo, agentAlias, agentType, queueItem.getJobNo(), queueItem.getProcCode(), "-");
        return queueItems.getLong("id");
    }

    private static DynamicObject getQueueByQueueName(String queueName, Long orgId, String agentNo) {
        if (StringUtils.isEmpty((CharSequence)queueName)) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.QUEUE_NAME_NOT_EXIST.getCode() + "", ResultStatusEnums.QUEUE_NAME_NOT_EXIST.getCodeMsg());
            throw new KDException(errorCode, null, null);
        }
        QFilter queueNameFilter = new QFilter("ysq_queue_name", "=", (Object)queueName);
        DynamicObject queue = QueryServiceHelper.queryOne((String)"ysq_rpa_queues", (String)YsqQueuesConstant.selAllFileds(), (QFilter[])new QFilter[]{queueNameFilter});
        if (queue == null) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.QUEUES_NOT_EXIST.getCode() + "", ResultStatusEnums.QUEUES_NOT_EXIST.getCodeMsg());
            throw new KDException(errorCode, null, null);
        }
        if (StringUtils.isNotEmpty((CharSequence)agentNo) && queue.getString("ysq_robots_no_tag").contains(agentNo)) {
            return queue;
        }
        if (queue.getString("ysq_robots_no_tag").contains(RobotRangeEnums.DEPTALL.getCode()) && ObjectUtils.isNotEmpty((Object)orgId) && OrgServiceHelper.getChildOrg(queue.getLong("org")).contains(orgId)) {
            return queue;
        }
        if (StringUtils.isEmpty((CharSequence)agentNo) && ObjectUtils.isNotEmpty((Object)queue.getLong("org")) && ObjectUtils.isNotEmpty((Object)orgId) && OrgServiceHelper.getChildOrg(queue.getLong("org")).contains(orgId)) {
            return queue;
        }
        log.error(" [{}]\u90e8\u95e8 \u65e0\u6743\u6743\u9650\u8bbf\u95ee [{}] \u961f\u5217", (Object)orgId, (Object)queueName);
        ErrorCode errorCode = new ErrorCode(ResultStatusEnums.QUEUE_NO_PERMISSION.getCode() + "", ResultStatusEnums.QUEUE_NO_PERMISSION.getCodeMsg());
        throw new KDException(errorCode, null, null);
    }

    private static void getQueueByQueueNameAndItemNo(String queueName, String itemNo) {
        QFilter queueNameFilter = new QFilter("ysq_queue_name", "=", (Object)queueName);
        QFilter itemNoFilter = new QFilter("ysq_item_no", "=", (Object)itemNo);
        DynamicObjectCollection queueitems = QueryServiceHelper.query((String)"ysq_rpa_queues_items", (String)YsqQueueItemsConstant.selAllFileds(), (QFilter[])new QFilter[]{queueNameFilter, itemNoFilter});
        if (CollectionUtils.isEmpty((Collection)queueitems)) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.QUEUE_ITEM_NOTMATCH.getCode() + "", ResultStatusEnums.QUEUE_ITEM_NOTMATCH.getCodeMsg());
            throw new KDException(errorCode, null, null);
        }
    }

    private static Map<String, Object> updateAndConvertToBean(DynamicObject resultMap, Long orgId, String agentNo, String agentType) {
        return QueueItemServiceHelper.mapConverttQueueItem(resultMap, "");
    }

    private static List<Map<String, Object>> convertToBean(DynamicObject[] queueItems, DynamicObject queue) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (null == queueItems || queueItems.length == 0) {
            return list;
        }
        for (DynamicObject item : queueItems) {
            Map<String, Object> queueItem = QueueItemServiceHelper.mapConverttQueueItem(item, queue.getString("ysq_queue_desc"));
            list.add(queueItem);
        }
        return list;
    }

    private static Map<String, Object> mapConverttQueueItem(DynamicObject item, String queueDesc) {
        QueueItemVO queueItem = new QueueItemVO();
        queueItem.setId(item.getString("id"));
        queueItem.setQueueName(item.getString("ysq_queue_name"));
        queueItem.setPriority(item.getString("ysq_priority"));
        queueItem.setDeadline(item.getString("ysq_deadline"));
        queueItem.setRobotNo(item.getString("ysq_robot_no"));
        queueItem.setFailTryTimes(item.getInt("ysq_fail_try_times"));
        queueItem.setQueueMaxItems(item.getInt("ysq_queue_max_items"));
        queueItem.setQueueDesc(queueDesc);
        queueItem.setItemNo(item.getString("ysq_item_no"));
        queueItem.setRunTimes(item.getInt("ysq_run_times"));
        queueItem.setStatus(item.getString("ysq_status"));
        queueItem.setStartTime(item.getString("ysq_start_time"));
        queueItem.setEndTime(item.getString("ysq_end_time"));
        queueItem.setFailDesc(item.getString("ysq_faildesc_tag"));
        queueItem.setJobNo(item.getString("ysq_job_no"));
        JSONObject returnMap = JSON.parseObject((String)JSON.toJSONString((Object)queueItem));
        String fields = item.getString("ysq_custom_field_tag");
        List customKey = (List)JSONArray.parseObject((String)fields, ArrayList.class);
        if (CollectionUtils.isNotEmpty((Collection)customKey)) {
            for (Map itemKey : customKey) {
                if (!StringUtils.isNotBlank((CharSequence)QueueItemServiceHelper.convertStr(itemKey.get("key")))) continue;
                returnMap.put(QueueItemServiceHelper.convertStr(itemKey.get("key")), itemKey.get("value"));
            }
        }
        return returnMap;
    }

    private Integer convertInt(Object obj) {
        if (obj == null) {
            return null;
        }
        return Integer.valueOf(QueueItemServiceHelper.convertStr(obj));
    }

    private static String convertStr(Object obj) {
        if (obj == null) {
            return null;
        }
        return String.valueOf(obj);
    }

    private static boolean modifyQueueStatus(String status, String itemNo, String result, CdaAgentVO agent, String procCode, String jobNo) {
        try {
            QFilter itemNoFilter = new QFilter("ysq_item_no", "=", (Object)itemNo);
            QFilter[] queueItemsFilters = new QFilter[]{itemNoFilter};
            DynamicObject queueItem = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_queues_items", (String)YsqQueueItemsConstant.selAllFileds(), (QFilter[])queueItemsFilters);
            if (queueItem != null) {
                String esDetail;
                String queueName = queueItem.getString("ysq_queue_name");
                String agentNo = agent.getAgentNo();
                String agentAlias = agent.getAgentAlias();
                String orgCode = queueItem.getString("ysq_org_code");
                String agentType = agent.getAgentType();
                String id = queueItem.getString("id");
                String statusOriginal = queueItem.getString("ysq_status");
                int failTryTimes = 0;
                if (queueItem.get("ysq_fail_try_times") != null) {
                    failTryTimes = queueItem.getInt("ysq_fail_try_times");
                }
                int runTimes = 0;
                if (queueItem.get("ysq_run_times") != null) {
                    runTimes = queueItem.getInt("ysq_run_times");
                }
                if (StringUtils.isNotBlank((CharSequence)status)) {
                    if (ItemQueueStatusEnums.PENDING.getCode().equals(statusOriginal)) {
                        if (!(ItemQueueStatusEnums.RUNNING.getCode().equals(status) || ItemQueueStatusEnums.WAITTIMEOUT.getCode().equals(status) || ItemQueueStatusEnums.DELETED.getCode().equals(status))) {
                            log.error(ResultStatusEnums.STATUS_ERROR.getCodeMsg());
                            return false;
                        }
                        if (ItemQueueStatusEnums.RUNNING.getCode().equals(status)) {
                            queueItem.set("ysq_start_time", (Object)new Date());
                            queueItem.set("ysq_run_times", (Object)(++runTimes));
                        }
                    } else if (ItemQueueStatusEnums.RUNNING.getCode().equals(statusOriginal)) {
                        if (!(ItemQueueStatusEnums.SUCC.getCode().equals(status) || ItemQueueStatusEnums.FAILED.getCode().equals(status) || ItemQueueStatusEnums.DELETED.getCode().equals(status))) {
                            log.error(ResultStatusEnums.STATUS_ERROR.getCodeMsg());
                            return false;
                        }
                        if (ItemQueueStatusEnums.FAILED.getCode().equals(status)) {
                            queueItem.set("ysq_faildesc", (Object)result);
                        }
                        queueItem.set("ysq_end_time", (Object)new Date());
                    } else if (ItemQueueStatusEnums.RETRY.getCode().equals(statusOriginal)) {
                        if (!ItemQueueStatusEnums.RUNNING.getCode().equals(status) && !ItemQueueStatusEnums.DELETED.getCode().equals(status)) {
                            log.error(ResultStatusEnums.STATUS_ERROR.getCodeMsg());
                            return false;
                        }
                        if (ItemQueueStatusEnums.RUNNING.getCode().equals(status)) {
                            queueItem.set("ysq_start_time", (Object)new Date());
                            queueItem.set("ysq_run_times", (Object)(++runTimes));
                        }
                    } else if (ItemQueueStatusEnums.SUCC.getCode().equals(statusOriginal)) {
                        if (!ItemQueueStatusEnums.DELETED.getCode().equals(status)) {
                            log.error(ResultStatusEnums.STATUS_ERROR.getCodeMsg());
                            return false;
                        }
                    } else if (ItemQueueStatusEnums.WAITTIMEOUT.getCode().equals(statusOriginal)) {
                        if (!ItemQueueStatusEnums.DELETED.getCode().equals(status)) {
                            log.error(ResultStatusEnums.STATUS_ERROR.getCodeMsg());
                            return false;
                        }
                    } else if (ItemQueueStatusEnums.FAILED.getCode().equals(statusOriginal)) {
                        if (!ItemQueueStatusEnums.DELETED.getCode().equals(status) && !ItemQueueStatusEnums.RETRY.getCode().equals(status)) {
                            log.error(ResultStatusEnums.STATUS_ERROR.getCodeMsg());
                            return false;
                        }
                    } else if (ItemQueueStatusEnums.DELETED.getCode().equals(statusOriginal)) {
                        return false;
                    }
                    if (failTryTimes > 0 && failTryTimes >= runTimes && ItemQueueStatusEnums.FAILED.getCode().equals(status)) {
                        queueItem.set("ysq_status", (Object)ItemQueueStatusEnums.RETRY.getCode());
                    } else {
                        queueItem.set("ysq_status", (Object)status);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)agentType)) {
                    queueItem.set("ysq_agent_type", (Object)agentType);
                }
                if (StringUtils.isNotEmpty((CharSequence)jobNo)) {
                    queueItem.set("ysq_job_no", (Object)jobNo);
                }
                if (StringUtils.isNotEmpty((CharSequence)agentAlias)) {
                    queueItem.set("ysq_agent_alias", (Object)agentAlias);
                }
                if (StringUtils.isNotEmpty((CharSequence)procCode)) {
                    queueItem.set("ysq_proc_code", (Object)procCode);
                }
                SaveServiceHelper.update((DynamicObject)queueItem);
                log.info("\u961f\u5217\u9879\u66f4\u65b0\u5230es\u6210\u529f" + id);
                ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
                dynamicObjects.add(queueItem);
                if (ItemQueueStatusEnums.RUNNING.getCode().equals(status)) {
                    esDetail = "POP\u6570\u636e\u3002\u8bbe\u7f6e\u524d\uff1a" + QueueItemStatusEnums.match(statusOriginal).getName() + "\uff1b\u8bbe\u7f6e\u540e\uff1a" + QueueItemStatusEnums.match(status).getName();
                    EsUtils.addQueueEsLog(dynamicObjects, "edit", agentNo, agent.getAgentAlias(), agentType, jobNo, procCode, esDetail);
                }
                if (ItemQueueStatusEnums.SUCC.getCode().equals(status) || ItemQueueStatusEnums.FAILED.getCode().equals(status)) {
                    esDetail = "\u8bbe\u7f6e\u72b6\u6001\u3002\u8bbe\u7f6e\u524d\uff1a" + QueueItemStatusEnums.match(statusOriginal).getName() + "\uff1b\u8bbe\u7f6e\u540e\uff1a" + QueueItemStatusEnums.match(status).getName();
                    EsUtils.addQueueEsLog(dynamicObjects, "edit", agentNo, agent.getAgentAlias(), agentType, jobNo, procCode, esDetail);
                }
                if (ItemQueueStatusEnums.DELETED.getCode().equals(status)) {
                    EsUtils.addQueueEsLog(dynamicObjects, "deleted", agentNo, agent.getAgentAlias(), agentType, jobNo, procCode, "\u5220\u9664\u6570\u636e");
                }
            }
        }
        catch (Exception e) {
            log.error("\u961f\u5217\u9879\u66f4\u65b0\u5f02\u5e38");
        }
        return true;
    }
}

