/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.servicehelper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.annotation.OperateFileLog;
import ysq.rpac.rpamc.common.constant.YsqAgentConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessConstant;
import ysq.rpac.rpamc.common.constant.YsqRpaJobConstant;
import ysq.rpac.rpamc.common.constant.YsqShareFileConstant;
import ysq.rpac.rpamc.common.constant.YsqSysConfigConstant;
import ysq.rpac.rpamc.common.enums.ResultStatusEnums;
import ysq.rpac.rpamc.common.enums.RobotTypeEnums;
import ysq.rpac.rpamc.common.enums.ShareFileCreateTypeEnums;
import ysq.rpac.rpamc.common.enums.ShareFileLastOperTypeEnums;
import ysq.rpac.rpamc.common.model.CdaAgentVO;
import ysq.rpac.rpamc.common.model.FileQueryVO;
import ysq.rpac.rpamc.common.model.ISearchCustomApiResultVO;
import ysq.rpac.rpamc.common.model.ShareFileBatchDownModel;
import ysq.rpac.rpamc.common.model.ShareFileDelModel;
import ysq.rpac.rpamc.common.model.ShareFileModel;
import ysq.rpac.rpamc.common.model.ShareFileSimpleDownModel;
import ysq.rpac.rpamc.common.model.dto.ShareFileDTO;
import ysq.rpac.rpamc.common.servicehelper.AgentServiceHelper;
import ysq.rpac.rpamc.common.utils.DateUtils;
import ysq.rpac.rpamc.common.utils.EsUtils;
import ysq.rpac.rpamc.common.utils.UserUtils;

public class ShareFileServiceHelper {
    private static final String ATTACHMENT_PANEL = "attachmentpanel";
    private static Log log = LogFactory.getLog(ShareFileServiceHelper.class);

    public static void uploadFileList(List<Map<String, Object>> attachmentDataList, String tags) {
        ArrayList<DynamicObject> dynamicObjectList = ShareFileServiceHelper.buildShareFileDynamicObject(attachmentDataList, tags);
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return;
        }
        try {
            for (int i = 0; i < dynamicObjectList.size(); ++i) {
                DynamicObject saveDynamicObject = dynamicObjectList.get(i);
                saveDynamicObject.set("ysq_user_name", (Object)RequestContext.get().getUserName());
                ShareFileServiceHelper.saveShareFile(saveDynamicObject, attachmentDataList.get(i));
            }
        }
        catch (Exception e) {
            log.warn("\u6587\u4ef6\u5939-web\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0(uploadFileList)\uff1a" + e.getMessage());
        }
    }

    private static void saveShareFile(DynamicObject dynamicObject, Map<String, Object> attachmentData) {
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)"ysq_rpa_sfile", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            ValidateResultCollection validateResult = operationResult.getValidateResult();
            List validateErrors = validateResult.getValidateErrors();
            ValidateResult result = (ValidateResult)validateErrors.get(0);
            log.warn("\u6587\u4ef6\u5939-web\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0(\u6982\u8981)\uff1a" + operationResult.getMessage());
            log.warn("\u6587\u4ef6\u5939-web\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0(\u8be6\u60c5)\uff1a" + result.getAllErrorInfo());
            return;
        }
        ShareFileServiceHelper.bindFile(attachmentData, dynamicObject.getLong("id"), dynamicObject.getString("ysq_file_name"));
        EsUtils.addFileEsIndex(dynamicObject.getLong("id"), dynamicObject.getString("ysq_file_name"), OperateFileLog.Type.PAGE_UPLOAD.getType(), null, UserUtils.getCurrUserId(), dynamicObject.getLong("ysq_org_id"), null);
    }

    private static void bindFile(Map<String, Object> attachmentData, Long shareFileId, String fileName) {
        attachmentData.put("name", fileName);
        String temUrl = attachmentData.get("url").toString();
        String fileUrl = AttachmentServiceHelper.saveTempToFileService((String)temUrl, (String)"ysq_rpamc", (String)"ysq_rpa_sfile", (Object)shareFileId, (String)fileName, (boolean)true);
        attachmentData.put("url", fileUrl);
        ArrayList<Map<String, Object>> fileList = new ArrayList<Map<String, Object>>();
        fileList.add(attachmentData);
        AttachmentServiceHelper.upload((String)"ysq_rpa_sfile", (Object)shareFileId, (String)ATTACHMENT_PANEL, fileList);
    }

    private static ArrayList<DynamicObject> buildShareFileDynamicObject(List<Map<String, Object>> attachmentDataList, String tags) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>();
        for (Map<String, Object> attachmentData : attachmentDataList) {
            String fileName = attachmentData.get("name").toString();
            fileName = ShareFileServiceHelper.fileTypeToLowerCase(fileName);
            String[] split = fileName.split("\\.");
            DynamicObject dynamicObject = ShareFileServiceHelper.duplicateFileName(fileName);
            if (dynamicObject != null) {
                fileName = ShareFileServiceHelper.renameFile(fileName);
            }
            DynamicObject shareFile = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_sfile");
            shareFile.set("id", (Object)ID.genLongId());
            shareFile.set("billno", (Object)ShareFileServiceHelper.getBillNo());
            shareFile.set("org", (Object)UserUtils.getDptId());
            shareFile.set("billstatus", (Object)"A");
            shareFile.set("ysq_file_name", (Object)fileName);
            shareFile.set("ysq_file_name_low", (Object)fileName.toLowerCase());
            shareFile.set("ysq_file_size", (Object)Long.valueOf(attachmentData.get("size").toString()));
            shareFile.set("ysq_last_oper_time", (Object)new Date());
            shareFile.set("ysq_last_oper_type", (Object)ShareFileLastOperTypeEnums.WEB_CREATE.getValue());
            shareFile.set("ysq_file_create_type", (Object)ShareFileCreateTypeEnums.WEB_UPLOAD.getValue());
            shareFile.set("ysq_operator", (Object)UserUtils.getCurrUserId());
            shareFile.set("ysq_file_type", (Object)split[split.length - 1]);
            shareFile.set("ysq_cur_org_name", (Object)UserUtils.getDptNameById(UserUtils.getDptId()));
            shareFile.set("ysq_create_user_name", (Object)UserUtils.getCurrUserName());
            shareFile.set("ysq_org_id", (Object)UserUtils.getDptId());
            shareFile.set("ysq_file_tag", (Object)tags);
            dynamicObjectList.add(shareFile);
        }
        return dynamicObjectList;
    }

    private static String getBillNo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        String format = sdf.format(new Date());
        int i = (int)(Math.random() * 90000.0 + 10000.0);
        String billNo = "RPAsfile_" + format + "_" + i;
        return billNo;
    }

    public static void validateTags(ShareFileModel shareFile) throws KDException {
        if (StringUtils.isNotEmpty((CharSequence)shareFile.getFileTag())) {
            String tag = shareFile.getFileTag();
            shareFile.setFileTag(tag.replace("\uff0c", ","));
            if (shareFile.getFileTag().length() > 200) {
                ErrorCode errorCode = new ErrorCode(ResultStatusEnums.SHARE_FILE_TAG_LEN.getCode() + "", ResultStatusEnums.SHARE_FILE_TAG_LEN.getCodeMsg());
                throw new KDException(errorCode, new Object[0]);
            }
            String[] split = shareFile.getFileTag().split(",");
            Set collect = Arrays.stream(split).filter(item -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{item})).collect(Collectors.toSet());
            if (collect.size() > 5) {
                ErrorCode errorCode = new ErrorCode(ResultStatusEnums.SHARE_FILE_TAG_NUM.getCode() + "", ResultStatusEnums.SHARE_FILE_TAG_NUM.getCodeMsg());
                throw new KDException(errorCode, new Object[0]);
            }
            shareFile.setFileTag(collect.toString().replace("[", "").replace("]", ""));
        }
    }

    public static void validateUploadVO(ShareFileModel shareFile) throws KDException {
        if (StringUtils.isEmpty((CharSequence)shareFile.getUrl())) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.RPA_SHARE_FILE_UPLOADFILE_NULL.getCode() + "", ResultStatusEnums.RPA_SHARE_FILE_UPLOADFILE_NULL.getCodeMsg());
            throw new KDException(errorCode, new Object[0]);
        }
        String fileName = shareFile.getFileName();
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.RPA_SHARE_FILE_FILENAME_NULL.getCode() + "", ResultStatusEnums.RPA_SHARE_FILE_FILENAME_NULL.getCodeMsg());
            throw new KDException(errorCode, new Object[0]);
        }
        String fileType = null;
        int typeSplitIndex = fileName.lastIndexOf(".");
        if (typeSplitIndex > 0) {
            fileType = fileName.substring(typeSplitIndex + 1).toLowerCase();
            fileName = fileName.substring(0, typeSplitIndex);
        }
        if (!YsqShareFileConstant.ALLOWED_FILE_TYPE.contains(fileType)) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.FILE_TYPE_ERROR.getCode() + "", ResultStatusEnums.FILE_TYPE_ERROR.getCodeMsg());
            throw new KDException(errorCode, new Object[0]);
        }
        String upType = shareFile.getUpType();
        String procCode = (String)ServiceApiContext.getRequest().getRequestHeaders().get("proccode");
        if (StringUtils.isEmpty((CharSequence)procCode)) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.SHARE_FILE_PARAMS_NULL.getCode() + "", ResultStatusEnums.SHARE_FILE_PARAMS_NULL.getCodeMsg());
            throw new KDException(errorCode, new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)shareFile.getFileDesc()) && shareFile.getFileDesc().length() > 200) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.MAX_FILE_UPLOAD_SIZE_EXCEEDED.getCode() + "", ResultStatusEnums.MAX_FILE_UPLOAD_SIZE_EXCEEDED.getCodeMsg());
            throw new KDException(errorCode, new Object[0]);
        }
        Map<String, Long> licenseUseMap = ShareFileServiceHelper.getFileCapacity();
        Long used = licenseUseMap.get("used");
        Long total = licenseUseMap.get("total");
        Long newSize = shareFile.getFileSize();
        if ("yes".equals(shareFile.getIsOverwrite())) {
            DynamicObject duplicateFile = ShareFileServiceHelper.duplicateFileName(shareFile.getFileName());
            if (duplicateFile != null) {
                ShareFileServiceHelper.checkFileOrgPower(duplicateFile.getLong("ysq_org_id"), procCode);
                Long oldSize = duplicateFile.getLong("ysq_file_size");
                if (used - oldSize + newSize > total) {
                    ErrorCode errorCode = new ErrorCode(ResultStatusEnums.MAX_FILE_SIZE_EXCEEDED.getCode() + "", ResultStatusEnums.MAX_FILE_SIZE_EXCEEDED.getCodeMsg());
                    throw new KDException(errorCode, new Object[0]);
                }
            }
        } else if (used + newSize > total) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.MAX_FILE_SIZE_EXCEEDED.getCode() + "", ResultStatusEnums.MAX_FILE_SIZE_EXCEEDED.getCodeMsg());
            throw new KDException(errorCode, new Object[0]);
        }
        shareFile.setFileName(fileName + "." + fileType);
    }

    public static DynamicObject duplicateFileName(String fileName) {
        QFilter nameFilter = new QFilter("ysq_file_name_low", "=", (Object)fileName.toLowerCase());
        DynamicObject load = QueryServiceHelper.queryOne((String)"ysq_rpa_sfile", (String)YsqShareFileConstant.selAllFileds(), (QFilter[])new QFilter[]{nameFilter});
        return load;
    }

    public static CustomApiResult pyUploadFile(ShareFileModel shareFile) {
        DynamicObject emptyObject = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_sfile");
        emptyObject.set("ysq_file_tag", (Object)shareFile.getFileTag());
        if (StringUtils.isNotEmpty((CharSequence)shareFile.getJobNo())) {
            QFilter filter = new QFilter("ysq_job_no", "=", (Object)shareFile.getJobNo());
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])new QFilter[]{filter});
            if (load != null && load.length > 0) {
                emptyObject.set("ysq_job_no", load[0].get("ysq_job_no"));
                emptyObject.set("ysq_sch_name", load[0].get("ysq_sch_name"));
            }
        }
        String procCode = (String)ServiceApiContext.getRequest().getRequestHeaders().get("proccode");
        DynamicObject process = null;
        QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        emptyObject.set("ysq_file_size", (Object)shareFile.getFileSize().toString());
        emptyObject.set("ysq_file_desc", (Object)shareFile.getFileDesc());
        String commToken = (String)ServiceApiContext.getRequest().getRequestHeaders().get("commtoken");
        if (StringUtils.isEmpty((CharSequence)commToken)) {
            QFilter f1 = new QFilter("ysq_agent_no", "=", (Object)String.valueOf(RequestContext.get().getCurrUserId()));
            QFilter f2 = new QFilter("ysq_agent_type", "=", (Object)RobotTypeEnums.STUDIO.getCode());
            DynamicObject agent = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_agent", (String)YsqAgentConstant.selAllFileds(), (QFilter[])new QFilter[]{f1, f2});
            if (agent != null) {
                emptyObject.set("ysq_agent_type", (Object)RobotTypeEnums.STUDIO);
                emptyObject.set("ysq_agent_no", (Object)RequestContext.get().getCurrUserId());
                emptyObject.set("ysq_agent_alias", (Object)RequestContext.get().getUserName());
            }
            emptyObject.set("ysq_file_create_type", (Object)1);
            emptyObject.set("org", (Object)UserUtils.getDptId());
            emptyObject.set("ysq_org_id", (Object)UserUtils.getDptId());
            emptyObject.set("ysq_user_name", (Object)RequestContext.get().getUserName());
        } else {
            process = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
            if (process != null) {
                emptyObject.set("ysq_proc_code", (Object)process.getString("ysq_proc_code"));
                emptyObject.set("ysq_proc_name", (Object)process.getString("ysq_proc_name"));
                emptyObject.set("ysq_file_desc", (Object)("\u6d41\u7a0b\u6587\u4ef6\uff1a\u6765\u81ea\u6d41\u7a0b" + process.getString("ysq_proc_name")));
            }
            CdaAgentVO agent = AgentServiceHelper.checkCommonToken(commToken);
            emptyObject.set("ysq_agent_type", (Object)agent.getAgentType());
            emptyObject.set("ysq_agent_no", (Object)agent.getAgentNo());
            emptyObject.set("ysq_agent_alias", (Object)agent.getAgentAlias());
            emptyObject.set("ysq_file_create_type", (Object)2);
            if (process != null) {
                DynamicObject orgObj = process.getDynamicObject("org");
                long orgId = orgObj.getLong(0);
                emptyObject.set("org", process.get("org"));
                emptyObject.set("ysq_org_id", (Object)orgId);
            }
        }
        emptyObject.set("ysq_is_third", (Object)false);
        DynamicObject duplicateFile = ShareFileServiceHelper.duplicateFileName(shareFile.getFileName());
        String newName = shareFile.getFileName();
        if (duplicateFile != null && !"yes".equals(shareFile.getIsOverwrite())) {
            newName = ShareFileServiceHelper.renameFile(shareFile.getFileName());
        }
        Long shareFileId = ID.genLongId();
        emptyObject.set("id", (Object)shareFileId);
        ArrayList list = new ArrayList();
        HashMap<String, Object> attach = new HashMap<String, Object>();
        try {
            attach.put("uid", AttachmentServiceHelper.generateUid());
            attach.put("name", newName);
            attach.put("size", shareFile.getFileSize());
            attach.put("url", shareFile.getUrl());
            list.add(attach);
            AttachmentServiceHelper.upload((String)"ysq_rpa_sfile", (Object)shareFileId, (String)ATTACHMENT_PANEL, list);
        }
        catch (Exception e) {
            return CustomApiResult.success((Object)ISearchCustomApiResultVO.fail("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", 0));
        }
        if (duplicateFile != null) {
            if ("yes".equals(shareFile.getIsOverwrite())) {
                emptyObject.set("createtime", duplicateFile.get("createtime"));
                AttachmentServiceHelper.remove((String)"ysq_rpa_sfile", (Object)duplicateFile.get("id"));
                QFilter f = new QFilter("id", "=", duplicateFile.get("id"));
                DynamicObject sfile = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_sfile", (String)YsqShareFileConstant.selAllFileds(), (QFilter[])new QFilter[]{f});
                if (sfile != null && StringUtils.isNotEmpty((CharSequence)sfile.getString("ysq_job_no"))) {
                    QFilter jobNoFilter = new QFilter("ysq_job_no", "=", (Object)sfile.getString("ysq_job_no"));
                    DynamicObject job = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])new QFilter[]{jobNoFilter});
                    if (job != null) {
                        long fileCount = job.getLong("ysq_file_ref_count");
                        if (--fileCount < 0L) {
                            fileCount = 0L;
                        }
                        job.set("ysq_file_ref_count", (Object)fileCount);
                        SaveServiceHelper.update((DynamicObject)job);
                    }
                }
                DeleteServiceHelper.delete((String)"ysq_rpa_sfile", (QFilter[])new QFilter[]{f});
                emptyObject.set("ysq_last_oper_type", (Object)ShareFileLastOperTypeEnums.WEB_COVER.getValue());
                ShareFileServiceHelper.saveShareFile(emptyObject, shareFile.getFileName());
            } else {
                AttachmentServiceHelper.rename((String)attach.get("uid").toString(), (String)newName);
                emptyObject.set("ysq_last_oper_type", (Object)ShareFileLastOperTypeEnums.WEB_CREATE.getValue());
                ShareFileServiceHelper.saveShareFile(emptyObject, newName);
            }
        } else {
            emptyObject.set("ysq_last_oper_type", (Object)ShareFileLastOperTypeEnums.WEB_CREATE.getValue());
            ShareFileServiceHelper.saveShareFile(emptyObject, shareFile.getFileName());
        }
        if (StringUtils.isEmpty((CharSequence)commToken)) {
            if (duplicateFile != null && "yes".equals(shareFile.getIsOverwrite())) {
                EsUtils.addFileEsIndex(shareFileId, newName, OperateFileLog.Type.STUDIO_RECOVER.getType(), null, UserUtils.getCurrUserId(), emptyObject.getLong("ysq_org_id"), emptyObject.getString("ysq_agent_alias"));
            } else {
                EsUtils.addFileEsIndex(shareFileId, newName, OperateFileLog.Type.STUDIO_UPLOAD.getType(), null, UserUtils.getCurrUserId(), emptyObject.getLong("ysq_org_id"), emptyObject.getString("ysq_agent_alias"));
            }
        } else {
            CdaAgentVO agent = AgentServiceHelper.checkCommonToken(commToken);
            if (null == agent) {
                agent = new CdaAgentVO();
                agent.setAgentAlias(emptyObject.getString("ysq_agent_alias"));
            }
            if (duplicateFile != null && "yes".equals(shareFile.getIsOverwrite())) {
                EsUtils.addFileEsIndex(shareFileId, newName, OperateFileLog.Type.AGENT_RECOVER.getType(), process, UserUtils.getCurrUserId(), emptyObject.getLong("ysq_org_id"), agent.getAgentAlias());
            } else {
                EsUtils.addFileEsIndex(shareFileId, newName, OperateFileLog.Type.AGENT_UPLOAD.getType(), process, UserUtils.getCurrUserId(), emptyObject.getLong("ysq_org_id"), agent.getAgentAlias());
            }
        }
        return CustomApiResult.success((Object)ISearchCustomApiResultVO.success(emptyObject.get("ysq_file_name")));
    }

    public static void saveShareFile(DynamicObject emptyObject, String filename) {
        emptyObject.set("billno", (Object)ShareFileServiceHelper.getBillNo());
        emptyObject.set("billstatus", (Object)"A");
        emptyObject.set("ysq_create_user_name", (Object)RequestContext.get().getUserName());
        emptyObject.set("ysq_cur_org_name", (Object)UserUtils.getDptNameById(UserUtils.getDptId()));
        emptyObject.set("ysq_last_oper_time", (Object)new Date());
        emptyObject.set("ysq_file_type", (Object)filename.substring(filename.lastIndexOf(".") + 1));
        emptyObject.set("ysq_file_name", (Object)filename);
        emptyObject.set("ysq_file_name_low", (Object)filename.toLowerCase());
        emptyObject.set("ysq_operator", (Object)UserUtils.getCurrUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{emptyObject});
    }

    public static String renameFile(String fileName) {
        String fileType = null;
        String fileNameLow = null;
        int typeSplitIndex = fileName.lastIndexOf(".");
        if (typeSplitIndex > 0) {
            fileType = fileName.substring(typeSplitIndex + 1);
            fileName = fileName.substring(0, typeSplitIndex);
            fileNameLow = fileName.substring(0, typeSplitIndex).toLowerCase();
        }
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        QFilter fileTypeFilter = new QFilter("ysq_file_type", "=", (Object)fileType);
        list.add(fileTypeFilter);
        QFilter nameFilter = new QFilter("ysq_file_name_low", "like", (Object)(fileNameLow + "%"));
        list.add(nameFilter);
        QFilter[] filterArr = new QFilter[list.size()];
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"ysq_rpa_sfile", (String)YsqShareFileConstant.selAllFileds(), (QFilter[])list.toArray(filterArr));
        ArrayList<String> l1 = new ArrayList<String>();
        for (DynamicObject dynamicObject : load) {
            l1.add(dynamicObject.getString("ysq_file_name_low"));
        }
        String newName = "";
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            String tempName = fileName + "(" + i + ")" + "." + fileType;
            String tempNameLow = fileNameLow + "(" + i + ")" + "." + fileType;
            if (l1.contains(tempNameLow)) continue;
            newName = tempName;
            break;
        }
        return newName;
    }

    private static String fileTypeToLowerCase(String fileName) {
        String[] split = fileName.split("\\.");
        String fileType = split[split.length - 1].toLowerCase();
        int i = fileName.lastIndexOf(".");
        String substring = fileName.substring(0, i);
        return substring + "." + fileType;
    }

    public static CustomApiResult pyLoadFile(FileQueryVO queryVO) {
        List<Long> childOrg;
        String fileTag;
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        String fileName = queryVO.getFileName();
        if (StringUtils.isNotEmpty((CharSequence)fileName)) {
            QFilter nameFilter = new QFilter("ysq_file_name_low", "like", (Object)("%" + fileName.trim().toLowerCase() + "%"));
            list.add(nameFilter);
        }
        if (StringUtils.isNotEmpty((CharSequence)(fileTag = queryVO.getFileTag()))) {
            String[] split = fileTag.split(",");
            Set fileTags = Arrays.stream(split).filter(item -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{item})).collect(Collectors.toSet());
            QFilter tagFilter = null;
            for (String tag : fileTags) {
                if (tagFilter == null) {
                    tagFilter = new QFilter("ysq_file_tag", "like", (Object)("%" + tag + "%"));
                    continue;
                }
                tagFilter = tagFilter.or(new QFilter("ysq_file_tag", "like", (Object)("%" + tag + "%")));
            }
            if (tagFilter != null) {
                list.add(tagFilter);
            }
        }
        String commToken = (String)ServiceApiContext.getRequest().getRequestHeaders().get("commtoken");
        String procCode = (String)ServiceApiContext.getRequest().getRequestHeaders().get("proccode");
        QFilter orgFilter = null;
        if (commToken == null) {
            long orgId = RequestContext.get().getOrgId();
            childOrg = UserUtils.getChildOrg(orgId);
            orgFilter = new QFilter("org", "in", childOrg);
            list.add(orgFilter);
        } else {
            QFilter proCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
            DynamicObject procDynamicObject = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)"org", (QFilter[])new QFilter[]{proCodeFilter});
            if (procDynamicObject == null) {
                return CustomApiResult.success((Object)ISearchCustomApiResultVO.fail("\u6d41\u7a0b\u7f16\u53f7\u4e3a\uff1a" + procCode + "\u7684\u6d41\u7a0b\u4e0d\u5b58\u5728", 1));
            }
            childOrg = UserUtils.getChildOrg(procDynamicObject.getLong("org"));
            orgFilter = new QFilter("org", "in", childOrg);
            list.add(orgFilter);
        }
        QFilter[] filters = new QFilter[list.size()];
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"ysq_rpa_sfile", (String)YsqShareFileConstant.selAllFileds(), (QFilter[])list.toArray(filters), (String)"", (int)queryVO.getPage(), (int)queryVO.getSize());
        DynamicObject[] total = BusinessDataServiceHelper.load((String)"ysq_rpa_sfile", (String)YsqShareFileConstant.selAllFileds(), (QFilter[])list.toArray(filters));
        ArrayList<ShareFileDTO> res = new ArrayList<ShareFileDTO>();
        for (DynamicObject dynamicObject : load) {
            ShareFileDTO dto = new ShareFileDTO();
            dto.setId(dynamicObject.getLong("id"));
            dto.setFileName(dynamicObject.getString("ysq_file_name"));
            dto.setFileSize(Long.valueOf(dynamicObject.getString("ysq_file_size")));
            dto.setFileDesc(dynamicObject.getString("ysq_file_desc"));
            dto.setFileType(dynamicObject.getString("ysq_file_type"));
            dto.setThird(Boolean.valueOf(dynamicObject.getString("ysq_is_third")));
            dto.setCurOrgName(dynamicObject.getString("ysq_cur_org_name"));
            dto.setJobNo(dynamicObject.getString("ysq_job_no"));
            dto.setSchName(dynamicObject.getString("ysq_sch_name"));
            dto.setProcCode(dynamicObject.getString("ysq_proc_code"));
            dto.setProcName(dynamicObject.getString("ysq_proc_name"));
            dto.setAgentNo(dynamicObject.getString("ysq_agent_no"));
            dto.setAgentAlias(dynamicObject.getString("ysq_agent_alias"));
            dto.setAgentType(dynamicObject.getString("ysq_agent_type"));
            dto.setLastOperType(dynamicObject.getString("ysq_last_oper_type"));
            dto.setLastOperTime(Timestamp.valueOf(dynamicObject.getString("ysq_last_oper_time")));
            dto.setFileCreateType(Integer.valueOf(dynamicObject.getString("ysq_file_create_type")));
            dto.setOperator(dynamicObject.getString("ysq_operator"));
            dto.setCreateTime(DateUtils.dateToTimeStamp(dynamicObject.getString("createtime")));
            dto.setFileTag(dynamicObject.getString("ysq_file_tag"));
            res.add(dto);
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("items", res);
        result.put("total", Integer.valueOf(total.length));
        return CustomApiResult.success((Object)ISearchCustomApiResultVO.success(result));
    }

    public static void shareFileDelete(ShareFileDelModel fileDel) {
        if (StringUtils.isBlank((CharSequence)fileDel.getFileName())) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.RPA_SHARE_FILE_FILENAME_NULL.getCode() + "", ResultStatusEnums.RPA_SHARE_FILE_FILENAME_NULL.getCodeMsg());
            throw new KDException(errorCode, new Object[0]);
        }
        QFilter fileNameFilter = new QFilter("ysq_file_name_low", "=", (Object)fileDel.getFileName().trim().toLowerCase());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"ysq_rpa_sfile", (String)YsqShareFileConstant.selAllFileds(), (QFilter[])new QFilter[]{fileNameFilter});
        if (dynamicObject == null) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.RPA_SHARE_FILE_NOEXIST.getCode() + "", ResultStatusEnums.RPA_SHARE_FILE_NOEXIST.getCodeMsg());
            throw new KDException(errorCode, new Object[0]);
        }
        long fileOrg = dynamicObject.getLong("org");
        Map requestHeaders = ServiceApiContext.getRequest().getRequestHeaders();
        String procCode = (String)requestHeaders.get("proccode");
        ShareFileServiceHelper.checkFileOrgPower(fileOrg, procCode);
        long orgId = dynamicObject.getLong("ysq_org_id");
        long fileId = dynamicObject.getLong("id");
        String jobNo = fileDel.getJobNo();
        DynamicObject process = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_sfile");
        process.set("ysq_proc_name", dynamicObject.get("ysq_proc_name"));
        process.set("ysq_proc_code", dynamicObject.get("ysq_proc_code"));
        if (dynamicObject != null && StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("ysq_job_no"))) {
            QFilter jobNoFilter = new QFilter("ysq_job_no", "=", (Object)dynamicObject.getString("ysq_job_no"));
            DynamicObject job = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])new QFilter[]{jobNoFilter});
            if (job != null) {
                long fileCount = job.getLong("ysq_file_ref_count");
                if (--fileCount < 0L) {
                    fileCount = 0L;
                }
                job.set("ysq_file_ref_count", (Object)fileCount);
                SaveServiceHelper.update((DynamicObject)job);
            }
        }
        DeleteServiceHelper.delete((String)"ysq_rpa_sfile", (QFilter[])new QFilter[]{fileNameFilter});
        AttachmentServiceHelper.remove((String)"ysq_rpa_sfile", (Object)dynamicObject.getLong("id"));
        ShareFileServiceHelper.updateJobFileNum(jobNo, null);
        String commToken = (String)ServiceApiContext.getRequest().getRequestHeaders().get("commtoken");
        if (StringUtils.isEmpty((CharSequence)commToken)) {
            EsUtils.addFileEsIndex(fileId, fileDel.getFileName(), OperateFileLog.Type.STUDIO_DELETE.getType(), null, UserUtils.getCurrUserId(), orgId, null);
        } else {
            CdaAgentVO agent = AgentServiceHelper.checkCommonToken(commToken);
            if (null == agent) {
                agent = new CdaAgentVO();
                agent.setAgentAlias(dynamicObject.getString("ysq_agent_alias"));
            }
            EsUtils.addFileEsIndex(fileId, fileDel.getFileName(), OperateFileLog.Type.AGENT_DELETE.getType(), process, UserUtils.getCurrUserId(), orgId, agent.getAgentAlias());
        }
    }

    private static void checkFileOrgPower(long fileOrg, String procCode) {
        if (StringUtils.isBlank((CharSequence)procCode)) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.NULL_PARAM.getCode() + "", ResultStatusEnums.NULL_PARAM.getCodeMsg());
            throw new KDException(errorCode, new Object[0]);
        }
        QFilter proFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObject procDynamicObject = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)"org", (QFilter[])new QFilter[]{proFilter});
        String commToken = (String)ServiceApiContext.getRequest().getRequestHeaders().get("commtoken");
        if (procDynamicObject == null || StringUtils.isEmpty((CharSequence)commToken)) {
            long orgId = RequestContext.get().getOrgId();
            List<Long> childOrg = UserUtils.getChildOrg(orgId);
            if (!childOrg.contains(fileOrg)) {
                ErrorCode errorCode = new ErrorCode(ResultStatusEnums.RPA_SHARE_FILE_NO_PERMISSION.getCode() + "", ResultStatusEnums.RPA_SHARE_FILE_NO_PERMISSION.getCodeMsg());
                throw new KDException(errorCode, new Object[0]);
            }
        } else {
            long proOrg = procDynamicObject.getLong("org");
            List<Long> childOrg = UserUtils.getChildOrg(proOrg);
            if (!childOrg.contains(fileOrg)) {
                ErrorCode errorCode = new ErrorCode(ResultStatusEnums.RPA_SHARE_FILE_NO_PERMISSION.getCode() + "", ResultStatusEnums.RPA_SHARE_FILE_NO_PERMISSION.getCodeMsg());
                throw new KDException(errorCode, new Object[0]);
            }
        }
    }

    public static void updateJobFileNum(String oldJobNo, DynamicObject curJob) {
        try {
            int anInt;
            DynamicObject tmpJob;
            DynamicObject[] load;
            QFilter[] qFilters;
            QFilter jobNoFilter;
            if (StringUtils.isNotBlank((CharSequence)oldJobNo)) {
                jobNoFilter = new QFilter("ysq_job_no", "=", (Object)oldJobNo);
                qFilters = new QFilter[]{jobNoFilter};
                load = BusinessDataServiceHelper.load((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])qFilters);
                if (load.length > 0 && null != (tmpJob = load[0])) {
                    anInt = tmpJob.getInt("ysq_file_ref_count");
                    tmpJob.set("ysq_file_ref_count", (Object)(anInt > 0 ? anInt - 1 : 0));
                    SaveServiceHelper.update((DynamicObject)tmpJob);
                }
            }
            if (null != curJob) {
                jobNoFilter = new QFilter("ysq_job_no", "=", (Object)curJob.getString("ysq_job_no"));
                qFilters = new QFilter[]{jobNoFilter};
                load = BusinessDataServiceHelper.load((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])qFilters);
                if (load.length > 0 && null != (tmpJob = load[0])) {
                    anInt = tmpJob.getInt("ysq_file_ref_count");
                    tmpJob.set("ysq_file_ref_count", (Object)(anInt + 1));
                    SaveServiceHelper.update((DynamicObject)tmpJob);
                }
            }
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u5173\u8054\u6587\u4ef6\u6570\u66f4\u65b0\u9519\u8bef\uff01 {}", (Throwable)e);
        }
    }

    public static DynamicObject queryOneFile(ShareFileSimpleDownModel simpleDown) {
        QFilter fileTypeFilter;
        QFilter eqFilter;
        String isLast;
        String procCode = (String)ServiceApiContext.getRequest().getRequestHeaders().get("proccode");
        if (StringUtils.isBlank((CharSequence)procCode)) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.SHARE_FILE_PARAMS_NULL.getCode() + "", ResultStatusEnums.SHARE_FILE_PARAMS_NULL.getCodeMsg());
            throw new KDException(errorCode, new Object[0]);
        }
        ArrayList<QFilter> fileFilters = new ArrayList<QFilter>();
        String fileName = simpleDown.getFileName();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.RPA_SHARE_FILE_FILENAME_NULL.getCode() + "", ResultStatusEnums.RPA_SHARE_FILE_FILENAME_NULL.getCodeMsg());
            throw new KDException(errorCode, new Object[0]);
        }
        fileName = fileName.trim().toLowerCase();
        String fileType = null;
        int typeSplitIndex = fileName.lastIndexOf(".");
        if (typeSplitIndex > 0) {
            fileType = fileName.substring(typeSplitIndex + 1);
            fileName = fileName.substring(0, typeSplitIndex);
        }
        if (StringUtils.isBlank(fileType)) {
            fileType = "";
        }
        if (null == (isLast = simpleDown.getIsLaster())) {
            isLast = "yes";
        }
        String fileNameReg = null;
        if ("yes".equals(isLast)) {
            QFilter fileTypeFilter2;
            QFilter fileNameFilter;
            QFilter eqFilter2;
            QFilter likeFilter;
            QFilter likeRightFilter;
            QFilter likeLeftFilter;
            fileNameReg = "^(\\(\\d+\\))*$";
            if (StringUtils.isNotBlank((CharSequence)fileType)) {
                likeLeftFilter = new QFilter("ysq_file_name_low", "like", (Object)("%)." + fileType));
                likeRightFilter = new QFilter("ysq_file_name_low", "like", (Object)(fileName + "(" + "%"));
                likeFilter = likeLeftFilter.and(likeRightFilter);
                eqFilter2 = new QFilter("ysq_file_name_low", "=", (Object)(fileName + "." + fileType));
                fileNameFilter = likeFilter.or(eqFilter2);
                fileTypeFilter2 = new QFilter("ysq_file_type", "=", (Object)fileType);
                fileFilters.add(fileNameFilter);
                fileFilters.add(fileTypeFilter2);
            } else {
                likeLeftFilter = new QFilter("ysq_file_name_low", "like", (Object)"%)");
                likeRightFilter = new QFilter("ysq_file_name_low", "like", (Object)(fileName + "(" + "%"));
                likeFilter = likeLeftFilter.and(likeRightFilter);
                eqFilter2 = new QFilter("ysq_file_name_low", "=", (Object)fileName);
                fileNameFilter = likeFilter.or(eqFilter2);
                fileTypeFilter2 = QFilter.isNull((String)"ysq_file_type");
                fileFilters.add(fileNameFilter);
                fileFilters.add(fileTypeFilter2);
            }
        } else if (StringUtils.isBlank((CharSequence)fileType)) {
            eqFilter = new QFilter("ysq_file_name_low", "=", (Object)fileName);
            fileTypeFilter = QFilter.isNull((String)"ysq_file_type");
            fileFilters.add(eqFilter);
            fileFilters.add(fileTypeFilter);
        } else {
            eqFilter = new QFilter("ysq_file_name_low", "=", (Object)(fileName + "." + fileType));
            fileTypeFilter = new QFilter("ysq_file_type", "=", (Object)fileType);
            fileFilters.add(eqFilter);
            fileFilters.add(fileTypeFilter);
        }
        QFilter[] qFilters = fileFilters.toArray(new QFilter[fileFilters.size()]);
        DynamicObjectCollection fileList = QueryServiceHelper.query((String)"ysq_rpa_sfile", (String)YsqShareFileConstant.selAllFileds(), (QFilter[])qFilters, (String)"ysq_last_oper_time desc");
        if (null != fileList && fileList.size() > 0) {
            if (null == fileNameReg) {
                ShareFileServiceHelper.checkFileOrgPower(((DynamicObject)fileList.get(0)).getLong("org"), procCode);
                return (DynamicObject)fileList.get(0);
            }
            for (DynamicObject tmpFile : fileList) {
                try {
                    long orgObj = tmpFile.getLong("org");
                    ShareFileServiceHelper.checkFileOrgPower(orgObj, procCode);
                }
                catch (KDException e) {
                    continue;
                }
                String tmpFileName = tmpFile.getString("ysq_file_name_low");
                if (StringUtils.isBlank((CharSequence)fileType) || fileType == null) {
                    if (tmpFileName.equals(fileName)) {
                        return tmpFile;
                    }
                    tmpFileName = tmpFileName.substring(fileName.length());
                } else {
                    if (tmpFileName.equals(fileName + "." + fileType)) {
                        return tmpFile;
                    }
                    tmpFileName = tmpFileName.substring(fileName.length(), tmpFileName.length() - fileType.length() - 1);
                }
                if (!Pattern.matches(fileNameReg, tmpFileName)) continue;
                return tmpFile;
            }
        }
        return null;
    }

    public static DynamicObject[] queryFileList(ShareFileBatchDownModel batchDown) {
        String procCode = (String)ServiceApiContext.getRequest().getRequestHeaders().get("proccode");
        if (StringUtils.isBlank((CharSequence)procCode)) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.SHARE_FILE_PARAMS_NULL.getCode() + "", ResultStatusEnums.SHARE_FILE_PARAMS_NULL.getCodeMsg());
            throw new KDException(errorCode, new Object[0]);
        }
        QFilter likeFilter = new QFilter("ysq_file_name_low", "like", (Object)("%" + batchDown.getFileName().trim() + "%"));
        DynamicObjectCollection shareFileCollection = QueryServiceHelper.query((String)"ysq_rpa_sfile", (String)YsqShareFileConstant.selAllFileds(), (QFilter[])new QFilter[]{likeFilter});
        String fileTag = batchDown.getFileTag();
        if (StringUtils.isNotEmpty((CharSequence)fileTag)) {
            String[] split = fileTag.split(",");
            Set fileTags = Arrays.stream(split).filter(item -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{item})).collect(Collectors.toSet());
            for (String tag : fileTags) {
                likeFilter = likeFilter.or(new QFilter("ysq_file_tag", "like", (Object)("%" + tag + "%")));
            }
        }
        DynamicObject process = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)"org", (QFilter[])new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)procCode)});
        List<Long> orgList = null;
        String commToken = (String)ServiceApiContext.getRequest().getRequestHeaders().get("commtoken");
        if (process == null || StringUtils.isEmpty((CharSequence)commToken)) {
            long orgId = RequestContext.get().getOrgId();
            orgList = UserUtils.getChildOrg(orgId);
        } else {
            long proOrg = process.getLong("org");
            orgList = UserUtils.getChildOrg(proOrg);
        }
        List<Long> finalOrgList = orgList;
        List<DynamicObject> collect = shareFileCollection.stream().filter(file -> finalOrgList.contains(file.getLong("org"))).collect(Collectors.toList());
        DynamicObject[] files = new DynamicObject[collect.size()];
        return collect.toArray(files);
    }

    public static InputStream batchFile(DynamicObject[] shareFileList, String dirPath) {
        FileService fs = FileServiceFactory.getAttachmentFileService();
        String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.93 Safari/537.36";
        BatchDownloadRequest.Dir attFileDir = ShareFileServiceHelper.createDirAndFileByAttFile("ysq_rpa_sfile", shareFileList, dirPath);
        BatchDownloadRequest bdr = new BatchDownloadRequest("alldownload");
        bdr.setDirs(new BatchDownloadRequest.Dir[]{attFileDir});
        FileOutputStream out = null;
        String url = "";
        try {
            File file = File.createTempFile("batchZip", ".zip");
            out = new FileOutputStream(file);
            fs.batchDownload(bdr, (OutputStream)out, userAgent);
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            url = cache.saveAsUrl(file.getName(), (InputStream)new FileInputStream(file), 120);
            URL down = new URL(RequestContext.get().getClientFullContextPath() + url + "&access_token=" + "1422473158618776576_U8xDARGadbSFFTNb8lS3nUR7w9BaJgHpRCKOJyiexbSB1paxZ6EPBeSeWAYvrXEoNYD7P5jxkeicPe1h2VmSDpMVr8Ep1k2zRjup");
            HttpURLConnection conn = (HttpURLConnection)down.openConnection();
            conn.setRequestMethod("GET");
            conn.setUseCaches(false);
            conn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("User-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            return conn.getInputStream();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static BatchDownloadRequest.Dir createDirAndFileByAttFile(String attachmentfield, DynamicObject[] shareFileList, String dirPath) {
        BatchDownloadRequest.Dir attFileDir = new BatchDownloadRequest.Dir(dirPath);
        ArrayList<BatchDownloadRequest.File> attFileFile = new ArrayList<BatchDownloadRequest.File>();
        for (DynamicObject dynamicObject : shareFileList) {
            List attachmentpanel = AttachmentServiceHelper.getAttachments((String)attachmentfield, (Object)dynamicObject.getLong("id"), (String)ATTACHMENT_PANEL);
            if (attachmentpanel.size() <= 0) continue;
            String url = ((Map)attachmentpanel.get(0)).get("url").toString();
            HashMap<String, String> map = new HashMap<String, String>();
            try {
                String[] querys;
                URL urls = new URL(url);
                String query = urls.getQuery();
                for (String param : querys = query.split("&")) {
                    String key = param.split("=")[0];
                    String value = param.split("=")[1];
                    map.put(key, value);
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            String path = (String)map.get("path");
            String name = ((Map)attachmentpanel.get(0)).get("name").toString();
            BatchDownloadRequest.File aFile = new BatchDownloadRequest.File(name, path);
            attFileFile.add(aFile);
        }
        BatchDownloadRequest.File[] files = attFileFile.toArray(new BatchDownloadRequest.File[attFileFile.size()]);
        attFileDir.setFiles(files);
        return attFileDir;
    }

    public static Map<String, Long> getFileCapacity() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        QFilter keyFilter = new QFilter("ysq_key", "=", (Object)"ysq_file_capacity");
        DynamicObject config = BusinessDataServiceHelper.loadSingle((String)"ysq_sys_config", (String)YsqSysConfigConstant.selAllFileds(), (QFilter[])new QFilter[]{keyFilter});
        String sSql = "SELECT ysq_file_size FROM ysq_rpa_sfile ";
        DataSet dsResult = ORM.create().queryDataSet(ShareFileServiceHelper.class.getName(), sSql, new Object[0]);
        DataSet fileSizeList = dsResult.groupBy().sum("ysq_file_size", "ysq_file_size").finish();
        DynamicObjectCollection dCollection = ORM.create().toPlainDynamicObjectCollection(fileSizeList);
        if (dCollection.size() > 0) {
            long fileSize = ((DynamicObject)dCollection.get(0)).getLong("ysq_file_size");
            map.put("used", fileSize);
            map.put("total", config.getLong("ysq_value"));
        } else {
            map.put("used", 0L);
            map.put("total", config.getLong("ysq_value"));
        }
        return map;
    }
}

