/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.servicehelper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.open.res.model.ThirdAppApplyDto;
import kd.bos.open.res.util.ResourceClientUtil;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;
import kd.bos.openapi.base.util.HttpClientOpenUtils;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.security.ApiSecurityService;
import kd.bos.openapi.security.model.SignInfoDto;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqSysConfigConstant;
import ysq.rpac.rpamc.common.task.AppUpdateTask;

public class Source2AppServiceHelper {
    private static Log log = LogFactory.getLog(Source2AppServiceHelper.class);
    private static String HmacSHA256 = "HmacSHA256";
    private static String getAppList = "kapi/v2/kdec/kdec_rpac_resource/basic/getAppList";
    private static String getAllEdition = "kapi/v2/kdec/kdec_rpac_resource/basic/getAllEdition";
    private static String getEditionIpkgFileUrl = "kapi/v2/kdec/kdec_rpac_resource/basic/getEditionIpkgFileUrl";
    private static String getAppToken = "api/getAppToken.do";
    private static String getAccessToken = "api/login.do";

    private static ThirdAppApplyDto getResourceClientInfo() {
        log.info("----------------\u83b7\u53d6thirdAppApplyDto---start------------------");
        ThirdAppApplyDto thirdAppApplyDto = ResourceClientUtil.findResourceClientInfo();
        log.info("----------------\u83b7\u53d6thirdAppApplyDto----end-----------------");
        if (thirdAppApplyDto == null) {
            log.info("\u83b7\u53d6thirdAppApplyDto\u5931\u8d25");
            throw new OpenApiException(ApiErrorCode.Data_NotFound, ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u5e94\u7528\u672a\u5f00\u901a\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"OpenApiCloudUpdatePlugin_4", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
        return thirdAppApplyDto;
    }

    public static Map<String, String> getSourceInfo() {
        ThirdAppApplyDto resourceClientInfo = Source2AppServiceHelper.getResourceClientInfo();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("number", resourceClientInfo.getThirdcode());
        hashMap.put("name", resourceClientInfo.getName());
        hashMap.put("publickey", resourceClientInfo.getPublickey());
        hashMap.put("accesstoken", resourceClientInfo.getAccesstoken());
        hashMap.put("status", resourceClientInfo.getBillstatus());
        hashMap.put("fileserver", resourceClientInfo.getFileserver());
        hashMap.put("server_accountid", resourceClientInfo.getTargetaccountid());
        hashMap.put("phone", resourceClientInfo.getPhone());
        String targeturl = resourceClientInfo.getTargeturl();
        if (StringUtils.isNotBlank((CharSequence)targeturl)) {
            char c = targeturl.charAt(targeturl.length() - 1);
            if (c != '/') {
                targeturl = targeturl + "/";
            }
            hashMap.put("server_url", targeturl);
        }
        hashMap.put("tenantid", resourceClientInfo.getTenantid());
        hashMap.put("accountid", resourceClientInfo.getAccountid());
        return hashMap;
    }

    public static InputStream getFileInputStream(String ipkgFileUrl) {
        Map<String, String> apply = Source2AppServiceHelper.getSourceInfo();
        if (MapUtils.isEmpty(apply)) {
            return null;
        }
        InputStream inputStream = null;
        try {
            String appTokenUrl = apply.get("server_url") + getAppToken;
            log.info("\u83b7\u53d6AppToken\u7684URL" + appTokenUrl);
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", "text/plain");
            header.put("Accept", "*/*");
            header.put("Accept-Encoding", "gzip, deflate, br");
            header.put("Connection", "keep-alive");
            HashMap<String, String> appTokenReqBody = new HashMap<String, String>();
            appTokenReqBody.put("appId", apply.get("number"));
            appTokenReqBody.put("appSecret", apply.get("accesstoken"));
            appTokenReqBody.put("accountId", apply.get("server_accountid"));
            appTokenReqBody.put("language", "zh_CN");
            JSONObject appTokenBodyJsonObj = (JSONObject)JSON.toJSON(appTokenReqBody);
            String appTokenParams = appTokenBodyJsonObj.toString();
            log.info("\u83b7\u53d6apptoken\u7684\u8bf7\u6c42\u4f53" + appTokenParams);
            String appTokenResponse = HttpClientOpenUtils.postjson((String)appTokenUrl, header, (String)appTokenParams);
            log.info("\u83b7\u53d6AppToken\u7684\u7ed3\u679c" + appTokenResponse);
            if (StringUtils.isBlank((CharSequence)appTokenResponse)) {
                return null;
            }
            JSONObject appTokenJSONObj = JSON.parseObject((String)appTokenResponse);
            Boolean status = appTokenJSONObj.getBoolean("status");
            if (!status.booleanValue()) {
                return null;
            }
            JSONObject appTokenData = appTokenJSONObj.getJSONObject("data");
            String appToken = appTokenData.getString("app_token");
            String accessTokenUrl = apply.get("server_url") + getAccessToken;
            log.info("\u83b7\u53d6AppToken\u7684URL" + accessTokenUrl);
            HashMap<String, String> accessBody = new HashMap<String, String>();
            accessBody.put("user", apply.get("number"));
            accessBody.put("usertype", "UserName");
            accessBody.put("apptoken", appToken);
            accessBody.put("accountId", apply.get("server_accountid"));
            accessBody.put("logintype", "2");
            JSONObject accessObj = (JSONObject)JSON.toJSON(accessBody);
            String accessParams = accessObj.toString();
            log.info("\u83b7\u53d6apptoken\u7684\u8bf7\u6c42\u4f53" + accessParams);
            String accessTokenResponse = HttpClientOpenUtils.postjson((String)accessTokenUrl, header, (String)accessParams);
            log.info("\u83b7\u53d6accessToken\u7684\u7ed3\u679c" + accessTokenResponse);
            if (StringUtils.isBlank((CharSequence)accessTokenResponse)) {
                return null;
            }
            JSONObject accessTokenJSONObj = JSON.parseObject((String)accessTokenResponse);
            Boolean accessTokenRespStatus = accessTokenJSONObj.getBoolean("status");
            if (!accessTokenRespStatus.booleanValue()) {
                return null;
            }
            JSONObject accessTokenData = accessTokenJSONObj.getJSONObject("data");
            String accessToken = accessTokenData.getString("access_token");
            log.info("\u643a\u5e26accessToken\u8bf7\u6c42ipkg\u5730\u5740" + ipkgFileUrl + "&access_token=" + accessToken);
            URL path = new URL(ipkgFileUrl + "&access_token=" + accessToken);
            HttpURLConnection conn = (HttpURLConnection)path.openConnection();
            conn.setRequestMethod("POST");
            conn.setUseCaches(false);
            conn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("User-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            inputStream = conn.getInputStream();
            log.info("\u8bf7\u6c42Ipkg\u540e\u62ff\u5230\u7684\u6d41\u7684\u5927\u5c0f\uff1a" + inputStream.available());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inputStream;
    }

    public static List<Map> getProcessList(@NotNull String peimitCode, @NotNull String permitGroupId, @NotNull String productType) {
        Map<String, String> apply = Source2AppServiceHelper.getSourceInfo();
        if (apply == null) {
            return null;
        }
        List result = new ArrayList<Map>();
        HashMap<String, String> header = new HashMap<String, String>();
        HashMap<String, String> body = new HashMap<String, String>();
        log.info("getProcessList-\u8d44\u6e90\u4e91\u6458\u8981\u4fe1\u606f\uff1a" + apply);
        String signatureNonce = UUID.randomUUID().toString();
        log.info("signatureNonce\uff1a" + signatureNonce);
        String timestamp = DateUtil.convertToStr((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
        log.info("timestamp\uff1a" + timestamp);
        Source2AppServiceHelper.getHeader(header, apply, signatureNonce, timestamp);
        body.put("peimitCode", peimitCode);
        body.put("permitGroupId", permitGroupId);
        body.put("productType", productType);
        JSONObject object = (JSONObject)JSON.toJSON(body);
        String params = object.toString();
        String signature = Source2AppServiceHelper.getSignature(apply, apply.get("publickey"), params, timestamp, signatureNonce);
        header.put("signature", signature);
        log.info("signature\uff1a" + signature);
        String response = "";
        try {
            String url = apply.get("server_url") + getAppList;
            log.info("\u8d44\u6e90\u4e91\u8bf7\u6c42\u5730\u5740" + url);
            log.info("\u8d44\u6e90\u4e91\u8bf7\u6c42\u5934" + header);
            log.info("\u8d44\u6e90\u4e91\u8bf7\u6c42\u4f53" + params);
            response = HttpClientOpenUtils.postjson((String)url, header, (String)params);
            log.info("getProcessList\u8bf7\u6c42\u8fd4\u56deresponse" + response);
            if (response != null) {
                JSONObject resultObj = JSON.parseObject((String)response);
                result = resultObj.getJSONArray("data").toJavaList(Map.class);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return result;
        }
        return result;
    }

    public static List<Map> getAllEdition(@NotNull long id) {
        Map<String, String> apply = Source2AppServiceHelper.getSourceInfo();
        if (apply == null) {
            return null;
        }
        List result = new ArrayList<Map>();
        HashMap<String, String> header = new HashMap<String, String>();
        HashMap<String, Long> body = new HashMap<String, Long>();
        String signatureNonce = UUID.randomUUID().toString();
        String timestamp = DateUtil.convertToStr((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
        Source2AppServiceHelper.getHeader(header, apply, signatureNonce, timestamp);
        body.put("id", id);
        JSONObject object = (JSONObject)JSON.toJSON(body);
        String params = object.toString();
        String signature = Source2AppServiceHelper.getSignature(apply, apply.get("publickey"), params, timestamp, signatureNonce);
        header.put("signature", signature);
        String response = "";
        try {
            String url = apply.get("server_url") + getAllEdition;
            log.info("\u8d44\u6e90\u4e91\u5e94\u7528\u7248\u672c\u8bf7\u6c42id" + id);
            log.info("\u8d44\u6e90\u4e91\u5e94\u7528\u7248\u672c\u8bf7\u6c42\u5730\u5740" + url);
            log.info("\u8d44\u6e90\u4e91\u5e94\u7528\u7248\u672c\u8bf7\u6c42\u5934" + header);
            log.info("\u8d44\u6e90\u4e91\u5e94\u7528\u7248\u672c\u8bf7\u6c42\u4f53" + params);
            response = HttpClientOpenUtils.postjson((String)url, header, (String)params);
            log.info("\u8d44\u6e90\u4e91\u5e94\u7528\u7248\u672c\u8bf7\u6c42\u7ed3\u679c" + response);
            if (response != null) {
                JSONObject resultObj = JSON.parseObject((String)response);
                result = resultObj.getJSONArray("data").toJavaList(Map.class);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return result;
        }
        return result;
    }

    public static String getEditionIpkgFileUrl(@NotNull long appId, @NotNull long editionId) {
        Map<String, String> apply = Source2AppServiceHelper.getSourceInfo();
        if (apply == null) {
            return null;
        }
        String result = "";
        HashMap<String, String> header = new HashMap<String, String>();
        HashMap<String, Long> body = new HashMap<String, Long>();
        String signatureNonce = UUID.randomUUID().toString();
        String timestamp = DateUtil.convertToStr((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
        Source2AppServiceHelper.getHeader(header, apply, signatureNonce, timestamp);
        body.put("appId", appId);
        body.put("editionId", editionId);
        JSONObject object = (JSONObject)JSON.toJSON(body);
        String params = object.toString();
        String signature = Source2AppServiceHelper.getSignature(apply, apply.get("publickey"), params, timestamp, signatureNonce);
        header.put("signature", signature);
        String response = "";
        try {
            String url = apply.get("server_url") + getEditionIpkgFileUrl;
            log.info("\u8d44\u6e90\u4e91ipkg\u6587\u4ef6\u8bf7\u6c42appId" + appId + "editionId" + editionId);
            log.info("\u8d44\u6e90\u4e91ipkg\u6587\u4ef6\u8bf7\u6c42\u5730\u5740" + url);
            response = HttpClientOpenUtils.postjson((String)url, header, (String)params);
            log.info("\u8d44\u6e90\u4e91ipkg\u6587\u4ef6\u8bf7\u6c42\u7ed3\u679c" + response);
            if (response != null) {
                JSONObject resultObj = JSON.parseObject((String)response);
                result = resultObj.getString("data");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return result;
        }
        return result;
    }

    private static void getHeader(Map<String, String> header, Map<String, String> apply, String signatureNonce, String timestamp) {
        header.put("appId", apply.get("number"));
        header.put("timestamp", timestamp);
        header.put("signatureNonce", signatureNonce);
        header.put("user", apply.get("number"));
        header.put("usertype", "UserName");
        header.put("accountId", apply.get("server_accountid"));
        header.put("Content-Type", "application/json");
        header.put("Accept", "*/*");
        header.put("Connection", "Keep-Alive");
        header.put("User-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
    }

    private static String getSignature(Map<String, String> apply, String signature, String content, String timestamp, String uuid) {
        SignInfoDto signInfo = new SignInfoDto();
        signInfo.setContent(content);
        signInfo.setDateTime(timestamp);
        signInfo.setSignatureNonce(uuid);
        signInfo.setAuthType("2");
        signInfo.setThirdAppNumber("RPA_APP");
        signInfo.setAccountId(apply.get("accountid"));
        ApiSecurityService apiSecurityService = ApiSecurityFactory.getApiSecurityService();
        String encyptString = apiSecurityService.signingBySha256(signature, signInfo);
        return encyptString;
    }

    public static void startSchedule() {
        QFilter statusFilter = new QFilter("ysq_key", "=", (Object)"app_synchronize");
        DynamicObject config = BusinessDataServiceHelper.loadSingle((String)"ysq_sys_config", (String)YsqSysConfigConstant.selAllFileds(), (QFilter[])new QFilter[]{statusFilter});
        if (!config.getBoolean("ysq_value")) {
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            String ids = "2YAHW11H34LR";
            String jobIds = "2YAE7Y8O=8VF";
            String[] idList = ids.split(",");
            String[] jobIdList = jobIds.split(",");
            for (String id : idList) {
                scheduleManager.enableSchedule(id);
            }
            for (String id : jobIdList) {
                scheduleManager.enableJob(id);
            }
            config.set("ysq_value", (Object)"true");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
            new AppUpdateTask().doTask();
        }
    }
}

