/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.status.job.core;

import java.sql.Timestamp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import ysq.rpac.rpamc.common.cache.RedisCache;
import ysq.rpac.rpamc.common.enums.RedisKeyItemsEnums;
import ysq.rpac.rpamc.common.enums.ResultStatusEnums;
import ysq.rpac.rpamc.common.status.job.model.JobStatusFullInfoVO;
import ysq.rpac.rpamc.common.status.job.model.JobStatusReqInfoVO;
import ysq.rpac.rpamc.common.status.job.utils.JobStatusConfigs;
import ysq.rpac.rpamc.common.task.JobRedoTask;
import ysq.rpac.rpamc.common.utils.DateUtils;

public class JobStatusCache {
    private static final Integer MAX_REDO_TIMES = 10;
    private static Log log = LogFactory.getLog(JobRedoTask.class);
    private static JobStatusCache instance = null;
    private final RedisCache redisUtils = RedisCache.getInstance();

    public static JobStatusCache getInstance() {
        if (null == instance) {
            instance = new JobStatusCache();
        }
        return instance;
    }

    public void handChacheStatus(Long jobId, String jobNo, String status, String putClass) throws Exception {
        this.handChacheStatus(jobId, jobNo, status, DateUtils.getTimestamp(), putClass);
    }

    public void handChacheStatus(Long jobId, String jobNo, String status, Timestamp modifyTime, String putClass) throws Exception {
        Integer threadId = this.buildThreadId(jobId);
        String changgingCacheId = this.buildChangeingIdsKey(jobId);
        JobStatusReqInfoVO jobCache = new JobStatusReqInfoVO(jobId, jobNo, status, modifyTime);
        JobStatusFullInfoVO fullInfo = new JobStatusFullInfoVO(jobId, jobNo, status, modifyTime);
        if (this.checkIsExist(changgingCacheId, jobCache, status)) {
            log.debug("exc: \u4efb\u52a1id\uff1a{}\uff0cjobNO\uff1a{}\uff0c\u8981\u6539\u6210\u72b6\u6001\uff1a{}\uff0c\u5df2\u63d0\u4ea4\uff0c\u672c\u6b21\u4e0d\u63d0\u4ea4\u961f\u5217\u3002\u4fee\u6539\u65f6\u95f4\uff1a{}", new Object[]{jobId, jobNo, status, modifyTime});
            throw new Exception(ResultStatusEnums.JOB_CHANGEING_DELAY.getCodeMsg());
        }
        fullInfo.setPutClass(putClass);
        this.redisUtils.rightPush(this.buildKey(threadId), SerializationUtils.toJsonString((Object)fullInfo));
        log.debug("push: \u4efb\u52a1id\uff1a{}\uff0cjobNO\uff1a{}\uff0c\u8981\u6539\u6210\u72b6\u6001\uff1a{}\uff0c\u5df2\u52a0\u5165\u5904\u7406\u961f\u5217\uff0c\u7b49\u5f85\u5904\u7406\u3002\u4fee\u6539\u65f6\u95f4\uff1a{}", new Object[]{jobId, jobNo, status, modifyTime});
    }

    public boolean handChacheStatusCheck(Long jobId, String jobNo, String status, String putClass) {
        String changgingCacheId = this.buildChangeingIdsKey(jobId);
        JobStatusReqInfoVO jobCache = new JobStatusReqInfoVO(jobId, jobNo, status, DateUtils.getTimestamp());
        return this.checkIsExist(changgingCacheId, jobCache, status);
    }

    public void chacheStatus(Long jobId, String jobNo, String status, String putClass) {
        this.chacheStatus(jobId, jobNo, status, DateUtils.getTimestamp(), putClass);
    }

    public void chacheStatus(Long jobId, String jobNo, String status, Timestamp modifyTime, String putClass) {
        Integer threadId = this.buildThreadId(jobId);
        JobStatusReqInfoVO jobCache = new JobStatusReqInfoVO(jobId, jobNo, status, modifyTime);
        JobStatusFullInfoVO fullInfo = new JobStatusFullInfoVO(jobId, jobNo, status, modifyTime);
        fullInfo.setPutClass(putClass);
        this.redisUtils.rightPush(this.buildKey(threadId), SerializationUtils.toJsonString((Object)fullInfo));
        log.debug("push: \u4efb\u52a1id\uff1a{}\uff0cjobNO\uff1a{}\uff0c\u8981\u6539\u6210\u72b6\u6001\uff1a{}\uff0c\u5df2\u52a0\u5165\u5904\u7406\u961f\u5217\uff0c\u7b49\u5f85\u5904\u7406\u3002\u4fee\u6539\u65f6\u95f4\uff1a{}", new Object[]{jobId, jobNo, status, modifyTime});
    }

    public void chacheStatus(JobStatusFullInfoVO fullInfo, String putClass) {
        fullInfo.setPutClass(putClass);
        Long jobId = fullInfo.getId();
        String status = fullInfo.getStatus();
        Integer threadId = this.buildThreadId(jobId);
        JobStatusReqInfoVO jobCache = new JobStatusReqInfoVO(fullInfo.getId(), fullInfo.getJobNo(), fullInfo.getStatus(), fullInfo.getModifyTime());
        this.redisUtils.rightPush(this.buildKey(threadId), SerializationUtils.toJsonString((Object)fullInfo));
        log.debug("push: \u4efb\u52a1id\uff1a{}\uff0cjobNO\uff1a{}\uff0c\u8981\u6539\u6210\u72b6\u6001\uff1a{}\uff0c\u5df2\u52a0\u5165\u5904\u7406\u961f\u5217\uff0c\u7b49\u5f85\u5904\u7406\u3002\u4fee\u6539\u65f6\u95f4\uff1a{}", new Object[]{jobId, fullInfo.getJobNo(), status, fullInfo.getModifyTime()});
    }

    public JobStatusFullInfoVO popCahche(Integer threadId) {
        JobStatusFullInfoVO fullInfo = (JobStatusFullInfoVO)this.redisUtils.pop(this.buildKey(threadId), JobStatusFullInfoVO.class);
        if (null != fullInfo) {
            Long jobId = fullInfo.getId();
            String changgingCacheId = this.buildChangeingIdsKey(jobId);
            this.redisUtils.delete(new String[]{changgingCacheId});
            log.debug("pop\uff1a\u4efb\u52a1id\uff1a{}\uff0cjobNO\uff1a{}\uff0c\u8981\u6539\u6210\u72b6\u6001\uff1a{}\uff0c\u5df2\u53d6\u51fa\u8fdb\u884c\u5904\u7406\u3002\u4fee\u6539\u65f6\u95f4\uff1a{}", new Object[]{jobId, fullInfo.getJobNo(), fullInfo.getStatus(), fullInfo.getModifyTime()});
            log.debug("del cache\uff1a\u7f13\u5b58cacheid\uff1a{}\uff0c\u5df2\u4ece\u5224\u65ad\u7f13\u5b58\u4e2d\u5220\u9664\u3002", (Object)changgingCacheId);
        } else {
            log.debug("\u672a\u83b7\u53d6\u5230\u5f85\u5904\u7406\u4efb\u52a1");
        }
        return fullInfo;
    }

    public Integer queueNum(Integer threadId) {
        return this.redisUtils.listNum(this.buildKey(threadId));
    }

    private synchronized boolean checkIsExist(String changgingCacheId, JobStatusReqInfoVO jobCache, String status) {
        JobStatusReqInfoVO changeCache = (JobStatusReqInfoVO)this.redisUtils.get(changgingCacheId, JobStatusReqInfoVO.class);
        if (null != changeCache && changeCache.getStatus().equals(status)) {
            return true;
        }
        this.redisUtils.set(changgingCacheId, SerializationUtils.toJsonString((Object)jobCache));
        return false;
    }

    private Integer buildThreadId(Long jobId) {
        int threadNums = JobStatusConfigs.threadNum;
        return (int)(jobId % (long)threadNums);
    }

    private String buildKey(Integer threadId) {
        return RedisKeyItemsEnums.JOB_STATUS_CACHE_H.getKey() + RedisKeyItemsEnums.KEY_SPLIT.getKey() + threadId;
    }

    private String buildChangeingIdsKey(Long jobId) {
        return RedisKeyItemsEnums.JOB_STATUS_CACHEING_IDS_H.getKey() + RedisKeyItemsEnums.KEY_SPLIT.getKey() + jobId;
    }

    public void cacheRedo(Integer threadId, JobStatusFullInfoVO fullInfo) {
        Integer doTimes = fullInfo.getDoTimes();
        if (null == doTimes) {
            doTimes = 0;
        }
        doTimes = doTimes + 1;
        fullInfo.setDoTimes(doTimes);
        if (doTimes < MAX_REDO_TIMES) {
            this.redisUtils.rightPush(this.buildKey(threadId), SerializationUtils.toJsonString((Object)fullInfo));
        }
    }

    private JobStatusCache() {
    }
}

