/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.task;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;

public abstract class AbstractRpaTask
extends AbstractTask {
    protected static final Long TRY_LOCK_TIME = 1000L;
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected DLock lock = null;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.doTask();
    }

    public void doTask() {
        if (this.needLock()) {
            this.lock = DLock.create((String)this.getLockKey());
            if (this.hasLock()) {
                try {
                    this.realDoThread();
                }
                catch (Exception e) {
                    this.log.info("thread run has exception: ", (Object)e);
                }
                finally {
                    this.lock.unlock();
                }
            }
        } else {
            this.realDoThread();
        }
    }

    protected boolean tryLock() {
        if (null == this.lock) {
            return false;
        }
        return this.lock.tryLock(TRY_LOCK_TIME.longValue());
    }

    protected abstract boolean needLock();

    protected abstract String getLockKey();

    protected abstract boolean hasLock();

    protected abstract void realDoThread();
}

