/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.task;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import ysq.rpac.rpamc.common.cache.RedisCache;
import ysq.rpac.rpamc.common.cache.RobotCache;
import ysq.rpac.rpamc.common.constant.YsqAgentConstant;
import ysq.rpac.rpamc.common.enums.RedisKeyItemsEnums;
import ysq.rpac.rpamc.common.enums.RedisLockKeysEnums;
import ysq.rpac.rpamc.common.model.CdaAgentVO;
import ysq.rpac.rpamc.common.status.agent.model.AgentChangeBean;
import ysq.rpac.rpamc.common.task.AbstractRpaTask;

public class AgentChangeTask
extends AbstractRpaTask {
    private static final Integer MAX_FAILED_TIMES = 10;
    private RedisCache redisCache = RedisCache.getInstance();
    private RobotCache robotCache = RobotCache.getInstance();
    private boolean isContinute = true;

    @Override
    protected boolean needLock() {
        return true;
    }

    @Override
    protected String getLockKey() {
        return RedisLockKeysEnums.KEY_HEAD.getKey() + RequestContext.get().getAccountId() + "/" + RedisLockKeysEnums.AGENT_CHANGE.getKey();
    }

    @Override
    protected boolean hasLock() {
        return this.tryLock();
    }

    @Override
    protected void realDoThread() {
        while (this.redisCache.listNum(RedisKeyItemsEnums.ROBOT_STATUS_MODIFY_H.getKey()) > 0) {
            this.changeStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeStatus() {
        AgentChangeBean cacheBean = (AgentChangeBean)this.redisCache.pop(RedisKeyItemsEnums.ROBOT_STATUS_MODIFY_H.getKey(), AgentChangeBean.class);
        Long agentId = cacheBean.getAgentId();
        Date lastHeartTime = cacheBean.getLastHeartTime();
        String dataStatus = cacheBean.getDataStatus();
        cacheBean.addFailedTimes();
        int failedTimes = cacheBean.getFailedTimes();
        boolean isTrue = false;
        try {
            if (failedTimes > MAX_FAILED_TIMES) {
                isTrue = true;
                return;
            }
            DynamicObject agentObj = BusinessDataServiceHelper.loadSingle((Object)agentId, (String)"ysq_rpa_agent", (String)YsqAgentConstant.selAllFileds());
            agentObj.set("ysq_data_status", (Object)dataStatus);
            agentObj.set("ysq_last_heart_time", (Object)lastHeartTime);
            SaveServiceHelper.update((DynamicObject)agentObj);
            this.robotCache.put(agentObj.getString("ysq_comm_token"), new CdaAgentVO().fromDynamicObject(agentObj));
            isTrue = true;
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
        }
        finally {
            if (failedTimes <= MAX_FAILED_TIMES && !isTrue) {
                this.redisCache.rightPush(RedisKeyItemsEnums.ROBOT_STATUS_MODIFY_H.getKey(), SerializationUtils.toJsonString((Object)cacheBean));
            }
        }
    }
}

