/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqAppCenterConstant;
import ysq.rpac.rpamc.common.constant.YsqAppMineConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.enums.ProcessesStatusEnums;
import ysq.rpac.rpamc.common.enums.RedisLockKeysEnums;
import ysq.rpac.rpamc.common.model.ParamsVo;
import ysq.rpac.rpamc.common.model.dto.ParamDTO;
import ysq.rpac.rpamc.common.servicehelper.JobServiceHelper;
import ysq.rpac.rpamc.common.servicehelper.KdFileServiceHelper;
import ysq.rpac.rpamc.common.servicehelper.ScheduleServiceHelper;
import ysq.rpac.rpamc.common.servicehelper.Source2AppServiceHelper;
import ysq.rpac.rpamc.common.task.AbstractRpaTask;
import ysq.rpac.rpamc.common.utils.DateUtils;
import ysq.rpac.rpamc.common.utils.IsearchFileUtils;
import ysq.rpac.rpamc.common.utils.KdPageUtils;
import ysq.rpac.rpamc.common.utils.LicenseUtils;

public class AppUpdateTask
extends AbstractRpaTask {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final int COUNT = 100000;

    @Override
    protected boolean needLock() {
        return true;
    }

    @Override
    protected String getLockKey() {
        return RedisLockKeysEnums.KEY_HEAD.getKey() + RequestContext.get().getAccountId() + "/" + RedisLockKeysEnums.APP_UPDATE.getKey();
    }

    @Override
    protected boolean hasLock() {
        return this.tryLock();
    }

    @Override
    protected void realDoThread() {
        List<Map> appList = Source2AppServiceHelper.getProcessList("", "", LicenseServiceHelper.getModeType() + "");
        if (CollectionUtils.isEmpty(appList)) {
            this.log.warn("\u8d44\u6e90\u4e91\u83b7\u53d6\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\u3002");
            return;
        }
        this.log.info("\u8c03\u7528\u5e94\u7528\u5217\u8868\u63a5\u53e3\u83b7\u5f97\u7684\u6570\u636e" + appList);
        for (Map appInfoMap : appList) {
            String appId = MapUtils.getString((Map)appInfoMap, (Object)"id");
            String appSn = MapUtils.getString((Map)appInfoMap, (Object)"processcode");
            Date modifyTime = DateUtils.parseDate(appInfoMap.get("modifytime").toString());
            DynamicObject appCenterObj = BusinessDataServiceHelper.loadSingle((String)"ysq_app_center", (String)YsqAppCenterConstant.selAllFileds(), (QFilter[])new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)appSn)});
            this.log.info("\u5f00\u59cb\u66f4\u65b0appSn\u4e3a" + appSn + "\u7684AppCenter\u4e3b\u8868");
            if (appCenterObj == null) {
                DynamicObject appCenterAddObj = this.buildAppCenterObj(null, appInfoMap);
                OperationResult operationResult = SaveServiceHelper.saveOperate((String)"ysq_app_center", (DynamicObject[])new DynamicObject[]{appCenterAddObj}, (OperateOption)OperateOption.create());
                if (!operationResult.isSuccess()) {
                    ValidateResultCollection validateResult = operationResult.getValidateResult();
                    List validateErrors = validateResult.getValidateErrors();
                    ValidateResult result = (ValidateResult)validateErrors.get(0);
                    this.log.error("\u83b7\u53d6\u8d44\u6e90\u4e91\u6570\u636e\u540e\u65b0\u589eAppCenter\u6570\u636e\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0(\u6982\u8981)\uff1a" + operationResult.getMessage());
                    this.log.error("\u83b7\u53d6\u8d44\u6e90\u4e91\u6570\u636e\u540e\u65b0\u589eAppCenter\u6570\u636e\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0(\u8be6\u60c5)\uff1a" + result.getAllErrorInfo());
                    continue;
                }
                this.log.info("\u7f16\u53f7\u4e3a\uff1a" + appSn + "\u7684appCenter\u4e3b\u8868\u65b0\u589e\u5b8c\u6210\uff0c\u5f00\u59cb\u66f4\u65b0\u7248\u672c\u8868");
                this.updateAppCenterVer(appId, appSn);
            } else {
                Date updateDate = appCenterObj.getDate("ysq_update_date");
                if (modifyTime.equals(updateDate)) continue;
                appCenterObj = this.buildAppCenterObj(appCenterObj, appInfoMap);
                Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{appCenterObj});
                if (save.length <= 0) {
                    this.log.error("\u83b7\u53d6\u8d44\u6e90\u4e91\u6570\u636e\u540e\u66f4\u65b0AppCenter\u6570\u636e\u5931\u8d25\u3002");
                    continue;
                }
                this.log.info("\u7f16\u53f7\u4e3a\uff1a" + appSn + "\u7684appCente\u4e3b\u8868\u66f4\u65b0\u5b8c\u6210\uff0c\u5f00\u59cb\u66f4\u65b0\u7248\u672c\u8868");
                this.updateAppCenterVer(appId, appSn);
            }
            this.updateAppMine(appInfoMap);
        }
    }

    private DynamicObject buildAppCenterObj(DynamicObject dynamicObject, Map appInfoMap) {
        DynamicObject appCenterObj;
        if (dynamicObject == null) {
            appCenterObj = BusinessDataServiceHelper.newDynamicObject((String)"ysq_app_center");
            appCenterObj.set("name", appInfoMap.get("processcode"));
            appCenterObj.set("creator", (Object)1L);
            appCenterObj.set("createorg", (Object)10000L);
            appCenterObj.set("org", (Object)0L);
            appCenterObj.set("status", (Object)"A");
            appCenterObj.set("enable", (Object)"1");
            appCenterObj.set("ctrlstrategy", (Object)"5");
        } else {
            appCenterObj = dynamicObject;
        }
        appCenterObj.set("modifier", (Object)1L);
        appCenterObj.set("ysq_app_name", appInfoMap.get("name"));
        appCenterObj.set("ysq_dev_com_code", appInfoMap.get("developerscode"));
        appCenterObj.set("ysq_dev_com_name", appInfoMap.get("developersname"));
        appCenterObj.set("ysq_launch_date", (Object)DateUtils.parseDate(appInfoMap.get("createtime").toString()));
        appCenterObj.set("ysq_update_date", (Object)DateUtils.parseDate(appInfoMap.get("modifytime").toString()));
        appCenterObj.set("ysq_last_version", appInfoMap.get("lastestedition"));
        appCenterObj.set("ysq_app_price", (Object)0);
        appCenterObj.set("ysq_app_open_source", (Object)"no");
        appCenterObj.set("ysq_app_special", (Object)"no");
        appCenterObj.set("ysq_app_explain", appInfoMap.get("appdesc"));
        appCenterObj.set("ysq_app_label", appInfoMap.get("keyword"));
        appCenterObj.set("ysq_app_involve_sys", appInfoMap.get("involvesystem"));
        appCenterObj.set("ysq_app_use_helper_tag", (Object)this.splitUseHelper(appInfoMap));
        appCenterObj.set("ysq_proc_code", appInfoMap.get("processcode"));
        appCenterObj.set("ysq_app_product_type", (Object)LicenseServiceHelper.getModeType());
        appCenterObj.set("ysq_app_permit_code", appInfoMap.get("permitcode"));
        appCenterObj.set("ysq_app_group_number", appInfoMap.get("permitid"));
        return appCenterObj;
    }

    private void updateAppCenterVer(String appId, String appSn) {
        try {
            List<Map> allEdition = Source2AppServiceHelper.getAllEdition(Long.valueOf(appId));
            this.log.info("appSn\u4e3a" + appSn + "\u7684\u5e94\u7528\u7248\u672c\u83b7\u5f97\u7684\u6570\u636e\uff1a" + allEdition);
            if (CollectionUtils.isEmpty(allEdition)) {
                return;
            }
            allEdition.sort((o1, o2) -> Math.toIntExact(this.codeToLong(MapUtils.getString((Map)o1, (Object)"processversion")) - this.codeToLong(MapUtils.getString((Map)o2, (Object)"processversion"))));
            DynamicObject appCenterObj = BusinessDataServiceHelper.loadSingle((String)"ysq_app_center", (String)YsqAppCenterConstant.selAllFileds(), (QFilter[])new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)appSn)});
            DynamicObjectCollection appCenterVerCollection = appCenterObj.getDynamicObjectCollection("ysq_rpa_app_center_ver");
            DynamicObjectType entryType = appCenterVerCollection.getDynamicObjectType();
            for (int i = 0; i < allEdition.size(); ++i) {
                Map edition = allEdition.get(i);
                Date modifyTime = DateUtils.parseDate(edition.get("modifytime").toString());
                String editionId = (String)edition.get("id");
                if (appCenterVerCollection.size() - i > 0 && i <= appCenterVerCollection.size() - i) {
                    DynamicObject appCenterVerObj = (DynamicObject)appCenterVerCollection.get(i);
                    Date updateDate = appCenterVerObj.getDate("ysq_app_update_date");
                    if (updateDate.equals(modifyTime)) continue;
                    appCenterVerObj.set("ysq_app_update_date", (Object)modifyTime);
                    appCenterVerObj.set("ysq_app_update_content", edition.get("updatedesc"));
                    appCenterVerObj.set("ysq_app_ver_code", edition.get("processversion"));
                    String editionIpkgFileUrl = Source2AppServiceHelper.getEditionIpkgFileUrl(Long.valueOf(appId), Long.valueOf(editionId));
                    this.log.info("\u5e94\u7528\u4e2d\u5fc3\u7248\u672c\u66f4\u65b0\u83b7\u53d6\u6587\u4ef6url\uff1a" + editionIpkgFileUrl);
                    if (StringUtils.isBlank((CharSequence)editionIpkgFileUrl)) {
                        this.log.warn("\u5e94\u7528\u4e2d\u5fc3\u7248\u672c\u66f4\u65b0\u83b7\u53d6\u6587\u4ef6url\u4e3a\u7a7a\u8df3\u8fc7\u66f4\u65b0");
                        continue;
                    }
                    InputStream inStream = Source2AppServiceHelper.getFileInputStream(editionIpkgFileUrl);
                    if (inStream == null) {
                        this.log.warn("\u5e94\u7528\u4e2d\u5fc3\u7248\u672c\u66f4\u65b0\u83b7\u53d6\u7684\u6d41\u4e3a\u7a7a\u8df3\u8fc7\u66f4\u65b0");
                        continue;
                    }
                    this.log.info("\u5e94\u7528\u4e2d\u5fc3\u7248\u672c\u66f4\u65b0\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f" + inStream.available());
                    DynamicObject attachFieldObj = IsearchFileUtils.uploadFile(inStream);
                    DynamicObjectCollection entryAttaFieldColl = appCenterVerObj.getDynamicObjectCollection("ysq_rpa_app_file");
                    entryAttaFieldColl.clear();
                    DynamicObject atta = new DynamicObject(entryAttaFieldColl.getDynamicObjectType());
                    atta.set("fbasedataId", (Object)attachFieldObj);
                    entryAttaFieldColl.add((Object)atta);
                    Object[] saveAttaResult = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachFieldObj});
                    if (saveAttaResult.length <= 0) {
                        this.log.error("AppCenter\u7248\u672c\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25");
                        continue;
                    }
                    appCenterVerCollection.set(i, (Object)appCenterVerObj);
                    Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{appCenterObj});
                    if (save.length > 0) continue;
                    this.log.error("AppCenter\u7248\u672c\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25");
                    continue;
                }
                DynamicObject entryItem = new DynamicObject(entryType);
                entryItem.set("seq", (Object)(i + 1));
                entryItem.set("ysq_app_ver_code", edition.get("processversion"));
                entryItem.set("ysq_app_update_date", (Object)DateUtils.parseDate(edition.get("modifytime").toString()));
                entryItem.set("ysq_app_update_content", edition.get("updatedesc"));
                String editionIpkgFileUrl = Source2AppServiceHelper.getEditionIpkgFileUrl(Long.valueOf(appId), Long.valueOf(editionId));
                this.log.info("\u5e94\u7528\u4e2d\u5fc3\u7248\u672c\u65b0\u589e\u83b7\u53d6\u6587\u4ef6url\uff1a" + editionIpkgFileUrl);
                if (StringUtils.isNotBlank((CharSequence)editionIpkgFileUrl)) {
                    InputStream inStream = Source2AppServiceHelper.getFileInputStream(editionIpkgFileUrl);
                    if (inStream == null) {
                        this.log.info("\u5e94\u7528\u4e2d\u5fc3\u7248\u672c\u65b0\u589e\u83b7\u53d6\u7684\u6d41\u4e3a\u7a7a\u8df3\u8fc7\u66f4\u65b0");
                        continue;
                    }
                    this.log.info("\u5e94\u7528\u4e2d\u5fc3\u7248\u672c\u65b0\u589e\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f" + inStream.available());
                    DynamicObject attachFieldObj = IsearchFileUtils.uploadFile(inStream);
                    DynamicObjectCollection entryAttaFieldColl = entryItem.getDynamicObjectCollection("ysq_rpa_app_file");
                    DynamicObject atta = new DynamicObject(entryAttaFieldColl.getDynamicObjectType());
                    atta.set("fbasedataId", (Object)attachFieldObj);
                    entryAttaFieldColl.add((Object)atta);
                    Object[] saveAttaResult = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachFieldObj});
                    if (saveAttaResult.length <= 0) {
                        this.log.error("AppCenter\u7248\u672c\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25");
                    }
                }
                appCenterVerCollection.add((Object)entryItem);
                Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{appCenterObj});
                if (save.length > 0) continue;
                this.log.error("AppCenter\u7248\u672c\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25");
            }
        }
        catch (Exception e) {
            this.log.warn("\u66f4\u65b0AppCenterVer\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private Long codeToLong(String verCode) {
        String newStr = verCode.replace(".", "");
        return Long.valueOf(newStr);
    }

    private void updateAppMine(Map appInfoMap) {
        String appId = (String)appInfoMap.get("id");
        String appSn = (String)appInfoMap.get("processcode");
        Date modifyTime = DateUtils.parseDate(appInfoMap.get("modifytime").toString());
        if (!LicenseUtils.checkStdAppLicense(appSn).booleanValue()) {
            this.log.info("\u6d41\u7a0b\u7f16\u53f7\u4e3a\uff1a" + appSn + "\u7684\u5e94\u7528\u65e0\u8bb8\u53ef\u8df3\u8fc7\u66f4\u65b0");
            return;
        }
        DynamicObject appMineObj = BusinessDataServiceHelper.loadSingle((String)"ysq_app_mine", (String)YsqAppMineConstant.selAllFileds(), (QFilter[])new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)appSn)});
        if (appMineObj == null) {
            appMineObj = this.buildAppMineObj(null, appInfoMap);
            this.log.info("\u65b0\u589e\u7684appMine\u5bf9\u8c61\u4fe1\u606f" + appMineObj);
            Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{appMineObj});
            if (save.length <= 0) {
                this.log.info("\u6d41\u7a0b\u7f16\u53f7\u4e3a\uff1a" + appSn + "\u7684\u5e94\u7528,\u6211\u7684\u5e94\u7528\u4e3b\u8868\u65b0\u589e\u5931\u8d25");
                return;
            }
            this.updateAppMineVer(appId, appSn);
            this.updateAppMineFile(appId, appSn);
        } else {
            Date date = appMineObj.getDate("ysq_update_date");
            if (!date.equals(modifyTime)) {
                appMineObj = this.buildAppMineObj(appMineObj, appInfoMap);
                Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{appMineObj});
                if (save.length <= 0) {
                    this.log.info("\u6d41\u7a0b\u7f16\u53f7\u4e3a\uff1a" + appSn + "\u7684\u5e94\u7528,\u6211\u7684\u5e94\u7528\u4e3b\u8868\u66f4\u65b0\u5931\u8d25");
                    return;
                }
                this.updateAppMineVer(appId, appSn);
                this.updateAppMineFile(appId, appSn);
            }
        }
    }

    private DynamicObject buildAppMineObj(DynamicObject dynamicObject, Map appInfoMap) {
        DynamicObject newAppMine = null;
        if (dynamicObject == null) {
            newAppMine = BusinessDataServiceHelper.newDynamicObject((String)"ysq_app_mine");
            newAppMine.set("name", appInfoMap.get("processcode"));
            newAppMine.set("creator", (Object)1L);
            newAppMine.set("createorg", (Object)0L);
            newAppMine.set("status", (Object)"A");
            newAppMine.set("enable", (Object)"1");
            newAppMine.set("ctrlstrategy", (Object)"5");
        } else {
            newAppMine = dynamicObject;
        }
        newAppMine.set("org", (Object)0L);
        newAppMine.set("modifier", (Object)1L);
        newAppMine.set("ysq_app_name", appInfoMap.get("name"));
        newAppMine.set("ysq_dev_com_code", appInfoMap.get("developerscode"));
        newAppMine.set("ysq_dev_com_name", appInfoMap.get("developersname"));
        newAppMine.set("ysq_last_version", appInfoMap.get("lastestedition"));
        newAppMine.set("ysq_app_price", (Object)0);
        newAppMine.set("ysq_app_open_source", (Object)"no");
        newAppMine.set("ysq_app_special", (Object)"no");
        newAppMine.set("ysq_app_explain", appInfoMap.get("appdesc"));
        newAppMine.set("ysq_app_label", appInfoMap.get("keyword"));
        newAppMine.set("ysq_app_involve_sys", appInfoMap.get("involvesystem"));
        newAppMine.set("ysq_app_use_help_tag", (Object)this.splitUseHelper(appInfoMap));
        newAppMine.set("ysq_update_date", (Object)DateUtils.parseDate(appInfoMap.get("modifytime").toString()));
        newAppMine.set("ysq_status", (Object)"Activated");
        newAppMine.set("ysq_proc_code", appInfoMap.get("processcode"));
        return newAppMine;
    }

    private void updateAppMineVer(String appId, String appSn) {
        this.log.info("appSn\u4e3a" + appSn + "\u7684\u6211\u7684\u5e94\u7528\u7248\u672c\u5f00\u59cb\u66f4\u65b0");
        List<Map> allEdition = Source2AppServiceHelper.getAllEdition(Long.valueOf(appId));
        if (CollectionUtils.isEmpty(allEdition)) {
            return;
        }
        allEdition.sort((o1, o2) -> Math.toIntExact(this.codeToLong(MapUtils.getString((Map)o1, (Object)"processversion")) - this.codeToLong(MapUtils.getString((Map)o2, (Object)"processversion"))));
        DynamicObject appMineObj = BusinessDataServiceHelper.loadSingle((String)"ysq_app_mine", (String)YsqAppMineConstant.selAllFileds(), (QFilter[])new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)appSn)});
        DynamicObjectCollection appMineVerCollection = appMineObj.getDynamicObjectCollection("ysq_rpa_app_mine_ver");
        if (appMineVerCollection.size() > 0) {
            appMineVerCollection.clear();
        }
        for (int i = 0; i < allEdition.size(); ++i) {
            Map editionMap = allEdition.get(i);
            DynamicObject appMineVerObj = appMineVerCollection.addNew();
            appMineVerObj.set("ysq_app_ver_code", editionMap.get("processversion"));
            appMineVerObj.set("ysq_fk_proc_code", (Object)appSn);
            appMineVerObj.set("seq", (Object)(i + 1));
            appMineVerObj.set("ysq_app_update_date", (Object)DateUtils.parseDate(editionMap.get("modifytime").toString()));
            appMineVerObj.set("ysq_app_update_content", editionMap.get("updatedesc"));
            Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{appMineObj});
            if (save.length > 0) continue;
            this.log.info("\u6d41\u7a0b\u7f16\u53f7\u4e3a\uff1a" + appSn + "\u7248\u672c\u4e3a\uff1a" + editionMap.get("processversion") + "\u6211\u7684\u5e94\u7528\u7248\u672c\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
        }
    }

    private void updateAppMineFile(String appId, String appSn) {
        this.log.info("==========\u5f00\u59cb\u66f4\u65b0\u6211\u7684\u5e94\u7528\u9644\u4ef6\u90e8\u5206==========");
        List<Map> allEdition = Source2AppServiceHelper.getAllEdition(Long.valueOf(appId));
        if (CollectionUtils.isEmpty(allEdition)) {
            this.log.warn("\u83b7\u53d6\u6d41\u7a0b\u7f16\u53f7\u4e3a" + appSn + "\u7684\u7248\u672c\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        allEdition.sort((o1, o2) -> Math.toIntExact(this.codeToLong(MapUtils.getString((Map)o1, (Object)"processversion")) - this.codeToLong(MapUtils.getString((Map)o2, (Object)"processversion"))));
        Map map = allEdition.get(allEdition.size() - 1);
        String editionId = map.get("id").toString();
        String ipkgFileUrl = Source2AppServiceHelper.getEditionIpkgFileUrl(Long.valueOf(appId), Long.valueOf(editionId));
        if (StringUtils.isBlank((CharSequence)ipkgFileUrl)) {
            this.log.info("\u6211\u7684\u5e94\u7528\u9644\u4ef6\u83b7\u53d6\u7684\u6587\u4ef6\u5730\u5740\uff1a" + ipkgFileUrl);
            return;
        }
        String[] split = ipkgFileUrl.split("/");
        String ipkgName = split[split.length - 1];
        this.log.info("\u6211\u7684\u5e94\u7528\u9644\u4ef6\u83b7\u53d6\u7684\u6587\u4ef6\u540d\uff1a" + ipkgName);
        InputStream ipkgInputStream = Source2AppServiceHelper.getFileInputStream(ipkgFileUrl);
        if (ipkgInputStream == null) {
            this.log.error("\u6211\u7684\u5e94\u7528\u9644\u4ef6\u5904\u7406 \u83b7\u53d6\u6587\u4ef6\u8f93\u5165\u6d41\u4e3a\u7a7a\uff01\uff01\uff01");
            return;
        }
        ByteArrayOutputStream baos = AppUpdateTask.cloneInputStream(ipkgInputStream);
        if (baos == null) {
            this.log.error("\u6211\u7684\u5e94\u7528\u9644\u4ef6\u5904\u7406\u6587\u4ef6\u6d41\u8f6c\u6362\u5931\u8d25\u4e3a\u7a7a\uff01\uff01\uff01");
            return;
        }
        ByteArrayInputStream streamForRead = new ByteArrayInputStream(baos.toByteArray());
        ByteArrayInputStream streamForUpload = new ByteArrayInputStream(baos.toByteArray());
        Map<String, Object> ipkgInfoMap = IsearchFileUtils.readIpkgFile(streamForRead);
        this.log.info("appSn\u4e3a\uff1a" + appSn + "\u7684Ipkg\u5305\u8bfb\u53d6\u540e\u83b7\u5f97\u7684\u4fe1\u606f\uff1a" + ipkgInfoMap);
        int ipkgSize = 0;
        try {
            ipkgSize = ((InputStream)streamForUpload).available();
            this.log.info("ipkg\u6d41\u5927\u5c0f\uff1a" + ipkgSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String ipkgUrl = KdFileServiceHelper.uploadFileToBasAttachment(streamForUpload, null);
        this.log.info("appSn\u4e3a\uff1a" + appSn + "\u7684Ipkg\u4e0a\u4f20\u540e\u7684\u5730\u5740\uff1a" + ipkgUrl);
        QFilter[] qFilters = new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)appSn)};
        DynamicObject object = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)"id", (QFilter[])qFilters);
        long procFid = ID.genLongId();
        long procVerFid = ID.genLongId();
        if (object != null) {
            this.log.info("\u6709\u65e7\u6d41\u7a0b\uff0c\u9700\u8981\u6e05\u7a7a\u5904\u7406");
            AttachmentServiceHelper.remove((String)"ysq_rpa_process", (Object)object.getLong("id"));
            int deletePro = DeleteServiceHelper.delete((String)"ysq_rpa_process", (QFilter[])qFilters);
            this.log.info("\u5220\u9664\u5c31\u6d41\u7a0b\u6761\u6570\uff1a" + deletePro);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])qFilters);
            if (query.size() > 0) {
                AttachmentServiceHelper.remove((String)"ysq_rpa_process_ver", (Object)((DynamicObject)query.get(0)).getLong("id"));
            }
            int deleteProVer = DeleteServiceHelper.delete((String)"ysq_rpa_process_ver", (QFilter[])qFilters);
            this.log.info("\u5220\u9664\u5c31\u6d41\u7a0b\u7248\u672c\u6761\u6570\uff1a" + deleteProVer);
            this.log.info("\u5904\u7406\u6d41\u7a0b\u4fe1\u606f");
            this.saveProcess(procFid, appSn, ipkgInfoMap);
            this.log.info("\u65b0\u589e\u7248\u672c\u4fe1\u606f");
            this.saveProcessVer(procFid, procVerFid, appSn, ipkgInfoMap, ipkgUrl);
            ScheduleServiceHelper.uploadSchdule(appSn, procFid, MapUtils.getString(ipkgInfoMap, (Object)"proVersion") == null ? "" : MapUtils.getString(ipkgInfoMap, (Object)"proVersion"), MapUtils.getString(ipkgInfoMap, (Object)"Inputs") == null ? "" : MapUtils.getString(ipkgInfoMap, (Object)"Inputs"));
            this.log.info("\u53d6\u6d88\u539f\u7b49\u5f85\u4efb\u52a1");
            JobServiceHelper.cancle(appSn, ((Object)((Object)this)).getClass().getName());
            this.log.info("\u8c03\u5ea6\u66f4\u65b0\u3001\u53d6\u6d88\u7b49\u5f85\u4efb\u52a1\u5df2\u5b8c\u6210");
        } else {
            this.log.info("\u65e0\u65e7\u6d41\u7a0b\uff0c\u4e0d\u9700\u8981\u6e05\u7a7a\u5904\u7406");
            this.saveProcess(procFid, appSn, ipkgInfoMap);
            this.saveProcessVer(procFid, procVerFid, appSn, ipkgInfoMap, ipkgUrl);
        }
        ArrayList fileList = new ArrayList();
        HashMap<String, Object> filePathMap = new HashMap<String, Object>();
        filePathMap.put("url", ipkgUrl);
        filePathMap.put("name", UUID.randomUUID() + ".ipkg");
        filePathMap.put("size", ipkgSize);
        filePathMap.put("uid", AttachmentServiceHelper.generateUid());
        fileList.add(filePathMap);
        AttachmentServiceHelper.upload((String)"ysq_rpa_process_ver", (Object)procVerFid, (String)"attachmentpanel", fileList);
        this.log.info("==========ipkg\u6587\u4ef6\u548c\u6d41\u7a0b\u7248\u672c\u7ed1\u5b9a\u5b8c\u6210\uff0c\u5f00\u59cb\u66f4\u65b0ipkg\u9884\u7f6e\u6587\u4ef6\u90e8\u5206==========");
        List<ParamDTO> paramDTOS = this.uploadDefValueFile(ipkgInfoMap, ipkgInputStream);
        DynamicObject appMine = QueryServiceHelper.queryOne((String)"ysq_app_mine", (String)"id", (QFilter[])new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)appSn)});
        if (CollectionUtils.isNotEmpty(paramDTOS) && appMine != null) {
            long fid = appMine.getLong("id");
            AttachmentServiceHelper.remove((String)"ysq_app_mine", (Object)fid);
            for (ParamDTO paramDTO : paramDTOS) {
                ArrayList bindFileList = new ArrayList();
                HashMap<String, Object> bindFilePathMap = new HashMap<String, Object>();
                bindFilePathMap.put("url", paramDTO.getFilePath());
                bindFilePathMap.put("name", paramDTO.getFileName());
                bindFilePathMap.put("size", 1000);
                bindFilePathMap.put("uid", AttachmentServiceHelper.generateUid());
                bindFileList.add(bindFilePathMap);
                AttachmentServiceHelper.upload((String)"ysq_app_mine", (Object)fid, (String)paramDTO.getParamName(), bindFileList);
            }
        }
        IsearchFileUtils.close(ipkgInputStream);
        IsearchFileUtils.close(streamForRead);
        IsearchFileUtils.close(streamForUpload);
        try {
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.log.info("==========ipkg\u9884\u7f6e\u6587\u4ef6\u90e8\u5206\u4e0a\u4f20\u5b8c\u6210==========");
        List attachments1 = AttachmentServiceHelper.getAttachments((String)"ysq_rpa_process_ver", (Object)procVerFid, (String)"attachmentpanel");
        this.log.info("\u83b7\u53d6\u6d41\u7a0b\u7248\u672c\u6587\u4ef6" + attachments1);
        DynamicObject appMineObj = QueryServiceHelper.queryOne((String)"ysq_app_mine", (String)"id", (QFilter[])new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)appSn)});
        List attachments2 = AttachmentServiceHelper.getAttachments((String)"ysq_app_mine", (Object)appMineObj.getLong("id"), (String)"attachmentpanel");
        this.log.info("\u83b7\u53d6\u9884\u7f6e\u6587\u4ef6" + attachments2);
    }

    private void saveProcess(long procFid, String appSn, Map ipkgInfoMap) {
        String billNo;
        DynamicObject procDO;
        block2: {
            procDO = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_process");
            billNo = "";
            int i = 0;
            do {
                billNo = KdPageUtils.getBillNo();
                QFilter qFilter = new QFilter("billno", "=", (Object)billNo);
                QFilter[] qFilters = new QFilter[]{qFilter};
                boolean exists = QueryServiceHelper.exists((String)"ysq_rpa_process", (QFilter[])qFilters);
                if (!exists) break block2;
            } while (++i <= 100000);
            throw new KDException("\u6d41\u7a0b\u7f16\u53f7\u751f\u6210\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
        Map proAppExteInfos = (Map)ipkgInfoMap.get("proAppExteInfos");
        procDO.set("id", (Object)procFid);
        procDO.set("billno", (Object)billNo);
        procDO.set("billstatus", (Object)"A");
        procDO.set("creator", (Object)1L);
        procDO.set("org", (Object)0L);
        procDO.set("ysq_proc_code", (Object)appSn);
        procDO.set("ysq_is_assistant", (Object)1);
        procDO.set("ysq_is_start_up", (Object)0);
        procDO.set("ysq_proc_file", (Object)"");
        procDO.set("ysq_proc_ver", ipkgInfoMap.get("proVersion"));
        procDO.set("ysq_studio_ver", ipkgInfoMap.get("proStudio"));
        procDO.set("ysq_proc_name", proAppExteInfos.get("appName"));
        procDO.set("ysq_proc_desc", proAppExteInfos.get("appDesc"));
        procDO.set("ysq_pro_change", ipkgInfoMap.get("proChange"));
        procDO.set("ysq_param_tag", ipkgInfoMap.get("Inputs"));
        procDO.set("ysq_proc_type", (Object)"standard");
        procDO.set("ysq_status_ctime", (Object)new Date());
        procDO.set("ysq_publish_time", (Object)new Date());
        procDO.set("ysq_work_status", (Object)"release");
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{procDO});
        if (save.length <= 0) {
            this.log.error("\u6d41\u7a0b\u65b0\u589e\u5931\u8d25");
        }
    }

    private void saveProcessVer(long procFid, long procVerFid, String appSn, Map ipkgInfoMap, String fileUrl) {
        Map proAppExteInfos = (Map)ipkgInfoMap.get("proAppExteInfos");
        DynamicObject procVerObject = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_process_ver");
        procVerObject.set("id", (Object)procVerFid);
        procVerObject.set("org", (Object)0L);
        procVerObject.set("creator", (Object)1L);
        procVerObject.set("ysq_proc_name", proAppExteInfos.get("appName"));
        procVerObject.set("ysq_proc_code", (Object)appSn);
        procVerObject.set("ysq_proc_file", (Object)("/doc/ipkg/" + UUID.randomUUID() + ".ipkg"));
        procVerObject.set("ysq_proc_ver", ipkgInfoMap.get("proVersion"));
        procVerObject.set("ysq_pro_change", ipkgInfoMap.get("proChange"));
        procVerObject.set("ysq_is_activity", (Object)"yes");
        procVerObject.set("ysq_publish_time", (Object)new Date());
        procVerObject.set("ysq_status_ctime", (Object)new Date());
        procVerObject.set("ysq_studio_ver", ipkgInfoMap.get("proStudio"));
        procVerObject.set("ysq_proc_fid", (Object)procFid);
        procVerObject.set("ysq_proc_desc", proAppExteInfos.get("appDesc"));
        procVerObject.set("ysq_work_status", (Object)ProcessesStatusEnums.RELEASE.getCode());
        procVerObject.set("ysq_param_tag", ipkgInfoMap.get("Inputs"));
        Object[] save = SaveServiceHelper.save((IDataEntityType)procVerObject.getDataEntityType(), (Object[])new DynamicObject[]{procVerObject});
        if (save.length <= 0) {
            this.log.error("\u6d41\u7a0b\u7248\u672c\u65b0\u589e\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ParamDTO> uploadDefValueFile(Map<String, Object> ipkgInfoMap, InputStream inStream) {
        ArrayList<ParamDTO> paramDTOS = null;
        if (ipkgInfoMap.containsKey("Inputs") && ipkgInfoMap.containsKey("proAppInfos")) {
            ArrayList<ParamDTO> fileParamList = new ArrayList<ParamDTO>();
            String procParams = MapUtils.getString(ipkgInfoMap, (Object)"Inputs");
            List<ParamsVo> paramsVos = IsearchFileUtils.analysisParam(procParams);
            for (ParamsVo paramsVo : paramsVos) {
                if (!StringUtils.equals((CharSequence)paramsVo.getParamsType(), (CharSequence)"file")) continue;
                ParamDTO paramDTO = new ParamDTO();
                paramDTO.setParamName(paramsVo.getParamsName());
                paramDTO.setFileName(paramsVo.getParamsDefValue());
                fileParamList.add(paramDTO);
            }
            if (CollectionUtils.isNotEmpty(fileParamList)) {
                paramDTOS = new ArrayList<ParamDTO>();
                ZipEntry nextEntry = null;
                try (ZipInputStream zipInputStream = new ZipInputStream(inStream, Charset.forName("GBK"));){
                    while ((nextEntry = zipInputStream.getNextEntry()) != null) {
                        String name = nextEntry.getName();
                        for (ParamDTO paramDTO : fileParamList) {
                            int len;
                            if (!StringUtils.equals((CharSequence)paramDTO.getFileName(), (CharSequence)("./" + name))) continue;
                            String[] split = name.split("/");
                            name = split[split.length - 1];
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            byte[] buffer = new byte[9000];
                            while ((len = zipInputStream.read(buffer)) != -1) {
                                baos.write(buffer, 0, len);
                            }
                            ByteArrayInputStream swapStream = new ByteArrayInputStream(baos.toByteArray());
                            String filePath = KdFileServiceHelper.uploadFileToBasAttachment(swapStream, name);
                            baos.close();
                            ParamDTO param = new ParamDTO();
                            param.setFilePath(filePath);
                            param.setFileName(name);
                            param.setParamName(paramDTO.getParamName());
                            paramDTOS.add(param);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    IsearchFileUtils.close(inStream);
                }
            }
        }
        return paramDTOS;
    }

    private String splitUseHelper(Map appInfoMap) {
        String[] scopeSplit;
        String[] characSplit;
        String[] notSplit;
        String appCharacter = MapUtils.getString((Map)appInfoMap, (Object)"characteristics");
        String appNote = MapUtils.getString((Map)appInfoMap, (Object)"note");
        String appScope = MapUtils.getString((Map)appInfoMap, (Object)"scope");
        String appMore = MapUtils.getString((Map)appInfoMap, (Object)"more");
        JSONObject jsonObject = new JSONObject();
        ArrayList<String> noteMap = new ArrayList<String>();
        for (String str : notSplit = appNote.split("\\n")) {
            noteMap.add(str);
        }
        ArrayList<String> characterMap = new ArrayList<String>();
        for (String string : characSplit = appCharacter.split("\\n")) {
            characterMap.add(string);
        }
        HashMap<String, ArrayList<String>> appCharacterMap = new HashMap<String, ArrayList<String>>();
        appCharacterMap.put("main", characterMap);
        appCharacterMap.put("note", noteMap);
        jsonObject.put("appCharacter", appCharacterMap);
        ArrayList<String> scopeList = new ArrayList<String>();
        for (String str : scopeSplit = appScope.split("\\n")) {
            scopeList.add(str);
        }
        jsonObject.put("appScope", scopeList);
        ArrayList arrayList = new ArrayList();
        List maps = JSONArray.parseArray((String)appMore, Map.class);
        maps.stream().forEach(item -> {
            if ("1".equals(item.get("type"))) {
                HashMap<String, String> moreMap = new HashMap<String, String>();
                moreMap.put("id", "ysq_hyper_app");
                moreMap.put("name", item.get("name").toString());
                moreMap.put("href", item.get("url").toString());
                appMoreMaps.add(moreMap);
            } else if ("2".equals(item.get("type"))) {
                // empty if block
            }
        });
        jsonObject.put("appMore", arrayList);
        this.log.info("\u5e94\u7528\u8be6\u60c5\u5e2e\u52a9\uff1a" + jsonObject);
        return jsonObject.toString();
    }

    private static ByteArrayOutputStream cloneInputStream(InputStream input) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = input.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            return baos;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

