/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.task;

import java.util.Date;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import ysq.rpac.rpamc.common.cache.RedisCache;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.enums.RedisKeyItemsEnums;
import ysq.rpac.rpamc.common.enums.RedisLockKeysEnums;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.message.JobQueueProducer;
import ysq.rpac.rpamc.common.model.RpaJobVO;
import ysq.rpac.rpamc.common.task.AbstractRpaTask;

public class JobRedoTask
extends AbstractRpaTask {
    private boolean isRunning = false;
    private boolean isContinute = true;
    private final RedisCache redisCache = RedisCache.getInstance();
    private final JobQueueProducer jobQueueProducer = JobQueueProducer.getInstance();

    @Override
    protected boolean needLock() {
        return true;
    }

    @Override
    protected String getLockKey() {
        return RedisLockKeysEnums.KEY_HEAD.getKey() + RequestContext.get().getAccountId() + "/" + RedisLockKeysEnums.JOB_REDO.getKey();
    }

    @Override
    protected boolean hasLock() {
        return this.tryLock();
    }

    @Override
    protected void realDoThread() {
        while (this.redisCache.listNum(RedisKeyItemsEnums.JOB_REDO_CACHE_H.getKey()) > 0) {
            this.redoJob();
        }
    }

    public void redoJob() {
        RpaJobVO rpaJob = (RpaJobVO)this.redisCache.pop(RedisKeyItemsEnums.JOB_REDO_CACHE_H.getKey(), RpaJobVO.class);
        try {
            this.realRedo(rpaJob);
        }
        catch (Exception e) {
            this.log.warn("\u4efb\u52a1\u91cd\u505a\u5931\u8d25", (Throwable)e);
        }
    }

    private void realRedo(RpaJobVO rpaJob) {
        Integer runTimes = rpaJob.getRunTimes();
        if (runTimes > rpaJob.getFailTryTimes()) {
            return;
        }
        Date now = new Date();
        RpaJobVO rpaRedoJob = new RpaJobVO();
        rpaRedoJob.setWorkStatus(rpaJob.getWorkStatus());
        rpaRedoJob.setScheduleFId(rpaJob.getScheduleFId());
        rpaRedoJob.setSchName(rpaJob.getSchName());
        rpaRedoJob.setSchType(rpaJob.getSchType());
        rpaRedoJob.setJobNo(UUID.randomUUID().toString());
        rpaRedoJob.setJobOrder(System.currentTimeMillis());
        rpaRedoJob.setProcFid(rpaJob.getProcFid());
        if (null != rpaJob.getJobType()) {
            rpaRedoJob.setJobType(rpaJob.getJobType());
        } else {
            rpaRedoJob.setJobType("plan");
        }
        rpaRedoJob.setProduceType(rpaJob.getProduceType());
        rpaRedoJob.setCurrRobotNo(null);
        rpaRedoJob.setCurrRobotName(null);
        rpaRedoJob.setExecRobotsNo(rpaJob.getExecRobotsNo());
        rpaRedoJob.setExecRobotsNames(rpaJob.getExecRobotsNames());
        rpaRedoJob.setExecRobotsAlias(rpaJob.getExecRobotsAlias());
        rpaRedoJob.setProcCode(rpaJob.getProcCode());
        rpaRedoJob.setProcName(rpaJob.getProcName());
        rpaRedoJob.setProcFile(rpaJob.getProcFile());
        rpaRedoJob.setProcVer(rpaJob.getProcVer());
        rpaRedoJob.setPublishTime(rpaJob.getPublishTime());
        rpaRedoJob.setOrgId(rpaJob.getOrgId());
        rpaRedoJob.setOwnerUserFid(rpaJob.getOwnerUserFid());
        rpaRedoJob.setOwnerUserAlias(rpaJob.getOwnerUserAlias());
        rpaRedoJob.setDeveloperUserFid(rpaJob.getDeveloperUserFid());
        rpaRedoJob.setScheduleTime(now);
        rpaRedoJob.setJobTime(now);
        rpaRedoJob.setStatus(RpaJobStatusEnums.PENDING.getCode());
        rpaRedoJob.setPendingTimeout(rpaJob.getPendingTimeout());
        rpaRedoJob.setRunningTimeout(rpaJob.getRunningTimeout());
        rpaRedoJob.setProcHandDoMin(rpaJob.getProcHandDoMin());
        rpaRedoJob.setAutoStopTime(rpaJob.getAutoStopTime());
        rpaRedoJob.setFailTryTimes(rpaJob.getFailTryTimes());
        runTimes = runTimes + 1;
        rpaRedoJob.setRunTimes(runTimes);
        rpaRedoJob.setParameter(rpaJob.getParameter());
        rpaRedoJob.setPriority("high");
        rpaRedoJob.setDescription(null);
        rpaRedoJob.setApplyUsersFids(rpaJob.getApplyUsersFids());
        rpaRedoJob.setApplyUsersDesc(rpaJob.getApplyUsersDesc());
        rpaRedoJob.setStartTime(null);
        rpaRedoJob.setEndTime(null);
        rpaRedoJob.setExceptionName(null);
        rpaRedoJob.setExceptionContent(null);
        rpaRedoJob.setStudioVer(rpaJob.getStudioVer());
        rpaRedoJob.setProcVerDesc(rpaJob.getProcVerDesc());
        rpaRedoJob.setComJobType(rpaJob.getComJobType());
        String proChange = null;
        QFilter[] filterArr = new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)rpaJob.getProcCode()), new QFilter("ysq_proc_ver", "=", (Object)rpaJob.getProcVer())};
        DynamicObject procVer = null;
        try {
            procVer = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])filterArr);
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            procVer = null;
        }
        if (null != procVer) {
            proChange = procVer.getString("ysq_pro_change");
        }
        Object[] jobs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rpaRedoJob.buildDynamicObject()});
        DynamicObject jobd = (DynamicObject)jobs[0];
        rpaRedoJob.setFid(jobd.getLong("id"));
        this.jobQueueProducer.addJob(rpaRedoJob, proChange);
    }
}

