/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.task;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import ysq.rpac.rpamc.common.cache.RedisCache;
import ysq.rpac.rpamc.common.enums.RedisKeyItemsEnums;
import ysq.rpac.rpamc.common.enums.RedisLockKeysEnums;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.status.job.core.JobStatusCache;
import ysq.rpac.rpamc.common.status.job.model.JobStatusCacheBean;
import ysq.rpac.rpamc.common.status.job.model.JobStatusFullInfoVO;
import ysq.rpac.rpamc.common.status.job.utils.JobStatusFullInofBuilder;
import ysq.rpac.rpamc.common.task.AbstractRpaTask;
import ysq.rpac.rpamc.common.utils.DateUtils;

public class JobStatusCacheTask
extends AbstractRpaTask {
    private static final Integer MAX_FAILED_TIMES = 10;
    private RedisCache redisCache = RedisCache.getInstance();
    private JobStatusCache jobStatusCache = JobStatusCache.getInstance();
    private boolean isContinute = true;

    @Override
    protected boolean needLock() {
        return true;
    }

    @Override
    protected String getLockKey() {
        return RedisLockKeysEnums.KEY_HEAD.getKey() + RequestContext.get().getAccountId() + "/" + RedisLockKeysEnums.JOB_STATUS_CACHE.getKey();
    }

    @Override
    protected boolean hasLock() {
        return this.tryLock();
    }

    @Override
    protected void realDoThread() {
        while (this.redisCache.listNum(RedisKeyItemsEnums.JOB_STATUS_CACHE_DATAKEY_H.getKey()) > 0) {
            this.changeStatusThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeStatusThread() {
        JobStatusCacheBean cacheBean = (JobStatusCacheBean)this.redisCache.pop(RedisKeyItemsEnums.JOB_STATUS_CACHE_DATAKEY_H.getKey(), JobStatusCacheBean.class);
        Long jobId = cacheBean.getJobId();
        String jobNo = cacheBean.getJobNo();
        String extendAgentNo = cacheBean.getExtendAgentNo();
        String agentAlias = cacheBean.getAgentAlias();
        Date jobTime = cacheBean.getJobTime();
        Date now = cacheBean.getStartTime();
        cacheBean.addFailedTimes();
        int failedTimes = cacheBean.getFailedTimes();
        boolean isTrue = false;
        try {
            if (failedTimes > MAX_FAILED_TIMES) {
                isTrue = true;
                return;
            }
            JobStatusFullInofBuilder builder = JobStatusFullInofBuilder.newBuilder(jobId, jobNo, RpaJobStatusEnums.RUNNING.getCode(), now);
            builder.currRobotNo(extendAgentNo).currRobotName(agentAlias).startTime(now);
            if (null != jobTime) {
                long seconds = DateUtils.getIntervals(new Date(now.getTime()), new Date(jobTime.getTime()));
                builder.pendingTime(seconds);
            }
            JobStatusFullInfoVO fullInfo = builder.build();
            this.jobStatusCache.chacheStatus(fullInfo, ((Object)((Object)this)).getClass().getName());
            isTrue = true;
        }
        catch (Exception e) {
            this.log.warn((Throwable)e);
        }
        finally {
            if (failedTimes <= MAX_FAILED_TIMES && !isTrue) {
                this.redisCache.rightPush(RedisKeyItemsEnums.JOB_STATUS_CACHE_DATAKEY_H.getKey(), SerializationUtils.toJsonString((Object)cacheBean));
            }
        }
    }
}

