/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.task;

import com.alibaba.fastjson.JSONObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.enums.RedisLockKeysEnums;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.message.JobQueueProducer;
import ysq.rpac.rpamc.common.model.RpaJobVO;
import ysq.rpac.rpamc.common.status.job.core.JobStatusCache;
import ysq.rpac.rpamc.common.status.job.model.JobStatusFullInfoVO;
import ysq.rpac.rpamc.common.status.job.utils.JobStatusConfigs;
import ysq.rpac.rpamc.common.task.AbstractRpaTask;

public class JobStatusChangeTask
extends AbstractRpaTask {
    private JobStatusCache jobStatusCache = JobStatusCache.getInstance();
    private JobQueueProducer jobQueueProducer = JobQueueProducer.getInstance();

    @Override
    protected boolean needLock() {
        return true;
    }

    @Override
    protected String getLockKey() {
        return RedisLockKeysEnums.KEY_HEAD.getKey() + RequestContext.get().getAccountId() + "/" + RedisLockKeysEnums.JOB_RUNNER.getKey();
    }

    @Override
    protected boolean hasLock() {
        return this.tryLock();
    }

    @Override
    protected void realDoThread() {
        for (int i = 0; i < JobStatusConfigs.threadNum; ++i) {
            this.realDo(i);
        }
    }

    public void realDo(Integer threadId) {
        JobStatusFullInfoVO fullInfo = null;
        do {
            if (null == (fullInfo = this.jobStatusCache.popCahche(threadId))) {
                this.log.info("\u961f\u5217{}\u7684\u6570\u636e\u5df2\u5904\u7406\u5b8c", (Object)threadId);
                continue;
            }
            try {
                boolean isMysql = true;
                DynamicObject rpaJobDb = BusinessDataServiceHelper.loadSingle((Object)fullInfo.getId(), (String)"ysq_rpa_job");
                if (null == rpaJobDb) {
                    this.log.info("mysql\u4e2d\u8be5\u4efb\u52a1id:{}, jobNo:{}\u4e0d\u5b58\u5728", (Object)fullInfo.getId(), (Object)fullInfo.getJobNo());
                    isMysql = false;
                }
                if (null == rpaJobDb) continue;
                this.changeStatus(rpaJobDb, fullInfo, isMysql);
            }
            catch (Exception e) {
                this.log.warn("\u72b6\u6001\u5207\u6362\u5904\u7406\u5f02\u5e38\uff0c\u653e\u56de\u961f\u5217", (Throwable)e);
                this.jobStatusCache.cacheRedo(threadId, fullInfo);
            }
        } while (null != fullInfo);
    }

    private void changeStatus(DynamicObject hisJob, JobStatusFullInfoVO newJob, boolean isMysql) {
        String operType = newJob.getOperType();
        if ("client".equals(hisJob.getString("ysq_result_change_type")) && !"client".equals(operType)) {
            return;
        }
        DynamicObject updateJob = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_job");
        updateJob.set("id", (Object)hisJob.getLong("id"));
        String jobNo = newJob.getJobNo();
        String hisStatus = hisJob.getString("ysq_status");
        String newStatus = newJob.getStatus();
        this.log.info("\u4efb\u52a1id\uff1a{}\uff0cjobNO:{}\u8981\u4ece{}\u72b6\u6001\u6539\u6210{}\u72b6\u6001\u3002\u4fee\u6539\u65f6\u95f4\uff1a{}", new Object[]{newJob.getId(), newJob.getJobNo(), hisStatus, newStatus, newJob.getModifyTime().getTime()});
        updateJob.set("ysq_job_no", (Object)jobNo);
        updateJob.set("ysq_status", (Object)newStatus);
        if (RpaJobStatusEnums.RUNNING.getCode().equals(newStatus)) {
            if (RpaJobStatusEnums.PENDING.getCode().equals(hisStatus) || RpaJobStatusEnums.CANCELLED.getCode().equals(hisStatus) || RpaJobStatusEnums.PEND_OUTTIME.getCode().equals(hisStatus)) {
                this.updateStatus(updateJob, newJob, hisStatus, isMysql);
            }
        } else if (RpaJobStatusEnums.STOPPING.getCode().equals(newStatus)) {
            if (RpaJobStatusEnums.RUNNING.getCode().equals(hisStatus)) {
                this.jobQueueProducer.addJobStopping(new RpaJobVO().fromDynamicObject(hisJob));
                this.updateStatus(updateJob, newJob, hisStatus, isMysql);
            }
        } else if (RpaJobStatusEnums.SUCCESS.getCode().equals(newStatus)) {
            this.updateStatus(updateJob, newJob, hisStatus, isMysql);
        } else if (RpaJobStatusEnums.FAILED.getCode().equals(newStatus)) {
            if (!RpaJobStatusEnums.SUCCESS.getCode().equals(hisStatus)) {
                this.updateStatus(updateJob, newJob, hisStatus, isMysql);
            }
        } else if (RpaJobStatusEnums.STOPPED.getCode().equals(newStatus)) {
            if (!RpaJobStatusEnums.SUCCESS.getCode().equals(hisStatus)) {
                this.jobQueueProducer.returnJobStopping(jobNo);
                this.updateStatus(updateJob, newJob, hisStatus, isMysql);
            }
        } else if (RpaJobStatusEnums.CANCELLED.getCode().equals(newStatus)) {
            if (RpaJobStatusEnums.PENDING.getCode().equals(hisStatus)) {
                this.jobQueueProducer.removeJob(jobNo);
                this.updateStatus(updateJob, newJob, hisStatus, isMysql);
            }
        } else if (RpaJobStatusEnums.PEND_OUTTIME.getCode().equals(newStatus)) {
            if (RpaJobStatusEnums.PENDING.getCode().equals(hisStatus)) {
                this.jobQueueProducer.removeJob(jobNo);
                this.updateStatus(updateJob, newJob, hisStatus, isMysql);
            }
        } else if (!(!RpaJobStatusEnums.RUN_OUTTIME.getCode().equals(newStatus) || RpaJobStatusEnums.SUCCESS.getCode().equals(hisStatus) || RpaJobStatusEnums.STOPPED.getCode().equals(hisStatus) || RpaJobStatusEnums.FAILED.getCode().equals(hisStatus) || RpaJobStatusEnums.STOPPING.getCode().equals(hisStatus))) {
            this.updateStatus(updateJob, newJob, hisStatus, isMysql);
        }
        this.setStatusToKD(hisStatus, updateJob.getString("ysq_status"), updateJob);
    }

    private void updateStatus(DynamicObject updateJob, JobStatusFullInfoVO newJob, String hisStatus, boolean isMysql) {
        if (isMysql) {
            String jobNo;
            QFilter qFilter;
            ORMImpl a;
            Object[] count;
            String excContent;
            if (null != newJob.getCurrRobotNo()) {
                updateJob.set("ysq_curr_robot_no", (Object)newJob.getCurrRobotNo());
            }
            if (null != newJob.getCurrRobotName()) {
                updateJob.set("ysq_curr_robot_name", (Object)newJob.getCurrRobotName());
            }
            if (null != newJob.getPendingTime()) {
                updateJob.set("ysq_pending_time", (Object)newJob.getPendingTime());
            }
            if (null != newJob.getStartTime()) {
                updateJob.set("ysq_start_time", (Object)newJob.getStartTime());
            }
            if (null != newJob.getEndTime()) {
                updateJob.set("ysq_end_time", (Object)newJob.getEndTime());
            }
            if (null != newJob.getRunTimes()) {
                updateJob.set("ysq_run_times", (Object)newJob.getRunTimes());
            }
            if (null != newJob.getRunTimeSec()) {
                updateJob.set("ysq_run_time_sec", (Object)newJob.getRunTimeSec());
            }
            if (null != newJob.getDescription()) {
                updateJob.set("ysq_description", (Object)newJob.getDescription());
            }
            if (null != newJob.getExceptionName()) {
                updateJob.set("ysq_exception_name", (Object)newJob.getExceptionName());
            }
            if (StringUtils.isNotBlank((CharSequence)(excContent = newJob.getExceptionContent()))) {
                if (excContent.length() > 40000) {
                    excContent = excContent.substring(0, 40000);
                }
                updateJob.set("ysq_exception_content_tag", (Object)excContent);
            }
            if (null != newJob.getRobotStartTime()) {
                updateJob.set("ysq_robot_start_time", (Object)newJob.getRobotStartTime());
            }
            if (null != newJob.getRobotEndTime()) {
                updateJob.set("ysq_robot_end_time", (Object)newJob.getRobotEndTime());
            }
            if (null != newJob.getOperType()) {
                updateJob.set("ysq_result_change_type", (Object)newJob.getOperType());
            }
            if ((count = (a = new ORMImpl()).aggregate("count", "ysq_rpa_sfile", new String[]{"count(1)"}, new QFilter[]{qFilter = new QFilter("ysq_job_no", "=", (Object)(jobNo = updateJob.getString("ysq_job_no")))})) != null && count.length > 0) {
                updateJob.set("ysq_file_ref_count", count[0]);
            }
            SaveServiceHelper.update((DynamicObject)updateJob);
            this.log.info("\u4efb\u52a1id\uff1a{}\uff0cjobNO:{}\u8981\u4ece{}\u72b6\u6001\u6539\u6210{}\u72b6\u6001\u3002\u4fee\u6539\u65f6\u95f4\uff1a{}\u3002\u4fee\u6539\u6210\u529f\u3002", new Object[]{updateJob.getLong("id"), updateJob.getString("ysq_job_no"), hisStatus, updateJob.getString("ysq_status")});
        }
    }

    private void setStatusToKD(String hisStatus, String newStatus, DynamicObject updateJob) {
        try {
            if (!this.isSendDataKd(hisStatus, newStatus)) {
                return;
            }
            DynamicObject job = BusinessDataServiceHelper.loadSingle((Object)updateJob.getString("id"), (String)"ysq_rpa_job");
            String rpa_processname = job.getString("ysq_proc_name");
            String rpa_processversion = job.getString("ysq_proc_ver");
            String rpa_taskid = updateJob.getString("id");
            String rpa_status = newStatus;
            JSONObject data = new JSONObject();
            data.put("rpa_processname", (Object)rpa_processname);
            data.put("rpa_processversion", (Object)rpa_processversion);
            data.put("rpa_taskid", (Object)rpa_taskid);
            data.put("rpa_status", (Object)rpa_status);
            EventServiceHelper.triggerEventSubscribe((String)"RPA_status_event", (String)data.toJSONString());
            this.log.info("\u6d41\u7a0b\uff1a{}\uff0cjobNO:{}\u8981\u4ece{}\u72b6\u6001\u6539\u6210{}\u72b6\u6001\u3002", new Object[]{rpa_processname, rpa_taskid, hisStatus, newStatus});
        }
        catch (Exception e) {
            this.log.error("\u9519\u8bef\u4fe1\u606f\uff1a{}", (Throwable)e);
        }
    }

    private boolean isSendDataKd(String hisStatus, String newStatus) {
        if (RpaJobStatusEnums.PENDING.getCode().equals(hisStatus) && (RpaJobStatusEnums.RUNNING.getCode().equals(newStatus) || RpaJobStatusEnums.PEND_OUTTIME.getCode().equals(newStatus) || RpaJobStatusEnums.CANCELLED.getCode().equals(newStatus) || RpaJobStatusEnums.SUCCESS.getCode().equals(newStatus) || RpaJobStatusEnums.FAILED.getCode().equals(newStatus))) {
            return true;
        }
        if (RpaJobStatusEnums.RUNNING.getCode().equals(hisStatus) && (RpaJobStatusEnums.SUCCESS.getCode().equals(newStatus) || RpaJobStatusEnums.FAILED.getCode().equals(newStatus) || RpaJobStatusEnums.RUN_OUTTIME.getCode().equals(newStatus) || RpaJobStatusEnums.STOPPED.getCode().equals(newStatus))) {
            return true;
        }
        if (RpaJobStatusEnums.RUN_OUTTIME.getCode().equals(hisStatus) && (RpaJobStatusEnums.SUCCESS.getCode().equals(newStatus) || RpaJobStatusEnums.FAILED.getCode().equals(newStatus) || RpaJobStatusEnums.STOPPED.getCode().equals(newStatus))) {
            return true;
        }
        return RpaJobStatusEnums.STOPPING.getCode().equals(hisStatus) && (RpaJobStatusEnums.STOPPED.getCode().equals(newStatus) || RpaJobStatusEnums.SUCCESS.getCode().equals(newStatus) || RpaJobStatusEnums.FAILED.getCode().equals(newStatus));
    }
}

