/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.task;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.cache.RedisCache;
import ysq.rpac.rpamc.common.constant.YsqRpaJobConstant;
import ysq.rpac.rpamc.common.enums.RedisKeyItemsEnums;
import ysq.rpac.rpamc.common.enums.RedisLockKeysEnums;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.status.job.core.JobStatusCache;
import ysq.rpac.rpamc.common.status.job.model.JobStatusFullInfoVO;
import ysq.rpac.rpamc.common.status.job.model.JobStopBean;
import ysq.rpac.rpamc.common.status.job.utils.JobStatusFullInofBuilder;
import ysq.rpac.rpamc.common.task.AbstractRpaTask;
import ysq.rpac.rpamc.common.utils.DateUtils;

public class JobStopTask
extends AbstractRpaTask {
    private static final Integer MAX_FAILED_TIMES = 10;
    private boolean isContinute = true;
    private RedisCache redisCache = RedisCache.getInstance();
    private JobStatusCache jobStatusCache = JobStatusCache.getInstance();

    @Override
    protected boolean needLock() {
        return true;
    }

    @Override
    protected String getLockKey() {
        return RedisLockKeysEnums.KEY_HEAD.getKey() + RequestContext.get().getAccountId() + "/" + RedisLockKeysEnums.JOB_STOP.getKey();
    }

    @Override
    protected boolean hasLock() {
        return this.tryLock();
    }

    @Override
    protected void realDoThread() {
        while (this.redisCache.listNum(RedisKeyItemsEnums.JOB_STOP_CACHE_H.getKey()) > 0) {
            this.doStopJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStopJob() {
        JobStopBean cacheBean = (JobStopBean)this.redisCache.pop(RedisKeyItemsEnums.JOB_STOP_CACHE_H.getKey(), JobStopBean.class);
        String extendAgentNo = cacheBean.getExtendAgentNo();
        String jobNo = cacheBean.getJobNo();
        cacheBean.addFailedTimes();
        int failedTimes = cacheBean.getFailedTimes();
        boolean isTrue = false;
        try {
            if (failedTimes > MAX_FAILED_TIMES) {
                isTrue = true;
                return;
            }
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            filterList.add(new QFilter("ysq_curr_robot_no", "=", (Object)extendAgentNo));
            if (StringUtils.isNotEmpty((CharSequence)jobNo)) {
                filterList.add(new QFilter("ysq_job_no", "!=", (Object)jobNo));
            }
            QFilter statusFilter = new QFilter("ysq_status", "=", (Object)RpaJobStatusEnums.RUNNING.getCode()).or("ysq_status", "=", (Object)RpaJobStatusEnums.STOPPING.getCode());
            filterList.add(statusFilter);
            QFilter[] filters = new QFilter[filterList.size()];
            for (int i = 0; i < filterList.size(); ++i) {
                filters[i] = (QFilter)filterList.get(i);
            }
            DynamicObject[] jobList = BusinessDataServiceHelper.load((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])filters);
            Timestamp now = DateUtils.getTimestamp();
            for (DynamicObject rpaJob : jobList) {
                int n;
                String newStatus = null;
                if (RpaJobStatusEnums.RUNNING.getCode().equals(rpaJob.getString("ysq_status"))) {
                    newStatus = RpaJobStatusEnums.FAILED.getCode();
                } else if (RpaJobStatusEnums.STOPPING.getCode().equals(rpaJob.getString("ysq_status"))) {
                    newStatus = RpaJobStatusEnums.STOPPED.getCode();
                }
                JobStatusFullInofBuilder fullInfoBuilder = JobStatusFullInofBuilder.newBuilder(rpaJob.getLong("id"), rpaJob.getString("ysq_job_no"), newStatus, now);
                Integer runTimes = rpaJob.getInt("ysq_run_times");
                if (runTimes == null) {
                    n = 0;
                } else {
                    runTimes = runTimes + 1;
                    n = runTimes;
                }
                fullInfoBuilder.runTimes(n);
                Date startTime = rpaJob.getDate("ysq_start_time");
                long runTimeSec = DateUtils.getIntervals(now, startTime);
                fullInfoBuilder.runTimeSec(runTimeSec);
                fullInfoBuilder.endTime(now);
                JobStatusFullInfoVO fullInfo = fullInfoBuilder.build();
                this.jobStatusCache.chacheStatus(fullInfo, ((Object)((Object)this)).getClass().getName());
            }
            isTrue = true;
        }
        catch (Exception e) {
            this.log.warn((Throwable)e);
        }
        finally {
            if (failedTimes <= MAX_FAILED_TIMES && !isTrue) {
                this.redisCache.rightPush(RedisKeyItemsEnums.JOB_STOP_CACHE_H.getKey(), SerializationUtils.toJsonString((Object)cacheBean));
            }
        }
    }
}

