/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.task;

import java.util.ArrayList;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.cache.RobotCache;
import ysq.rpac.rpamc.common.enums.RedisLockKeysEnums;
import ysq.rpac.rpamc.common.model.LicenseVO;
import ysq.rpac.rpamc.common.task.AbstractRpaTask;
import ysq.rpac.rpamc.common.utils.LicenseUtils;

public class LicenseChangeTask
extends AbstractRpaTask {
    private RobotCache robotCache = RobotCache.getInstance();

    @Override
    protected boolean needLock() {
        return true;
    }

    @Override
    protected String getLockKey() {
        return RedisLockKeysEnums.KEY_HEAD.getKey() + RequestContext.get().getAccountId() + "/" + RedisLockKeysEnums.LICENSE_OVERDUE_CHECK.getKey();
    }

    @Override
    protected boolean hasLock() {
        return this.tryLock();
    }

    @Override
    protected void realDoThread() {
        DynamicObject[] load;
        LicenseVO licenseVO = LicenseUtils.licenseNums();
        Integer assistantLicTotal = licenseVO.getAssistants();
        Integer robotLicTotal = licenseVO.getRobots();
        Integer studioLicTotal = licenseVO.getStudios();
        Integer cRobotLicTotal = licenseVO.getCsRobot();
        Integer assistantLics = LicenseUtils.getUsedLicNums("assistant");
        Integer robotLics = LicenseUtils.getUsedLicNums("robot");
        Integer studioLics = LicenseUtils.getUsedLicNums("studio");
        Integer cRobotLics = LicenseUtils.getUsedLicNums("standardRobot");
        if (assistantLics > assistantLicTotal) {
            ArrayList ids = new ArrayList();
            int count = assistantLics - assistantLicTotal;
            QFilter qFilter = new QFilter("ysq_agent_type", "=", (Object)"assistant");
            DynamicObject[] load2 = BusinessDataServiceHelper.load((String)"ysq_rpa_agent", (String)"id,ysq_comm_token", (QFilter[])new QFilter[]{qFilter}, (String)"ysq_last_heart_time asc,ysq_last_login_time asc", (int)count);
            this.removeRobot(load2);
        }
        if (robotLics > robotLicTotal) {
            int count = robotLics - robotLicTotal;
            QFilter qFilter = new QFilter("ysq_agent_type", "=", (Object)"robot");
            load = BusinessDataServiceHelper.load((String)"ysq_rpa_agent", (String)"id,ysq_comm_token", (QFilter[])new QFilter[]{qFilter}, (String)"ysq_last_heart_time asc,ysq_last_login_time asc", (int)count);
            this.removeRobot(load);
        }
        if (studioLics > studioLicTotal) {
            int count = studioLics - studioLicTotal;
            QFilter qFilter = new QFilter("ysq_agent_type", "=", (Object)"studio");
            load = BusinessDataServiceHelper.load((String)"ysq_rpa_agent", (String)"id,ysq_comm_token", (QFilter[])new QFilter[]{qFilter}, (String)"ysq_last_login_time asc", (int)count);
            this.removeRobot(load);
        }
        if (cRobotLics > cRobotLicTotal) {
            int count = cRobotLics - cRobotLicTotal;
            QFilter qFilter = new QFilter("ysq_agent_type", "=", (Object)"standardRobot");
            load = BusinessDataServiceHelper.load((String)"ysq_rpa_agent", (String)"id,ysq_comm_token", (QFilter[])new QFilter[]{qFilter}, (String)"ysq_last_login_time asc", (int)count);
            this.removeRobot(load);
        }
    }

    private void removeRobot(DynamicObject[] load) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (load != null && load.length > 0) {
            for (DynamicObject robot : load) {
                String comtoken = robot.getString("ysq_comm_token");
                if (StringUtils.isNotBlank((CharSequence)comtoken)) {
                    this.robotCache.remove(robot.getString("ysq_comm_token"));
                }
                ids.add(robot.getLong("id"));
            }
            if (CollectionUtils.isNotEmpty(ids)) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_agent");
                DeleteServiceHelper.delete((IDataEntityType)dynamicObject.getDataEntityType(), (Object[])ids.toArray());
            }
        }
    }
}

