/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.task;

import java.util.Date;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import ysq.rpac.rpamc.common.enums.RedisKeyItemsEnums;
import ysq.rpac.rpamc.common.enums.RedisLockKeysEnums;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.message.RobotPendingJobProducer;
import ysq.rpac.rpamc.common.message.model.JobQueueBean;
import ysq.rpac.rpamc.common.status.job.core.JobStatusCache;
import ysq.rpac.rpamc.common.status.job.model.JobStatusFullInfoVO;
import ysq.rpac.rpamc.common.status.job.utils.JobStatusFullInofBuilder;
import ysq.rpac.rpamc.common.task.AbstractRpaTask;
import ysq.rpac.rpamc.common.utils.DateUtils;

public class PreRobotRunOuttimeTask
extends AbstractRpaTask {
    private static final long TEN_MIN_SEC = 600000L;
    private RobotPendingJobProducer robotPendingJobProducer = RobotPendingJobProducer.getInstance();
    private JobStatusCache jobStatusCache = JobStatusCache.getInstance();

    @Override
    protected boolean needLock() {
        return false;
    }

    @Override
    protected String getLockKey() {
        return RedisLockKeysEnums.KEY_HEAD.getKey() + RequestContext.get().getAccountId() + "/" + RedisLockKeysEnums.ROBOT_RUNOUT_TIME.getKey();
    }

    @Override
    protected boolean hasLock() {
        return this.tryLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realDoThread() {
        this.log.info("PreRobotRunOuttime check start...");
        Set<String> robotPendKeys = this.robotPendingJobProducer.listKeys();
        Date now = new Date();
        for (String key : robotPendKeys) {
            try {
                JobQueueBean cacheJob;
                String[] keyArr = key.split(RedisKeyItemsEnums.KEY_SPLIT.getKey());
                if (keyArr.length < 3) continue;
                String agentNo = keyArr[2];
                String jobNo = keyArr[3];
                DLock lock = DLock.create((String)(RedisLockKeysEnums.KEY_HEAD.getKey() + RequestContext.get().getAccountId() + RedisLockKeysEnums.KEY_SPLIT_LOCK.getKey() + RedisLockKeysEnums.ROBOT_HEART_HEAD.getKey() + agentNo));
                if (!lock.tryLock() || null == (cacheJob = this.robotPendingJobProducer.popJob(agentNo, jobNo))) continue;
                String cacheTimeStr = cacheJob.getRobotPendingPutTime();
                Date cacheTime = DateUtils.parseDate(cacheTimeStr);
                String robotName = cacheJob.getRobotName();
                if (null != cacheTime && now.getTime() - cacheTime.getTime() < 600000L) {
                    this.robotPendingJobProducer.pushJob(agentNo, robotName, jobNo, cacheJob, null);
                    continue;
                }
                JobStatusFullInofBuilder builder = JobStatusFullInofBuilder.newBuilder(cacheJob.getJobId(), cacheJob.getJobNo(), RpaJobStatusEnums.FAILED.getCode(), now);
                builder.currRobotNo(agentNo).currRobotName(robotName).startTime(now);
                Date jobTime = cacheJob.getJobTime();
                if (null != jobTime) {
                    long seconds = DateUtils.getIntervals(new Date(now.getTime()), new Date(jobTime.getTime()));
                    builder.pendingTime(seconds);
                }
                JobStatusFullInfoVO fullInfo = builder.build();
                this.jobStatusCache.chacheStatus(fullInfo, ((Object)((Object)this)).getClass().getName());
            }
            catch (Exception e) {
                this.log.warn((Throwable)e);
            }
            finally {
                this.lock.unlock();
                this.lock.close();
            }
        }
        this.log.info("PreRobotRunOuttimeJob end...");
    }
}

