/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.task;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import ysq.rpac.rpamc.common.cache.RobotCache;
import ysq.rpac.rpamc.common.config.CdagentConfig;
import ysq.rpac.rpamc.common.constant.YsqAgentConstant;
import ysq.rpac.rpamc.common.constant.YsqRpaJobConstant;
import ysq.rpac.rpamc.common.enums.RedisLockKeysEnums;
import ysq.rpac.rpamc.common.enums.RoborDataStatusEnums;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.model.CdaAgentVO;
import ysq.rpac.rpamc.common.status.job.core.JobStatusCache;
import ysq.rpac.rpamc.common.status.job.utils.JobStatusFullInofBuilder;
import ysq.rpac.rpamc.common.task.AbstractRpaTask;
import ysq.rpac.rpamc.common.utils.DateUtils;

public class RobotOfflineTask
extends AbstractRpaTask {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private CdagentConfig cdagentConfig = new CdagentConfig();
    private JobStatusCache jobStatusCache = JobStatusCache.getInstance();
    private RobotCache robotCache = RobotCache.getInstance();

    @Override
    protected boolean needLock() {
        return true;
    }

    @Override
    protected String getLockKey() {
        return RedisLockKeysEnums.KEY_HEAD.getKey() + RequestContext.get().getAccountId() + "/" + RedisLockKeysEnums.ROBOT_OFFLINE.getKey();
    }

    @Override
    protected boolean hasLock() {
        return this.tryLock();
    }

    @Override
    protected void realDoThread() {
        Date now = new Date();
        int agentTime = this.cdagentConfig.getAgentTime();
        if (agentTime != 0) {
            Date seconds = DateUtils.addSeconds(now, -agentTime);
            String date = DateUtils.formatDate(seconds);
            QFilter agentFilter = new QFilter("ysq_last_heart_time", "<=", (Object)seconds);
            QFilter agentTypeFilter = new QFilter("ysq_agent_type", "!=", (Object)"studio");
            QFilter[] filters = new QFilter[]{agentFilter, agentTypeFilter};
            DynamicObject[] cdaAgentList = BusinessDataServiceHelper.load((String)"ysq_rpa_agent", (String)YsqAgentConstant.selAllFileds(), (QFilter[])filters);
            if (null == cdaAgentList || cdaAgentList.length == 0) {
                this.log.info("CdaAgent cdaAgentList is empty.");
                return;
            }
            for (int i = 0; i < cdaAgentList.length; ++i) {
                DynamicObject agent = cdaAgentList[i];
                agent.set("ysq_data_status", (Object)RoborDataStatusEnums.OFFLINE.getCode());
                SaveServiceHelper.update((DynamicObject)agent);
                this.robotCache.put(agent.getString("ysq_comm_token"), new CdaAgentVO().fromDynamicObject(agent));
                String agentNo = "-" + agent.get("ysq_agent_no") + "-";
                QFilter agentNoFilter = new QFilter("ysq_curr_robot_no", "=", (Object)agentNo);
                ArrayList<String> list = new ArrayList<String>();
                list.add(RpaJobStatusEnums.RUNNING.getCode());
                list.add(RpaJobStatusEnums.STOPPING.getCode());
                QFilter statusFilter = new QFilter("ysq_status", "in", list);
                QFilter[] jobfilters = new QFilter[]{agentNoFilter, statusFilter};
                DynamicObject[] rpaJobList = BusinessDataServiceHelper.load((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])jobfilters);
                if (null == rpaJobList || rpaJobList.length == 0) {
                    this.log.info("RpaJob rpaJobList is empty.");
                    continue;
                }
                for (DynamicObject job : rpaJobList) {
                    JobStatusFullInofBuilder builder;
                    String status = job.getString("ysq_status");
                    if (RpaJobStatusEnums.RUNNING.getCode().equals(status)) {
                        builder = JobStatusFullInofBuilder.newBuilder(job.getLong("id"), job.getString("ysq_job_no"), RpaJobStatusEnums.FAILED.getCode(), now);
                        builder.endTime(now);
                        this.jobStatusCache.chacheStatus(builder.build(), ((Object)((Object)this)).getClass().getName());
                        continue;
                    }
                    if (!RpaJobStatusEnums.STOPPING.getCode().equals(status)) continue;
                    builder = JobStatusFullInofBuilder.newBuilder(job.getLong("id"), job.getString("ysq_job_no"), RpaJobStatusEnums.STOPPED.getCode(), now);
                    builder.endTime(now);
                    this.jobStatusCache.chacheStatus(builder.build(), ((Object)((Object)this)).getClass().getName());
                }
            }
        }
    }
}

