/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.task;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.enums.RedisLockKeysEnums;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.message.JobQueueProducer;
import ysq.rpac.rpamc.common.message.RobotPendingJobProducer;
import ysq.rpac.rpamc.common.model.RpaJobVO;
import ysq.rpac.rpamc.common.status.job.core.JobStatusCache;
import ysq.rpac.rpamc.common.status.job.utils.JobStatusFullInofBuilder;
import ysq.rpac.rpamc.common.task.AbstractRpaOvertimeTask;
import ysq.rpac.rpamc.common.utils.DateUtils;

public class RpaOvertimePendingTask
extends AbstractRpaOvertimeTask {
    private JobStatusCache jobStatusCache = JobStatusCache.getInstance();
    private JobQueueProducer jobQueueProducer = JobQueueProducer.getInstance();

    @Override
    protected boolean needLock() {
        return true;
    }

    @Override
    protected String getLockKey() {
        return RedisLockKeysEnums.KEY_HEAD.getKey() + RequestContext.get().getAccountId() + "/" + RedisLockKeysEnums.OVERTIME_PENDING.getKey();
    }

    @Override
    protected boolean hasLock() {
        return this.tryLock();
    }

    @Override
    protected void initStatus() {
        this.status = RpaJobStatusEnums.PENDING.getCode();
    }

    @Override
    protected void doJobStatus(DynamicObject oneJob, Date now) {
        Date jobTime = oneJob.getDate("ysq_job_time");
        if (null != oneJob.get("ysq_start_time")) {
            jobTime = oneJob.getDate("ysq_start_time");
        }
        if (jobTime == null) {
            jobTime = oneJob.getDate("createtime");
        }
        long jobWaiteSecond = DateUtils.getIntervals(DateUtils.getNow(), jobTime);
        this.countWaiteTime(oneJob, jobWaiteSecond);
        this.doPendingOut(oneJob, now, jobWaiteSecond);
    }

    private void doPendingOut(DynamicObject oneJob, Date now, long jobWaiteSecond) {
        try {
            int pendingTimeout = oneJob.getInt("ysq_pending_timeout");
            if (0 != pendingTimeout && jobWaiteSecond >= (long)(pendingTimeout * 60)) {
                Long jobId = oneJob.getLong("id");
                String jobNo = oneJob.getString("ysq_job_no");
                JobStatusFullInofBuilder builder = JobStatusFullInofBuilder.newBuilder(jobId, jobNo, RpaJobStatusEnums.PEND_OUTTIME.getCode(), now);
                builder.endTime(now);
                builder.pendingTime(jobWaiteSecond);
                this.jobStatusCache.chacheStatus(builder.build(), ((Object)((Object)this)).getClass().getName());
                this.log.info("\u7b49\u5f85\u8d85\u65f6\u72b6\u6001\u4fee\u6539\u6210\u529f");
            }
        }
        catch (Exception e) {
            this.log.warn((Throwable)e);
        }
    }

    private void countWaiteTime(DynamicObject oneJob, long jobWaiteSecond) {
        try {
            Integer n;
            Long jobId = oneJob.getLong("id");
            DynamicObject job = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_job");
            job.set("id", (Object)jobId);
            boolean needUpdate = false;
            boolean doReCache = false;
            if (jobWaiteSecond > 60L) {
                Integer waitTimes;
                Integer n2 = waitTimes = Integer.valueOf(oneJob.get("ysq_wait_times") == null ? 0 : oneJob.getInt("ysq_wait_times"));
                n = waitTimes = Integer.valueOf(waitTimes + 1);
                job.set("ysq_wait_times", (Object)waitTimes);
                if (waitTimes == 1) {
                    job.set("ysq_wait_time_interval", (Object)DateUtils.getHourInterval(new Date()));
                }
                job.set("ysq_pending_time", (Object)jobWaiteSecond);
                needUpdate = true;
            }
            String jobNo = oneJob.getString("ysq_job_no");
            Integer waitNocacheTimes = oneJob.get("ysq_wait_nocache_times") == null ? 0 : oneJob.getInt("ysq_wait_nocache_times");
            if (this.jobQueueProducer.checkJobExist(jobNo) || RobotPendingJobProducer.getInstance().checkHasJob(jobNo, null)) {
                if (0 != waitNocacheTimes) {
                    job.set("ysq_wait_nocache_times", (Object)0);
                    needUpdate = true;
                }
            } else {
                n = waitNocacheTimes;
                Integer n3 = waitNocacheTimes = Integer.valueOf(waitNocacheTimes + 1);
                if (waitNocacheTimes > 3) {
                    job.set("ysq_wait_nocache_times", (Object)0);
                    needUpdate = true;
                    doReCache = true;
                } else {
                    job.set("ysq_wait_nocache_times", (Object)waitNocacheTimes);
                    needUpdate = true;
                }
            }
            if (needUpdate) {
                SaveServiceHelper.update((DynamicObject)job);
            }
            if (doReCache) {
                this.doReCache(oneJob.getLong("id"), oneJob.getString("ysq_proc_code"), oneJob.getString("ysq_proc_ver"));
            }
        }
        catch (Exception e) {
            this.log.warn((Throwable)e);
        }
    }

    private void doReCache(Long id, String procCode, String procVer) {
        DynamicObject oneJob = null;
        try {
            oneJob = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ysq_rpa_job");
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            oneJob = null;
        }
        if (null == oneJob) {
            return;
        }
        QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        QFilter procVerFilter = new QFilter("ysq_proc_ver", "=", (Object)procVer);
        QFilter[] filters = new QFilter[]{procCodeFilter, procVerFilter};
        DynamicObject processesVers = null;
        try {
            processesVers = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])filters);
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            processesVers = null;
        }
        String proChange = null;
        if (null != processesVers) {
            proChange = processesVers.getString("ysq_pro_change");
        }
        this.jobQueueProducer.addJob(new RpaJobVO().fromDynamicObject(oneJob), proChange);
    }
}

