/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.task;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import ysq.rpac.rpamc.common.enums.RedisLockKeysEnums;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.message.JobQueueProducer;
import ysq.rpac.rpamc.common.status.job.core.JobStatusCache;
import ysq.rpac.rpamc.common.status.job.utils.JobStatusFullInofBuilder;
import ysq.rpac.rpamc.common.task.AbstractRpaOvertimeTask;
import ysq.rpac.rpamc.common.utils.DateUtils;

public class RpaOvertimeRunningTask
extends AbstractRpaOvertimeTask {
    private JobStatusCache jobStatusCache = JobStatusCache.getInstance();
    private JobQueueProducer jobQueueProducer = JobQueueProducer.getInstance();

    @Override
    protected boolean needLock() {
        return false;
    }

    @Override
    protected String getLockKey() {
        return RedisLockKeysEnums.KEY_HEAD.getKey() + RequestContext.get().getAccountId() + "/" + RedisLockKeysEnums.OVERTIME_RUNNING.getKey();
    }

    @Override
    protected boolean hasLock() {
        return this.tryLock();
    }

    @Override
    protected void initStatus() {
        this.status = RpaJobStatusEnums.RUNNING.getCode();
    }

    @Override
    protected void doJobStatus(DynamicObject oneJob, Date now) {
        try {
            Long jobId = oneJob.getLong("id");
            Date jobTime = oneJob.getDate("ysq_job_time");
            if (null != oneJob.get("ysq_start_time")) {
                jobTime = oneJob.getDate("ysq_start_time");
            }
            if (jobTime == null) {
                jobTime = oneJob.getDate("createtime");
            }
            String jobNo = oneJob.getString("ysq_job_no");
            int autoStopTime = oneJob.getInt("ysq_auto_stop_time");
            int runningTimeout = oneJob.getInt("ysq_running_timeout");
            long jobWaiteSecond = DateUtils.getIntervals(DateUtils.getNow(), jobTime);
            if (autoStopTime != 0 && jobWaiteSecond > (long)(autoStopTime * 60)) {
                JobStatusFullInofBuilder builder = JobStatusFullInofBuilder.newBuilder(jobId, jobNo, RpaJobStatusEnums.STOPPING.getCode(), now);
                builder.runTimeSec(jobWaiteSecond);
                this.jobStatusCache.chacheStatus(builder.build(), ((Object)((Object)this)).getClass().getName());
                this.log.info("\u81ea\u52a8\u505c\u6b62\u72b6\u6001\u4fee\u6539\u6210\u529f");
                return;
            }
            if (!this.agentIsOk(oneJob.getString("ysq_curr_robot_no"))) {
                JobStatusFullInofBuilder builder = JobStatusFullInofBuilder.newBuilder(jobId, jobNo, RpaJobStatusEnums.FAILED.getCode(), now);
                builder.endTime(now);
                builder.runTimeSec(jobWaiteSecond);
                this.jobStatusCache.chacheStatus(builder.build(), ((Object)((Object)this)).getClass().getName());
                return;
            }
            if (runningTimeout != 0 && jobWaiteSecond > (long)(runningTimeout * 60)) {
                JobStatusFullInofBuilder builder = JobStatusFullInofBuilder.newBuilder(jobId, jobNo, RpaJobStatusEnums.RUN_OUTTIME.getCode(), now);
                builder.endTime(now);
                builder.runTimeSec(jobWaiteSecond);
                this.jobStatusCache.chacheStatus(builder.build(), ((Object)((Object)this)).getClass().getName());
                this.log.info("\u6b63\u5728\u8fd0\u884c\u8d85\u65f6\u72b6\u6001\u4fee\u6539\u6210\u529f");
                return;
            }
        }
        catch (Exception e) {
            this.log.warn((Throwable)e);
        }
    }
}

