/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.task;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import ysq.rpac.rpamc.common.enums.RedisLockKeysEnums;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.message.JobQueueProducer;
import ysq.rpac.rpamc.common.status.job.core.JobStatusCache;
import ysq.rpac.rpamc.common.status.job.utils.JobStatusFullInofBuilder;
import ysq.rpac.rpamc.common.task.AbstractRpaOvertimeTask;
import ysq.rpac.rpamc.common.utils.DateUtils;

public class RpaOvertimeStoppingTask
extends AbstractRpaOvertimeTask {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private JobStatusCache jobStatusCache = JobStatusCache.getInstance();
    private JobQueueProducer jobQueueProducer = JobQueueProducer.getInstance();

    @Override
    protected boolean needLock() {
        return false;
    }

    @Override
    protected String getLockKey() {
        return RedisLockKeysEnums.KEY_HEAD.getKey() + RequestContext.get().getAccountId() + "/" + RedisLockKeysEnums.OVERTIME_STOPPING.getKey();
    }

    @Override
    protected boolean hasLock() {
        return this.tryLock();
    }

    @Override
    protected void initStatus() {
        this.status = RpaJobStatusEnums.STOPPING.getCode();
    }

    @Override
    protected void doJobStatus(DynamicObject oneJob, Date now) {
        try {
            Long jobId = oneJob.getLong("id");
            Date jobTime = oneJob.getDate("ysq_job_time");
            if (null != oneJob.get("ysq_start_time")) {
                jobTime = oneJob.getDate("ysq_start_time");
            }
            if (jobTime == null) {
                jobTime = oneJob.getDate("createtime");
            }
            String jobNo = oneJob.getString("ysq_job_no");
            long jobWaiteSecond = DateUtils.getIntervals(DateUtils.getNow(), jobTime);
            String currNo = oneJob.getString("ysq_curr_robot_no");
            if (!this.agentIsOk(currNo)) {
                JobStatusFullInofBuilder builder = JobStatusFullInofBuilder.newBuilder(jobId, jobNo, RpaJobStatusEnums.FAILED.getCode(), now);
                builder.endTime(now);
                builder.runTimeSec(jobWaiteSecond);
                this.jobStatusCache.chacheStatus(builder.build(), ((Object)((Object)this)).getClass().getName());
            }
        }
        catch (Exception e) {
            this.log.warn((Throwable)e);
        }
    }
}

