/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.upgrade;

import java.io.InputStream;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentDto;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import ysq.rpac.rpamc.common.constant.YsqProcessConstant;
import ysq.rpac.rpamc.common.constant.YsqSysConfigConstant;

public class ProcessMigrate {
    private static final String MIGRATE_PROCESS = "process_migrated";
    private static final String ATTACHMENT_PANEL = "attachmentpanel";

    public static void migrateProcess() {
        DynamicObject[] allProcess;
        DynamicObject config = ProcessMigrate.findConfig(MIGRATE_PROCESS);
        if (config == null) {
            return;
        }
        String v = config.getString("ysq_value");
        if (!Boolean.parseBoolean(v) && (allProcess = BusinessDataServiceHelper.load((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])new QFilter[0])) != null && allProcess.length > 0) {
            ProcessMigrate.iterProcess(allProcess);
        }
        config.set("ysq_value", (Object)"true");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
    }

    private static void iterProcess(DynamicObject[] allProcess) {
        for (DynamicObject model : allProcess) {
            QFilter versionFilter;
            long processId = model.getLong("id");
            List attachmentpanel = AttachmentServiceHelper.getAttachments((String)"ysq_rpa_process", (Object)processId, (String)ATTACHMENT_PANEL);
            if (attachmentpanel == null || attachmentpanel.size() == 0) continue;
            QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)model.getString("ysq_proc_code"));
            DynamicObject versionModel = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process_ver", (QFilter[])new QFilter[]{codeFilter, versionFilter = new QFilter("ysq_proc_ver", "=", (Object)model.getString("ysq_proc_ver"))});
            if (versionModel == null) continue;
            versionModel.set("billno", (Object)model.getString("billno"));
            SaveServiceHelper.saveOperate((String)"ysq_rpa_process_ver", (DynamicObject[])new DynamicObject[]{versionModel}, (OperateOption)OperateOption.create());
            ProcessMigrate.uploadTargetAttachments("ysq_rpa_process_ver", versionModel.getLong("id"), ATTACHMENT_PANEL, attachmentpanel);
        }
    }

    public static void uploadTargetAttachments(String formId, Object targetId, String attachKey, List<Map<String, Object>> attachments) {
        for (Map<String, Object> attachItem : attachments) {
            DynamicObject obj = AttachmentServiceHelper.getAttCreatorByUID((String)((String)attachItem.get("uid")));
            AttachmentDto attachmentDto = AttachmentServiceHelper.getAttachmentInfoByAttPk((Object)obj.getPkValue());
            String resourcePath = attachmentDto.getResourcePath();
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            FileService fs = FileServiceFactory.getAttachmentFileService();
            InputStream inputStream = fs.getInputStream(resourcePath);
            String tempUrl = cache.saveAsUrl((String)attachItem.get("name"), inputStream, 7200);
            tempUrl = EncreptSessionUtils.encryptSession((String)tempUrl);
            String address = RequestContext.get().getClientFullContextPath();
            if (!address.endsWith("/")) {
                address = address + "/";
            }
            String tempUrl3 = address + tempUrl;
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
            String appId = dataEntityType.getAppId();
            String name = (String)attachItem.get("name");
            String path = AttachmentServiceHelper.saveTempToFileService((String)tempUrl3, (String)appId, (String)formId, (Object)targetId, (String)name);
            attachItem.put("url", path);
            Timestamp lastModified = (Timestamp)attachItem.get("lastModified");
            attachItem.put("lastModified", lastModified.getTime());
            Object description = attachItem.get("description");
            attachItem.put("description", description);
        }
        AttachmentServiceHelper.upload((String)formId, (Object)targetId, (String)attachKey, attachments);
    }

    private static DynamicObject findConfig(String key) {
        QFilter keyFilter = new QFilter("ysq_key", "=", (Object)key);
        DynamicObject config = BusinessDataServiceHelper.loadSingle((String)"ysq_sys_config", (String)YsqSysConfigConstant.selAllFileds(), (QFilter[])new QFilter[]{keyFilter});
        return config;
    }
}

