/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.utils;

import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.HyperlinkAp;
import kd.bos.metadata.form.control.LabelAp;

public class CreateFieldUtils {
    public static FieldAp createFiledAp(String key, String name) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setBackColor("#FFFFFF");
        fieldAp.setFireUpdEvt(true);
        return fieldAp;
    }

    public static FieldAp createTextField(String key, String name, boolean isPas, boolean isMust, int maxValue, boolean isVisible) {
        FieldAp fieldAp = CreateFieldUtils.createFiledAp(key, name);
        TextField field = new TextField();
        Map editor = field.createEditor();
        field.setCustomProperties(editor);
        field.setId(key);
        field.setKey(key);
        field.setPassword(isPas);
        field.setMustInput(isMust);
        field.setMaxLength(maxValue);
        int maxLength = field.getMaxLength();
        fieldAp.setField((Field)field);
        if (!isVisible) {
            fieldAp.setVisible("");
        }
        return fieldAp;
    }

    public static FieldAp createIntegerField(String key, String name, boolean isMust, String dataScope) {
        FieldAp fieldAp = CreateFieldUtils.createFiledAp(key, name);
        IntegerField integerField = new IntegerField();
        integerField.setId(key);
        integerField.setKey(key);
        integerField.setDataScope("");
        integerField.setMustInput(isMust);
        fieldAp.setField((Field)integerField);
        return fieldAp;
    }

    public static FieldAp createDecimalField(String key, String name, boolean isMust, int precision, int scale) {
        FieldAp fieldAp = CreateFieldUtils.createFiledAp(key, name);
        DecimalField decimalField = new DecimalField();
        decimalField.setId(key);
        decimalField.setKey(key);
        decimalField.setMustInput(isMust);
        decimalField.setScale(scale);
        decimalField.setPrecision(precision);
        fieldAp.setField((Field)decimalField);
        return fieldAp;
    }

    @Deprecated
    public static FieldAp createFile(String key, String name, boolean isMust, String extendName) {
        FieldAp fieldAp = CreateFieldUtils.createFiledAp(key, name);
        AttachmentField attachmentField = new AttachmentField();
        attachmentField.setId(key);
        attachmentField.setKey(key);
        attachmentField.setMustInput(isMust);
        attachmentField.setExtendName(extendName);
        fieldAp.setField((Field)attachmentField);
        return fieldAp;
    }

    public static HyperlinkAp createFileurl(String key, String name, String url) {
        HyperlinkAp hyperlinkAp = new HyperlinkAp();
        hyperlinkAp.setLinkUrl(url);
        hyperlinkAp.setId(key);
        hyperlinkAp.setKey(key);
        hyperlinkAp.setName(new LocaleString(name));
        Style style = hyperlinkAp.getStyle();
        if (style == null) {
            style = new Style();
        }
        Margin margin = new Margin();
        margin.setTop("4px");
        margin.setRight("10px");
        style.setMargin(margin);
        hyperlinkAp.setStyle(style);
        return hyperlinkAp;
    }

    public static ButtonAp createFileButton(String key, String name) {
        ButtonAp buttonAp = new ButtonAp();
        buttonAp.setId(key);
        buttonAp.setKey(key);
        buttonAp.setName(new LocaleString(name));
        buttonAp.setWidth(new LocaleString("100px"));
        buttonAp.setHeight(new LocaleString("20px"));
        return buttonAp;
    }

    public static FieldAp createCombo(String key, String name, boolean isMust) {
        FieldAp fieldAp = CreateFieldUtils.createFiledAp(key, name);
        ComboField comboField = new ComboField();
        comboField.setId(key);
        comboField.setKey(key);
        comboField.setMustInput(isMust);
        fieldAp.setField((Field)comboField);
        return fieldAp;
    }

    public static FieldAp createCheckBox(String key, String name, boolean isMust) {
        FieldAp fieldAp = CreateFieldUtils.createFiledAp(key, name);
        CheckBoxField checkBoxField = new CheckBoxField();
        checkBoxField.setId(key);
        checkBoxField.setKey(key);
        checkBoxField.setMustInput(isMust);
        checkBoxField.setShowStyle(2);
        fieldAp.setField((Field)checkBoxField);
        return fieldAp;
    }

    public static LabelAp createLable(String key, String name) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(key);
        labelAp.setId(key);
        labelAp.setName(new LocaleString(name));
        Style style = labelAp.getStyle();
        if (style == null) {
            style = new Style();
        }
        Margin margin = new Margin();
        margin.setBottom("7px");
        style.setMargin(margin);
        labelAp.setStyle(style);
        labelAp.setForeColor("#666666");
        return labelAp;
    }

    public static LabelAp createLableFile(String key, String name) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(key);
        labelAp.setId(key);
        labelAp.setName(new LocaleString(name));
        Style style = labelAp.getStyle();
        if (style == null) {
            style = new Style();
        }
        Margin margin = new Margin();
        margin.setTop("6px");
        margin.setRight("10px");
        style.setMargin(margin);
        labelAp.setStyle(style);
        labelAp.setForeColor("#666666");
        return labelAp;
    }
}

