/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.utils;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.enums.ScheduleModelEnums;

public class CronExpressionUtils {
    private static Log logger = LogFactory.getLog(CronExpressionUtils.class);
    public static final String MSG_MONDAY = "\u661f\u671f\u4e00";
    public static final String MSG_TUESDAY = "\u661f\u671f\u4e8c";
    public static final String MSG_WEDNESDAY = "\u661f\u671f\u4e09";
    public static final String MSG_THURSDAY = "\u661f\u671f\u56db";
    public static final String MSG_FRIDAY = "\u661f\u671f\u4e94";
    public static final String MSG_SATURDAY = "\u661f\u671f\u516d";
    public static final String MSG_SUNDAY = "\u661f\u671f\u65e5";

    public static String[] getCronExpression(String scheduleModel, String scheduleCommand, String scheduleTime) {
        logger.info("Ready get CronExpression from (" + scheduleModel + " - " + scheduleCommand + " - " + scheduleTime + ")");
        String[] resultArr = new String[3];
        if (ScheduleModelEnums.TIME.getCode().equals(scheduleModel)) {
            String[] array = scheduleCommand.split(" ");
            String[] yyyyMMdd = array[0].split("-");
            String[] hhmm = array[1].split("\\:");
            resultArr[0] = String.format("\u5b9a\u65f6", new Object[0]);
            resultArr[1] = "00 " + hhmm[1] + " " + hhmm[0] + " " + yyyyMMdd[2] + " " + yyyyMMdd[1] + " ? " + yyyyMMdd[0];
            resultArr[2] = String.format("\u5728%s:00\u6267\u884c\u4e00\u6b21", scheduleCommand);
        } else if (ScheduleModelEnums.MIN.getCode().equals(scheduleModel)) {
            resultArr[0] = String.format("\u5206\u949f", new Object[0]);
            resultArr[1] = "0 0/" + scheduleCommand + " * * * ?";
            resultArr[2] = String.format("\u6bcf\u9694%s\u5206\u949f\u6267\u884c\u4e00\u6b21", scheduleCommand);
        } else if (ScheduleModelEnums.HOUR.getCode().equals(scheduleModel)) {
            resultArr[0] = String.format("\u5c0f\u65f6", new Object[0]);
            resultArr[1] = "0 " + scheduleTime + " 0/" + scheduleCommand + " * * ?";
            resultArr[2] = String.format("\u6bcf\u9694%s\u5c0f\u65f6,\u5728%s\u520600\u79d2\u6267\u884c\u4e00\u6b21", scheduleCommand, scheduleTime);
        } else if (ScheduleModelEnums.DAY.getCode().equals(scheduleModel)) {
            resultArr[0] = String.format("\u5929", new Object[0]);
            String[] array = scheduleTime.split("\\:");
            resultArr[1] = "00 " + array[1] + " " + array[0] + " * * ?";
            resultArr[2] = String.format("\u5728\u6bcf\u5929\u7684%s:00\u6267\u884c\u4e00\u6b21", scheduleTime);
        } else if (ScheduleModelEnums.WEEK.getCode().equals(scheduleModel)) {
            resultArr[0] = String.format("\u661f\u671f", new Object[0]);
            if (StringUtils.isBlank((CharSequence)scheduleCommand)) {
                scheduleCommand = "?";
            }
            String[] array = scheduleTime.split("\\:");
            resultArr[1] = "00 " + array[1] + " " + array[0] + " ? * " + scheduleCommand + " *";
            String week = scheduleCommand.replace("1", MSG_SUNDAY);
            week = week.replace("2", MSG_MONDAY);
            week = week.replace("3", MSG_TUESDAY);
            week = week.replace("4", MSG_WEDNESDAY);
            week = week.replace("5", MSG_THURSDAY);
            week = week.replace("6", MSG_FRIDAY);
            week = week.replace("7", MSG_SATURDAY);
            resultArr[2] = String.format("\u5728\u6bcf\u5468\u7684%s\u7684%s:00\u6267\u884c\u4e00\u6b21", week, scheduleTime);
        } else if (ScheduleModelEnums.MONTH.getCode().equals(scheduleModel)) {
            resultArr[0] = "\u6708";
            scheduleCommand = scheduleCommand.replaceAll("99", "L");
            String[] array = scheduleTime.split("\\:");
            resultArr[1] = "00 " + array[1] + " " + array[0] + " " + scheduleCommand + " " + "?";
            String[] mmdd = scheduleCommand.split(" ");
            resultArr[2] = String.format("\u5728%s\u6708\u7684%s\u65e5%s:00\u6267\u884c\u4e00\u6b21", mmdd[1], mmdd[0], scheduleTime);
        } else if (ScheduleModelEnums.CRON.getCode().equals(scheduleModel)) {
            resultArr[0] = "cron\u8868\u8fbe\u5f0f";
            resultArr[1] = scheduleCommand;
            resultArr[2] = String.format("\u81ea\u5b9a\u4e49\u8868\u8fbe\u5f0f: %s", scheduleCommand);
        } else {
            logger.info("Unkown sheduleMode error: " + scheduleModel);
            return null;
        }
        return resultArr;
    }

    public static String[] buildCommands(String scheduleModel, String cronExpression, String minSplit, String hourSplit, String schTime, String week, String monthSelMonth, String monthSelDay) {
        String[] resultArr = new String[2];
        if (ScheduleModelEnums.TIME.getCode().equals(scheduleModel)) {
            return null;
        }
        if (ScheduleModelEnums.MIN.getCode().equals(scheduleModel)) {
            resultArr[0] = minSplit.trim();
            resultArr[1] = "";
        } else if (ScheduleModelEnums.HOUR.getCode().equals(scheduleModel)) {
            resultArr[0] = hourSplit.trim();
            resultArr[1] = (minSplit = minSplit.trim()).length() > 1 ? minSplit : "0" + minSplit;
        } else if (ScheduleModelEnums.DAY.getCode().equals(scheduleModel)) {
            resultArr[0] = "";
            resultArr[1] = schTime.trim();
        } else if (ScheduleModelEnums.WEEK.getCode().equals(scheduleModel)) {
            resultArr[0] = CronExpressionUtils.viewManySelToStr(week);
            resultArr[1] = schTime.trim();
        } else if (ScheduleModelEnums.MONTH.getCode().equals(scheduleModel)) {
            resultArr[0] = CronExpressionUtils.viewManySelToStr(monthSelDay) + " " + CronExpressionUtils.viewManySelToStr(monthSelMonth);
            resultArr[1] = schTime.trim();
        } else if (ScheduleModelEnums.CRON.getCode().equals(scheduleModel)) {
            resultArr[0] = cronExpression;
            resultArr[1] = "";
        } else {
            logger.info("Unkown sheduleMode error: " + scheduleModel);
            return null;
        }
        return resultArr;
    }

    private static String viewManySelToStr(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return "";
        }
        int index = 0;
        StringBuilder newStr = new StringBuilder();
        for (String oneStr : source.split(",")) {
            if (!StringUtils.isNotBlank((CharSequence)oneStr)) continue;
            newStr.append(",");
            newStr.append(oneStr.trim());
            ++index;
        }
        if (index > 0) {
            return newStr.toString().substring(1);
        }
        return "";
    }
}

