/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class DateUtils {
    private static Log log = LogFactory.getLog(DateUtils.class);
    public static final String FORMART_yyyyMMdd = "yyyyMMdd";
    public static final String FORMART_yyyyMMddHHmmss = "yyyyMMddHHmmss";
    public static final String FORMART_yyyyMMddHHmmssSSS = "yyyyMMddHHmmssSSS";
    public static final String FORMART_FULL = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMART_DATE = "yyyy-MM-dd";
    public static final String FORMART_HH = "HH";
    public static final String FORMART_TIME = "HH:mm:ss";
    public static final String FORMART_UTC = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String UTC_ZONE_FORMATER = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String LOGTIME_FORMATTER = "yyyy-MM-dd HH:mm:ss,SSS";
    public static final String DEFAULT_LOCAL = "en_US";
    public static final long SECOND_MIS = 1000L;
    public static final long MINUTE_MIS = 60000L;
    public static final long HOUR_MIS = 3600000L;
    public static final long DAY_MIS = 86400000L;

    public static String full() {
        return DateUtils.formatDate(DateUtils.getNow(), FORMART_FULL);
    }

    public static Date getNow() {
        return new Date();
    }

    public static Date parseDate(String dateStr) {
        return DateUtils.parseDate(dateStr, FORMART_FULL);
    }

    public static long dateToTimeStamp(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMART_FULL);
        try {
            Date dateToTimeStamp = sdf.parse(date);
            return dateToTimeStamp.getTime();
        }
        catch (ParseException e) {
            log.debug("\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return 0L;
        }
    }

    public static long dateToTimeStamp(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            Date dateToTimeStamp = sdf.parse(date);
            return dateToTimeStamp.getTime();
        }
        catch (ParseException e) {
            log.debug("\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return 0L;
        }
    }

    public static String engDateToString(String date, String format) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
        SimpleDateFormat sdf2 = new SimpleDateFormat(format);
        Date parse = null;
        try {
            parse = sdf1.parse(date);
            System.out.println(parse);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return sdf2.format(parse);
    }

    public static Timestamp getTimestamp() {
        return new Timestamp(Calendar.getInstance().getTimeInMillis());
    }

    public static String timeStampToDate(long timeStamp) {
        return DateUtils.timeStampToDate(timeStamp, FORMART_FULL);
    }

    public static String timeStampToDate(long timeStamp, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String sd = sdf.format(new Date(Long.parseLong(String.valueOf(timeStamp))));
        return sd;
    }

    public static long getInterval(String src, String dest) {
        if (src == null || dest == null) {
            return 0L;
        }
        Date start = DateUtils.parseDate(src, FORMART_FULL);
        Date end = DateUtils.parseDate(dest, FORMART_FULL);
        if (start == null || end == null) {
            return 0L;
        }
        long time = end.getTime() - start.getTime();
        return time <= 0L ? 0L : time;
    }

    public static Date parseDate(String dateStr, String format) {
        try {
            if (StringUtils.isBlank((CharSequence)dateStr)) {
                return null;
            }
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.parse(dateStr);
        }
        catch (ParseException e) {
            log.debug("\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return null;
        }
    }

    public static String formatDate(Date date) {
        return DateUtils.formatDate(date, FORMART_FULL);
    }

    public static String formatDate(Date date, String type) {
        if (date == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)type)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(type);
        return sdf.format(date);
    }

    public static long getIntervals(Date end, Date start) {
        if (end == null || start == null) {
            return 0L;
        }
        Calendar nc = Calendar.getInstance();
        nc.setTime(end);
        Calendar oc = Calendar.getInstance();
        oc.setTime(start);
        return (nc.getTimeInMillis() - oc.getTimeInMillis()) / 1000L;
    }

    private DateUtils() {
    }

    public static Date addSeconds(Date date, int amount) {
        return DateUtils.add(date, 13, amount);
    }

    private static Date add(Date date, int calendarField, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static String getHourInterval(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        int hourStart = calendar.get(11);
        int hourEnd = hourStart + 1;
        String hourStartStr = (hourStart > 9 ? "" + hourStart : "0" + hourStart) + ":00";
        String hourEndStr = (hourEnd > 9 ? "" + hourEnd : "0" + hourEnd) + ":00";
        return hourStartStr + "-" + hourEndStr;
    }

    public static String secondToTime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = (seconds %= 3600L) / 60L;
        String hour = (hours + "").toString().length() < 2 ? "0" + hours + "" : hours + "";
        String minute = (minutes + "").toString().length() < 2 ? "0" + minutes + "" : minutes + "";
        String second = (seconds + "").toString().length() < 2 ? "0" + seconds + "" : (seconds %= 60L) + "";
        return hour + "\u5c0f\u65f6" + minute + "\u5206" + second + "\u79d2";
    }

    public static String secondToTimeFormat(long seconds) {
        StringBuffer sb = new StringBuffer();
        if (seconds >= 3600L) {
            long hours = seconds / 3600L;
            sb.append(hours + "\u5c0f\u65f6");
            seconds -= 3600L * hours;
        }
        if (seconds >= 60L) {
            long minutes = seconds / 60L;
            sb.append(minutes + "\u5206");
            seconds -= minutes * 60L;
        }
        return sb.append(seconds + "\u79d2").toString();
    }

    public static Date getWeekStartDate() {
        Calendar calendar = Calendar.getInstance();
        int dayOfWeek = calendar.get(7) - 1;
        int num = dayOfWeek == 1 ? 0 : (dayOfWeek == 0 ? -6 : 1 - dayOfWeek);
        calendar.add(5, num);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getWeekEnd() {
        Calendar cal = Calendar.getInstance();
        cal.set(7, cal.getActualMaximum(7));
        cal.add(7, 1);
        Date time = cal.getTime();
        return time;
    }

    public static boolean dateBefore(String sourceDate, String destDate) {
        return DateUtils.dateBefore(sourceDate, destDate, FORMART_FULL);
    }

    public static boolean dateBefore(String sourceDate, String destDate, String format) {
        try {
            SimpleDateFormat formater = new SimpleDateFormat(format);
            Date source = formater.parse(sourceDate);
            Date dest = formater.parse(destDate);
            return source.before(dest);
        }
        catch (ParseException e) {
            log.error(" \u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return false;
        }
    }

    public static String getCurrentDate() {
        return DateUtils.formatDate(DateUtils.getNow(), FORMART_FULL);
    }
}

