/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.annotation.OperateFileLog;
import ysq.rpac.rpamc.common.utils.UserUtils;

public class EsUtils {
    public static void addAssetEsIndex(DynamicObject assetObj, String action, String agentNo, String jobNo, String procCode, Long userId, String agentType, String details) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ysq_asset_log");
        DynamicObject object = new DynamicObject((DynamicObjectType)entityType);
        object.set("ysq_data_no", (Object)EsUtils.xuuid());
        object.set("ysq_assetid", assetObj.get("id"));
        object.set("ysq_asset_name", (Object)assetObj.getString("ysq_asset_name"));
        object.set("ysq_asset_value_tag", (Object)assetObj.getString("ysq_asset_value_tag"));
        object.set("ysq_asset_desc_tag", (Object)assetObj.getString("ysq_asset_desc"));
        object.set("ysq_asset_type", (Object)assetObj.getString("ysq_asset_type"));
        object.set("ysq_asset_type", (Object)assetObj.getString("ysq_asset_type"));
        if (userId != null) {
            String name = UserUtils.getUserName(userId);
            object.set("username", (Object)name);
        }
        if (assetObj.getBoolean("ysq_is_client_edit")) {
            object.set("ysq_is_client_edit", (Object)"true");
        } else {
            object.set("ysq_is_client_edit", (Object)"false");
        }
        if (assetObj.getBoolean("ysq_is_python_expr")) {
            object.set("ysq_is_python_exp", (Object)"true");
        } else {
            object.set("ysq_is_python_exp", (Object)"false");
        }
        object.set("ysq_access_time", (Object)new Date());
        object.set("ysq_data_module", (Object)"asset");
        object.set("ysq_action", (Object)action);
        object.set("ysq_proc_code", (Object)procCode);
        object.set("ysq_robot_no_tag", (Object)agentNo);
        object.set("ysq_operator", (Object)userId);
        object.set("ysq_job_no", (Object)jobNo);
        object.set("ysq_agent_type", (Object)agentType);
        object.set("ysq_details_tag", (Object)details);
        if (StringUtils.isNotBlank((CharSequence)procCode)) {
            QFilter procCOdeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
            DynamicObject procObject = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)"ysq_proc_name", (QFilter[])new QFilter[]{procCOdeFilter});
            if (procObject != null) {
                object.set("ysq_proc_name", (Object)procObject.getString("ysq_proc_name"));
            }
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        list.add(object);
        LogORM logORM = LogORM.create();
        logORM.insert(list);
    }

    public static long[] addQueueEsLog(List<DynamicObject> queueObjList, String action, String agentNo, String agentAlias, String agentType, String jobNo, String procCode, String detail) {
        LogORM logORM = LogORM.create();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject queueObj : queueObjList) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ysq_queues_log");
            DynamicObject object = new DynamicObject((DynamicObjectType)entityType);
            object.set("ysq_data_no", (Object)EsUtils.xuuid());
            Long userId = RequestContext.get().getCurrUserId();
            if (userId != null) {
                String name = UserUtils.getUserName(userId);
                object.set("username", (Object)name);
            }
            object.set("ysq_data_module", (Object)"queue");
            object.set("ysq_action", (Object)action);
            if (StringUtils.isNotBlank((CharSequence)agentAlias)) {
                object.set("ysq_robot_no", (Object)agentAlias);
            } else if (StringUtils.isNotBlank((CharSequence)agentNo)) {
                object.set("ysq_robot_no", (Object)agentNo);
            } else {
                object.set("ysq_robot_no", (Object)"-");
            }
            if (StringUtils.isNotBlank((CharSequence)agentType)) {
                object.set("ysq_agent_type", (Object)agentType);
            } else {
                object.set("ysq_agent_type", (Object)"");
            }
            if (StringUtils.isNotBlank((CharSequence)jobNo)) {
                object.set("ysq_job_no", (Object)jobNo);
            } else {
                object.set("ysq_job_no", (Object)"-");
            }
            object.set("ysq_proc_code", (Object)procCode);
            object.set("ysq_queue_name", (Object)queueObj.getString("ysq_queue_name"));
            object.set("ysq_status", (Object)queueObj.getString("ysq_status"));
            object.set("ysq_item_no", (Object)queueObj.getString("ysq_item_no"));
            object.set("ysq_fail_try_times", (Object)queueObj.getLong("ysq_fail_try_times"));
            object.set("ysq_queue_max_items", (Object)queueObj.getLong("ysq_queue_max_items"));
            object.set("ysq_create_time", (Object)queueObj.getDate("createtime"));
            object.set("ysq_end_time", (Object)queueObj.getDate("ysq_deadline"));
            object.set("ysq_fail_desc", (Object)queueObj.getString("ysq_faildesc"));
            object.set("ysq_detail", (Object)detail);
            list.add(object);
        }
        return logORM.insert(list);
    }

    public static int delQueueEsLog(String queueName) {
        if (StringUtils.isBlank((CharSequence)queueName)) {
            return 0;
        }
        LogORM logORM = LogORM.create();
        QFilter qFilter = new QFilter("ysq_queue_name", "=", (Object)queueName);
        int delete = logORM.delete("ysq_queues_log", new QFilter[]{qFilter});
        return delete;
    }

    public static int delQueueItemEsLog(String itemNo) {
        if (StringUtils.isBlank((CharSequence)itemNo)) {
            return 0;
        }
        LogORM logORM = LogORM.create();
        QFilter qFilter = new QFilter("ysq_item_no", "=", (Object)itemNo);
        int delete = logORM.delete("ysq_queues_log", new QFilter[]{qFilter});
        return delete;
    }

    public static int delAssetEsLog(Long assetId) {
        if (assetId == null || assetId.equals(0L)) {
            return 0;
        }
        LogORM logORM = LogORM.create();
        QFilter qFilter = new QFilter("ysq_assetid", "=", (Object)assetId);
        int delete = logORM.delete("ysq_asset_log", new QFilter[]{qFilter});
        return delete;
    }

    public static String xuuid() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static void addFileEsIndex(Long fileId, String fileName, String action, DynamicObject process, Long userId, Long orgId, String agentAlias) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ysq_rpa_file_log");
        DynamicObject ysqFileLog = new DynamicObject((DynamicObjectType)entityType);
        ysqFileLog.set("ysq_file_name", (Object)fileName);
        ysqFileLog.set("ysq_file_id", (Object)fileId);
        ysqFileLog.set("ysq_opt_type", (Object)action);
        ysqFileLog.set("ysq_opt_user_id", (Object)userId);
        if (userId != null) {
            String name = UserUtils.getUserName(userId);
            ysqFileLog.set("ysq_opt_user_name", (Object)name);
        }
        ysqFileLog.set("ysq_opt_org_code", (Object)orgId);
        ysqFileLog.set("ysq_opt_org_name", (Object)UserUtils.getDptNameById(orgId));
        if (process != null) {
            ysqFileLog.set("ysq_proc_name", (Object)process.getString("ysq_proc_name"));
            ysqFileLog.set("ysq_proc_code", (Object)process.getString("ysq_proc_code"));
        }
        ysqFileLog.set("ysq_agent_alias", (Object)agentAlias);
        ysqFileLog.set("ysq_opt_time", (Object)new Date());
        StringBuffer desc = new StringBuffer();
        if (action.equals(OperateFileLog.Type.PAGE_UPLOAD.getType())) {
            desc.append(OperateFileLog.Desc.USER.getDesc() + ysqFileLog.getString("ysq_opt_user_name") + OperateFileLog.Desc.HAND_MOVEMENT.getDesc() + OperateFileLog.Desc.UPLOAD.getDesc());
        } else if (action.equals(OperateFileLog.Type.STUDIO_UPLOAD.getType())) {
            desc.append(OperateFileLog.Desc.USER.getDesc() + ysqFileLog.getString("ysq_opt_user_name") + OperateFileLog.Desc.STUDIO.getDesc() + OperateFileLog.Desc.UPLOAD.getDesc());
        } else if (action.equals(OperateFileLog.Type.AGENT_UPLOAD.getType())) {
            if (process == null) {
                process = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_process");
                process.set("ysq_proc_name", (Object)"");
            }
            desc.append(OperateFileLog.Desc.USER.getDesc() + ysqFileLog.getString("ysq_opt_user_name") + "/" + agentAlias + OperateFileLog.Desc.AGENT.getDesc() + process.getString("ysq_proc_name") + OperateFileLog.Desc.UPLOAD.getDesc());
        } else if (action.equals(OperateFileLog.Type.STUDIO_RECOVER.getType())) {
            desc.append(OperateFileLog.Desc.USER.getDesc() + ysqFileLog.getString("ysq_opt_user_name") + OperateFileLog.Desc.STUDIO.getDesc() + OperateFileLog.Desc.RECOVER.getDesc());
        } else if (action.equals(OperateFileLog.Type.AGENT_RECOVER.getType())) {
            if (process == null) {
                process = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_process");
                process.set("ysq_proc_name", (Object)"");
            }
            desc.append(OperateFileLog.Desc.USER.getDesc() + ysqFileLog.getString("ysq_opt_user_name") + "/" + agentAlias + OperateFileLog.Desc.AGENT.getDesc() + process.getString("ysq_proc_name") + OperateFileLog.Desc.RECOVER.getDesc());
        } else if (action.equals(OperateFileLog.Type.PAGE_DOWNLOUD.getType())) {
            desc.append(OperateFileLog.Desc.USER.getDesc() + ysqFileLog.getString("ysq_opt_user_name") + OperateFileLog.Desc.HAND_MOVEMENT.getDesc() + OperateFileLog.Desc.DOWNLOAD.getDesc());
        } else if (action.equals(OperateFileLog.Type.STUDIO_DOWNLOUD.getType())) {
            desc.append(OperateFileLog.Desc.USER.getDesc() + ysqFileLog.getString("ysq_opt_user_name") + OperateFileLog.Desc.STUDIO.getDesc() + OperateFileLog.Desc.DOWNLOAD.getDesc());
        } else if (action.equals(OperateFileLog.Type.AGENT_DOWNLOUD.getType())) {
            if (process == null) {
                process = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_process");
                process.set("ysq_proc_name", (Object)"");
            }
            desc.append(OperateFileLog.Desc.USER.getDesc() + ysqFileLog.getString("ysq_opt_user_name") + "/" + agentAlias + OperateFileLog.Desc.AGENT.getDesc() + process.getString("ysq_proc_name") + OperateFileLog.Desc.DOWNLOAD.getDesc());
        } else if (action.equals(OperateFileLog.Type.PAGE_DELETE.getType())) {
            desc.append(OperateFileLog.Desc.USER.getDesc() + ysqFileLog.getString("ysq_opt_user_name") + OperateFileLog.Desc.HAND_MOVEMENT.getDesc() + OperateFileLog.Desc.DELETE.getDesc() + "\u201c" + fileName + "\u201d");
        } else if (action.equals(OperateFileLog.Type.STUDIO_DELETE.getType())) {
            desc.append(OperateFileLog.Desc.USER.getDesc() + ysqFileLog.getString("ysq_opt_user_name") + OperateFileLog.Desc.STUDIO.getDesc() + OperateFileLog.Desc.DELETE.getDesc() + "\u201c" + fileName + "\u201d");
        } else if (action.equals(OperateFileLog.Type.AGENT_DELETE.getType())) {
            if (process == null) {
                process = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_process");
                process.set("ysq_proc_name", (Object)"");
            }
            desc.append(OperateFileLog.Desc.USER.getDesc() + ysqFileLog.getString("ysq_opt_user_name") + "/" + agentAlias + OperateFileLog.Desc.AGENT.getDesc() + process.getString("ysq_proc_name") + OperateFileLog.Desc.DELETE.getDesc() + "\u201c" + fileName + "\u201d");
        } else if (action.equals(OperateFileLog.Type.CLEAN.getType())) {
            desc.append(OperateFileLog.Desc.USER.getDesc() + ysqFileLog.getString("ysq_opt_user_name") + OperateFileLog.Desc.HAND_MOVEMENT.getDesc() + OperateFileLog.Desc.CLEAN.getDesc());
        }
        ysqFileLog.set("ysq_opt_desc", (Object)desc.toString());
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        list.add(ysqFileLog);
        LogORM logORM = LogORM.create();
        logORM.insert(list);
    }
}

