/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.utils;

import com.isearch.license.verifier.LicenseVerifier;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.model.dto.SignInfosDTO;

public class IpkgUtils {
    private static Log log = LogFactory.getLog(IpkgUtils.class);
    private static final String NULL = "null";
    private static final double DIFFLIMIT = 0.02;

    public static Map<String, Object> checkIpkgIsIntact(Map<String, Object> ipkgInfomap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String proName = String.valueOf(ipkgInfomap.get("proName"));
        String proVersion = String.valueOf(ipkgInfomap.get("proVersion"));
        String proChange = String.valueOf(ipkgInfomap.get("proChange"));
        String proStudio = String.valueOf(ipkgInfomap.get("proStudio"));
        Map proAppInfosmap = MapUtils.getMap(ipkgInfomap, (Object)"proAppInfos");
        Map proAppExteInfosmap = MapUtils.getMap(ipkgInfomap, (Object)"proAppExteInfos");
        if (StringUtils.isBlank((CharSequence)proName) || StringUtils.equals((CharSequence)NULL, (CharSequence)proName)) {
            resultMap.put("result", false);
            resultMap.put("message", "Ipkg\u5305\u4e2d\u7f3a\u5931proName\u5b57\u6bb5");
            return resultMap;
        }
        if (StringUtils.isBlank((CharSequence)proVersion) || StringUtils.equals((CharSequence)NULL, (CharSequence)proVersion)) {
            resultMap.put("result", false);
            resultMap.put("message", "Ipkg\u5305\u4e2d\u7f3a\u5931proVersion\u5b57\u6bb5");
            return resultMap;
        }
        if (StringUtils.isBlank((CharSequence)proChange) || StringUtils.equals((CharSequence)NULL, (CharSequence)proChange)) {
            resultMap.put("result", false);
            resultMap.put("message", "Ipkg\u5305\u4e2d\u7f3a\u5931proChange\u5b57\u6bb5");
            return resultMap;
        }
        if (StringUtils.isBlank((CharSequence)proStudio) || StringUtils.equals((CharSequence)NULL, (CharSequence)proStudio)) {
            resultMap.put("result", false);
            resultMap.put("message", "Ipkg\u5305\u4e2d\u7f3a\u5931proStudio\u5b57\u6bb5");
            return resultMap;
        }
        if (!ipkgInfomap.containsKey("mainPySize")) {
            resultMap.put("result", false);
            resultMap.put("message", "Ipkg\u5305\u4e2d\u7f3a\u5931Main.py\u6587\u4ef6");
            return resultMap;
        }
        if (proAppInfosmap == null || proAppInfosmap.isEmpty() || !proAppInfosmap.containsKey("appType") || StringUtils.isBlank((CharSequence)MapUtils.getString((Map)proAppInfosmap, (Object)"appType")) || !proAppInfosmap.containsKey("devComCode") || StringUtils.isBlank((CharSequence)MapUtils.getString((Map)proAppInfosmap, (Object)"devComCode")) || !proAppInfosmap.containsKey("appSn") || StringUtils.isBlank((CharSequence)MapUtils.getString((Map)proAppInfosmap, (Object)"appSn")) || !proAppInfosmap.containsKey("isOpenSource") || StringUtils.isBlank((CharSequence)MapUtils.getString((Map)proAppInfosmap, (Object)"isOpenSource")) || !proAppInfosmap.containsKey("fileSize") || StringUtils.isBlank((CharSequence)MapUtils.getString((Map)proAppInfosmap, (Object)"fileSize")) || !proAppInfosmap.containsKey("proChange") || StringUtils.isBlank((CharSequence)MapUtils.getString((Map)proAppInfosmap, (Object)"proChange")) || !proAppInfosmap.containsKey("proVersion") || StringUtils.isBlank((CharSequence)MapUtils.getString((Map)proAppInfosmap, (Object)"proVersion")) || !proAppInfosmap.containsKey("signCode") || StringUtils.isBlank((CharSequence)MapUtils.getString((Map)proAppInfosmap, (Object)"signCode"))) {
            resultMap.put("result", false);
            resultMap.put("message", "Ipkg\u5305\u4e2dProAppInfos\u5b57\u6bb5\u975e\u6cd5");
            return resultMap;
        }
        if (proAppExteInfosmap == null || proAppExteInfosmap.isEmpty() || !proAppExteInfosmap.containsKey("appName") || StringUtils.isBlank((CharSequence)MapUtils.getString((Map)proAppExteInfosmap, (Object)"appName")) || !proAppExteInfosmap.containsKey("devComName") || StringUtils.isBlank((CharSequence)MapUtils.getString((Map)proAppExteInfosmap, (Object)"devComName")) || !proAppExteInfosmap.containsKey("productType") || StringUtils.isBlank((CharSequence)MapUtils.getString((Map)proAppExteInfosmap, (Object)"productType")) || !proAppExteInfosmap.containsKey("permitCode") || StringUtils.isBlank((CharSequence)MapUtils.getString((Map)proAppExteInfosmap, (Object)"permitCode")) || !proAppExteInfosmap.containsKey("permitGroupNumber") || proAppExteInfosmap.get("permitGroupNumber") == null || !proAppExteInfosmap.containsKey("appDesc") || proAppExteInfosmap.get("appDesc") == null) {
            resultMap.put("result", false);
            resultMap.put("message", "Ipkg\u5305\u4e2dProAppExteInfos\u5b57\u6bb5\u975e\u6cd5");
            return resultMap;
        }
        resultMap.put("result", true);
        resultMap.put("message", "Ipkg\u6821\u9a8c\u7ed3\u679c\u6b63\u786e");
        return resultMap;
    }

    public static Map<String, Object> checkNoOpenIpkg(Map<String, Object> ipkgInfomap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (!ipkgInfomap.containsKey("proAppInfos")) {
            resultMap.put("result", false);
            resultMap.put("message", "Ipkg\u5305\u4e2d\u7f3a\u5c11proAppInfos\u5b57\u6bb5");
            return resultMap;
        }
        if (!ipkgInfomap.containsKey("proAppExteInfos")) {
            resultMap.put("result", false);
            resultMap.put("message", "Ipkg\u5305\u4e2d\u7f3a\u5c11proAppExteInfos\u5b57\u6bb5");
            return resultMap;
        }
        HashMap proAppInfos = (HashMap)ipkgInfomap.get("proAppInfos");
        HashMap proAppExteInfos = (HashMap)ipkgInfomap.get("proAppExteInfos");
        String procCode = String.valueOf(ipkgInfomap.get("proCode"));
        long ipkgMainPySize = MapUtils.getInteger(ipkgInfomap, (Object)"mainPySize").intValue();
        String presetMainPySize = String.valueOf(proAppInfos.get("fileSize"));
        if (!IpkgUtils.checkStandIpkgSign(proAppInfos, procCode)) {
            resultMap.put("result", false);
            resultMap.put("message", "Ipkg\u7b7e\u540d\u6821\u9a8c\u5931\u8d25");
            return resultMap;
        }
        if (!IpkgUtils.checkStadndIpkgMain(ipkgMainPySize, Long.valueOf(presetMainPySize))) {
            resultMap.put("result", false);
            resultMap.put("message", "Ipkg\u5305Main.py\u6587\u4ef6\u975e\u6cd5");
            return resultMap;
        }
        if (!IpkgUtils.checkProAppExteInfos(proAppExteInfos)) {
            resultMap.put("result", false);
            resultMap.put("message", "proAppExteInfos\u5b57\u6bb5\u4e0d\u5b8c\u6574");
            return resultMap;
        }
        resultMap.put("result", true);
        resultMap.put("message", "Ipkg\u5305\u6821\u9a8c\u6210\u529f");
        return resultMap;
    }

    private static boolean checkStandIpkgSign(Map<String, Object> proAppInfos, String procCode) {
        LicenseVerifier licenseVerifier = new LicenseVerifier();
        String signCode = String.valueOf(proAppInfos.get("signCode"));
        SignInfosDTO signInfos = new SignInfosDTO();
        signInfos.setAppType(String.valueOf(proAppInfos.get("appType")));
        signInfos.setDevComCode(String.valueOf(proAppInfos.get("devComCode")));
        signInfos.setProcCode(procCode);
        signInfos.setIsOpenSource(String.valueOf(proAppInfos.get("isOpenSource")));
        signInfos.setFileSize(String.valueOf(proAppInfos.get("fileSize")));
        signInfos.setProChange(String.valueOf(proAppInfos.get("proChange")));
        signInfos.setProcVer(String.valueOf(proAppInfos.get("proVersion")));
        return licenseVerifier.verifySignCode(signInfos.buildSource(), signCode);
    }

    private static boolean checkStadndIpkgMain(Long ipkgMainPySize, Long presetMainPySize) {
        if (presetMainPySize == null || ipkgMainPySize == null || presetMainPySize == 0L || ipkgMainPySize == 0L) {
            return false;
        }
        if (ipkgMainPySize.equals(presetMainPySize)) {
            double diffAbsValue;
            double diff = 1.0 - ipkgMainPySize.doubleValue() / presetMainPySize.doubleValue();
            double d = diffAbsValue = diff < 0.0 ? -diff : diff;
            if (diffAbsValue > 0.02) {
                return false;
            }
        }
        return true;
    }

    private static boolean checkProAppExteInfos(Map<String, Object> proAppExteInfos) {
        String appName = String.valueOf(proAppExteInfos.get("appName"));
        String devComName = String.valueOf(proAppExteInfos.get("devComName"));
        String productType = String.valueOf(proAppExteInfos.get("productType"));
        String permitCode = String.valueOf(proAppExteInfos.get("permitCode"));
        String groupNumber = String.valueOf(proAppExteInfos.get("permitGroupNumber"));
        return !StringUtils.isBlank((CharSequence)appName) && !StringUtils.equals((CharSequence)appName, (CharSequence)NULL) && !StringUtils.isBlank((CharSequence)devComName) && !StringUtils.equals((CharSequence)devComName, (CharSequence)NULL) && !StringUtils.isBlank((CharSequence)productType) && !StringUtils.equals((CharSequence)productType, (CharSequence)NULL) && !StringUtils.isBlank((CharSequence)permitCode) && !StringUtils.equals((CharSequence)permitCode, (CharSequence)NULL) && !StringUtils.isBlank((CharSequence)groupNumber) && !StringUtils.equals((CharSequence)groupNumber, (CharSequence)NULL);
    }
}

