/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.MainEntityType;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.FileNameUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.model.ParamsVo;

public class IsearchFileUtils {
    private static Log log = LogFactory.getLog(IsearchFileUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readFromInputStream(InputStream is, StringBuilder out) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                out.append(line);
            }
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error("\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
                }
            }
        }
    }

    public static String uploadTempfile(String url, String name) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream in = cache.getInputStream(url);
        FileService service = FileServiceFactory.getAttachmentFileService();
        FileService fs = FileServiceFactory.getAttachmentFileService();
        RequestContext requestContext = RequestContext.get();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)uuid, (String)name);
        FileItem fileItem = new FileItem(name, pathParam, in);
        String downUrl = service.upload(fileItem);
        return downUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObject uploadFile(InputStream is) {
        String fileName = UUID.randomUUID().toString().replace("-", "") + ".ipkg";
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        RequestContext context = RequestContext.get();
        MainEntityType attaFiledEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_attachment");
        String tableName = attaFiledEntityType.getAlias();
        String[] ids = DBServiceHelper.genStringIds((String)tableName, (int)1);
        String url = null;
        String attPk = null;
        if (ids != null && ids.length > 0) {
            attPk = ids[0];
        }
        int size = 0;
        try {
            size = is.available();
            String uuid = UUID.randomUUID().toString().replace("-", "");
            String path = FileNameUtils.getAttachmentFileName((String)context.getTenantId(), (String)context.getAccountId(), (Object)attPk, (String)(uuid + "/" + fileName));
            FileItem fileItem = new FileItem(fileName, path, is);
            url = fileService.upload(fileItem);
            log.info("\u9644\u4ef6( " + attPk + " )\u7684\u5b58\u50a8\u4f4d\u7f6e\u4e3a: " + url);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IsearchFileUtils.close(is);
        }
        DynamicObject attachFieldObj = BusinessDataServiceHelper.newDynamicObject((String)"bd_attachment");
        attachFieldObj.set("id", (Object)attPk);
        attachFieldObj.set("name", (Object)new LocaleString(fileName));
        attachFieldObj.set("number", (Object)UUID.randomUUID().toString());
        attachFieldObj.set("size", (Object)size);
        attachFieldObj.set("type", (Object)(fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : ""));
        attachFieldObj.set("status", (Object)"B");
        attachFieldObj.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        long currTime = System.currentTimeMillis();
        attachFieldObj.set("createtime", (Object)currTime);
        attachFieldObj.set("modifytime", (Object)currTime);
        attachFieldObj.set("uid", (Object)AttachmentServiceHelper.generateUid());
        attachFieldObj.set("url", (Object)url);
        attachFieldObj.set("tempfile", (Object)1);
        attachFieldObj.set("pageid", (Object)"");
        return attachFieldObj;
    }

    public static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<String, Object> readIpkgFile(InputStream inputStream) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String procName = null;
        String procCode = null;
        String procVersion = null;
        String proChange = null;
        String proStudio = null;
        String line = null;
        String mainPyMd5 = null;
        Long mainPySize = null;
        HashMap<String, String> proAppInfos = null;
        HashMap<String, Object> proAppExteInfos = null;
        try (ZipArchiveInputStream is = new ZipArchiveInputStream(inputStream);
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "utf-8"));){
            ZipArchiveEntry entry = null;
            do {
                JSONObject json;
                StringBuilder out;
                if (null == (entry = is.getNextZipEntry()) || entry.isDirectory() || entry.getSize() <= 0L) continue;
                if ("Project.json".equals(entry.getName())) {
                    out = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        out.append(line);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)out.toString())) continue;
                    json = JSON.parseObject((String)out.toString());
                    String procDesc = json.getString("proDesc");
                    if (StringUtils.isBlank((CharSequence)procDesc)) {
                        procDesc = json.getString("description");
                    }
                    if (StringUtils.isBlank((CharSequence)(procName = json.getString("ProName")))) {
                        procName = json.getString("name");
                    }
                    procVersion = json.getString("version");
                    proChange = json.getString("ProChange");
                    proStudio = json.getString("ProStudio");
                    procCode = procName;
                    returnMap.put("proVersion", procVersion);
                    returnMap.put("proDesc", procDesc);
                    returnMap.put("proName", procName);
                    returnMap.put("proCode", procCode);
                    returnMap.put("proChange", proChange);
                    returnMap.put("proStudio", proStudio);
                    continue;
                }
                if (entry.getName().contains("Project.pro") && !entry.getName().contains("/")) {
                    JSONObject jsonObject;
                    out = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        out.append(line);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)out.toString())) continue;
                    json = JSON.parseObject((String)out.toString());
                    JSONArray globaVarJsonArray = json.getJSONArray("GlobalVar");
                    JSONObject innerJson = json.getJSONObject("ProInfo");
                    String procDesc = innerJson.getString("ProDesc");
                    procName = innerJson.getString("ProName");
                    procVersion = innerJson.getString("ProVersion");
                    proChange = innerJson.getString("ProChange");
                    procCode = procName;
                    proStudio = innerJson.getString("ProStudio");
                    String proAppInfosStr = innerJson.getString("ProAppInfos");
                    String proAppExteInfosStr = innerJson.getString("ProAppExteInfos");
                    returnMap.put("proVersion", procVersion);
                    returnMap.put("proDesc", procDesc);
                    returnMap.put("proName", procName);
                    returnMap.put("proCode", procCode);
                    returnMap.put("proChange", proChange);
                    returnMap.put("proStudio", proStudio);
                    if (StringUtils.isNotBlank((CharSequence)proAppInfosStr)) {
                        proAppInfos = new HashMap<String, String>();
                        jsonObject = JSONObject.parseObject((String)proAppInfosStr);
                        proAppInfos.put("appType", jsonObject.getString("AppType"));
                        proAppInfos.put("devComCode", jsonObject.getString("DevComCode"));
                        proAppInfos.put("appSn", jsonObject.getString("AppSn"));
                        proAppInfos.put("isOpenSource", jsonObject.getString("IsOpenSource"));
                        proAppInfos.put("fileSize", jsonObject.getString("FileSize"));
                        proAppInfos.put("proChange", jsonObject.getString("ProChange"));
                        proAppInfos.put("proVersion", jsonObject.getString("ProVersion"));
                        proAppInfos.put("signCode", jsonObject.getString("SignCode"));
                        returnMap.put("proAppInfos", proAppInfos);
                    }
                    if (StringUtils.isNotBlank((CharSequence)proAppExteInfosStr)) {
                        proAppExteInfos = new HashMap<String, Object>();
                        jsonObject = JSONObject.parseObject((String)proAppExteInfosStr);
                        proAppExteInfos.put("appName", jsonObject.getString("AppName"));
                        proAppExteInfos.put("devComName", jsonObject.getString("DevComName"));
                        proAppExteInfos.put("productType", jsonObject.getString("ProductType"));
                        proAppExteInfos.put("permitCode", jsonObject.getString("PermitCode"));
                        proAppExteInfos.put("permitGroupNumber", jsonObject.getLong("PermitGroupNumber"));
                        proAppExteInfos.put("appDesc", jsonObject.getString("AppDesc"));
                        returnMap.put("proAppExteInfos", proAppExteInfos);
                    }
                    returnMap.put("GlobalVar", globaVarJsonArray.toString());
                    continue;
                }
                if (entry.getName().contains("Project.int")) {
                    out = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        out.append(line);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)out.toString())) continue;
                    json = JSON.parseObject((String)out.toString());
                    JSONArray jsonArray = json.getJSONArray("Inputs");
                    returnMap.put("Inputs", jsonArray.toString());
                    continue;
                }
                if (!entry.getName().contains("Main.py")) continue;
                out = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    out.append(line);
                }
                mainPyMd5 = DigestUtils.md5Hex((String)String.valueOf(out));
                mainPySize = entry.getSize();
                returnMap.put("mainPyMd5", mainPyMd5);
                returnMap.put("mainPySize", mainPySize);
            } while (null != entry);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return returnMap;
    }

    public static List<ParamsVo> analysisParam(String param) {
        ArrayList<ParamsVo> list = new ArrayList<ParamsVo>();
        if (StringUtils.isBlank((CharSequence)param)) {
            return list;
        }
        List dataList = (List)JSONArray.parseObject((String)param, ArrayList.class);
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            for (int i = 0; i < dataList.size(); ++i) {
                String blStr;
                Map map = (Map)dataList.get(i);
                ParamsVo paramsVo = new ParamsVo();
                if (map.containsKey("Value")) {
                    paramsVo.setParamsDefValue(map.get("Value").toString());
                }
                if (map.containsKey("Help")) {
                    paramsVo.setParamsHelp(map.get("Help").toString());
                }
                if (map.containsKey("Desc")) {
                    paramsVo.setParamsDesc(map.get("Desc").toString());
                }
                if (map.containsKey("Name")) {
                    paramsVo.setParamsName(map.get("Name").toString());
                }
                if (map.containsKey("Type")) {
                    paramsVo.setParamsType(map.get("Type").toString());
                }
                if (map.containsKey("IsEmpty")) {
                    blStr = map.get("IsEmpty").toString();
                    paramsVo.setParamsRequired(blStr);
                }
                if (map.containsKey("ChildNode")) {
                    blStr = map.get("ChildNode").toString();
                    paramsVo.setChildNode(blStr);
                }
                if (map.containsKey("ItemPos")) {
                    blStr = map.get("ItemPos").toString();
                    paramsVo.setItemPos(blStr);
                }
                if (map.containsKey("FileExtName")) {
                    blStr = map.get("FileExtName").toString();
                    paramsVo.setFileExtName(blStr);
                }
                list.add(paramsVo);
            }
        }
        return list;
    }

    public static List<ParamsVo> analysisParam(String param, String globalVar) {
        ArrayList<ParamsVo> list = new ArrayList<ParamsVo>();
        if (StringUtils.isBlank((CharSequence)param)) {
            return list;
        }
        List dataList = (List)JSONArray.parseObject((String)param, ArrayList.class);
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            for (int i = 0; i < dataList.size(); ++i) {
                String blStr;
                Map map = (Map)dataList.get(i);
                ParamsVo paramsVo = new ParamsVo();
                if (map.containsKey("Value")) {
                    String paramsType = (String)map.get("Type");
                    if ("file".equals(paramsType)) {
                        String paramsName = map.get("Name").toString();
                        List globalVarList = (List)JSONArray.parseObject((String)globalVar, ArrayList.class);
                        for (Map globalVarMap : globalVarList) {
                            String varname = globalVarMap.get("varname").toString();
                            if (!StringUtils.equals((CharSequence)paramsName, (CharSequence)varname)) continue;
                            paramsVo.setParamsDefValue(globalVarMap.get("vardef").toString());
                            break;
                        }
                    } else {
                        paramsVo.setParamsDefValue(map.get("Value").toString());
                    }
                }
                if (map.containsKey("Help")) {
                    paramsVo.setParamsHelp(map.get("Help").toString());
                }
                if (map.containsKey("Desc")) {
                    paramsVo.setParamsDesc(map.get("Desc").toString());
                }
                if (map.containsKey("Name")) {
                    paramsVo.setParamsName(map.get("Name").toString());
                }
                if (map.containsKey("Type")) {
                    paramsVo.setParamsType(map.get("Type").toString());
                }
                if (map.containsKey("IsEmpty")) {
                    blStr = map.get("IsEmpty").toString();
                    paramsVo.setParamsRequired(blStr);
                }
                if (map.containsKey("ChildNode")) {
                    blStr = map.get("ChildNode").toString();
                    paramsVo.setChildNode(blStr);
                }
                if (map.containsKey("ItemPos")) {
                    blStr = map.get("ItemPos").toString();
                    paramsVo.setItemPos(blStr);
                }
                if (map.containsKey("FileExtName")) {
                    blStr = map.get("FileExtName").toString();
                    paramsVo.setFileExtName(blStr);
                }
                list.add(paramsVo);
            }
        }
        return list;
    }

    public static String paramsBase64(String schParam) {
        Base64.Encoder encoder = Base64.getEncoder();
        String encodedText = "";
        if (StringUtils.isNotBlank((CharSequence)schParam)) {
            encodedText = null;
            try {
                encodedText = encoder.encodeToString(schParam.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.warn("\u8fd0\u884c\u53c2\u6570\u52a0\u5bc6\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return encodedText;
    }

    public static String base64ToParams(String schParam) {
        Base64.Decoder decoder = Base64.getDecoder();
        String decodedText = "";
        try {
            decodedText = new String(decoder.decode(schParam), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.warn("\u8fd0\u884c\u53c2\u6570\u89e3\u5bc6\u5931\u8d25\uff1a" + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            return schParam;
        }
        return decodedText;
    }

    public static String getOneAttachments(String formId, Long id) {
        List attachmentpanel = AttachmentServiceHelper.getAttachments((String)formId, (Object)id, (String)"attachmentpanel", (boolean)true);
        if (attachmentpanel.size() > 0) {
            String url = ((Map)attachmentpanel.get(0)).get("url").toString();
            log.info("\u83b7\u53d6\u6807\u51c6\u5e94\u7528\u5217\u8868\uff0c\u83b7\u53d6\u6d41\u7a0b\u9644\u4ef6\u4fe1\u606f" + attachmentpanel);
            return url;
        }
        return null;
    }
}

